package tle.searchutil.hibernate2;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

import net.sf.hibernate.Criteria;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.expression.Criterion;
import net.sf.hibernate.expression.Expression;
import net.sf.hibernate.expression.Junction;
import net.sf.hibernate.expression.MatchMode;
import tle.searchutil.CompositeCond;
import tle.searchutil.Cond;
import tle.searchutil.Match;
import tle.searchutil.OneZero;
import tle.searchutil.Order;
import tle.searchutil.PropertyCond;
import tle.searchutil.PropertyValueCond;
import tle.searchutil.PropertyValuesCond;
import tle.searchutil.SearchFilter;
import tle.searchutil.SingleCond;
import tle.searchutil.TwoPropertyCond;
import tle.searchutil.YesNo;
import tle.searchutil.impl.CondAnd;
import tle.searchutil.impl.CondBetween;
import tle.searchutil.impl.CondEq;
import tle.searchutil.impl.CondEqProperty;
import tle.searchutil.impl.CondGe;
import tle.searchutil.impl.CondGt;
import tle.searchutil.impl.CondIlike;
import tle.searchutil.impl.CondIn;
import tle.searchutil.impl.CondLe;
import tle.searchutil.impl.CondLeProperty;
import tle.searchutil.impl.CondLike;
import tle.searchutil.impl.CondLt;
import tle.searchutil.impl.CondLtProperty;
import tle.searchutil.impl.CondNot;
import tle.searchutil.impl.CondNotIn;
import tle.searchutil.impl.CondNotNull;
import tle.searchutil.impl.CondNull;
import tle.searchutil.impl.CondOr;

/**
 * Hibernate 2.1.x   QueryHelper
 * <p>
 * @author ֹ
 *
 */
public class Hibernate2QueryHelper {
	public Hibernate2QueryHelper() {
	}
	
	/**
	 * Query parameter ˸  ҴѴ.
	 * @param query
	 * @param filter
	 * @param startIdx
	 * @param parameterValues Ķ  ϰ ִ List
	 * @throws HibernateException 
	 */
	public void setParameter(Query query,  
			int startIdx, List parameterValues) throws HibernateException {
		for (int i = 0 ; i < parameterValues.size() ; i++) {
			Object value = parameterValues.get(i);
			if (value instanceof YesNo) {
				query.setParameter(i + startIdx, ((YesNo)value).getValue(), Hibernate.YES_NO);
			} else if (value instanceof OneZero) {
				query.setParameter(i + startIdx, ((OneZero)value).getValue(), Hibernate.BOOLEAN);
			} else {
				query.setParameter(i + startIdx, value);
			}
		}
	}
	
	/**
	 * crit ˻  ߰Ѵ.
	 * 
	 * @param crit
	 * @param filter
	 */
	public void appendCriterion(Criteria crit, SearchFilter filter) {
		Stack stackList = new Stack(); //  List
		Stack stacki = new Stack(); //  i 
		Stack stackJunction = new Stack(); //  composite OP
		
		List conds = filter.getConds();
		
		Object currentJunction = crit; 
		
		for (int i = 0 ; i < conds.size() ; i++) {
			Cond cond = (Cond)conds.get(i);
			if (cond instanceof CompositeCond) {
				stackList.push(conds);
				stacki.push(new Integer(i));
				stackJunction.push(currentJunction);
				
				if (cond instanceof CondAnd) {
					currentJunction = Expression.conjunction();
				} else if (cond instanceof CondOr) {
					currentJunction = Expression.disjunction();
				}
				
				conds = ((CompositeCond)cond).getConds();
				i = -1;
				continue;
			} else if (cond instanceof SingleCond) {
				stackList.push(conds);
				stacki.push(new Integer(i));
				stackJunction.push(currentJunction);
				
				currentJunction = cond;
				List tempList = new ArrayList(1);
				tempList.add(((SingleCond)cond).getCond());
				conds = tempList;
				i = -1;
				continue;
			} else {
				if (currentJunction instanceof Criteria) {
					((Criteria)currentJunction).add(createCreterion(cond));
				} else if (currentJunction instanceof Junction) {
					((Junction)currentJunction).add(createCreterion(cond));
				}
			
				// CondNot CompositeCond/SingleCond ƴ Cond  
				// ڿ ó.
			}
			if (i == conds.size() - 1) {
				//   ó  ÿ ִ
				// junction  junction ߰Ѵ.
				
				if (stackList.size() > 0) {
					conds = (List)stackList.pop();
					i = ((Integer)stacki.pop()).intValue();
					Object parentJunction = stackJunction.pop(); // 
					
					if (currentJunction instanceof Junction) {
						if (parentJunction instanceof Criteria) {
							((Criteria)parentJunction).add((Junction)currentJunction);
						} else if (parentJunction instanceof Junction) {
							((Junction)parentJunction).add((Junction)currentJunction);
						} else if (parentJunction instanceof CondNot) {
							//  CondNot̸ ݵ   
							// ,   not(currentJunction) ߰ϸ ȴ.
							Object grandParentJunction = stackJunction.peek();
							if (grandParentJunction instanceof Criteria) {
								((Criteria)grandParentJunction).add(Expression.not((Junction)currentJunction));
							} else if (grandParentJunction instanceof Junction) {
								((Junction)grandParentJunction).add(Expression.not((Junction)currentJunction));
							}							
						}
					} else if (currentJunction instanceof CondNot) {
						// CondNot CompositeCond/SingleCond ƴ Cond  
						// CondNot  ݵ  
						if (parentJunction instanceof Criteria) {
							((Criteria)parentJunction).add(Expression.not(createCreterion(cond)));
						} else if (parentJunction instanceof Junction) {
							((Junction)parentJunction).add(Expression.not(createCreterion(cond)));
						}
					}
					currentJunction = parentJunction;
				}
			}
		}
	}
	
	/**
	 * cond ŸԿ  ˸ Criterion Ѵ.
	 * @param cond
	 * @return
	 */
	private Criterion createCreterion(Cond cond) {
		if (cond instanceof PropertyValueCond) {
			PropertyValueCond valueCond = (PropertyValueCond)cond;
			
			if (valueCond instanceof CondEq) {
				return Expression.eq(valueCond.getPropertyName(), valueCond.getValue());
			} else if (valueCond instanceof CondGe) {
				return Expression.ge(valueCond.getPropertyName(), valueCond.getValue());
			} else if (valueCond instanceof CondGt) {
				return Expression.gt(valueCond.getPropertyName(), valueCond.getValue());
			} else if (valueCond instanceof CondLe) {
				return Expression.le(valueCond.getPropertyName(), valueCond.getValue());
			} else if (valueCond instanceof CondLike) {
				CondLike likeCond = (CondLike)valueCond;
				MatchMode mode = null;
				switch(likeCond.getMatch()) {
				case Match.ANYWHERE:
					mode = MatchMode.ANYWHERE;
					break;
				case Match.START:
					mode = MatchMode.START;
					break;
				case Match.END:
					mode = MatchMode.END;
					break;
				case Match.EXACT:
					mode = MatchMode.EXACT;
					break;
				default:
					mode = MatchMode.ANYWHERE;
				}
				if (valueCond instanceof CondIlike) {
					return Expression.ilike(valueCond.getPropertyName(), likeCond.getValueString(), mode);
				} else {
					return Expression.like(valueCond.getPropertyName(), likeCond.getValueString(), mode);
				}
			} else if (valueCond instanceof CondLt) {
				return Expression.lt(valueCond.getPropertyName(), valueCond.getValue());
			}
			
		} else if (cond instanceof TwoPropertyCond) {
			TwoPropertyCond twoCond = (TwoPropertyCond)cond;
			
			if (twoCond instanceof CondEqProperty) {
				return Expression.eqProperty(twoCond.getPropertyName(), twoCond.getOtherPropertyName());
			} else if (twoCond instanceof CondLeProperty) {
				return Expression.leProperty(twoCond.getPropertyName(), twoCond.getOtherPropertyName());
			} else if (twoCond instanceof CondLtProperty) {
				return Expression.ltProperty(twoCond.getPropertyName(), twoCond.getOtherPropertyName());
			}
			
		} else if (cond instanceof PropertyValuesCond) {
			PropertyValuesCond valuesCond = (PropertyValuesCond)cond;
			if (valuesCond instanceof CondBetween) {
				CondBetween betCond = (CondBetween)valuesCond;
				
				return Expression.between(valuesCond.getPropertyName(),
						betCond.getLo(), betCond.getHi());
			} else if (valuesCond instanceof CondIn) {
				return Expression.in(valuesCond.getPropertyName(), valuesCond.getValues());
			} else if (valuesCond instanceof CondNotIn) {
				return Expression.not(
						Expression.in(valuesCond.getPropertyName(), valuesCond.getValues())
						);
			}
			
		} else if (cond instanceof PropertyCond) {
			PropertyCond propertyCond = (PropertyCond)cond;
			
			if (propertyCond instanceof CondNotNull) {
				return Expression.isNotNull(propertyCond.getPropertyName());
			} else if (propertyCond instanceof CondNull) {
				return Expression.isNull(propertyCond.getPropertyName());
			}
		}
		throw new IllegalArgumentException("not supported Cond type : "+cond.getClass().getName());
	}
	
	/**
	 * crit   ߰Ѵ.
	 *  
	 * @param crit
	 * @param filter
	 */
	public void appendOrder(Criteria crit, SearchFilter filter) {
		List orders = filter.getOrders();
		for (int i = 0 ; i < orders.size() ; i++) {
			Order order = (Order)orders.get(i);
			if (order.isAscending()) {
				crit.addOrder(net.sf.hibernate.expression.Order.asc(order.getPropertyName()));
			} else {
				crit.addOrder(net.sf.hibernate.expression.Order.desc(order.getPropertyName()));
			}
		}
	}

}
