package tle.searchutil.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import tle.searchutil.PropertyValuesCond;

public class AbstractPropertyValuesCond extends AbstractPropertyCond implements
		PropertyValuesCond {
	
	private List values;
	
	public AbstractPropertyValuesCond(String propertyName, Object[] v) {
		super(propertyName);
		for (int i = 0 ; i < v.length ; i++) {
			addValue(v[i]);
		}
	}

	public AbstractPropertyValuesCond(String propertyName, Collection v) {
		this(propertyName, v.toArray());
	}


	public PropertyValuesCond addValue(Object value) {
		if (values == null) {
			values = new ArrayList(8);
		}
		values.add(value);
		return this;
	}

	public List getValues() {
		if (values == null) return Collections.EMPTY_LIST;
		return values;
	}

}
