/*
 * Decompiled with CFR 0.152.
 */
package tle.searchutil.sql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import tle.searchutil.OneZero;
import tle.searchutil.QueryHelper;
import tle.searchutil.TrueFalse;
import tle.searchutil.YesNo;

public class SQLQueryHelper
extends QueryHelper {
    public void setParameter(PreparedStatement pstmt, int startIdx, List parameterValues) throws SQLException {
        for (int i = 0; i < parameterValues.size(); ++i) {
            Object value = parameterValues.get(i);
            this.setValue(pstmt, i + startIdx, value);
        }
    }

    protected void setValue(PreparedStatement pstmt, int idx, Object value) throws SQLException {
        if (value instanceof YesNo) {
            pstmt.setString(idx, ((YesNo)value).getValue() != false ? "Y" : "N");
        } else if (value instanceof TrueFalse) {
            pstmt.setString(idx, ((TrueFalse)value).getValue() != false ? "T" : "F");
        } else if (value instanceof OneZero) {
            pstmt.setInt(idx, ((OneZero)value).getValue() != false ? 1 : 0);
        } else if (value instanceof Number) {
            if (value instanceof Long) {
                pstmt.setLong(idx, (Long)value);
            } else if (value instanceof Short) {
                pstmt.setShort(idx, (Short)value);
            } else if (value instanceof Byte) {
                pstmt.setByte(idx, (Byte)value);
            } else if (value instanceof Float) {
                pstmt.setFloat(idx, ((Float)value).floatValue());
            } else if (value instanceof Double) {
                pstmt.setDouble(idx, (Double)value);
            } else {
                pstmt.setInt(idx, ((Number)value).intValue());
            }
        } else if (value instanceof Date) {
            Date dValue = (Date)value;
            pstmt.setTimestamp(idx, new Timestamp(dValue.getTime()));
        } else if (value instanceof Timestamp) {
            pstmt.setTimestamp(idx, (Timestamp)value);
        } else if (value instanceof java.sql.Date) {
            pstmt.setDate(idx, (java.sql.Date)value);
        } else if (value instanceof Time) {
            pstmt.setTime(idx, (Time)value);
        } else {
            pstmt.setString(idx, value.toString());
        }
    }
}

