/*
 * Decompiled with CFR 0.152.
 */
package tle.framework.component.impl.rp;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import tle.framework.component.ComponentException;
import tle.framework.component.impl.rp.config.CommandMappingConfig;
import tle.framework.component.impl.rp.config.DefaultRPConfiguration;
import tle.framework.component.impl.rp.config.ValidatorConfig;
import tle.framework.component.impl.rp.handler.CommandHandler;
import tle.framework.component.impl.rp.handler.CommandHandlerClassLoader;
import tle.framework.component.impl.rp.handler.GoViewCommandHandler;
import tle.framework.component.impl.rp.handler.JSPCommandHandler;
import tle.framework.component.impl.rp.handler.NoHandlerCommandHandler;
import tle.framework.component.impl.rp.validator.Validator;
import tle.framework.component.spi.ra.RequestInfo;
import tle.framework.log.Logger;

public class RequestProcessorElementFactory {
    private CommandHandlerClassLoader commandHandlerClassLoader;
    private Map validatorMap;
    private Map handlerMap;
    private Map commandHandlerMap;
    private CommandHandler defaultHandler = null;
    private boolean useDefaultOnInvalidMapping = false;

    public RequestProcessorElementFactory(DefaultRPConfiguration configuration) throws ComponentException {
        if (configuration.isUsingIndependentClassPath()) {
            this.commandHandlerClassLoader = new CommandHandlerClassLoader(configuration.getClassPathArray());
        }
        this.init(configuration);
    }

    public void init(DefaultRPConfiguration configuration) throws ComponentException {
        this.initValidator(configuration);
        this.initHandler(configuration);
        this.initCommandHandlerMapping(configuration);
        this.useDefaultOnInvalidMapping = configuration.isUseDefaultOnInvalidMapping();
    }

    private void initValidator(DefaultRPConfiguration configuration) {
        HashMap<String, Validator> validatorMap = new HashMap<String, Validator>();
        List validatorConfigList = configuration.getValidatorConfigList();
        for (int i = 0; i < validatorConfigList.size(); ++i) {
            ValidatorConfig validatorConfig = (ValidatorConfig)validatorConfigList.get(i);
            try {
                Class<?> validatorClass = Class.forName(validatorConfig.getClassName());
                Validator validator = (Validator)validatorClass.newInstance();
                validatorMap.put(validatorConfig.getName(), validator);
                continue;
            }
            catch (ClassNotFoundException e) {
                Logger.warn("fail to create Validator (" + validatorConfig.getName() + "," + validatorConfig.getClassName() + ")", e);
                continue;
            }
            catch (InstantiationException e) {
                Logger.warn("fail to create Validator (" + validatorConfig.getName() + "," + validatorConfig.getClassName() + ")", e);
                continue;
            }
            catch (IllegalAccessException e) {
                Logger.warn("fail to create Validator (" + validatorConfig.getName() + "," + validatorConfig.getClassName() + ")", e);
                continue;
            }
            catch (ClassCastException e) {
                Logger.warn("fail to create Validator (" + validatorConfig.getName() + "," + validatorConfig.getClassName() + ")", e);
            }
        }
        this.validatorMap = validatorMap;
    }

    public Validator createValitor(String name) {
        return (Validator)this.validatorMap.get(name);
    }

    private void initHandler(DefaultRPConfiguration configuration) throws ComponentException {
        this.initHandlerInstance(configuration);
        this.initDefaultHandler(configuration);
    }

    private void initHandlerInstance(DefaultRPConfiguration configuration) throws ComponentException {
        HashMap<String, CommandHandler> handlerMap = new HashMap<String, CommandHandler>();
        Map handlerClassMap = configuration.getHandlerClassMap();
        Iterator iter = handlerClassMap.keySet().iterator();
        while (iter.hasNext()) {
            String handlerID = (String)iter.next();
            String className = (String)handlerClassMap.get(handlerID);
            try {
                Class handlerClass = null;
                handlerClass = this.commandHandlerClassLoader != null ? this.commandHandlerClassLoader.loadHandlerClass(className) : Class.forName(className);
                CommandHandler handler = (CommandHandler)handlerClass.newInstance();
                if (handlerMap.containsKey(handlerID)) {
                    throw new ComponentException("aleady exists CommandHandler ID : " + handlerID);
                }
                handlerMap.put(handlerID, handler);
            }
            catch (ClassNotFoundException e) {
                Logger.warn("fail to create Handler (" + handlerID + "," + className + ")", e);
            }
            catch (InstantiationException e) {
                Logger.warn("fail to create Handler (" + handlerID + "," + className + ")", e);
            }
            catch (IllegalAccessException e) {
                Logger.warn("fail to create Handler (" + handlerID + "," + className + ")", e);
            }
            catch (ClassCastException e) {
                Logger.warn("fail to create Handler (" + handlerID + "," + className + ")", e);
            }
        }
        Map handlerJspMap = configuration.getHandlerJspMap();
        Iterator iterJsp = handlerJspMap.keySet().iterator();
        while (iterJsp.hasNext()) {
            String handlerID = (String)iterJsp.next();
            String jspPage = (String)handlerJspMap.get(handlerID);
            JSPCommandHandler handler = new JSPCommandHandler(jspPage);
            if (handlerMap.containsKey(handlerID)) {
                throw new ComponentException("aleady exists CommandHandler ID : " + handlerID);
            }
            handlerMap.put(handlerID, handler);
        }
        this.handlerMap = handlerMap;
    }

    private void initDefaultHandler(DefaultRPConfiguration configuration) {
        GoViewCommandHandler goViewHandler = new GoViewCommandHandler();
        NoHandlerCommandHandler noHandler = new NoHandlerCommandHandler();
        switch (configuration.getDefaultHandlerType()) {
            case 1: {
                this.defaultHandler = goViewHandler;
                break;
            }
            case 2: {
                this.defaultHandler = noHandler;
            }
        }
        this.handlerMap.put("default.GOVIEW", goViewHandler);
        this.handlerMap.put("default.NOHANDLER", noHandler);
    }

    private void initCommandHandlerMapping(DefaultRPConfiguration configuration) {
        this.commandHandlerMap = Collections.unmodifiableMap(configuration.getCommandHandlerMap());
    }

    public CommandMappingConfig createCommandMappingConfig(RequestInfo requestInfo) {
        return (CommandMappingConfig)this.commandHandlerMap.get(requestInfo.getCommandID());
    }

    public CommandHandler createCommandHandler(RequestInfo requestInfo) throws ComponentException {
        CommandMappingConfig commandMapping = (CommandMappingConfig)this.commandHandlerMap.get(requestInfo.getCommandID());
        if (commandMapping == null) {
            return this.defaultHandler;
        }
        CommandHandler handler = (CommandHandler)this.handlerMap.get(commandMapping.getHandlerID());
        if (handler == null) {
            if (this.useDefaultOnInvalidMapping) {
                handler = this.defaultHandler;
            } else {
                throw new ComponentException("not found CommandHandler : " + commandMapping.getHandlerID());
            }
        }
        return handler;
    }

    public void reloadHandlerClasses(DefaultRPConfiguration configuration) throws ComponentException {
        if (this.commandHandlerClassLoader == null) {
            throw new UnsupportedOperationException("ClassLoader != CommandHandlerClassLoader");
        }
        this.commandHandlerClassLoader.remakeClassLoader();
        this.initHandler(configuration);
    }

    public String getHandlerIDForCommandID(String commandID) {
        CommandMappingConfig commandMapping = (CommandMappingConfig)this.commandHandlerMap.get(commandID);
        if (commandMapping != null) {
            return commandMapping.getHandlerID();
        }
        return this.defaultHandler.getClass().getName();
    }

    public CommandHandler getCommandHandler(String handlerID) {
        return (CommandHandler)this.handlerMap.get(handlerID);
    }
}

