/*
 * Ʈ: TLE2Framework
 * ϸ: DefaultRequestInfo.java
 * ۼ: 2004. 10. 21
 */
package tle.framework.component.impl.ra;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import tle.framework.component.spi.ra.FileItem;
import tle.framework.component.spi.ra.RequestInfo;

/**
 * RequestInfo ü
 * 
 * @author ֹ
 * @since 2.0
 */
public class DefaultRequestInfo implements RequestInfo {
	
	/**
	 * ɾ ID
	 */
	private String commandID;
	/**
	 * &lt;Ķ̸, ĶͰ[]>  ϴ 
	 */
	private Map parameterMap = new java.util.HashMap();
	/**
	 * &lt;Ķ̸, >  ϴ 
	 */
	private Map fileMap = new java.util.HashMap();
	
	/**
	 * &lt;Ű̸, Cookie>  ϴ 
	 */
	private Map cookieMap = new java.util.HashMap();
	
	private HttpServletRequest request;
	private HttpServletResponse response;
	
	public DefaultRequestInfo(HttpServletRequest request, HttpServletResponse response) {
		this.request = request;
		this.response = response;
		
		Cookie[] cookies = request.getCookies();
		if (cookies != null) {
			for (int i = 0 ; i < cookies.length ; i++) {
				cookieMap.put(cookies[i].getName(), cookies[i]);
			}
		}
	}

	/**
	 * ɾ ID Ѵ.
	 * @param commandID
	 */
	void setCommandID(String commandID) {
		this.commandID = commandID;
	}

	/* (non-Javadoc)
	 * @see tle.framework.component.spi.ra.RequestInfo#getCommandID()
	 */
	public String getCommandID() {
		return commandID;
	}

	/**
	 *  ̸ Ķ͸ ߰Ѵ.
	 * @param values
	 */
	void addParameter(String name, String[] values) {
		 parameterMap.put(name, values);
	}
	
	/* (non-Javadoc)
	 * @see tle.framework.component.spi.ra.RequestInfo#getParameter(java.lang.String)
	 */
	public String getParameter(String name) {
		String[] values = (String[])parameterMap.get(name);
		if (values == null || values.length == 0)
			return null;
		else
			return values[0];
	}

	/* (non-Javadoc)
	 * @see tle.framework.component.spi.ra.RequestInfo#getParameterValues(java.lang.String)
	 */
	public String[] getParameterValues(String name) {
		return (String[])parameterMap.get(name);
	}

	/* (non-Javadoc)
	 * @see tle.framework.component.spi.ra.RequestInfo#getParameterNames()
	 */
	public String[] getParameterNames() {
		String[] names = new String[parameterMap.size()];
		parameterMap.keySet().toArray(names);
		return names;
	}

	/* (non-Javadoc)
	 * @see tle.framework.component.spi.ra.RequestInfo#getHeader(java.lang.String)
	 */
	public String getHeader(String name) {
		return request.getHeader(name);
	}

	/* (non-Javadoc)
	 * @see tle.framework.component.spi.ra.RequestInfo#getCookieValue(java.lang.String)
	 */
	public String getCookieValue(String name) {
		Cookie cookie = (Cookie)cookieMap.get(name);
		if (cookie == null) {
			return null;
		} else {
			return cookie.getValue();
		}
	}

	/* (non-Javadoc)
	 * @see tle.framework.component.spi.ra.RequestInfo#getCookie(java.lang.String)
	 */
	public Cookie getCookie(String name) {
		return (Cookie)cookieMap.get(name);
	}

	/* (non-Javadoc)
	 * @see tle.framework.component.spi.ra.RequestInfo#getCookies()
	 */
	public Cookie[] getCookies() {
		return request.getCookies();
	}

	/* (non-Javadoc)
	 * @see tle.framework.component.spi.ra.RequestInfo#getCookieMap()
	 */
	public Map getCookieMap() {
		return Collections.unmodifiableMap(this.cookieMap);
	}

	/**
	 *  ̸ Ķͷ  Ѵ.
	 * @param name
	 * @param file
	 */
	void addFileItem(String name, FileItem fileItem) {
		fileMap.put(name, fileItem);
	}

	/* (non-Javadoc)
	 * @see tle.framework.component.spi.ra.RequestInfo#getFileItem(java.lang.String)
	 */
	public FileItem getFileItem(String name) {
		return (FileItem)fileMap.get(name);
	}

	/* (non-Javadoc)
	 * @see tle.framework.component.spi.ra.RequestInfo#getFileByBytes(java.lang.String)
	 */
	public byte[] getFileByBytes(String name) throws Throwable {
		FileItem fileItem = this.getFileItem(name);
		if (fileItem == null) {
			return null;
		} else {
			return fileItem.getBytes();
		}
	}

	/* (non-Javadoc)
	 * @see tle.framework.component.spi.ra.RequestInfo#getRequest()
	 */
	public HttpServletRequest getRequest() {
		return request;
	}

	/* (non-Javadoc)
	 * @see tle.framework.component.spi.ra.RequestInfo#getResponse()
	 */
	public HttpServletResponse getResponse() {
		return response;
	}

	/* (non-Javadoc)
	 * @see tle.framework.component.spi.ra.RequestInfo#getSession()
	 */
	public HttpSession getSession() {
		return request.getSession(false);
	}

	/* (non-Javadoc)
	 * @see tle.framework.component.spi.ra.RequestInfo#getFileItems()
	 */
	public FileItem[] getFileItems() {
		Collection coll = fileMap.values();
		FileItem[] items = new FileItem[coll.size()];
		coll.toArray(items);
		return items;
	}
}
