/*
 * Ʈ: TLE2Framework
 * ϸ: RequestInfoWrapper.java
 * ۼ: 2005. 3. 21
 */
package tle.framework.component.spi.ra;

import java.util.Map;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import tle.framework.http.RIRequestWrapper;

/**
 * RequestAnalyzer  RequestInfo δ .
 * getRequest() ޼ҵ尡 RIRequestWrapper Ѵ.
 * 
 * @author ֹ
 */
public class RequestInfoWrapper implements RequestInfo {
	private RequestInfo ri;
	private RIRequestWrapper request;
	
	public RequestInfoWrapper(RequestInfo ri) {
		this.ri = ri;
		request = new RIRequestWrapper(ri.getRequest(), ri);
	}
	
	public String getCommandID() {
		return ri.getCommandID();
	}

	public String getParameter(String name) {
		return ri.getParameter(name);
	}

	public String[] getParameterValues(String name) {
		return ri.getParameterValues(name);
	}

	public String[] getParameterNames() {
		return ri.getParameterNames();
	}

	public String getHeader(String name) {
		return ri.getHeader(name);
	}

	public String getCookieValue(String name) {
		return ri.getCookieValue(name);
	}

	public Cookie getCookie(String name) {
		return ri.getCookie(name);
	}

	public Cookie[] getCookies() {
		return ri.getCookies();
	}

	public Map getCookieMap() {
		return ri.getCookieMap();
	}

	public FileItem getFileItem(String name) {
		return ri.getFileItem(name);
	}

	public byte[] getFileByBytes(String name) throws Throwable {
		return ri.getFileByBytes(name);
	}

	public HttpServletRequest getRequest() {
		return request;
	}

	public HttpServletResponse getResponse() {
		return ri.getResponse();
	}

	public HttpSession getSession() {
		return ri.getSession();
	}

	public FileItem[] getFileItems() {
		return ri.getFileItems();
	}

}
