/*
 * Decompiled with CFR 0.152.
 */
package tle.searchutil.hibernate3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Junction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.Type;
import tle.searchutil.CompositeCond;
import tle.searchutil.Cond;
import tle.searchutil.OneZero;
import tle.searchutil.Order;
import tle.searchutil.PropertyCond;
import tle.searchutil.PropertyValueCond;
import tle.searchutil.PropertyValuesCond;
import tle.searchutil.QueryHelper;
import tle.searchutil.SearchFilter;
import tle.searchutil.SingleCond;
import tle.searchutil.TrueFalse;
import tle.searchutil.TwoPropertyCond;
import tle.searchutil.YesNo;
import tle.searchutil.impl.CondAnd;
import tle.searchutil.impl.CondBetween;
import tle.searchutil.impl.CondEmpty;
import tle.searchutil.impl.CondEq;
import tle.searchutil.impl.CondEqProperty;
import tle.searchutil.impl.CondGe;
import tle.searchutil.impl.CondGeProperty;
import tle.searchutil.impl.CondGt;
import tle.searchutil.impl.CondGtProperty;
import tle.searchutil.impl.CondIdEq;
import tle.searchutil.impl.CondIlike;
import tle.searchutil.impl.CondIn;
import tle.searchutil.impl.CondLe;
import tle.searchutil.impl.CondLeProperty;
import tle.searchutil.impl.CondLike;
import tle.searchutil.impl.CondLt;
import tle.searchutil.impl.CondLtProperty;
import tle.searchutil.impl.CondNe;
import tle.searchutil.impl.CondNeProperty;
import tle.searchutil.impl.CondNot;
import tle.searchutil.impl.CondNotEmpty;
import tle.searchutil.impl.CondNotIn;
import tle.searchutil.impl.CondNotNull;
import tle.searchutil.impl.CondNull;
import tle.searchutil.impl.CondOr;

public class Hibernate3QueryHelper
extends QueryHelper {
    public void setParameter(Query query, int startIdx, List parameterValues) {
        for (int i = 0; i < parameterValues.size(); ++i) {
            Object value = parameterValues.get(i);
            if (value instanceof YesNo) {
                query.setParameter(i + startIdx, (Object)((YesNo)value).getValue(), (Type)Hibernate.YES_NO);
                continue;
            }
            if (value instanceof TrueFalse) {
                query.setParameter(i + startIdx, (Object)((TrueFalse)value).getValue(), (Type)Hibernate.TRUE_FALSE);
                continue;
            }
            if (value instanceof OneZero) {
                query.setParameter(i + startIdx, (Object)((OneZero)value).getValue(), (Type)Hibernate.BOOLEAN);
                continue;
            }
            query.setParameter(i + startIdx, value);
        }
    }

    public void appendCriterion(Criteria crit, SearchFilter filter) {
        Stack stackList = new Stack();
        Stack<Integer> stacki = new Stack<Integer>();
        Stack<Criteria> stackJunction = new Stack<Criteria>();
        ArrayList<Cond> conds = filter.getConds();
        Object currentJunction = crit;
        for (int i = 0; i < conds.size(); ++i) {
            Cond cond = (Cond)conds.get(i);
            if (cond instanceof CompositeCond) {
                stackList.push(conds);
                stacki.push(new Integer(i));
                stackJunction.push((Criteria)currentJunction);
                if (cond instanceof CondAnd) {
                    currentJunction = Restrictions.conjunction();
                } else if (cond instanceof CondOr) {
                    currentJunction = Restrictions.disjunction();
                }
                conds = ((CompositeCond)cond).getConds();
                i = -1;
                continue;
            }
            if (cond instanceof SingleCond) {
                stackList.push(conds);
                stacki.push(new Integer(i));
                stackJunction.push((Criteria)currentJunction);
                currentJunction = cond;
                ArrayList<Cond> tempList = new ArrayList<Cond>(1);
                tempList.add(((SingleCond)cond).getCond());
                conds = tempList;
                i = -1;
                continue;
            }
            if (currentJunction instanceof Criteria) {
                currentJunction.add(this.createCreterion(cond));
            } else if (currentJunction instanceof Junction) {
                ((Junction)currentJunction).add(this.createCreterion(cond));
            }
            while (i == conds.size() - 1 && stackList.size() > 0) {
                conds = (List)stackList.pop();
                i = (Integer)stacki.pop();
                Object parentJunction = stackJunction.pop();
                if (currentJunction instanceof Junction) {
                    if (parentJunction instanceof Criteria) {
                        ((Criteria)parentJunction).add((Criterion)((Junction)currentJunction));
                    } else if (parentJunction instanceof Junction) {
                        ((Junction)parentJunction).add((Criterion)((Junction)currentJunction));
                    } else if (parentJunction instanceof CondNot) {
                        Object grandParentJunction = stackJunction.peek();
                        if (grandParentJunction instanceof Criteria) {
                            ((Criteria)grandParentJunction).add(Restrictions.not((Criterion)((Junction)currentJunction)));
                        } else if (grandParentJunction instanceof Junction) {
                            ((Junction)grandParentJunction).add(Restrictions.not((Criterion)((Junction)currentJunction)));
                        }
                    }
                } else if (currentJunction instanceof CondNot) {
                    if (parentJunction instanceof Criteria) {
                        ((Criteria)parentJunction).add(Restrictions.not((Criterion)this.createCreterion(cond)));
                    } else if (parentJunction instanceof Junction) {
                        ((Junction)parentJunction).add(Restrictions.not((Criterion)this.createCreterion(cond)));
                    }
                }
                currentJunction = parentJunction;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private Criterion createCreterion(Cond cond) {
        if (cond instanceof PropertyValueCond) {
            PropertyValueCond valueCond = (PropertyValueCond)cond;
            if (valueCond instanceof CondEq) {
                Object value = valueCond.getValue();
                if (value instanceof YesNo) {
                    return Restrictions.eq((String)valueCond.getPropertyName(), (Object)((YesNo)value).getValue());
                }
                if (value instanceof TrueFalse) {
                    return Restrictions.eq((String)valueCond.getPropertyName(), (Object)((TrueFalse)value).getValue());
                }
                if (value instanceof OneZero) {
                    return Restrictions.eq((String)valueCond.getPropertyName(), (Object)((OneZero)value).getValue());
                }
                return Restrictions.eq((String)valueCond.getPropertyName(), (Object)value);
            }
            if (valueCond instanceof CondGe) {
                return Restrictions.ge((String)valueCond.getPropertyName(), (Object)valueCond.getValue());
            }
            if (valueCond instanceof CondGt) {
                return Restrictions.gt((String)valueCond.getPropertyName(), (Object)valueCond.getValue());
            }
            if (valueCond instanceof CondIdEq) {
                return Restrictions.idEq((Object)valueCond.getValue());
            }
            if (valueCond instanceof CondLe) {
                return Restrictions.le((String)valueCond.getPropertyName(), (Object)valueCond.getValue());
            }
            if (valueCond instanceof CondLike) {
                CondLike likeCond = (CondLike)valueCond;
                MatchMode mode = null;
                switch (likeCond.getMatch()) {
                    case 1: {
                        mode = MatchMode.ANYWHERE;
                        break;
                    }
                    case 8: {
                        mode = MatchMode.START;
                        break;
                    }
                    case 2: {
                        mode = MatchMode.END;
                        break;
                    }
                    case 4: {
                        mode = MatchMode.EXACT;
                        break;
                    }
                    default: {
                        mode = MatchMode.ANYWHERE;
                    }
                }
                if (valueCond instanceof CondIlike) {
                    return Restrictions.ilike((String)valueCond.getPropertyName(), (String)likeCond.getValueString(), (MatchMode)mode);
                }
                return Restrictions.like((String)valueCond.getPropertyName(), (String)likeCond.getValueString(), (MatchMode)mode);
            }
            if (valueCond instanceof CondLt) {
                return Restrictions.lt((String)valueCond.getPropertyName(), (Object)valueCond.getValue());
            }
            if (valueCond instanceof CondNe) {
                return Restrictions.ne((String)valueCond.getPropertyName(), (Object)valueCond.getValue());
            }
        } else if (cond instanceof TwoPropertyCond) {
            TwoPropertyCond twoCond = (TwoPropertyCond)cond;
            if (twoCond instanceof CondEqProperty) {
                return Restrictions.eqProperty((String)twoCond.getPropertyName(), (String)twoCond.getOtherPropertyName());
            }
            if (twoCond instanceof CondGeProperty) {
                return Restrictions.geProperty((String)twoCond.getPropertyName(), (String)twoCond.getOtherPropertyName());
            }
            if (twoCond instanceof CondGtProperty) {
                return Restrictions.gtProperty((String)twoCond.getPropertyName(), (String)twoCond.getOtherPropertyName());
            }
            if (twoCond instanceof CondLeProperty) {
                return Restrictions.leProperty((String)twoCond.getPropertyName(), (String)twoCond.getOtherPropertyName());
            }
            if (twoCond instanceof CondLtProperty) {
                return Restrictions.ltProperty((String)twoCond.getPropertyName(), (String)twoCond.getOtherPropertyName());
            }
            if (twoCond instanceof CondNeProperty) {
                return Restrictions.neProperty((String)twoCond.getPropertyName(), (String)twoCond.getOtherPropertyName());
            }
        } else if (cond instanceof PropertyValuesCond) {
            PropertyValuesCond valuesCond = (PropertyValuesCond)cond;
            if (valuesCond instanceof CondBetween) {
                CondBetween betCond = (CondBetween)valuesCond;
                return Restrictions.between((String)valuesCond.getPropertyName(), (Object)betCond.getLo(), (Object)betCond.getHi());
            }
            if (valuesCond instanceof CondIn) {
                return Restrictions.in((String)valuesCond.getPropertyName(), (Collection)valuesCond.getValues());
            }
            if (valuesCond instanceof CondNotIn) {
                return Restrictions.not((Criterion)Restrictions.in((String)valuesCond.getPropertyName(), (Collection)valuesCond.getValues()));
            }
        } else if (cond instanceof PropertyCond) {
            PropertyCond propertyCond = (PropertyCond)cond;
            if (propertyCond instanceof CondEmpty) {
                return Restrictions.isEmpty((String)propertyCond.getPropertyName());
            }
            if (propertyCond instanceof CondNotEmpty) {
                return Restrictions.isNotEmpty((String)propertyCond.getPropertyName());
            }
            if (propertyCond instanceof CondNotNull) {
                return Restrictions.isNotNull((String)propertyCond.getPropertyName());
            }
            if (propertyCond instanceof CondNull) {
                return Restrictions.isNull((String)propertyCond.getPropertyName());
            }
        }
        throw new IllegalArgumentException("not supported Cond type : " + cond.getClass().getName());
    }

    public void appendOrder(Criteria crit, SearchFilter filter) {
        List orders = filter.getOrders();
        for (int i = 0; i < orders.size(); ++i) {
            Order order = (Order)orders.get(i);
            if (order.isAscending()) {
                crit.addOrder(org.hibernate.criterion.Order.asc((String)order.getPropertyName()));
                continue;
            }
            crit.addOrder(org.hibernate.criterion.Order.desc((String)order.getPropertyName()));
        }
    }
}

