/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.monitor.MonitorMBean;
import javax.management.monitor.MonitorNotification;
import mx4j.log.Log;
import mx4j.log.Logger;

public abstract class Monitor
extends NotificationBroadcasterSupport
implements MonitorMBean,
MBeanRegistration {
    protected int alreadyNotified;
    protected int[] alreadyNotifieds;
    protected static final int capacityIncrement = 16;
    protected String dbgTag;
    protected int elementCount;
    protected static final int OBSERVED_ATTRIBUTE_ERROR_NOTIFIED = 2;
    protected static final int OBSERVED_ATTRIBUTE_TYPE_ERROR_NOTIFIED = 4;
    protected static final int OBSERVED_OBJECT_ERROR_NOTIFIED = 1;
    protected static final int RESET_FLAGS_ALREADY_NOTIFIED = 0;
    protected static final int RUNTIME_ERROR_NOTIFIED = 8;
    protected MBeanServer server;
    ArrayList objectNames = new ArrayList();
    String attribute;
    long granularity = 10000L;
    boolean isActive = false;
    transient boolean errorNotified = false;
    transient boolean mBeanFound = true;
    static Timer notificationTimer = new Timer();
    static long notificationID = 0L;
    MonitorTask monitorTask = null;

    static synchronized long createNotificationID() {
        return ++notificationID;
    }

    abstract void executeMonitor(ObjectName var1, Object var2);

    Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    public abstract void start();

    synchronized void doStart() {
        if (!this.isActive) {
            this.getLogger().info("Starting monitor " + this + " every " + this.granularity + " milliseconds");
            this.isActive = true;
            this.errorNotified = false;
            this.monitorTask = new MonitorTask();
            notificationTimer.scheduleAtFixedRate((TimerTask)this.monitorTask, 0L, this.granularity);
        }
    }

    public abstract void stop();

    synchronized void doStop() {
        if (this.isActive) {
            this.getLogger().info("Stopping monitor " + this.toString());
            this.isActive = false;
            this.monitorTask.cancel();
        }
    }

    public synchronized ObjectName getObservedObject() {
        if (this.objectNames.size() == 0) {
            return null;
        }
        return (ObjectName)this.objectNames.get(0);
    }

    public synchronized ObjectName[] getObservedObjects() {
        if (this.objectNames.size() == 0) {
            return null;
        }
        ObjectName[] names = new ObjectName[this.objectNames.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = (ObjectName)this.objectNames.get(i);
        }
        return names;
    }

    public synchronized void addObservedObject(ObjectName objectName) throws IllegalArgumentException {
        if (objectName == null) {
            throw new IllegalArgumentException("The observed object name cannot be null");
        }
        if (this.objectNames.contains(objectName)) {
            return;
        }
        this.errorNotified = false;
        this.objectNames.add(this.objectNames.size(), objectName);
    }

    public synchronized void setObservedObject(ObjectName objectName) throws IllegalArgumentException {
        this.addObservedObject(objectName);
    }

    public String getObservedAttribute() {
        return this.attribute;
    }

    public synchronized void setObservedAttribute(String attribute) throws IllegalArgumentException {
        if (attribute == null) {
            throw new IllegalArgumentException("The observed attribute cannot be null");
        }
        this.errorNotified = true;
        this.attribute = attribute;
    }

    public long getGranularityPeriod() {
        return this.granularity;
    }

    public void setGranularityPeriod(long period) throws IllegalArgumentException {
        if (period <= 0L) {
            throw new IllegalArgumentException("The monitoring period can't be negative or zero");
        }
        this.granularity = period;
    }

    public synchronized boolean isActive() {
        return this.isActive;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.getLogger().info("Pre register of monitor " + this.toString());
        this.server = server;
        this.errorNotified = false;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
        this.getLogger().info("Pre deregister of monitor " + this.toString());
        this.stop();
    }

    public void postDeregister() {
    }

    void notifyListeners(String type, ObjectName objectName) {
        MonitorNotification not = new MonitorNotification(type, this, Monitor.createNotificationID(), System.currentTimeMillis(), "", objectName, null, null, null);
        this.sendNotification(not);
    }

    void notifyListeners(String type, ObjectName objectName, String attribute) {
        MonitorNotification not = new MonitorNotification(type, this, Monitor.createNotificationID(), System.currentTimeMillis(), "", objectName, attribute, null, null);
        this.sendNotification(not);
    }

    void notifyListeners(String type, ObjectName objectName, String attribute, Throwable e) {
        MonitorNotification not = new MonitorNotification(type, this, Monitor.createNotificationID(), System.currentTimeMillis(), e.toString(), objectName, attribute, null, null);
        this.sendNotification(not);
    }

    public synchronized String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.objectNames == null || this.objectNames.size() == 0) {
            sb.append("?");
        } else {
            for (int i = 0; i < this.objectNames.size(); ++i) {
                sb.append(this.objectNames.get(i).toString()).append(",");
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append(" attribute ").append(this.attribute);
        return sb.toString();
    }

    public synchronized boolean containsObservedObject(ObjectName objectName) {
        return this.objectNames.contains(objectName);
    }

    public synchronized void removeObservedObject(ObjectName objectName) {
        if (this.objectNames.contains(objectName)) {
            this.objectNames.remove(objectName);
        }
    }

    private class MonitorTask
    extends TimerTask {
        private MonitorTask() {
        }

        public void run() {
            if (Monitor.this.isActive()) {
                if (Monitor.this.objectNames.size() == 0) {
                    Monitor.this.getLogger().warn(new StringBuffer("Monitor ").append(Monitor.this.toString()).append(" no objects specified for monitoring"));
                    if (!Monitor.this.errorNotified) {
                        Monitor.this.notifyListeners("jmx.monitor.error.mbean", null);
                    }
                    Monitor.this.errorNotified = true;
                }
                for (int i = 0; i < Monitor.this.objectNames.size(); ++i) {
                    ObjectName objectName = (ObjectName)Monitor.this.objectNames.get(i);
                    try {
                        if (objectName == null) {
                            Monitor.this.getLogger().warn("Monitor " + Monitor.this.toString() + " object name " + objectName + " not found");
                            if (!Monitor.this.errorNotified) {
                                Monitor.this.notifyListeners("jmx.monitor.error.mbean", objectName);
                            }
                            Monitor.this.errorNotified = true;
                            continue;
                        }
                        Monitor.this.getLogger().info("Execute monitor " + Monitor.this.toString());
                        if (!Monitor.this.server.isRegistered(objectName)) {
                            Monitor.this.getLogger().warn("Monitor " + Monitor.this.toString() + " object name " + objectName + " not found");
                            if (!Monitor.this.mBeanFound) continue;
                            Monitor.this.mBeanFound = false;
                            Monitor.this.notifyListeners("jmx.monitor.error.mbean", objectName);
                            continue;
                        }
                        Monitor.this.mBeanFound = true;
                        if (Monitor.this.errorNotified) continue;
                        MBeanInfo info = Monitor.this.server.getMBeanInfo(objectName);
                        MBeanAttributeInfo[] attributes = info.getAttributes();
                        boolean found = false;
                        if (attributes != null) {
                            for (int j = 0; j < attributes.length; ++j) {
                                if (!attributes[j].getName().equals(Monitor.this.attribute)) continue;
                                found = true;
                            }
                        }
                        if (!found) {
                            Monitor.this.getLogger().warn("Monitor " + Monitor.this.toString() + " attribute " + Monitor.this.attribute + " not found");
                            Monitor.this.errorNotified = true;
                            Monitor.this.notifyListeners("jmx.monitor.error.attribute", objectName, Monitor.this.attribute);
                            continue;
                        }
                        Object attributeValue = Monitor.this.server.getAttribute(objectName, Monitor.this.attribute);
                        if (attributeValue == null) {
                            Monitor.this.getLogger().warn("Monitor " + Monitor.this.toString() + " attribute " + Monitor.this.attribute + " is null");
                            Monitor.this.errorNotified = true;
                            Monitor.this.notifyListeners("jmx.monitor.error.type", objectName, Monitor.this.attribute);
                            continue;
                        }
                        Monitor.this.executeMonitor(objectName, attributeValue);
                        continue;
                    }
                    catch (Exception e) {
                        Monitor.this.getLogger().warn("Monitor " + Monitor.this.toString() + " object name " + objectName + " not found");
                        Monitor.this.errorNotified = true;
                        Monitor.this.notifyListeners("jmx.monitor.error.runtime", objectName, Monitor.this.attribute, e);
                    }
                }
            }
        }
    }
}

