/*
 * Decompiled with CFR 0.152.
 */
package tle.framework.component.impl.aamanager;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import tle.framework.component.ComponentConfig;
import tle.framework.component.ComponentException;
import tle.framework.component.impl.ComponentBase;
import tle.framework.component.impl.aamanager.Authenticator;
import tle.framework.component.impl.aamanager.DefaultAAManagerMBean;
import tle.framework.component.impl.aamanager.RoleManager;
import tle.framework.component.impl.aamanager.ServiceManager;
import tle.framework.component.impl.aamanager.SessionManager;
import tle.framework.component.impl.aamanager.UserManager;
import tle.framework.component.spi.aamanager.AAManager;
import tle.framework.component.spi.aamanager.AAManagerException;
import tle.framework.component.spi.aamanager.AAManagerProxy;
import tle.framework.component.spi.aamanager.NullService;
import tle.framework.component.spi.aamanager.NullUser;
import tle.framework.component.spi.aamanager.Role;
import tle.framework.component.spi.aamanager.Service;
import tle.framework.component.spi.aamanager.User;
import tle.framework.component.spi.aamanager.UserAuthenticationInfo;
import tle.framework.component.spi.ra.RequestInfo;

public class DefaultAAManager
extends ComponentBase
implements AAManager,
DefaultAAManagerMBean {
    private AAManagerProxy proxy;
    private RoleManager roleManager;
    private ServiceManager serviceManager;
    private SessionManager sessionManager;
    private UserManager userManager;
    private Authenticator authenticator;

    protected void initing(ComponentConfig config) throws ComponentException {
        String roleManagerClassName = config.getInitParameter("RoleManager");
        String serviceManagerClassName = config.getInitParameter("ServiceManager");
        String sessionManagerClassName = config.getInitParameter("SessionManager");
        String userManagerClassName = config.getInitParameter("UserManager");
        String authenticatorClassName = config.getInitParameter("Authenticator");
        try {
            Class<?> roleManagerClass = Class.forName(roleManagerClassName);
            RoleManager roleManagerInstance = (RoleManager)roleManagerClass.newInstance();
            roleManagerInstance.init(config);
            this.roleManager = roleManagerInstance;
        }
        catch (Throwable e) {
            throw new ComponentException(e.getMessage(), e);
        }
        try {
            Class<?> serviceManagerClass = Class.forName(serviceManagerClassName);
            ServiceManager serviceManagerInstance = (ServiceManager)serviceManagerClass.newInstance();
            serviceManagerInstance.init(config);
            this.serviceManager = serviceManagerInstance;
        }
        catch (Throwable e) {
            throw new ComponentException(e.getMessage(), e);
        }
        try {
            Class<?> sessionManagerClass = Class.forName(sessionManagerClassName);
            SessionManager sessionManagerInstance = (SessionManager)sessionManagerClass.newInstance();
            sessionManagerInstance.init(config);
            this.sessionManager = sessionManagerInstance;
        }
        catch (Throwable e) {
            throw new ComponentException(e.getMessage(), e);
        }
        try {
            Class<?> authenticatorClass = Class.forName(authenticatorClassName);
            Authenticator authenticatorInstance = (Authenticator)authenticatorClass.newInstance();
            authenticatorInstance.init(config);
            this.authenticator = authenticatorInstance;
        }
        catch (Throwable e) {
            throw new ComponentException(e.getMessage(), e);
        }
        try {
            Class<?> userManagerClass = Class.forName(userManagerClassName);
            UserManager userManagerInstance = (UserManager)userManagerClass.newInstance();
            userManagerInstance.init(config);
            this.userManager = userManagerInstance;
        }
        catch (Throwable e) {
            throw new ComponentException(e.getMessage(), e);
        }
        this.proxy = new AAManagerProxy(this);
    }

    public User authenticate(UserAuthenticationInfo authInfo) throws AAManagerException {
        this.authenticator.authenticate(authInfo);
        return this.userManager.getUser(authInfo);
    }

    public void openSession(User user, HttpServletRequest request, HttpServletResponse response) throws AAManagerException {
        this.sessionManager.openSession(user, request, response);
    }

    public void closeSession(HttpServletRequest request, HttpServletResponse response) throws AAManagerException {
        this.sessionManager.closeSession(request, response);
    }

    public User getSessionUser(HttpServletRequest request) throws AAManagerException {
        User user = this.sessionManager.getSessionUser(request);
        if (user == null) {
            return NullUser.intance;
        }
        return user;
    }

    public boolean checkAuthorization(User user, Service service) throws AAManagerException {
        Role[] roles = user.getRoles();
        if (roles != null) {
            for (int i = 0; i < roles.length; ++i) {
                if (!this.serviceManager.hasGrant(roles[i], service)) continue;
                return true;
            }
        }
        return false;
    }

    public Service getService(RequestInfo requestInfo) throws AAManagerException {
        Service service = this.serviceManager.getService(requestInfo);
        if (service == null) {
            return NullService.intance;
        }
        return service;
    }

    public Role getRole(String roleID) throws AAManagerException {
        return this.roleManager.getRole(roleID);
    }

    public AAManagerProxy getAAManagerProxy() {
        return this.proxy;
    }

    public String getRoleManagerClassName() {
        return this.roleManager.getClass().getName();
    }

    public String getServiceManagerClassName() {
        return this.serviceManager.getClass().getName();
    }

    public String getSessionManagerClassName() {
        return this.sessionManager.getClass().getName();
    }

    public String getUserManagerClassName() {
        return this.userManager.getClass().getName();
    }

    public String getAuthenticatorClassName() {
        return this.authenticator.getClass().getName();
    }

    public void reloadServiceConfiguration() throws AAManagerException {
        this.serviceManager.reloadConfiguration(this.config);
    }
}

