/*
 * Ʈ: TLE2Framework
 * ϸ: ServiceGroup.java
 * ۼ: 2004. 11. 10
 */
package tle.framework.component.impl.aamanager.service;

import java.util.Map;
import java.util.StringTokenizer;

/**
 *   &lt;group> ±  Ѵ.
 * 
 * @author ֹ
 * @since 2.0
 */
public class ServiceGroup {
	private String commandPrefix;
	private boolean needAuthentication;
	private boolean allRolesUsable;
	private Map roleList = new java.util.HashMap();
	
	public ServiceGroup(String commandPrefix, boolean needAuthentication, boolean allRollUsable, String roleIDs) {
		this.commandPrefix = commandPrefix;
		this.needAuthentication = needAuthentication;
		this.allRolesUsable = allRollUsable;
		
		if (roleIDs != null) {
			StringTokenizer st = new StringTokenizer(roleIDs, ", ");
			while(st.hasMoreTokens()) {
				String roleID = st.nextToken();
				roleList.put(roleID, roleID);
			}
		}
	}
	
	/**
	 *  ׷ ɾ prefix Ѵ.
	 */
	public String getCommandPrefix() {
		return commandPrefix;
	}
	/**
	 *  ׷ ü  밡  true Ѵ.
	 */
	public boolean isAllRolesUsable() {
		return allRolesUsable;
	}
	/**
	 *  ׷ 񽺸 ϱ   ʿ  true Ѵ.
	 */
	public boolean isNeedAuthentication() {
		return needAuthentication;
	}
	
	/**
	 *  ׷ 񽺸   ID   ִ  true Ѵ.
	 * 
	 * @param roleID  ID
	 */
	public boolean hasGrant(String roleID) {
		return roleList.containsKey(roleID);
	}
}
