// HKBitmap.cpp: implementation of the CHKBitmap class.
// Author:	Paul Reynolds 
// Date:	24/04/1998
// Version:	1.0
//////////////////////////////////////////////////////////////////////

#include <stdafx.h>
#include "HKBitmap.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CHKBitmap::CHKBitmap()
{
	m_crBlack = 0;
	m_crWhite = RGB(255,255,255);
}

CHKBitmap::~CHKBitmap()
{

}

int CHKBitmap::Width()
{
	BITMAP bm;
	GetBitmap(&bm);
	return bm.bmWidth;
}

int CHKBitmap::Height()
{
	BITMAP bm;
	GetBitmap(&bm);
	return bm.bmHeight;
}

void CHKBitmap::DrawTransparent(CDC * pDC, int x, int y, COLORREF crColour, INVERT Invert)
{
	COLORREF crOldBack = pDC->SetBkColor(m_crWhite);
	COLORREF crOldText = pDC->SetTextColor(m_crBlack);
	CDC dcImage, dcTrans;

	// Create two memory dcs for the image and the mask
	dcImage.CreateCompatibleDC(pDC);
	dcTrans.CreateCompatibleDC(pDC);

	// Select the image into the appropriate dc
	CBitmap* pOldBitmapImage = dcImage.SelectObject(this);

	// Create the mask bitmap
	CBitmap bitmapTrans;
	int nWidth = Width();
	int nHeight = Height();
	bitmapTrans.CreateBitmap(nWidth, nHeight, 1, 1, NULL);

	// Select the mask bitmap into the appropriate dc
	CBitmap* pOldBitmapTrans = dcTrans.SelectObject(&bitmapTrans);

	// Build mask based on transparent colour
	dcImage.SetBkColor(crColour);

	if (Invert == NONE)
	{
		dcTrans.BitBlt(0, 0, nWidth, nHeight, &dcImage, 0, 0, SRCCOPY);
		// Do the work - True Mask method - cool if not actual display
		pDC->BitBlt   (x, y, nWidth, nHeight, &dcImage, 0, 0, SRCINVERT);
		pDC->BitBlt   (x, y, nWidth, nHeight, &dcTrans, 0, 0, SRCAND);
		pDC->BitBlt   (x, y, nWidth, nHeight, &dcImage, 0, 0, SRCINVERT);
	}
	else
	if (Invert == VERT)
	{
		dcTrans.BitBlt(0, 0, nWidth, nHeight, &dcImage, 0, 0, SRCCOPY);
		pDC->StretchBlt   (x, y, nWidth, nHeight, &dcImage, nWidth-1, 0, -nWidth, nHeight, SRCINVERT);
		pDC->StretchBlt   (x, y, nWidth, nHeight, &dcTrans, nWidth-1, 0, -nWidth, nHeight, SRCAND);
		pDC->StretchBlt   (x, y, nWidth, nHeight, &dcImage, nWidth-1, 0, -nWidth, nHeight, SRCINVERT);
	}
	else
	{
		dcTrans.BitBlt(0, 0, nWidth, nHeight, &dcImage, 0, 0, SRCCOPY);
		//dcTrans.StretchBlt(0, 0, nWidth, nHeight, &dcImage, 0, nHeight-1, nWidth, -nHeight, SRCCOPY);
		pDC->StretchBlt   (x, y, nWidth, nHeight, &dcImage, 0, nHeight-1, nWidth, -nHeight, SRCINVERT);
		pDC->StretchBlt   (x, y, nWidth, nHeight, &dcTrans, 0, nHeight-1, nWidth, -nHeight, SRCAND);
		pDC->StretchBlt   (x, y, nWidth, nHeight, &dcImage, 0, nHeight-1, nWidth, -nHeight, SRCINVERT);
	}

	// Restore settings
	dcImage.SelectObject(pOldBitmapImage);
	dcTrans.SelectObject(pOldBitmapTrans);
	pDC->SetBkColor(crOldBack);
	pDC->SetTextColor(crOldText);
}


// DrawInvertedBitmap	- Draws the bitmap after inverting it
// hBimtap		- Bitmap handle
// hPal			- Palette to use when drawing the bitmap
// bLateral		- Flag to indicate whether to invert laterally or vertically
// xDest		- X coordinate of top left corner to draw at
// yDest		- Y coordinate of top left corner to draw at
void CHKBitmap::DrawInvertedBitmap( CDC *pDC, int xDest, int yDest, BOOL bLateral)
{
	// Create a memory DC compatible with the destination DC
	CDC memDC;
	memDC.CreateCompatibleDC( pDC );

	// Get logical coordinates
	BITMAP bm;
	GetObject(sizeof(bm), &bm );

	//memDC.SelectObject( &bitmap );
	CBitmap* pOldBmp = memDC.SelectObject(this);
	
	/*
	// Select and realize the palette
	if( hPal && pDC->GetDeviceCaps(RASTERCAPS) & RC_PALETTE)
	{
		SelectPalette( pDC->GetSafeHdc(), hPal, FALSE );
		pDC->RealizePalette();
	}
	*/

	if( bLateral )
		pDC->StretchBlt( xDest, yDest, bm.bmWidth, bm.bmHeight, &memDC, 
				bm.bmWidth-1, 0, -bm.bmWidth, bm.bmHeight, SRCCOPY );
	else
		pDC->StretchBlt( xDest, yDest, bm.bmWidth, bm.bmHeight, &memDC, 
				0, bm.bmHeight-1, bm.bmWidth, -bm.bmHeight, SRCCOPY );

	// Restore the old bitmap
	memDC.SelectObject(pOldBmp);
}

// GetInvertedBitmap	- Creates a new bitmap with the inverted image
// Returns		- Handle to a new bitmap with inverted image
// hBitmap		- Bitmap to invert
// bLateral		- Flag to indicate whether to invert laterally or vertically
HBITMAP CHKBitmap::GetInvertedBitmap(BOOL bLateral )
{
	// Create a memory DC compatible with the display
	CDC sourceDC, destDC;
	sourceDC.CreateCompatibleDC( NULL );
	destDC.CreateCompatibleDC( NULL );

	// Get logical coordinates
	BITMAP bm;
	GetObject(sizeof( bm ), &bm );

	// Create a bitmap to hold the result
	CBitmap bmResult;
	bmResult.CreateCompatibleBitmap(&CClientDC(NULL), bm.bmWidth, bm.bmHeight);

	// Select bitmaps into the DCs
	CBitmap* pOldSource = sourceDC.SelectObject(this);
	CBitmap* pOldDest = destDC.SelectObject(&bmResult);
	
	if( bLateral )
		destDC.StretchBlt( 0, 0, bm.bmWidth, bm.bmHeight, &sourceDC, 
				bm.bmWidth-1, 0, -bm.bmWidth, bm.bmHeight, SRCCOPY );
	else
		destDC.StretchBlt( 0, 0, bm.bmWidth, bm.bmHeight, &sourceDC, 
				0, bm.bmHeight-1, bm.bmWidth, -bm.bmHeight, SRCCOPY );

	// Reselect the old bitmaps
	sourceDC.SelectObject(pOldSource);
	destDC.SelectObject(pOldDest);

	return (HBITMAP)bmResult.Detach();
}

