// s35.cpp : ܼ  α׷   մϴ.
//

#include "stdafx.h"

#include "rect.h"
#include <assert.h>
#include <list>


void print(i4::rect &r)
{
	printf("(%d,%d,%d,%d)\n", r.left, r.top, r.right, r.bottom);
}

#include <windows.h>

void set_rect(RECT &r1, i4::rect &r2)
{
	::SetRect(&r1, r2.left, r2.top, r2.right, r2.bottom);
}

void print(RECT &r)
{
	RECT r1,r2,r3;
	
	printf("(%d,%d,%d,%d)\n", r.left, r.top, r.right, r.bottom);
}

int _tmain(int argc, _TCHAR* argv[])
{
	using namespace i4;	

	point p1(10,10);
	point p2(p1);
	assert(p1==p2);
	point p3;
	p3 = p1-p2;
	assert(p1==point(10,10));

	puts("test rect move");
	{
		rect r1(point(10,10),size(10,10));
		
		r1.move_x(20);
		assert(r1==rect(20,10,30,20));

		r1.move_xy(0,0);		
		assert(r1==rect(0,0,10,10));
		
		r1.move_y(10);
		assert(r1==rect(0,10,10,20));
	}
	puts("... ok\n");
	
	puts("test rect intersect, union, substract");
	{
		rect r1(0,0,10,10),r2(5,5,15,15), r3;

		r3.intersect_rect(r1,r2);
		assert(r3==rect(5,5,10,10));

		assert(!r3.intersect_rect(rect(0,0,10,10),rect(10,10,20,20)));

		r3.union_rect(r1,r2);
		assert(r3.is_equal(rect(0,0,15,15)));

		/*
		RECT _r1={0, 0, 10, 10},_r2={5, 0, 10, 10},_r3;
		//set_rect(_r1,r1);
		//set_rect(_r2,r2);

		BOOL b = ::SubtractRect(&_r3,&_r1,&_r2);

		printf("%d\n", b);

		print(_r1);
		print(_r2);
		print(_r3);

		r3.subtract_rect(r1,r2);
		//print(r3);
		//assert(r3==rect(0,0,5,5));
		*/
	}
	puts("... ok\n");

	puts("test rect inflate, deflate");
	{
		rect r1(0,0,10,10);

		r1.deflate_rect(1,1);
		assert(r1 == rect(1,1,9,9));
		
		r1.inflate_rect(1,1);
		assert(r1 == rect(0,0,10,10));
	}
	puts("... ok\n");

	puts("test rect center, pt_in_rect, left_top, right_bottomt");
	{
		rect r1(0,0,10,10);

		assert(r1.center() == point(5,5));

		r1.set_rect(0,0,10,10);
		assert(r1.pt_in_rect(point(5,5)));
		assert(r1.pt_in_rect(point(0,0)));
		assert(!r1.pt_in_rect(point(10,10)));
		assert(r1.left_top()==point(0,0));
		assert(r1.right_bottom()==point(10,10));

		r1.left_top()=point(10,10);
		r1.right_bottom()=point(20,20);
		assert(r1==rect(10,10,20,20));

	}
	puts("... ok\n");

	char *s = "12345";
	std::list<char> list(s,s+strlen(s));

	for (std::list<char>::iterator i = list.begin(),j; i != list.end();)
	{
		printf("%c",*i);
		j=i++;
		//list.erase(i);
		list.erase(j);
	}

		
	return 0;
}

