/*****
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
*****/

#ifndef UNICODE_H
#define UNICODE_H

typedef unsigned short UNICHAR;

class	cUnicode
{
public:
	cUnicode(const char  * str, int len = 0, bool internal = false, const char *charset = "");
	cUnicode(const UNICHAR * str, int len = 0, bool internal = false, const char *charset = "");
	~cUnicode();

	operator const char  *()   { return m_charBuf;    }
	operator const UNICHAR *() { return m_unicodeBuf; }

	const char    *c_str()     { return m_charBuf;    }
	const UNICHAR *u_str()     { return m_unicodeBuf; }

	int     length()           { return m_strLen;     }
	int     c_len()            { return m_charLen;    }
	int     u_len()            { return m_unicodeLen; }

private:
		// Accessible variables
	char	m_charBuf[MSL];
	UNICHAR	m_unicodeBuf[MSL];

	// str="012" : m_strLen==3, m_charLen==4, m_unicodeLen==8 
	int		m_strLen;		  // string length 
	int		m_charLen;        // char buf length, include '\0',
	int		m_unicodeLen;     // nchar buf length, m_charLen * sizeof(NCHAR)


	void	CharToUnicode(const char *charset, bool internal);
	void	UnicodeToChar(const char *charset, bool internal);
	void	UnicodeCpy(const UNICHAR * str, int maxlen);
};


#endif
