// GrannyListView.cpp :  Դϴ.
//

#include "stdafx.h"
#include "GrannyViewerDoc.h"
#include "granny/GrannyLoader.h"
#include "granny/GrannyModelTD.h"
#include "granny/GrannyModelAOS.h"
#include ".\grannylistview.h"
#include "debug.h"



// CGrannyListView

IMPLEMENT_DYNCREATE(CGrannyListView, CTreeView)
CGrannyListView::CGrannyListView()
{
}

CGrannyListView::~CGrannyListView()
{
}


BEGIN_MESSAGE_MAP(CGrannyListView, CTreeView)
	ON_WM_CREATE()
	ON_NOTIFY_REFLECT(NM_DBLCLK, OnNMDblclk)
	ON_NOTIFY_REFLECT(NM_CLICK, OnNMClick)
	ON_NOTIFY_REFLECT(TVN_SELCHANGED, OnTvnSelchanged)
	ON_NOTIFY_REFLECT(NM_RCLICK, OnNMRclick)
END_MESSAGE_MAP()

#ifdef _DEBUG
CGrannyViewerDoc* CGrannyListView::GetDocument() const // ׵   ζ ˴ϴ.
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CGrannyViewerDoc)));
	return (CGrannyViewerDoc*)m_pDocument;
}
#endif //_DEBUG

// CGrannyListView ޽ óԴϴ.

std::string getFileName(const std::string& path_name, char split)
{
	int pos = path_name.find_last_of(split);
	if (pos != std::string::npos) {
		int len = path_name.length()-pos-5;
		return path_name.substr(pos+1, len);
	}

	return path_name;
}

std::string getHandName(int hand)
{
	switch (hand) {
		case HAND_NONE :  return "none";
		case HAND_LEFT :  return "left";
		case HAND_RIGHT : return "right";
		case HAND_OWNER : return "owner";
	}
	return "";
}

bool isFileExist(std::string file)
{
	CFile f;
	return f.Open(file.c_str(), CFile::modeRead | CFile::shareDenyNone);
}

HTREEITEM CGrannyListView::InsertModelTD(CTreeCtrl& tree, HTREEITEM htRoot, Uint32 id, cGrannyModelTD *model)
{
	const UINT nMask = TVIF_TEXT | TVIF_PARAM;

	if (!model) return NULL;

	CString strText;
	strText.Format("%04d %s", GETID(id), getFileName(model->m_filename).c_str());
	
	HTREEITEM htChar  = tree.InsertItem(nMask, strText, 0,0,0,0, SETCHAR(id), htRoot, 0);
	HTREEITEM htAnim  = tree.InsertItem("anim", htChar);
	HTREEITEM htEquip = IsPlayerModelID(id) ? tree.InsertItem("equip", htChar) : NULL;
	
	strText.Format("file: %s%s", isFileExist(model->m_filename) ? "":"(x) ",model->m_filename.c_str());
	tree.InsertItem(strText, htChar);

	if (!model->desc.empty()) {
		strText.Format("desc: %s", model->desc.c_str());
		tree.InsertItem(strText, htChar);
	}

	strText.Format("hand: %s", getHandName(model->hand).c_str());
	tree.InsertItem(strText, htChar);

	strText.Format("bone left: %d, right: %d", model->left_hand_bone, model->right_hand_bone);
	tree.InsertItem(strText, htChar);

	strText.Format("%s (default)", getFileName(model->defaultanimname).c_str());
	HTREEITEM htItem = tree.InsertItem(nMask, strText, 0,0,0,0, SETANIM(AnimTypeData::GetAnimType("default.animation")), htAnim, 0);
	strText.Format("file: %s%s", isFileExist(model->defaultanimname) ? "":"(x) ",model->defaultanimname.c_str());
	tree.InsertItem(strText, htItem);
	
	std::map<int, std::string>& anim_names = model->animation_names;
	for (std::map<int, std::string>::iterator i = anim_names.begin(); i != anim_names.end(); i++) {
		strText.Format("%s (%s,%d)", getFileName(i->second).c_str(), 
			AnimTypeData::GetAnimTypeName(i->first).c_str(),i->first);
		HTREEITEM htItem = tree.InsertItem(nMask, strText, 0,0,0,0, SETANIM(i->first), htAnim,0);
		strText.Format("file: %s%s", isFileExist(i->second) ? "":"(x) ",i->second.c_str());
		tree.InsertItem(strText, htItem);
	}

	return htEquip;
}

HTREEITEM CGrannyListView::InsertModelAOS(CTreeCtrl& tree, HTREEITEM htRoot, Uint32 id, cGrannyModelAOS *model)
{
	const UINT nMask = TVIF_TEXT | TVIF_PARAM;

	if (!model) return NULL;

	CString strText;
	strText.Format("%04d %s", GETID(id), model->desc.c_str());

	HTREEITEM htChar  = tree.InsertItem(nMask, strText, 0,0,0,0, SETCHAR(id), htRoot, 0);
	HTREEITEM htPart  = tree.InsertItem("part", htChar);
	HTREEITEM htAnim  = tree.InsertItem("anim", htChar);
	HTREEITEM htEquip = tree.InsertItem("equip", htChar);

	std::map <int, cGrannyModelTD *> models = model->models;

	if (models.empty()) return htEquip;

	for (std::map<int, cGrannyModelTD*>::iterator i = models.begin(); i != models.end(); i++) {
		cGrannyModelTD *td = i->second;
		if (!td) continue;

		UINT id2 = 0xC000 | id<< 4 | i->first;
		strText.Format("%2d %s", i->first, AOSBodyData::GetAosBodyName(i->first).c_str());
		HTREEITEM htPart2 = tree.InsertItem(nMask, strText, 0,0,0,0, SETCHAR(id2), htPart, 0);
		strText.Format("file: %s", td->m_filename.c_str());
		tree.InsertItem(strText, htPart2);
	}

	if (!model->desc.empty()) {
		strText.Format("desc: %s", model->desc.c_str());
		tree.InsertItem(strText, htChar);
	}

	strText.Format("hand: %s", getHandName(model->hand).c_str());
	tree.InsertItem(strText, htChar);

	strText.Format("bone left: %d, right: %d", model->left_hand_bone, model->right_hand_bone);
	tree.InsertItem(strText, htChar);

	// part animation is same.
	std::map<int, std::string>& anim_names = models.begin()->second->animation_names;
	for (std::map<int, std::string>::iterator i = anim_names.begin(); i != anim_names.end(); i++) {
		strText.Format("%s (%s,%d)", getFileName(i->second).c_str(), 
			AnimTypeData::GetAnimTypeName(i->first).c_str(),i->first);
		HTREEITEM htItem = tree.InsertItem(nMask, strText, 0,0,0,0, SETANIM(i->first), htAnim,0);
		strText.Format("file: %s%s", isFileExist(i->second) ? "":"(x) ",i->second.c_str());
		tree.InsertItem(strText, htItem);
	}

	return htEquip;
}

HTREEITEM CGrannyListView::InsertEquipItem(CTreeCtrl& tree, HTREEITEM htRoot, Uint32 id, cGrannyModelTD *model)
{
	const UINT nMask = TVIF_TEXT | TVIF_PARAM;

	if (!model) return NULL;

	CString strText;
	strText.Format("%04d %s", GETID(id), getFileName(model->m_filename).c_str());
	
	HTREEITEM htChar = tree.InsertItem(nMask, strText, 0,0,0,0, SETCHAR(id), htRoot, 0);

	strText.Format("file: %s%s", isFileExist(model->m_filename) ? "":"(x) ",model->m_filename.c_str());
	tree.InsertItem(strText, htChar);

	strText.Format("id: %d (0x%08x)", id, id);
	tree.InsertItem(strText, htChar);

	if (!model->desc.empty()) {
		strText.Format("desc: %s", model->desc.c_str());
		tree.InsertItem(strText, htChar);
	}

	strText.Format("hand: %s", getHandName(model->hand).c_str());
	tree.InsertItem(strText, htChar);

	strText.Format("bone left: %d, right: %d", model->left_hand_bone, model->right_hand_bone);
	tree.InsertItem(strText, htChar);

	return htChar;
}


void CGrannyListView::OnInitialUpdate()
{
	CTreeView::OnInitialUpdate();

	DEBUG_TIMER_START("void CGrannyListView::OnInitialUpdate()");

	CTreeCtrl& tree=GetTreeCtrl();
	tree.DeleteAllItems();

	HTREEITEM htRoot = tree.InsertItem("Character"), htFirst=NULL;

	CGrannyViewerDoc* pDoc = GetDocument(); ASSERT(pDoc);
	cGrannyLoader* pLoader = pDoc->GetGrannyLoader(); 
	if (!pLoader) {
		DEBUG_TIMER_STOP("void CGrannyListView::OnInitialUpdate()");
		return;
	}
	GrannyModelMap& models = pLoader->GetGrannyModels();

	std::map<Uint32, HTREEITEM> mapEquip;
	
	for (GrannyModelMapIter iter = models.begin(); iter != models.end(); iter++) {
		Uint32 id = iter->first;
		Uint32 assign = GETASSIGN(id);
		if (!assign) {
			// aos part model
			if (ISPART(id)) continue;

			// insert char model
			HTREEITEM htEquip;

			cGrannyModelTD *td = dynamic_cast<cGrannyModelTD*>(iter->second);
			if (td) 
			{
				htEquip = InsertModelTD(tree, htRoot, id, td);
			}
			else
			{
				cGrannyModelAOS *aos = dynamic_cast<cGrannyModelAOS*>(iter->second);
				if (!aos) continue;
				htEquip = InsertModelAOS(tree, htRoot, id, aos);
			}

			if (IsPlayerModelID(id))
				mapEquip.insert(std::make_pair(id, htEquip));
		}
#if 1
		else {
			// assume, equip model is after than player model
			// insert equip item
			std::map<Uint32, HTREEITEM>::iterator i = mapEquip.find(assign);
			if (i == mapEquip.end()) continue;
			HTREEITEM htItem = i->second;

			if (!htFirst) htFirst = tree.GetParentItem(htItem);

			cGrannyModelTD* model = reinterpret_cast<cGrannyModelTD*>(iter->second);
			
			InsertEquipItem(tree, htItem, id, model);
		}
#endif
	}

#if 0
	// insert equip item
	for (GrannyModelMapIter iter = models.begin(); iter != models.end(); iter++) {
		Uint32 id = iter->first;
		Uint32 assign = GETASSIGN(id);
		if (!assign) continue;

		std::map<Uint32, HTREEITEM>::iterator i = mapEquip.find(assign);
		if (i == mapEquip.end()) continue;
		HTREEITEM htItem = i->second;

		if (!htFirst) htFirst = tree.GetParentItem(htItem);

		cGrannyModelTD* model = reinterpret_cast<cGrannyModelTD*>(iter->second);
		
		InsertEquipItem(tree, htItem, id, model);
	}
#endif
	
	tree.Expand(htRoot, TVE_EXPAND);

#if 0
	if (htFirst) {
		tree.Expand(htFirst, TVE_EXPAND);
		tree.SelectItem(htFirst);
	}
#endif

	DEBUG_TIMER_STOP("void CGrannyListView::OnInitialUpdate()");
}


int CGrannyListView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CTreeView::OnCreate(lpCreateStruct) == -1)
		return -1;

	CTreeCtrl& tree=GetTreeCtrl();
	tree.ModifyStyle(0,TVS_HASBUTTONS | TVS_LINESATROOT | TVS_HASLINES | TVS_SHOWSELALWAYS);
	
	return 0;
}

UINT CGrannyListView::GetSelectedItemData()
{
	CTreeCtrl &TreeCtrl = GetTreeCtrl();
	HTREEITEM htItem = TreeCtrl.GetSelectedItem();
	
	if (htItem == NULL) 
		return 0;
	else
		return TreeCtrl.GetItemData(htItem);
}

CString CGrannyListView::GetSelectedItemName()
{
	CTreeCtrl &TreeCtrl = GetTreeCtrl();
	HTREEITEM htItem = TreeCtrl.GetSelectedItem();

	return TreeCtrl.GetItemText(htItem);
}

void CGrannyListView::OnNMDblclk(NMHDR *pNMHDR, LRESULT *pResult)
{

	*pResult = 0;
}

void CGrannyListView::OnNMClick(NMHDR *pNMHDR, LRESULT *pResult)
{
	*pResult = 0;
}

void CGrannyListView::OnNMRclick(NMHDR *pNMHDR, LRESULT *pResult)
{
	UINT iData = GetSelectedItemData();
	CGrannyViewerDoc *pDoc = GetDocument();
	if (!pDoc) return;
	pDoc->SetCurEquipId(INVALID_GRN_ID);

	*pResult = 0;
}

void CGrannyListView::OnTvnSelchanged(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMTREEVIEW pNMTreeView = reinterpret_cast<LPNMTREEVIEW>(pNMHDR);
	
	UINT iData = GetSelectedItemData();
	CGrannyViewerDoc *pDoc = GetDocument();
	if (!pDoc) return;

	if (ISSET(iData))
	{
		if (ISANIM(iData)) {
			pDoc->SetCurAnimId(GETDATA(iData));
		} else if (ISCHAR(iData)) {
			UINT id = GETDATA(iData);
			if (GETASSIGN(id)) {
				pDoc->SetCurEquipId(id);
			} else {
				pDoc->SetCurModelId(id);
			}
		}
	}

	*pResult = 0;
}


