// GrannyViewerDoc.cpp : CGrannyViewerDoc Ŭ 
//

#include "stdafx.h"
#include "GrannyViewer.h"
#include "granny/GrannyLoader.h"
#include "granny/GrannyModelTD.h"
#include "loaders/StitchinLoader.h"
#include "iris/config.h"
#include "iris/exception.h"
#include "iris/Debug.h"
#include "grannyviewerdoc.h"
#include "grannyviewerview.h"
#include "LogView.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CGrannyViewerDoc

IMPLEMENT_DYNCREATE(CGrannyViewerDoc, CDocument)

BEGIN_MESSAGE_MAP(CGrannyViewerDoc, CDocument)
	ON_COMMAND(ID_FILE_VIEWXML, OnFileViewxml)
	ON_COMMAND(ID_FILE_CLEARLOG, OnFileClearlog)
	ON_COMMAND(ID_FILE_EXPORTMODEL, OnFileExportmodel)
	ON_COMMAND(ID_LOG_LOGLEVEL1, OnLogLoglevel1)
	ON_UPDATE_COMMAND_UI(ID_LOG_LOGLEVEL1, OnUpdateLogLoglevel1)
	ON_COMMAND(ID_LOG_LOGLEVEL2, OnLogLoglevel2)
	ON_UPDATE_COMMAND_UI(ID_LOG_LOGLEVEL2, OnUpdateLogLoglevel2)
	ON_COMMAND(ID_LOG_LOGLEVEL3, OnLogLoglevel3)
	ON_UPDATE_COMMAND_UI(ID_LOG_LOGLEVEL3, OnUpdateLogLoglevel3)
	ON_COMMAND(ID_LOG_SETFONT, &CGrannyViewerDoc::OnLogSetfont)
	ON_COMMAND(ID_FILE_DUMPMODEL, &CGrannyViewerDoc::OnFileDumpmodel)
	ON_COMMAND(ID_FILE_SHELLOPEN, &CGrannyViewerDoc::OnFileShellopen)
	ON_COMMAND(ID_LOG_LOGLEVEL4, &CGrannyViewerDoc::OnLogLoglevel4)
	ON_UPDATE_COMMAND_UI(ID_LOG_LOGLEVEL4, &CGrannyViewerDoc::OnUpdateLogLoglevel4)
END_MESSAGE_MAP()


// CGrannyViewerDoc /Ҹ

CGrannyViewerDoc* g_pGrannyViewerDoc = NULL;

CGrannyViewerDoc* GfxGetDocument()
{
	return g_pGrannyViewerDoc;
}

CGrannyViewerDoc::CGrannyViewerDoc()
: m_bInit(false), m_pGrannyLoader(NULL), m_lastSelect(SEL_NONE), m_pStitchinLoader(NULL)
{
	m_iCurModelId = m_iCurAnimId = m_iCurEquipId = m_iLastId = INVALID_GRN_ID;
	g_pGrannyViewerDoc = this;
}

CGrannyViewerDoc::~CGrannyViewerDoc()
{
	delete m_pGrannyLoader; m_pGrannyLoader = NULL;
	delete m_pStitchinLoader; m_pStitchinLoader = NULL;
	g_pGrannyViewerDoc = NULL;

}

CView* CGrannyViewerDoc::FindView(CRuntimeClass* pClass)
{
	POSITION pos = GetFirstViewPosition();
	while (pos != NULL)
	{
		CView* pView = GetNextView(pos);
		if (pView->IsKindOf(pClass)) return pView;
	}  

	return NULL;
}

BOOL CGrannyViewerDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	if (m_bInit) return TRUE;
	m_bInit = true;
	
	return TRUE;
}




// CGrannyViewerDoc serialization

void CGrannyViewerDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: ⿡  ڵ带 ߰մϴ.
	}
	else
	{
		// TODO: ⿡ ε ڵ带 ߰մϴ.
	}
}


// CGrannyViewerDoc 

#ifdef _DEBUG
void CGrannyViewerDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CGrannyViewerDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG


// CGrannyV


void CGrannyViewerDoc::SetCurModelId(UINT iModelId) 
{ 
	m_lastSelect = SEL_MODEL;
	m_iLastId = iModelId;

	m_iCurModelId = iModelId; 
	m_iCurAnimId = INVALID_GRN_ID;
	m_iCurEquipId = INVALID_GRN_ID;
	ResetEquip();
	CGrannyViewerView* pView = dynamic_cast<CGrannyViewerView*>(FindView(RUNTIME_CLASS(CGrannyViewerView))); ASSERT(pView);
	pView->ResetTrans();
	pView->InvalidateRect(NULL,FALSE);
}

void CGrannyViewerDoc::SetCurAnimId(UINT iAnimId) 
{ 
	m_lastSelect = SEL_ANIM;
	m_iLastId = iAnimId;

	m_iCurAnimId = iAnimId; 
	CGrannyViewerView* pView = dynamic_cast<CGrannyViewerView*>(FindView(RUNTIME_CLASS(CGrannyViewerView))); ASSERT(pView);
	pView->InvalidateRect(NULL,FALSE);
}

void CGrannyViewerDoc::SetCurEquipId(UINT iEquipId)
{
	m_lastSelect = SEL_EQUIP;
	m_iLastId = iEquipId;

	m_iCurEquipId = iEquipId;
	CGrannyViewerView* pView = dynamic_cast<CGrannyViewerView*>(FindView(RUNTIME_CLASS(CGrannyViewerView))); ASSERT(pView);
	pView->InvalidateRect(NULL,FALSE);
}

void CGrannyViewerDoc::AddEquip(UINT id) 
{ 
	std::vector<UINT>::iterator i = std::find(m_arEquip.begin(), m_arEquip.end(), id);
	if (i != m_arEquip.end()) return;
	m_arEquip.push_back(id);
	
	CGrannyViewerView* pView = dynamic_cast<CGrannyViewerView*>(FindView(RUNTIME_CLASS(CGrannyViewerView))); ASSERT(pView);
	pView->InvalidateRect(NULL,FALSE);
}

void CGrannyViewerDoc::RemoveEquip(UINT id)
{
	std::vector<UINT>::iterator i = std::find(m_arEquip.begin(), m_arEquip.end(), id);
	if (i == m_arEquip.end()) return;
	m_arEquip.erase(i);
	
	CGrannyViewerView* pView = dynamic_cast<CGrannyViewerView*>(FindView(RUNTIME_CLASS(CGrannyViewerView))); ASSERT(pView);
	pView->InvalidateRect(NULL,FALSE);
}

BOOL CGrannyViewerDoc::OnOpenDocument(LPCTSTR lpszPathName)
{
	GfxLog("Open %s...\n", lpszPathName);

	if (!CDocument::OnOpenDocument(lpszPathName))
		return FALSE;

	BOOL bRet = TRUE;

	CGrannyViewerApp *pApp = dynamic_cast<CGrannyViewerApp*>(AfxGetApp());

	DEBUG_TIMER_START("CGrannyViewerDoc::OnOpenDocument(LPCTSTR lpszPathName)");
	
	try {
		GfxLog(" grannyloader : %s\n", lpszPathName);
		delete m_pGrannyLoader;
		m_pGrannyLoader = new cGrannyLoader(lpszPathName, nConfig::mulpath, pApp->GetOpenModelID());

		std::string mfile = nConfig::mulpath + "Models/models.txt", 
					sfile = nConfig::mulpath + "stitchin.def";
		GfxLog(" stitchinloader %s, %s\n", mfile.c_str(), sfile.c_str());
		delete m_pStitchinLoader;
		m_pStitchinLoader = new cStitchinLoader();
		if (nConfig::aos) m_pStitchinLoader->Init(mfile, sfile);
	}
	catch (cException ex) {
		AfxMessageBox(GfxSprintf("Open Error %s\n", ex.debug_message().c_str()));
		bRet = FALSE;
	}

	DEBUG_TIMER_STOP("CGrannyViewerDoc::OnOpenDocument(LPCTSTR lpszPathName)");

	return bRet;
}

void CGrannyViewerDoc::Log(LPCTSTR lpszLog)
{
	CLogView *pView = dynamic_cast<CLogView*>(FindView(RUNTIME_CLASS(CLogView)));
	if (!pView) return;

	pView->Log(lpszLog);
	SetModifiedFlag(FALSE);
}

void CGrannyViewerDoc::OnFileViewxml()
{
	if (GetPathName().IsEmpty()) return;

#if 0
	char szPath[MAX_PATH+1]={0,};
	LONG cbValue=sizeof(szPath);
	RegQueryValue(HKEY_LOCAL_MACHINE,"SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\IEXPLORE.EXE", szPath, &cbValue);

	CString strExec;
	strExec.Format("%s %s", szPath, GetPathName());
	WinExec(strExec,SW_SHOW);
#endif
	ShellExecute(NULL, "open", GetPathName(), 0, 0, SW_SHOW);
}

void CGrannyViewerDoc::OnFileClearlog()
{
	CLogView *pView = dynamic_cast<CLogView*>(FindView(RUNTIME_CLASS(CLogView)));
	if (!pView) return;

	pView->Clear();
	SetModifiedFlag(FALSE);
}

void CGrannyViewerDoc::OnLogSetfont()
{
	// TODO: Add your command handler code here
	CFontDialog dlg;
	if (dlg.DoModal() != IDOK) return;

	CLogView *pView = dynamic_cast<CLogView*>(FindView(RUNTIME_CLASS(CLogView)));
	if (!pView) return;
	pView->SetFont(dlg.GetFaceName(), dlg.GetSize());

	SetModifiedFlag(FALSE);
}

void CGrannyViewerDoc::OnFileDumpmodel()
{
	if (!m_pGrannyLoader || m_iLastId == INVALID_GRN_ID || m_lastSelect == SEL_NONE) return;
	
	cGrannyModel* model = NULL;
	cGrannyFile* file = NULL;

	if (m_lastSelect != SEL_ANIM) {
		model = m_pGrannyLoader->GetModel(m_iLastId);
		if (model) file = model->GetModel();
	} else {
		model = m_pGrannyLoader->GetModel(m_iCurModelId);
		if (model) file = model->GetAnimation(m_iCurAnimId);
	}

	if (file) file->print();
}



void CGrannyViewerDoc::OnFileExportmodel()
{
	if (!m_pGrannyLoader || m_iLastId == INVALID_GRN_ID || m_lastSelect == SEL_NONE) return;
	
	cGrannyModel* model = NULL;
	std::string filename;

	if (m_lastSelect != SEL_ANIM) {
		model = m_pGrannyLoader->GetModel(m_iLastId);
		filename = getFileName(model->GetFileName());
	} else {
		model = m_pGrannyLoader->GetModel(m_iCurModelId);
		cGrannyAnimation *anm = model->GetAnimation(m_iCurAnimId);
		if (!anm) return;
		filename = anm->getFileName();
	}

	if (!model) return;

	
	//filename += ".smd";

#if 1
	static char BASED_CODE szFilter[] = "SMD Files (*.smd)|*.smd|All Files (*.*)|*.*||";

	CFileDialog dlg(FALSE, "smd", filename.c_str(), OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, szFilter);
	if (dlg.DoModal()==IDCANCEL) return;

	if (m_lastSelect != SEL_ANIM)
		model->ExportModel((LPCTSTR)dlg.GetPathName());
	else
		model->ExportAnimation((LPCTSTR)dlg.GetPathName(), m_iLastId);
#else
	model->Export("test.smd");
#endif
}

void CGrannyViewerDoc::OnFileShellopen()
{
	if (!m_pGrannyLoader || m_iLastId == INVALID_GRN_ID || m_lastSelect == SEL_NONE) return;
	
	cGrannyModel* model = NULL;
	std::string filename;

	if (m_lastSelect != SEL_ANIM) {
		model = m_pGrannyLoader->GetModel(m_iLastId);
		filename = model->GetFileName(true);
	} else {
		model = m_pGrannyLoader->GetModel(m_iCurModelId);
		cGrannyAnimation *anm = model->GetAnimation(m_iCurAnimId);
		filename = anm->getPathName();
	}

	if (!model) return;

	//AfxMessageBox(filename.c_str());
	ShellExecute(NULL, "open", filename.c_str(), 0, 0, SW_SHOW);
}


float CGrannyViewerDoc::GetCurAnimLength()
{
	if (m_iCurModelId == INVALID_GRN_ID || m_iCurAnimId == INVALID_GRN_ID || !m_pGrannyLoader) return 0.0f;
	cGrannyModel* model = m_pGrannyLoader->GetModel(m_iCurModelId);
	if (!model) return 0.0f;

	return model->GetAnimLength(m_iCurAnimId);
}

void CGrannyViewerDoc::OnLogLoglevel1()
{
	pDebug.SetLoglevel(LEVEL_INFO1);
}

void CGrannyViewerDoc::OnUpdateLogLoglevel1(CCmdUI *pCmdUI)
{
	pCmdUI->SetCheck(pDebug.GetLoglevel()==LEVEL_INFO1);
}

void CGrannyViewerDoc::OnLogLoglevel2()
{
	pDebug.SetLoglevel(LEVEL_INFO2);
}

void CGrannyViewerDoc::OnUpdateLogLoglevel2(CCmdUI *pCmdUI)
{
	pCmdUI->SetCheck(pDebug.GetLoglevel()==LEVEL_INFO2);
}

void CGrannyViewerDoc::OnLogLoglevel3()
{
	pDebug.SetLoglevel(LEVEL_INFO3);
}

void CGrannyViewerDoc::OnUpdateLogLoglevel3(CCmdUI *pCmdUI)
{
	pCmdUI->SetCheck(pDebug.GetLoglevel()==LEVEL_INFO3);
}


void CGrannyViewerDoc::OnLogLoglevel4()
{
	pDebug.SetLoglevel(LEVEL_INFO4);
}

void CGrannyViewerDoc::OnUpdateLogLoglevel4(CCmdUI *pCmdUI)
{
	pCmdUI->SetCheck(pDebug.GetLoglevel()==LEVEL_INFO4);
}
