// GrannyViewerDoc.h : CGrannyViewerDoc Ŭ ̽
//
#pragma once

#include <vector>

class cGrannyLoader;
class cStitchinLoader;

class CGrannyViewerDoc : public CDocument
{
protected: // serialization ϴ.
	CGrannyViewerDoc();
	DECLARE_DYNCREATE(CGrannyViewerDoc)

// Ư
public:
	CView* FindView(CRuntimeClass* pClass);
	cGrannyLoader *GetGrannyLoader() { return m_pGrannyLoader; }
	cStitchinLoader *GetStitchinLoader() { return m_pStitchinLoader; }

// ۾
public:

// 
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);

// 
public:
	virtual ~CGrannyViewerDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	cGrannyLoader *m_pGrannyLoader;
	cStitchinLoader *m_pStitchinLoader;

// ޽  Լ ߽ϴ.
protected:
	DECLARE_MESSAGE_MAP()
public:
	bool m_bInit;
	enum LAST_SELECT { SEL_NONE, SEL_ANIM, SEL_MODEL, SEL_EQUIP } m_lastSelect;
	UINT m_iCurAnimId, m_iCurModelId, m_iCurEquipId, m_iLastId;
	std::vector<UINT> m_arEquip;
	void SetCurModelId(UINT iModelId);
	void SetCurAnimId(UINT iAnimId);
	void SetCurEquipId(UINT iEquipId);
	UINT GetCurModelId() { return m_iCurModelId; }
	UINT GetCurAnimId() { return m_iCurAnimId; }
	UINT GetCurEquipId() { return m_iCurEquipId; }
	UINT GetEquipCount() { return m_arEquip.size(); }
	UINT GetEquipId(UINT i) { return m_arEquip[i]; }
	float GetCurAnimLength();
	
	void ResetEquip() { m_arEquip.clear(); }
	void AddEquip(UINT id);
	void RemoveEquip(UINT id);
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	void Log(LPCTSTR lpszLog);

	afx_msg void OnFileViewxml();
	afx_msg void OnFileClearlog();
	afx_msg void OnFileExportmodel();
	afx_msg void OnLogLoglevel1();
	afx_msg void OnUpdateLogLoglevel1(CCmdUI *pCmdUI);
	afx_msg void OnLogLoglevel2();
	afx_msg void OnUpdateLogLoglevel2(CCmdUI *pCmdUI);
	afx_msg void OnLogLoglevel3();
	afx_msg void OnUpdateLogLoglevel3(CCmdUI *pCmdUI);
	afx_msg void OnLogLoglevel4();
	afx_msg void OnUpdateLogLoglevel4(CCmdUI *pCmdUI);
	afx_msg void OnLogSetfont();
	afx_msg void OnFileDumpmodel();
	afx_msg void OnFileShellopen();
};


