// GrannyViewerView.cpp : CGrannyViewerView Ŭ 
//

#include "stdafx.h"
#include "GrannyViewer.h"

#include "GrannyViewerDoc.h"
#include "GrannyViewerView.h"
#include ".\grannyviewerview.h"
#include "granny/GrannyLoader.h"
#include "granny/GrannyFile.h"
#include "loaders/StitchinLoader.h"
#include "iris/Config.h"
#include "AnimSetup.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// CGrannyViewerView

IMPLEMENT_DYNCREATE(CGrannyViewerView, COpenGLView)

BEGIN_MESSAGE_MAP(CGrannyViewerView, COpenGLView)
	ON_WM_SIZE()
	ON_WM_KEYDOWN()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_MBUTTONDOWN()
	ON_WM_MBUTTONUP()
	ON_WM_MOUSEWHEEL()
	ON_WM_CREATE()
	ON_COMMAND(ID_POLYGON_FILL, OnPolygonFill)
	ON_COMMAND(ID_POLYGON_POINT, OnPolygonPoint)
	ON_COMMAND(ID_POLYGON_LINE, OnPolygonLine)
	ON_UPDATE_COMMAND_UI(ID_POLYGON_FILL, OnUpdatePolygonFill)
	ON_UPDATE_COMMAND_UI(ID_POLYGON_POINT, OnUpdatePolygonPoint)
	ON_UPDATE_COMMAND_UI(ID_POLYGON_LINE, OnUpdatePolygonLine)
	ON_COMMAND(ID_RENDER_TEXTURE, OnRenderTexture)
	ON_UPDATE_COMMAND_UI(ID_RENDER_TEXTURE, OnUpdateRenderTexture)
	ON_WM_DESTROY()
	ON_WM_RBUTTONDOWN()
	ON_WM_RBUTTONUP()
	ON_COMMAND(ID_RENDER_BONE, OnRenderBone)
	ON_UPDATE_COMMAND_UI(ID_RENDER_BONE, OnUpdateRenderBone)
	ON_COMMAND(ID_RENDER_SCALE_PLUS, OnRenderScalePlus)
	ON_COMMAND(ID_RENDER_SCALE_MINUS, OnRenderScaleMinus)
	ON_COMMAND(ID_RENDER_BONENAME, &CGrannyViewerView::OnRenderBonename)
	ON_UPDATE_COMMAND_UI(ID_RENDER_BONENAME, &CGrannyViewerView::OnUpdateRenderBonename)
	ON_COMMAND(ID_RENDER_BOUNDBOX, &CGrannyViewerView::OnRenderBoundbox)
	ON_UPDATE_COMMAND_UI(ID_RENDER_BOUNDBOX, &CGrannyViewerView::OnUpdateRenderBoundbox)
	ON_COMMAND(ID_RENDER_ANIMATIONSPEED, &CGrannyViewerView::OnRenderAnimationspeed)
	ON_WM_TIMER()
END_MESSAGE_MAP()

CGrannyViewerView::CGrannyViewerView()
: m_ptMouseDown(0), m_polyMode(GL_FILL), m_useTexture(true), m_drawBone(false), m_printBoneName(false), 
  m_drawBoundBox(false),
  m_fScale(1.0f),
  m_iFrameSec(33)
{
	ResetTrans();

	CWinApp *pApp = AfxGetApp();
	m_polyMode      = pApp->GetProfileInt(_T("render"), _T("polymode"), m_polyMode);
	m_useTexture    = pApp->GetProfileInt(_T("render"), _T("usetexture"), m_useTexture);
	m_drawBone      = pApp->GetProfileInt(_T("render"), _T("drawbone"), m_drawBone);
	m_printBoneName = pApp->GetProfileInt(_T("render"), _T("printbonename"), m_printBoneName);
	m_drawBoundBox  = pApp->GetProfileInt(_T("render"), _T("boundbox"), m_drawBoundBox);
	m_iFrameSec     = pApp->GetProfileInt(_T("render"), _T("framesec"), m_iFrameSec);

	nConfig::drawBone = m_drawBone;
	nConfig::printBoneName = m_printBoneName;

	nConfig::drawBoundBox = m_drawBoundBox;
}

CGrannyViewerView::~CGrannyViewerView()
{
	CWinApp *pApp = AfxGetApp();
	pApp->WriteProfileInt(_T("render"), _T("polymode"), m_polyMode);
	pApp->WriteProfileInt(_T("render"), _T("usetexture"), m_useTexture);
	pApp->WriteProfileInt(_T("render"), _T("drawbone"), m_drawBone);
	pApp->WriteProfileInt(_T("render"), _T("printbonename"), m_printBoneName);
	pApp->WriteProfileInt(_T("render"), _T("boundbox"), m_drawBoundBox);
	pApp->WriteProfileInt(_T("render"), _T("framesec"), m_iFrameSec);
}

void CGrannyViewerView::ResetTrans(void)
{
	m_xPos = 0.0f;
	m_yPos = 0.0f;
	m_zPos = -5.0f;
	m_xAngle = -90.0f;
	m_yAngle = 0.0f;
	m_curTime = 0.0f;
	m_fScale = 1.0f;
}

int CGrannyViewerView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (COpenGLView::OnCreate(lpCreateStruct) == -1)
		return -1;

	SetTimer(1,m_iFrameSec,NULL);

	return 0;
}

void CGrannyViewerView::OnDestroy()
{
	COpenGLView::OnDestroy();

	CWinApp *pApp = AfxGetApp();
	pApp->WriteProfileInt("view", "polymode", m_polyMode);
	pApp->WriteProfileInt("view", "usetexture", m_useTexture);
	pApp->WriteProfileInt("view", "drawbone", m_drawBone);
}


// CGrannyViewerView 

#ifdef _DEBUG
void CGrannyViewerView::AssertValid() const
{
	COpenGLView::AssertValid();
}

void CGrannyViewerView::Dump(CDumpContext& dc) const
{
	COpenGLView::Dump(dc);
}

CGrannyViewerDoc* CGrannyViewerView::GetDocument() const 
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CGrannyViewerDoc)));
	return (CGrannyViewerDoc*)m_pDocument;
}
#endif //_DEBUG


// CGrannyViewerView ޽ ó


/*
 *	ī޶ Orbit (ϸ TrackBall)
--------------------

  ⼭ ī޶ Orbit ̶ 3DS MAX  ī޶ Oribit  Ѵ.  TrackBall 
  ̶   δ. ī޶ ȸ  콺 巡׽ÿ Ʈ 
   ʴ  ߾ӿ ִ  ϰ     ̸ 
  ī޶ Ʈ ȸϴ  Ѵ.   
  
  - 콺 巡׽ÿ 콺 ó ġ  ȸ ؾ Ѵٴ 
    (׷   콺  ٺ ó 콺 ġ 
    ȸ ȴ)
    
  - ȸ ݹ  ȸ ݴ Ǵ 찡 ִµ, ̸ 
        콺 ġ͸ ȸ Ǳ  ͷ
    Ѿ Ѵ.
*/

void CameraOrbiting ( float src[2], float dest[2] )
{
	/*
	src[0] = [巡׽۽ 콺 x ġ -1.0 ~ 1.0];
	src[1] = [巡׽۽ 콺 y ġ -1.0 ~ 1.0];
	dest[0] = [巡 콺 y ġ -1.0 ~ 1.0];
	dest[1] = [巡 콺 y ġ -1.0 ~ 1.0];
	*/

	Point x,y;

	float *p1 = x.points, *p2 = y.points;
	//float tm[16], inverse_tm[16], m[16];
	GrnMatrix tm,m1,m2;

	//  TM  ´.
	glGetFloatv(GL_MODELVIEW_MATRIX, tm.matrix);

	//  Ѵ. (ȸ ϱ  Trnaspose  صȴ)
	//matrix_transpose(tm, inverse_tm); // ( !)
	tm.invert();

	p1[0] = src[0];
	p1[1] = src[1];

	// ̰ 1 ͷ ϰ z  Ѵ.
	// sqrt(x*x + y*y + z*z) = 1
	if ((p1[0]*p1[0] + p1[1]*p1[1]) > 1) { /*   콺 ġ ؼ */
		p1[2] = 0.0F; // z  0 Ѵ.
	}
	else {
		p1[2] = 1 - p1[0]*p1[0] - p1[1]*p1[1];
	}

	p2[0] = dest[0];
	p2[1] = dest[1];
	if ((p2[0]*p2[0] + p2[1]*p2[1]) > 1) {
		p2[2] = 0.0F;
	}
	else {
		p2[2] = 1 - p2[0]*p2[0] - p2[1]*p2[1];
	}

	// ͸ 븻Ѵ.
	//vector_normalize(p1); // ( !)
	//vector_normalize(p2);
	x.normalize();
	y.normalize();


	//vector_mult_matrix(p1, inverse_tm); // ( !)
	//vector_mult_matrix(p2, inverse_tm);
	x = tm * x;
	y = tm * y;

	// p2  p1  ȸϴ ĿʹϿ Ѵ. ( !)
	//quat_set_from_ax(p2, p1, &orbit->quat); /* important order of p1, p2 */
	m1.setQuaternion(x);
	m2.setQuaternion(y);

	m1 *= m2;

	// ʹϿ Ʈ ٲ۴. ( !)
	//quat_to_mat(&orbit->quat, m);

	//  ȸƮ Ѵ.
	glMultMatrixf(m1.matrix);
}


void CGrannyViewerView::RenderScene()
{
	CGrannyViewerDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	if (!pDoc) return;

	Point s(0,0,0), d(0,0,0);
	if (m_ptMouseDown != CPoint(0,0)) d.points[0]=0.1;
	//CameraOrbiting(s.points, d.points);

	cGrannyLoader *pLoader = pDoc->GetGrannyLoader();
	cStitchinLoader *pStitchinLoader = pDoc->GetStitchinLoader();
	if (!pLoader || !pStitchinLoader) return;

	Uint32 model = pDoc->GetCurModelId();
	Uint32 equip = pDoc->GetCurEquipId();
	Uint32 anim  = pDoc->GetCurAnimId();

	cGrannyModel *pModel = pLoader->GetModel(model);
	if (!pModel) return;
	cGrannyFile *pFile = pModel->GetModel();
	Point pt;
	float depth = 0.0f;
	if (pFile) 
		pt = pFile->getModelOrg(NULL,NULL,&depth);

	glLoadIdentity();
	glTranslatef(m_xPos,m_yPos,m_zPos);

	if (0.9f < m_fScale && m_fScale < 1.1f) {
		if (depth > 1000.0f)     m_fScale = 0.0001f;
		else if (depth > 100.0f) m_fScale = 0.01f;
		else if (depth > 10.0f)  m_fScale = 0.1f;
	}
		
	glScalef(m_fScale, m_fScale, m_fScale);
    glRotatef(m_xAngle,1.0f,0.0f,0.0f); 
	glRotatef(m_yAngle,0.0f,0.0f,1.0f);

	glTranslatef(pt.points[0], pt.points[1], pt.points[2]);
	glPolygonMode(GL_FRONT_AND_BACK, m_polyMode);

	if (m_useTexture && m_polyMode==GL_FILL) 
		glEnable(GL_TEXTURE_2D);

	GrnMatrix left, right;

	if (model != INVALID_GRN_ID)
		if (nConfig::aos && (model == 400 || model == 401))	{
			std::vector<int> bodyparts(14,0);
			if (equip != INVALID_GRN_ID) {
				cModelEntry *entry = pStitchinLoader->GetModel(equip&0xFFFF);
				if (entry) {
					int *c = entry->GetCovers();
					for (int i = 0; i < 13; i++)
						bodyparts[i+1]=c[i];
				}
			}
			pLoader->Render(model,anim,m_curTime,&left,&right,bodyparts);
		}
		else
			pLoader->Render(model,anim,m_curTime,&left,&right);
#if 0
	for (Uint32 i=0; i < pDoc->GetEquipCount(); i++)
		pLoader->Render(pDoc->GetEquipId(i),anim,m_curTime);
#endif

	if (equip != INVALID_GRN_ID)
		pLoader->Render(equip,anim,m_curTime,&left,&right);
//#endif


	if (m_useTexture && m_polyMode==GL_FILL) 
		glDisable(GL_TEXTURE_2D);
	
	if (pDoc->GetCurAnimId() != INVALID_GRN_ID) 
		m_curTime += 0.03f;
	if (m_curTime > pDoc->GetCurAnimLength()) 
		m_curTime = 0.0f;
}


void CGrannyViewerView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	switch (nChar)
	{
	case VK_UP:         
		m_yPos = m_yPos + 0.1f;
		break;
	case VK_DOWN:    
		m_yPos = m_yPos - 0.1f;
		break;
	case VK_LEFT:       
		m_xPos = m_xPos - 0.1f;
		break;
	case VK_RIGHT:     
		m_xPos = m_xPos + 0.1f;
		break;
	default:
		COpenGLView::OnKeyDown(nChar, nRepCnt, nFlags);
		return;
	} 

	InvalidateRect(NULL,FALSE);

	COpenGLView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CGrannyViewerView::OnLButtonDown(UINT nFlags, CPoint point)
{
#if 1
	SetCapture();
	m_ptMouseDown = point;

#else
	if(nFlags & MK_CONTROL) m_trackball.UseConstraints(CAMERA_AXES);
	else if(nFlags & MK_SHIFT) m_trackball.UseConstraints(BODY_AXES);
	else m_trackball.UseConstraints(NO_AXES);

	// remember where we clicked
	m_ptMouseDown=point;
	m_trackball.MouseDown(point);
	// capture mouse movements even outside window borders
	SetCapture();
	// redraw the view
	InvalidateRect(NULL, FALSE);
#endif

	COpenGLView::OnLButtonDown(nFlags, point);
}

void CGrannyViewerView::OnLButtonUp(UINT nFlags, CPoint point)
{
	ReleaseCapture();
	m_ptMouseDown = CPoint(0,0);
	InvalidateRect(NULL, FALSE);

	COpenGLView::OnLButtonUp(nFlags, point);
}

void CGrannyViewerView::OnMButtonDown(UINT nFlags, CPoint point)
{
	SetCapture();
	m_ptMouseDown = point;

	if (GetCapture()==this)
	{
		InvalidateRect(NULL, FALSE);
	}

	COpenGLView::OnMButtonDown(nFlags, point);
}

void CGrannyViewerView::OnMButtonUp(UINT nFlags, CPoint point)
{
	ReleaseCapture();
	point = CPoint(0,0);

	COpenGLView::OnMButtonUp(nFlags, point);
}

void CGrannyViewerView::OnRButtonDown(UINT nFlags, CPoint point)
{
	SetCapture();
	m_ptMouseDown = point;

	COpenGLView::OnRButtonDown(nFlags, point);
}

void CGrannyViewerView::OnRButtonUp(UINT nFlags, CPoint point)
{
	ReleaseCapture();
	point = CPoint(0,0);

	COpenGLView::OnRButtonUp(nFlags, point);
}


void CGrannyViewerView::OnMouseMove(UINT nFlags, CPoint point)
{
	//m_trackball.MouseMove(point);

	if (GetCapture()==this) {
		if (GetAsyncKeyState(VK_LBUTTON)) {
			//Increment the object rotation angles
			m_xAngle += (point.y-m_ptMouseDown.y)/3.6;
			m_yAngle += (point.x-m_ptMouseDown.x)/3.6;
		} else if (GetAsyncKeyState(VK_MBUTTON)) {
			m_xPos += (point.x - m_ptMouseDown.x)*0.01;
			m_yPos -= (point.y - m_ptMouseDown.y)*0.01;
		} else if (GetAsyncKeyState(VK_RBUTTON)) {
			m_zPos += (point.x - m_ptMouseDown.x)*0.03; 
		}
        //Redraw the view
        InvalidateRect(NULL,FALSE);
        //Set the mouse point
        m_ptMouseDown=point;
	}

	COpenGLView::OnMouseMove(nFlags, point);
}



BOOL CGrannyViewerView::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt)
{
	if (zDelta > 0) m_zPos += 0.3;
	else if (zDelta < 0) m_zPos -= 0.3;
	InvalidateRect(NULL,FALSE);

	return COpenGLView::OnMouseWheel(nFlags, zDelta, pt);
}

void CGrannyViewerView::OnPolygonFill()
{
	m_polyMode = GL_FILL;
	InvalidateRect(NULL,FALSE);
}

void CGrannyViewerView::OnPolygonPoint()
{
	m_polyMode = GL_POINT;
	InvalidateRect(NULL,FALSE);
}

void CGrannyViewerView::OnPolygonLine()
{
	m_polyMode = GL_LINE;
	InvalidateRect(NULL,FALSE);
}

void CGrannyViewerView::OnUpdatePolygonFill(CCmdUI *pCmdUI)
{
	pCmdUI->SetCheck(m_polyMode==GL_FILL);
}

void CGrannyViewerView::OnUpdatePolygonPoint(CCmdUI *pCmdUI)
{
	pCmdUI->SetCheck(m_polyMode==GL_POINT);
}

void CGrannyViewerView::OnUpdatePolygonLine(CCmdUI *pCmdUI)
{
	pCmdUI->SetCheck(m_polyMode==GL_LINE);
}

void CGrannyViewerView::OnRenderTexture()
{
	m_useTexture = !m_useTexture;
	InvalidateRect(NULL,FALSE);
}

void CGrannyViewerView::OnUpdateRenderTexture(CCmdUI *pCmdUI)
{
	pCmdUI->SetCheck(m_useTexture);
}

void CGrannyViewerView::OnRenderBone()
{
	m_drawBone = !m_drawBone;
	nConfig::drawBone = m_drawBone;
}

void CGrannyViewerView::OnUpdateRenderBone(CCmdUI *pCmdUI)
{
	pCmdUI->SetCheck(m_drawBone);
}


void CGrannyViewerView::OnSize(UINT nType, int cx, int cy) 
{
	COpenGLView::OnSize(nType, cx, cy);
}

void CGrannyViewerView::OnRenderScalePlus()
{
	m_fScale *= 10.0f;
	InvalidateRect(NULL,FALSE);
}

void CGrannyViewerView::OnRenderScaleMinus()
{
	m_fScale *= 0.1f;
	InvalidateRect(NULL,FALSE);
}

void CGrannyViewerView::OnRenderBonename()
{
	m_printBoneName = !m_printBoneName;
	nConfig::printBoneName = m_printBoneName;
	InvalidateRect(NULL,FALSE);
}

void CGrannyViewerView::OnUpdateRenderBonename(CCmdUI *pCmdUI)
{
	pCmdUI->SetCheck(m_printBoneName);
}

void CGrannyViewerView::OnRenderBoundbox()
{
	m_drawBoundBox = !m_drawBoundBox;
	nConfig::drawBoundBox = m_drawBoundBox;
	InvalidateRect(NULL,FALSE);
}

void CGrannyViewerView::OnUpdateRenderBoundbox(CCmdUI *pCmdUI)
{
	pCmdUI->SetCheck(m_drawBoundBox);
}

void CGrannyViewerView::OnRenderAnimationspeed()
{
	CAnimSetupDlg dlg;
	dlg.m_iTime = m_iFrameSec;
	if (dlg.DoModal() != IDOK) return;
	m_iFrameSec = dlg.m_iTime;
	KillTimer(1);
	SetTimer(1, m_iFrameSec,NULL);
}

void CGrannyViewerView::OnTimer(UINT_PTR nIDEvent)
{
	// TODO: Add your message handler code here and/or call default
	if (GetDocument()->GetCurAnimId() != INVALID_GRN_ID) 
		InvalidateRect(NULL,FALSE);

	//COpenGLView::OnTimer(nIDEvent);
}
