#include "stdafx.h"

#include <shellapi.h>
#include "resource.h"
#include "TrayPos.h"
#include "imgvw_if.h"
#include "..\trayhk\trayhk.h"
#include "singleinst.h"

#include <list>
#include <string.h>
using namespace std;

#pragma comment(lib, "trayhk")

#define VALKYRIE_CLS_NAME	TEXT("ValkyrieHidden")
#define VALKYRIE_WND_DATA	TEXT("ValkyrieWndData")

#define WM_TRAYNOTIFY		(WM_USER+1394)
#define WM_TRAYWHEEL		(WM_USER+1395)

typedef list<string>			StringList;
typedef list<string>::iterator	StringListIter;

typedef struct _VALKYRIEWNDDATA
{
    CMsgTrayPos			TrayPos;
	CImgvwIf			*pImgvwIf;

	StringList			clBitmapFile;
	StringListIter		posBitmapFIle;

	CRITICAL_SECTION	cs;
} VALKYRIEWNDDATA, *PVALKYRIEWNDDATA;

void WINAPI CalcViewRect(LPRECT lprc, int w, int h)
{
	RECT	rcWorkArea;

	SystemParametersInfo(SPI_GETWORKAREA, 0, &rcWorkArea, FALSE);

	lprc->left = rcWorkArea.right - w - 5;
	lprc->top = rcWorkArea.bottom - h - 5;
	lprc->right = lprc->left + w;
	lprc->bottom = lprc->top + h;
}

void WINAPI LoadBitmapFileInfo(HWND hwnd)
{
	PVALKYRIEWNDDATA	pvwd;

	pvwd = (PVALKYRIEWNDDATA) GetProp(hwnd, VALKYRIE_WND_DATA);

	pvwd->clBitmapFile.push_back("D:\\Documents and Settings\\Administrator\\My Documents\\My Pictures\\.jpg");
	pvwd->clBitmapFile.push_back("D:\\Documents and Settings\\Administrator\\My Documents\\My Pictures\\a2.jpg");
	pvwd->clBitmapFile.push_back("D:\\Documents and Settings\\Administrator\\My Documents\\My Pictures\\jiji.bmp");

	pvwd->posBitmapFIle = pvwd->clBitmapFile.begin();
}

void WINAPI OnCreate(HWND hwnd, WPARAM wParam, LPARAM lParam)
{
	NOTIFYICONDATA		nid;
	HICON				hIcon;
	PVALKYRIEWNDDATA	pvwd;

	pvwd = new VALKYRIEWNDDATA;
	InitializeCriticalSection(&pvwd->cs);
	pvwd->pImgvwIf = NULL;
	pvwd->TrayPos.SetNotifyIconInfo(hwnd, 1, WM_TRAYNOTIFY);
	SetProp(hwnd, VALKYRIE_WND_DATA, (HANDLE) pvwd);

	LoadBitmapFileInfo(hwnd);

	hIcon = (HICON) LoadImage(GetModuleHandle(NULL), MAKEINTRESOURCE(IDI_MAIN), IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR);

	InstallHook(hwnd, WM_TRAYWHEEL);
	SetHookPause(TRUE);

	ZeroMemory(&nid, sizeof nid);
	nid.cbSize = sizeof nid;
	nid.uFlags = NIF_ICON | NIF_MESSAGE;
	nid.uID = 1;
	nid.hWnd = hwnd;
	nid.uCallbackMessage = WM_TRAYNOTIFY;
	nid.hIcon = hIcon;
	
	Shell_NotifyIcon(NIM_ADD, &nid);
	DestroyIcon(hIcon);
}

void WINAPI OnDestroy(HWND hwnd, WPARAM wParam, LPARAM lParam)
{
	NOTIFYICONDATA		nid;
	PVALKYRIEWNDDATA	pvwd;

	ZeroMemory(&nid, sizeof nid);
	nid.cbSize = sizeof nid;
	nid.uID = 1;
	nid.hWnd = hwnd;

	Shell_NotifyIcon(NIM_ADD, &nid);

	RemoveHook();

	pvwd = (PVALKYRIEWNDDATA) GetProp(hwnd, VALKYRIE_WND_DATA);

	EnterCriticalSection(&pvwd->cs);
	if(pvwd->pImgvwIf != NULL)
	{
		delete pvwd->pImgvwIf;
		pvwd->pImgvwIf = NULL;
	}
	LeaveCriticalSection(&pvwd->cs);

	DeleteCriticalSection(&pvwd->cs);
	delete pvwd;
	RemoveProp(hwnd, VALKYRIE_WND_DATA);
}

void WINAPI OnTrayNotify(HWND hwnd, WPARAM wParam, LPARAM lParam)
{
	PVALKYRIEWNDDATA	pvwd;
	
	if(wParam == 1)
	{
		pvwd = (PVALKYRIEWNDDATA) GetProp(hwnd, VALKYRIE_WND_DATA);

		switch(lParam)
		{
		case WM_MOUSEMOVE:			
			pvwd->TrayPos.OnMouseMove();
			break;

		case WM_MOUSEHOVER:
			EnterCriticalSection(&pvwd->cs);
			if(pvwd->pImgvwIf == NULL)
			{
                SetHookPause(FALSE);

				RECT rcView;
				CalcViewRect(&rcView, 300, 200);
				pvwd->pImgvwIf = new CImgvwIf(NULL, rcView.left,rcView.top, 300, 200);
				pvwd->pImgvwIf->SetBitmap((*pvwd->posBitmapFIle).c_str());
				ShowWindow(pvwd->pImgvwIf->GetHwnd(), SW_SHOWNOACTIVATE);
			}
			LeaveCriticalSection(&pvwd->cs);
			break;

		case WM_MOUSELEAVE:
			EnterCriticalSection(&pvwd->cs);
			if(pvwd->pImgvwIf != NULL)
			{
				SetHookPause(TRUE);
				delete pvwd->pImgvwIf;
				pvwd->pImgvwIf = NULL;
			}
			LeaveCriticalSection(&pvwd->cs);
			break;

		case WM_RBUTTONUP:
			PostQuitMessage(0);
			break;
		}
	}
}

void WINAPI OnTrayWheel(HWND hwnd, WPARAM wParam, LPARAM lParam)
{
	PVALKYRIEWNDDATA	pvwd;

	pvwd = (PVALKYRIEWNDDATA) GetProp(hwnd, VALKYRIE_WND_DATA);

	if(++pvwd->posBitmapFIle == pvwd->clBitmapFile.end())
		pvwd->posBitmapFIle = pvwd->clBitmapFile.begin();

	EnterCriticalSection(&pvwd->cs);
	if(pvwd->pImgvwIf != NULL)
		pvwd->pImgvwIf->SetBitmap((*pvwd->posBitmapFIle).c_str());
	LeaveCriticalSection(&pvwd->cs);
}

LRESULT CALLBACK ValkyrieMsgProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	LRESULT	ret = 0;

	switch(uMsg)
	{
	case WM_CREATE:
		OnCreate(hwnd, wParam, lParam);
		break;

	case WM_DESTROY:
		OnDestroy(hwnd, wParam, lParam);
		break;

	case WM_TRAYNOTIFY:
		OnTrayNotify(hwnd, wParam, lParam);
		break;

	case WM_TRAYWHEEL:
		OnTrayWheel(hwnd, wParam, lParam);
		break;

	default:
		ret = DefWindowProc(hwnd, uMsg, wParam, lParam);
	}

	return ret;
}

int CALLBACK WinMain(HINSTANCE hInst, HINSTANCE, LPSTR, int)
{
	WNDCLASS				wc;
	MSG						msg;
	HWND					hwnd;
	CSingleInstance			inst("Valkyrie_Instance_Mutex");

	if(inst.IsExist() == FALSE)
	{
		wc.cbClsExtra		= 0;
		wc.cbWndExtra		= 0;
		wc.hbrBackground	= NULL;
		wc.hCursor			= NULL;
		wc.hIcon			= NULL;
		wc.hInstance		= hInst;
		wc.lpfnWndProc		= ValkyrieMsgProc;
		wc.lpszClassName	= VALKYRIE_CLS_NAME;
		wc.lpszMenuName		= NULL;
		wc.style			= 0;

		RegisterClass(&wc);

		hwnd = CreateWindow(VALKYRIE_CLS_NAME, "", WS_POPUP | WS_CLIPSIBLINGS, 0, 0, 0, 0, NULL, NULL, hInst, NULL);
		ShowWindow(hwnd, SW_HIDE);
		//UpdateWindow(hwnd);

		while(GetMessage(&msg, NULL, 0, 0))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}

		UnregisterClass(VALKYRIE_CLS_NAME, hInst);
	}

	return 0;
}