// imgvw.cpp : DLL  α׷   մϴ.
//

#include "stdafx.h"
#include "imgvw.h"
#include <unknwn.h>
#include <gdiplus.h>
using namespace Gdiplus;

#pragma comment(lib, "gdiplus")

#define WM_SETBITMAP (WM_USER+22)
#define TRAYWNDCLSNAME	TEXT("TrayNotifyWnd")
#define IMGVW_WND_DATA_NAME	TEXT("ImgvwWndData")

#define IMGVWS_AUTORECALCWND		1
#define IMGVWS_NOZOOMIMAGE			2

typedef struct _GLOBALDATA
{
	BOOL		bInitialize;
	ULONG_PTR	gdiplusToken;
} GLOBALDATA, *PGLOBALDATA;

typedef struct _IMGVW_WND_DATA
{
	DWORD		dwVwStyle;
	wchar_t	wszBitmapFileName[MAX_PATH];

} IMGVW_WND_DATA, *PIMGVW_WND_DATA;

GLOBALDATA	g_Data = {FALSE, NULL};
HINSTANCE	g_hInst;

VOID CALLBACK OnPaint(HWND hwnd, WPARAM, LPARAM);
LRESULT CALLBACK TrayWndMsgProc(HWND hwnd, UINT iMsg, WPARAM w, LPARAM l);
VOID RegisterBaseWndClass(HINSTANCE hInst, PSTR szClassName, WNDPROC wProc);
void WINAPI SwapWndPos(HWND hwnd);

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
	g_hInst = (HINSTANCE) hModule;
    return TRUE;
}

IMGVW_API
BOOL WINAPI IMGVW_Initialize()
{
	BOOL bRet = FALSE;

	if(g_Data.bInitialize == FALSE)
	{
		RegisterBaseWndClass(g_hInst, TRAYWNDCLSNAME, TrayWndMsgProc);
		GdiplusStartupInput gdiplusStartupInput;
		if(GdiplusStartup(&g_Data.gdiplusToken, &gdiplusStartupInput, NULL) == Ok)
		{
			g_Data.bInitialize = TRUE;
			bRet = TRUE;
		}
	}

	return bRet;
}

IMGVW_API
VOID WINAPI IMGVW_Cleanup()
{
	if(g_Data.bInitialize == TRUE)
	{
		UnregisterClass(TRAYWNDCLSNAME, g_hInst);
		GdiplusShutdown(g_Data.gdiplusToken);
	}
}


IMGVW_API
HWND WINAPI IMGVW_CreateTrayWnd(HWND hwnd, int x, int y, int w, int h)
{
	HWND hw =  CreateWindowEx(	WS_EX_TOOLWINDOW, 
							TRAYWNDCLSNAME, 
							"", 
							WS_POPUP | WS_CLIPSIBLINGS, 
							x, y, w, h, 
							hwnd, 
							NULL, 
							g_hInst, 
							0									);

	return hw;



}

IMGVW_API
LONG WINAPI IMGVW_SetBitmap(HWND h, LPCTSTR lpszBmp)
{
	return (LONG) SendMessage(h, WM_SETBITMAP, 0, (LPARAM) lpszBmp);
}

///////////////////////////////////////////////////////////////

void WINAPI RecalcWindowPos(HWND hwnd, BOOL bVert)
{
	RECT	rcWnd;
	SIZE	szWnd;

	GetWindowRect(hwnd, &rcWnd);

	szWnd.cx = rcWnd.right - rcWnd.left;
	szWnd.cy = rcWnd.bottom - rcWnd.top;

	if((bVert && szWnd.cx > szWnd.cy) || (!bVert && szWnd.cx < szWnd.cy))
		MoveWindow(hwnd, rcWnd.right - szWnd.cy, rcWnd.bottom - szWnd.cx, szWnd.cy, szWnd.cx, TRUE);
}

VOID CALLBACK OnPaint(HWND hwnd, WPARAM, LPARAM)
{
	HDC				hdc;
	PAINTSTRUCT		ps;
	HBITMAP			hBmp;
	HDC		hMemDC;
	HBITMAP	hOldBmp;
	BITMAP	bi;

	PIMGVW_WND_DATA	pWndData;

	pWndData = (PIMGVW_WND_DATA) GetProp(hwnd, IMGVW_WND_DATA_NAME);
		
	hdc = BeginPaint(hwnd, &ps);


	Image img(pWndData->wszBitmapFileName);

	if(img.GetLastStatus() == Ok)
	{
		SIZE	szImage;
		
		RECT	rcClient;
		SIZE	szClient;
		float	fRatio;
		float	fRatioX;
		float	fRatioY;
		POINT	ptDraw;

		szImage.cx = img.GetWidth();
		szImage.cy = img.GetHeight();

		GetClientRect(hwnd, &rcClient);
		szClient.cx = rcClient.right - rcClient.left;
		szClient.cy = rcClient.bottom - rcClient.top;

		fRatioX = (szClient.cx-10-10) / (float) szImage.cx;
		fRatioY = (szClient.cy-4-10) / (float) szImage.cy;

		fRatio = (fRatioX < fRatioY) ? fRatioX : fRatioY;

		SIZE	szDestImage;

		szDestImage.cx = fRatio * szImage.cx;
		szDestImage.cy = fRatio * szImage.cy;

		ptDraw.x = (szClient.cx - (fRatio * szImage.cx)) / 2;
		ptDraw.y = (szClient.cy - (fRatio * szImage.cy)) / 2;


		Bitmap bmpBuffer(szClient.cx, szClient.cy);
		Graphics grpBuffer(&bmpBuffer);

		Pen	pen(Color(0,0,0), 5.0f);
		SolidBrush brs(Color(0,0,0));

		grpBuffer.FillRectangle(&brs, 0, 0, szClient.cx, szClient.cy);
		//grpBuffer.DrawRectangle(&pen, 0, 0, szClient.cx-1, szClient.cy-1);

		grpBuffer.DrawImage(&img, ptDraw.x, ptDraw.y, szDestImage.cx, szDestImage.cy);		

		Graphics(hdc).DrawImage(&bmpBuffer, 0, 0, szClient.cx, szClient.cy);

		//BitBlt(hdc, 0, 0, szClient.cx, szClient.cy, grpBuffer.GetHDC(), 0, 0, SRCCOPY);
	}
	else
	{
		RECT	rcClient;
		HBRUSH	hbr;

		GetClientRect(hwnd, &rcClient);
		hbr = (HBRUSH) GetStockObject(WHITE_BRUSH);
		FillRect(hdc, &rcClient, hbr);
	}

	EndPaint(hwnd, &ps);
}

void WINAPI OnSetBitmap(HWND hwnd, WPARAM wParam, LPARAM lParam)
{
	HDC				hdc;
	PIMGVW_WND_DATA	pWndData;

	pWndData = (PIMGVW_WND_DATA) GetProp(hwnd, IMGVW_WND_DATA_NAME);
	MultiByteToWideChar(CP_ACP, 0, (LPCTSTR) lParam, -1, pWndData->wszBitmapFileName, sizeof pWndData->wszBitmapFileName);

	if(pWndData->dwVwStyle & IMGVWS_AUTORECALCWND)
	{
		hdc = GetDC(hwnd);
		Graphics	grpWindow(hdc);		
		Image		img(pWndData->wszBitmapFileName);
		RecalcWindowPos(hwnd, img.GetHeight() > img.GetWidth());
		ReleaseDC(hwnd, hdc);
	}

	InvalidateRect(hwnd, NULL, FALSE);
}

LRESULT CALLBACK TrayWndMsgProc(HWND hwnd, UINT iMsg, WPARAM w, LPARAM l)
{
	LRESULT	lRet = 0;
	PIMGVW_WND_DATA	pWndData;

	switch(iMsg)
	{
	case WM_CREATE:
		pWndData = new IMGVW_WND_DATA;
		pWndData->dwVwStyle = 0;
		pWndData->wszBitmapFileName[0] = '\0';

		SetProp(hwnd, IMGVW_WND_DATA_NAME, (HANDLE) pWndData);
		SetWindowPos(hwnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_NOACTIVATE | SWP_NOREDRAW);
		break;

	case WM_DESTROY:
		pWndData = (PIMGVW_WND_DATA) GetProp(hwnd, IMGVW_WND_DATA_NAME);
		RemoveProp(hwnd, IMGVW_WND_DATA_NAME);
        delete pWndData;		
		break;

	case WM_PAINT:
		OnPaint(hwnd, w, l);
		break;

	case WM_SETBITMAP:
		OnSetBitmap(hwnd, w, l);
		break;

	default:
		lRet = DefWindowProc(hwnd, iMsg, w, l);
		break;
	}

	return lRet;
}


VOID RegisterBaseWndClass(HINSTANCE hInst, PSTR szClassName, WNDPROC wProc)
{
	WNDCLASS	wcs;
	
	if(GetClassInfo(hInst, szClassName, &wcs) == 0)
	{
		wcs.cbClsExtra		= 0;
		wcs.cbWndExtra		= 0;
		wcs.hbrBackground	= NULL;
		wcs.hCursor			= LoadCursor(NULL, IDC_ARROW);
		wcs.hIcon			= NULL;
		wcs.hInstance		= hInst;
		wcs.lpfnWndProc		= wProc;
		wcs.lpszClassName	= szClassName;
		wcs.lpszMenuName	= NULL;
		wcs.style			= 0;
		
		RegisterClass(&wcs);
	}
}