package parser.state;

import java.util.Collection;

import collection.Tree;
import datatypes.CallGraphInfo;
import datatypes.FlatProfileInfo;

public abstract class VNProfState {
	protected static boolean disable = false;
	public VNProfState nextState(String line, Collection<FlatProfileInfo> flatCollection, Collection<Tree<CallGraphInfo>> callCollection){
		VNProfState nextState;
		
		enableRoutine();
		
		nextState = parseLine(line);
		if(!disable){
			process();
			nextState.init(line);
		}
		if(!disable){
			nextState.process(flatCollection, callCollection);
		}
		
		return nextState;
	}
	
	public boolean isEnd(){
		return false;
	}
	
	protected void enableRoutine(){}
	
	protected abstract void process();
	protected abstract void init(String line);
	protected abstract VNProfState parseLine(String line);
	protected abstract void process(Collection<FlatProfileInfo> flatProfile, Collection<Tree<CallGraphInfo>> callGraph);
}
