package viewer;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Iterator;
import java.util.Stack;

import javax.swing.JPanel;

public class CallGraphMainViewer extends JPanel {
	Stack<int[]> st;
	/**
	 * 
	 */
	private static final long serialVersionUID = -4766289869997242303L;

	public CallGraphMainViewer(){
		st = new Stack<int[]>();
	}
	
	public void addLine(int posX1, int posY1, int posX2, int posY2){
		int[] arr = new int[4];
		
		arr[0] = posX1;
		arr[1] = posY1;
		arr[2] = posX2;
		arr[3] = posY2;
		
		st.add(arr);
	}
	@Override
	protected void paintComponent(Graphics g) {
		// TODO Auto-generated method stub
		super.paintComponent(g);
		
		Iterator<int[]> it = st.iterator();
		Graphics2D g2=(Graphics2D)g;
		
		g2.setStroke(new BasicStroke(3,0,BasicStroke.JOIN_ROUND,1.0f,null, 0));
		while(it.hasNext()){
			int[] temp = it.next();
			int midX;
			
			midX = (temp[0]+temp[2])/2;
			
			g.drawLine(temp[0], temp[1], midX, temp[1]);
			g.drawLine(midX, temp[1], midX, temp[3]);
			g.drawLine(midX, temp[3], temp[2], temp[3]);
		}
		g2.setStroke(new BasicStroke(1,0,BasicStroke.JOIN_MITER,1.0f,null, 0));
	}
	
	public void lineClear(){
		st.removeAllElements();
	}
}
