package viewer;


import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.Stack;

import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import collection.Tree;
import datatypes.CallGraphInfo;

public class CallGraphPanel extends JPanel implements MouseListener, ActionListener{
	private CallGraphMainViewer callGraphMain;
	private JPanel miniMap;
	private CallGraphInfoPanel infoPanel;
	private Tree<CallGraphInfo> originalInfo;
	private Tree<CallGraphInfo> nowInfo;
	private int mainPanelWidth, mainPanelHight;
	private CallGraphNode selectedNode;
	private JButton visibleRoot;
	private JButton visibleSubNodes;
	private JButton zoomIn;
	private JButton zoomOut;
	/**
	 * 
	 */
	private static final long serialVersionUID = -5006416639110373830L;
	
	public CallGraphPanel(Tree<CallGraphInfo> info){
		JPanel southPanel = new JPanel();
		this.nowInfo = this.originalInfo = info;
		this.setLayout(new BorderLayout(2, 2));
		
		callGraphMain = new CallGraphMainViewer();
		callGraphMain.setBackground(new Color(255, 255, 255));
		callGraphMain.setLayout(null);
		drawMain();
		callGraphMain.setPreferredSize(new Dimension(mainPanelWidth, mainPanelHight));
		miniMap = new JPanel();
		miniMap.setBackground(new Color(100, 100, 100));
		miniMap.setPreferredSize(new Dimension(210, 170));
		infoPanel = new CallGraphInfoPanel();
		
		visibleRoot = new JButton(" Լ Ʈ ");
		visibleSubNodes = new JButton(" Լ ");
		zoomIn = new JButton("Ȯ");
		zoomOut = new JButton("");
		
		visibleRoot.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				if(infoPanel.getInfo() == null){
					return;
				}
				if(visibleRoot.getText().equals(" Լ Ʈ ")){
					visibleRoot.setText(" Լ ");
					nowInfo = infoPanel.getInfo();
					drawMain();
				}
				else if(selectedNode.getInfo() != originalInfo){
					visibleRoot.setText(" Լ Ʈ ");
					nowInfo = originalInfo;
					drawMain();
				}
			}
		});
		
		visibleRoot.setBounds(250, 15, 150, 20);
		visibleSubNodes.setBounds(410, 15, 110, 20);
		zoomIn.setBounds(530, 15, 40, 20);
		zoomOut.setBounds(580, 15, 40, 20);
		
		visibleRoot.setMargin(new Insets(1, 1, 1, 1));
		visibleSubNodes.setMargin(new Insets(1, 1, 1, 1));
		zoomIn.setMargin(new Insets(1, 1, 1, 1));
		zoomOut.setMargin(new Insets(1, 1, 1, 1));
		
		infoPanel.add(visibleRoot);
		infoPanel.add(visibleSubNodes);
		infoPanel.add(zoomIn);
		infoPanel.add(zoomOut);
		
		southPanel.setLayout(new BorderLayout(2,2));
		southPanel.add(miniMap, BorderLayout.WEST);
		southPanel.add(infoPanel, BorderLayout.CENTER);
		
		this.add(new JScrollPane(callGraphMain), BorderLayout.CENTER);
		this.add(southPanel, BorderLayout.SOUTH);
	}
	
	private void drawMain(){
		mainPanelWidth = 10;
		mainPanelHight = 10;
		callGraphMain.lineClear();
		
		callGraphMain.removeAll();
		
		int nextPosX = 10, nextPosY = 10;
		Stack<Iterator<Tree<CallGraphInfo>>> st = new Stack<Iterator<Tree<CallGraphInfo>>>();
		Stack<int[]> depthST = new Stack<int[]>();

		Tree<CallGraphInfo> temp = nowInfo;
		Iterator<Tree<CallGraphInfo>> t;
		temp.initRound();
		int[] pos;
		do{
			CallGraphNode node = new CallGraphNode(nextPosX, nextPosY, nowInfo==temp, temp);
			node.addMouseListener(this);
			node.addRootActionListener(this);
			callGraphMain.add(node);
			t = temp.getSubNodeIterator(); 
			if(t.hasNext()){
				pos = new int[2];
				pos[0] = nextPosX;
				pos[1] = nextPosY;
				
				st.push(t);
				depthST.push(pos);
				
				temp = t.next();
				nextPosX += CallGraphNode.defaultWidth+20;
				
				callGraphMain.addLine(pos[0]/*+CallGraphNode.defaultWidth*/, pos[1]+(CallGraphNode.defaultHight)/2,
						nextPosX, nextPosY+(CallGraphNode.defaultHight)/2);
				if(nextPosX+CallGraphNode.defaultWidth+20 > mainPanelWidth){
					mainPanelWidth = nextPosX+CallGraphNode.defaultWidth+20;
				}
			}
			else if(st.isEmpty()){	
			}
			else{
				do{
					t = st.peek();
					pos = depthST.peek();
					if(t.hasNext()){
						temp = t.next();
						nextPosY += CallGraphNode.defaultHight+20;
						mainPanelHight = nextPosY+CallGraphNode.defaultHight+20;
						
						callGraphMain.addLine(pos[0]/*+CallGraphNode.defaultWidth*/, pos[1]+(CallGraphNode.defaultHight)/2,
								nextPosX, nextPosY+(CallGraphNode.defaultHight)/2);
						break;
					}
					else{
						st.pop();
						depthST.pop();
						nextPosX -= CallGraphNode.defaultWidth+20;
					}
				}while(!st.isEmpty());
			}
			
		}while(!st.isEmpty() || temp.hasNextSubNodes());
		
		callGraphMain.repaint();
		callGraphMain.setPreferredSize(new Dimension(mainPanelWidth, mainPanelHight));
	}


	public void mouseClicked(MouseEvent arg0) {}


	public void mouseEntered(MouseEvent arg0) {}


	public void mouseExited(MouseEvent arg0) {}


	public void mouseReleased(MouseEvent arg0) {}
	

	public void mousePressed(MouseEvent arg0) {
		// TODO Auto-generated method stub
		CallGraphNode temp = (CallGraphNode)arg0.getComponent();
		if(selectedNode != null){
			selectedNode.setBackground(new Color(255, 255, 255));
		}
		(selectedNode = temp).setBackground(new Color(220, 220, 255));
		
		if(selectedNode.getInfo() == nowInfo){
			visibleRoot.setText(" Լ ");
		}
		else{
			visibleRoot.setText(" Լ Ʈ ");
		}
		this.infoPanel.setInfo(selectedNode.getInfo());
	}

	public void actionPerformed(ActionEvent arg0) {
		// TODO Auto-generated method stub
		if(((JButton)arg0.getSource()).getText().equalsIgnoreCase(">")){
			nowInfo = ((RootVisibleButton)arg0.getSource()).getContainer().getInfo();
		}
		else{
			nowInfo = originalInfo;
		}
		if(selectedNode != null && selectedNode.getInfo() == nowInfo){
			visibleRoot.setText(" Լ ");
		}
		else{
			visibleRoot.setText(" Լ Ʈ ");
		}
		this.drawMain();
	}
}
