package com.hangum.vocabulary.data;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;

import org.apache.commons.lang.StringUtils;

import resource.Dumy;

import com.hangum.vocabulary.VocabularyActivator;
import com.hangum.vocabulary.preferences.PreferenceConstants;
import com.hangum.vocabulary.util.RandomUtil;

public class DataFileHandler implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 5035074789490208018L;
	private String[] wordList = null;
	private String fullyFileName = "vocabulary.txt";
	private String extension = ".ser";
	String fullyContectText = null;
	
	HashMap<Integer, String[]> mapKnow 		= new HashMap<Integer, String[]>();
	HashMap<String, String[]> mapUnKnow 	= new HashMap<String, String[]>();
	HashMap<Integer, String[]> mapProgress 	= new HashMap<Integer, String[]>();

	int questPosition = 0;
	
	public DataFileHandler() {
		init();
	}
	
	private void init() {
		fullyFileName = VocabularyActivator.getDefault().getPluginPreferences().getString(PreferenceConstants.P_PATH);

		try {
			// ó   ..
			if("".equals(fullyFileName)) {
				String makeDir = "c:/temp/vocabulary/";
				String makeFile = "vocabulary.txt";
//				MessageDialog.openError(null, "Ȯ", "ȯ漳->ܾ忡 ܾ  ԷϿ ּ.");
				
				// is first startup plug-in
				File f = new File(makeDir + makeFile);
				if(!f.exists()) {
					InputStream is = new Dumy().getClass().getResourceAsStream(makeFile);
					byte[] readText = new byte[is.available()];
					is.read(readText, 0, is.available());
					
					File makedirs = new File(makeDir);
					makedirs.mkdirs();
					
					FileOutputStream fos = new FileOutputStream(makeDir + makeFile);
					fos.write(readText);
					fos.flush();
					fos.close();
				}
				
				fullyFileName = makeDir + makeFile;
			}
			
			File wordObj = new File(fullyFileName + extension);
			if(!wordObj.canRead()) {
				getData();
				
				int progress = 0, know = 0;//, unknow = 0;
				for(int i = 0; i<wordList.length; i++) {
					String[] dataUnit = StringUtils.split(wordList[i], "|");
					
					if(dataUnit.length == 2) {
						mapProgress.put(progress++, dataUnit);
						System.out.println("[progress]" + dataUnit[0] + ":" + dataUnit[1]);
					} else if(dataUnit.length == 3) {
//						if(dataUnit[2].equals("know")) {
							mapKnow.put(know++, dataUnit);
							System.out.println("[mapKnow]" + dataUnit[0] + ":" + dataUnit[1]);					
//						} else {
//							mapUnKnow.put(unknow++, dataUnit);
//							System.out.println("[mapUnKnow]" + dataUnit[0] + ":" + dataUnit[1]);
//						}
					}
				}	//
				
				ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(fullyFileName+extension));
				oos.writeObject(this);
				
				oos.flush();
				oos.close();			
				
			//    .
			} else {
				ObjectInputStream ois = new ObjectInputStream(new FileInputStream(fullyFileName+extension));
				DataFileHandler tmpDFH = (DataFileHandler)ois.readObject();
				
//				System.out.println("===========================================");
				this.questPosition = tmpDFH.questPosition;
				this.fullyContectText = tmpDFH.fullyContectText;
				this.wordList = tmpDFH.wordList;
				
				this.mapUnKnow 		= tmpDFH.mapUnKnow;
				this.mapKnow 		= tmpDFH.mapKnow;
				this.mapProgress 	= tmpDFH.mapProgress;
//				System.out.println("===========================================");
				
				ois.close();				
			}
		} catch(Exception e) {
			e.printStackTrace();
		}
	}
	
	public void getData() throws Exception {
		BufferedInputStream br = null;
		//  д´.
		try {
			br = new BufferedInputStream(new FileInputStream(fullyFileName));
			byte[] readText = new byte[br.available()];
			br.read(readText, 0, br.available());
			fullyContectText = new String(readText);
			
			wordList = StringUtils.split(fullyContectText, "\r\n");
//		} catch(FileNotFoundException fnfe) {
//			fnfe.printStackTrace();
			
//			MessageDialog.openError(null, "Ȯ", "fnfe    ߻߽ϴ." + fnfe.getMessage());
//		} catch(IOException ioe) {
//			ioe.printStackTrace();
			
//			MessageDialog.openError(null, "Ȯ", "ioe   ߻߽ϴ." + ioe.getMessage());
//		} catch(Exception e) {
//			e.printStackTrace();
		} finally {
			try {br.close();} catch(IOException e) {}
		}
	}

	public String[] getQuestion() {
		questPosition = RandomUtil.getInt(getMapProgress().size());
		String[] question = getMapProgress().get(questPosition);
		
//		System.out.println("===============================");
//		System.out.println(getMapProgress().size() + "[]" + questPosition + "[]" + question[0] + "===>" + question[1]);
		
		return question;
	}
	
	/**
	 * ü ׿    Ѵ.
	 * 
	 * @return
	 */
	public String[] getQuestionList() {
		String[] questList = new String[5];

		for(int i=0; i<questList.length; i++) {
			questList[i] = StringUtils.split(wordList[RandomUtil.getInt(wordList.length)], "|")[1];
		}
		
		return questList;
	}
	
	public String[] getWordList() {
		return wordList;
	}

	public HashMap<Integer, String[]> getMapKnow() {
		return mapKnow;
	}

	public HashMap<Integer, String[]> getMapProgress() {
		return mapProgress;
	}
	
	public HashMap<String, String[]> getMapUnKnow() {
		return mapUnKnow;
	}
	
	/**
	 *  ߾ 俩θ Ѵ
	 * 
	 * @param key
	 */
	public void setKnowData() {
		//  HahsMap  
		String[] question = getMapProgress().get(questPosition);
		getMapProgress().remove(questPosition);
		
		//  ˰ ִ Ϳ  ߰
		mapKnow.put(mapKnow.size()+1, question);
		
		saveOOS();
	}
	
	public void setUnKnow() {
		String[] question = getMapProgress().get(questPosition);
		
		System.out.println(" unknowmap==>" + question[0] + " - " + question[1]);
		mapUnKnow.put(question[0] + " - " + question[1], question);
		
		saveOOS();		
	}
	
	/**
	 * unknow remove
	 * @param index
	 */
	public void removeUnKnow(String indexStr) {
		try {
			String[] unKnow = mapUnKnow.get(indexStr);
			System.out.println("delete ite:" + unKnow[0] +":" + unKnow[1]);
			
			mapUnKnow.remove(indexStr);
			
			saveOOS();
		} catch(Exception e) {
			e.printStackTrace();
		}
	}
	
	private void saveOOS() {
		try {
			ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(fullyFileName+extension));
			oos.writeObject(this);
			
			oos.flush();
			oos.close();
			
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}
