package com.hangum.vocabulary.dialog;

import java.util.HashMap;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.hangum.vocabulary.data.DataFileHandler;

public class DictationDialog extends Dialog {
	DataFileHandler dfh = null;
	int intervalSize = 0;
	
	HashMap<Integer, String[]> knowMap = null;  //  @jve:decl-index=0:

	private Shell sShell = null;  //  @jve:decl-index=0:visual-constraint="10,10"
	private Composite compositeHead = null;
	private Composite compositeBody = null;
	private Composite compositeTail = null;
	private Label label = null;
	
	private Button buttonConfirm = null;
	private Button buttonQuestComback = null;
	private Button buttonNext = null;
	private Label labelList[] = null;
	private Text textAnswer[] = null;
	private Button buttonListen[] = null;
	private Label labelCorrect[] = null;
	private Browser browser = null;
	
	public DictationDialog(Shell shell) {
		this(shell, SWT.PRIMARY_MODAL);
	}
	
	public DictationDialog(Shell shell, int style) {
		super(shell, style);
	}
	
	public void open(DataFileHandler dfh) {
		this.dfh = dfh;
		createSShell();
		sShell.open();
		
		sShell.setMinimumSize(400, 400);
		sShell.pack();
		
		Display display = getParent().getDisplay();
		while (!sShell.isDisposed()) {
			if(!display.readAndDispatch()) {
				display.sleep();
			}
		}
	}
	
	/**
	 * This method initializes sShell
	 */
	private void createSShell() {
		sShell = new Shell(SWT.SHELL_TRIM | SWT.APPLICATION_MODAL);
		sShell.setText("Dictation");
		createCompositeHead();
		createCompositeBody();
		createCompositeTail();
		sShell.setSize(new Point(397, 382));
		sShell.setLayout(new GridLayout());
	}

	/**
	 * This method initializes compositeHead	
	 *
	 */
	private void createCompositeHead() {
		GridData gridData1 = new GridData();
		gridData1.horizontalAlignment = GridData.FILL;
		gridData1.grabExcessHorizontalSpace = true;
		gridData1.verticalAlignment = GridData.CENTER;
		compositeHead = new Composite(sShell, SWT.NONE);
		compositeHead.setLayout(new GridLayout());
		compositeHead.setLayoutData(gridData1);
		label = new Label(compositeHead, SWT.NONE);
		label.setText("Dictation");
		label.setFont(new Font(Display.getDefault(), "Verdana", 14, SWT.BOLD));
	}

	/**
	 * This method initializes compositeBody	
	 *
	 */
	private void createCompositeBody() {
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 4;
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		gridData.verticalAlignment = GridData.FILL;
		compositeBody = new Composite(sShell, SWT.BORDER);
		compositeBody.setLayoutData(gridData);
		compositeBody.setLayout(gridLayout);
		
		knowMap = dfh.getMapKnow();
		if(knowMap.size() > 10) intervalSize = 10;			
		else intervalSize = knowMap.size();
		
//		System.out.println("[know size]=====> " + knowMap.size());
//		System.out.println("###################################");
		
		labelList = new Label[intervalSize];
		buttonListen = new Button[intervalSize];
		textAnswer = new Text[intervalSize];
		labelCorrect = new Label[intervalSize];
		
//		try {
			GridData gridDataBtn = new GridData();
			gridDataBtn.widthHint = 100;
			gridDataBtn.heightHint = 20;
			
			GridData gridDataBtn2 = new GridData();
			gridDataBtn2.widthHint = 140;
			
			for(int i=0; i<intervalSize; i++) {
				String[] retKnow = knowMap.get((i+1));
//				System.out.println("====[" + i  + "]" + retKnow[0] + "==>" + retKnow[1]);
				final String word =retKnow[0];
				labelList[i] = new Label(compositeBody, SWT.NONE);
				labelList[i].setText((i+1) + ".    ");
				buttonListen[i] = new Button(compositeBody, SWT.NONE);
				buttonListen[i].setText(retKnow[1]);
				buttonListen[i].setLayoutData(gridDataBtn2);
				buttonListen[i]
				.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
					public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
						sound(word);
					}
				});
				textAnswer[i] = new Text(compositeBody, SWT.BORDER);
				textAnswer[i].setLayoutData(gridDataBtn);
				labelCorrect[i] = new Label(compositeBody, SWT.NONE);
				labelCorrect[i].setText(retKnow[0]);
				labelCorrect[i].setLayoutData(gridDataBtn);
				labelCorrect[i].setVisible(false);
			}
//		} catch(Exception e) {
//			e.printStackTrace();
//		}
	}
	
	private void sound(String word) {
		String firstCharUpper = word.substring(0, 1).toUpperCase();
		
		StringBuffer sbStrHtml = new StringBuffer();
		sbStrHtml.append("<OBJECT ID='KrDic_Pron_Player' Name='KrDic_Pron_Player' width='0' height='0' ")
	      .append(" CLASSID='CLSID:22D6F312-B0F6-11D0-94AB-0080C74C7E95'> ")
	      .append(" <PARAM NAME='FileName' VALUE='http://msrv.yahoo.co.kr/SOUND/")
	      .append(firstCharUpper)
	      .append("/")
	      .append(word)
	      .append(".mp3'> ")
	      .append(" <PARAM NAME='autoStart' VALUE='1'> ")
	      .append(" <EMBED type='application/x-mplayer2' pluginspage='http://www.microsoft.com/Windows/Downloads/Contents/Products/MediaPlayer/' ")
	      .append(" id='KrDic_Pron_Player' name='KrDic_Pron_Player' ")
	      .append(" autostart='1' controller='1' ")
	      .append(" src='http://msrv.yahoo.co.kr/SOUND/")
	      .append(firstCharUpper)
	      .append("/")
	      .append(word)
	      .append(".mp3' width='0' height='0'> ")
	      .append(" </EMBED> ")
	      .append(" </OBJECT>");
		
		browser.setText(sbStrHtml.toString());		
	}

	/**
	 * This method initializes compositeTail	
	 *
	 */
	private void createCompositeTail() {
		GridData gridData5 = new GridData();
		gridData5.widthHint = 100;
		GridLayout gridLayout1 = new GridLayout();
		gridLayout1.numColumns = 4;
		GridData gridData2 = new GridData();
		gridData2.horizontalAlignment = GridData.FILL;
		gridData2.grabExcessHorizontalSpace = true;
		gridData2.verticalAlignment = GridData.CENTER;
		compositeTail = new Composite(sShell, SWT.NONE);
		compositeTail.setLayoutData(gridData2);
		compositeTail.setLayout(gridLayout1);
		buttonConfirm = new Button(compositeTail, SWT.NONE);
		buttonConfirm.setText(" Ȯ");
		buttonConfirm.setLayoutData(gridData5);
		buttonConfirm
				.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
					public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
						Font worngFont = new Font(Display.getDefault(), "Segoe UI", 9, SWT.BOLD);
						Font confirmFont = new Font(Display.getDefault(), "Segoe UI", 9, SWT.BOLD);
						
						for(int i=0; i<intervalSize; i++) {
							labelCorrect[i].setVisible(true);
							
							String strCorr = labelCorrect[i].getText();
							if(strCorr.equals(textAnswer[i].getText())) {
								labelCorrect[i].setFont(confirmFont);
								labelCorrect[i].setForeground(Display.getCurrent().getSystemColor(SWT.COLOR_BLUE));
							} else {
								labelCorrect[i].setFont(worngFont);
								labelCorrect[i].setForeground(Display.getCurrent().getSystemColor(SWT.COLOR_RED));
							}
						}
					}
				});
		buttonQuestComback = new Button(compositeTail, SWT.NONE);
//		buttonQuestComback.setText(" ̵");
		buttonQuestComback.setText(" (&C)");
		buttonQuestComback
				.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
					public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
						sShell.close();
					}
				});
		buttonNext = new Button(compositeTail, SWT.NONE);
		buttonNext.setText("(&N)");
		buttonNext.setVisible(false);
		createBrowser();
	}

	/**
	 * This method initializes browser	
	 *
	 */
	private void createBrowser() {
		browser = new Browser(compositeTail, SWT.NONE);
		browser.setVisible(false);
	}

}
