package com.hangum.vocabulary.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;

import com.hangum.vocabulary.VocabularyActivator;

/**
 * Class used to initialize default preference values.
 */
public class PreferenceInitializer extends AbstractPreferenceInitializer {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer#initializeDefaultPreferences()
	 */
	public void initializeDefaultPreferences() {
		IPreferenceStore store = VocabularyActivator.getDefault().getPreferenceStore();
		if(System.getProperty("os.name").indexOf("Windows")>=0) {
			store.setDefault(PreferenceConstants.P_PATH, "c:/temp/vocabulary/vocabulary.txt");
		}
		else {
			store.setDefault(PreferenceConstants.P_PATH, "/tmp/vocabulary/vocabulary.txt");
		}
		store.setDefault(PreferenceConstants.P_DICTATION_INIT, "choice_text");
	}

}
