package com.hangum.vocabulary.views;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

import com.hangum.vocabulary.data.DataFileHandler;
import com.hangum.vocabulary.dialog.DictationDialog;
import com.hangum.vocabulary.util.RandomUtil;

/**
 * vocabulary view  ȭ
 * 
 * @author hangum
 *
 */
public class VocabularyView extends ViewPart {

	public static final String ID = "com.hangum.vocabulary.views.VocabularyView"; // TODO Needs to be whatever is mentioned in plugin.xml
	DataFileHandler dfh = null;  //  @jve:decl-index=0:
	String[] question = null;
	String browserUrl = "http://kr.dictionary.search.yahoo.com/search/dictionarym?p=";//  //  @jve:decl-index=0:
	String browserUrl2 = "&subtype=all&prop=&target=";  //  @jve:decl-index=0:
	StringBuffer sbStrHtml = new StringBuffer();  //  @jve:decl-index=0:
	
	private Action actionDictation;  //  @jve:decl-index=0:

	private Composite top = null;

	private Composite compSearch = null;

	private Composite compGroup = null;

	private SashForm sashForm = null;

	private Group groupBrowser = null;

	private Group groupQuestion = null;

	private Group groupControl = null;

	private Button radioButton = null;

	private Button radioButton1 = null;

	private Button radioButton2 = null;

	private Button radioButton3 = null;

	private Button radioButton4 = null;

	private List listCtl = null;

	private Label label = null;

	private Text textWord = null;

	private Label lblComment = null;

	private Browser browser = null;

	private Button btnNextVocabulary = null;
	private Button btnCustomer = null;
	private Button btnControlDel = null;
	private Browser browserHidden = null;
	private Button btnListen = null;
	
	@Override
	public void createPartControl(Composite parent) {
		// TODO Auto-generated method stub
		top = new Composite(parent, SWT.NONE);
		top.setLayout(new GridLayout());
		createCompSearch();
		createCompGroup();

		// 
		makeActions();
		contributeToActionBars();
		
//		 ʱⵥ Ѵ.
		initData();
	}
	
	private void contributeToActionBars() {
		IActionBars bars = getViewSite().getActionBars();
		
		IToolBarManager manager = bars.getToolBarManager();
		manager.add(actionDictation);
	}
	
	private void makeActions() {
		actionDictation = new Action() {
			public void run() {
				dictation();
			}
		};
		actionDictation.setText("Dictation");
		actionDictation.setToolTipText("Dictation");
		actionDictation.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().
			getImageDescriptor(ISharedImages.IMG_OBJS_INFO_TSK));
	}

	private void dictation() {
		HashMap<Integer, String[]> knowMap = dfh.getMapKnow();
		if(knowMap.size() == 0) {
			MessageDialog.openInformation(null, "Ȯ", "Dictation   ׸ ϴ.");
		} else {
			DictationDialog dd = new DictationDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
			dd.open(dfh);
		}
	}

	@Override
	public void setFocus() {
		this.textWord.setFocus();
	}

	/**
	 * This method initializes compSearch	
	 *
	 */
	private void createCompSearch() {
		GridData gridData15 = new GridData();
		gridData15.horizontalSpan = 2;
		GridData gridData14 = new GridData();
		gridData14.widthHint = 157;
		GridData gridData12 = new GridData();
		gridData12.grabExcessHorizontalSpace = true;
		gridData12.verticalAlignment = GridData.CENTER;
		gridData12.horizontalAlignment = GridData.FILL;
		GridLayout gridLayout1 = new GridLayout();
		gridLayout1.numColumns = 7;
		gridLayout1.verticalSpacing = 5;
		gridLayout1.marginWidth = 5;
		gridLayout1.marginHeight = 0;
		gridLayout1.horizontalSpacing = 5;
		GridData gridData1 = new GridData();
		gridData1.horizontalAlignment = GridData.FILL;
		gridData1.grabExcessHorizontalSpace = true;
		gridData1.verticalAlignment = GridData.CENTER;
		compSearch = new Composite(top, SWT.NONE);
		compSearch.setLayoutData(gridData1);
		compSearch.setLayout(gridLayout1);
		label = new Label(compSearch, SWT.NONE);
		label.setText("˻");
		label.setFont(new Font(Display.getDefault(), "Segoe UI", 9, SWT.BOLD));
		textWord = new Text(compSearch, SWT.BORDER);
		textWord.setLayoutData(gridData14);
		textWord.addTraverseListener(new org.eclipse.swt.events.TraverseListener() {
			public void keyTraversed(org.eclipse.swt.events.TraverseEvent e) {
				if(e.keyCode == 13) {
					if(!"".equals(textWord.getText())) {
						viewBrowser();
					}
				}
			}
		});

		btnListen = new Button(compSearch, SWT.NONE);
		btnListen.setText("(&l)");
		btnListen.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				listenVocabulary();
			}
		});
		
		lblComment = new Label(compSearch, SWT.NONE);		
		lblComment.setText(" ");
		lblComment.setFont(new Font(Display.getDefault(), "Segoe UI", 10, SWT.BOLD));
		lblComment.setLayoutData(gridData12);
		lblComment.setForeground(Display.getCurrent().getSystemColor(SWT.COLOR_BLUE));
		
		
		btnNextVocabulary = new Button(compSearch, SWT.NONE);
		btnNextVocabulary.setText("Next(&n)");
		btnNextVocabulary.setLayoutData(gridData15);
		btnNextVocabulary.setForeground(Display.getCurrent().getSystemColor(SWT.COLOR_LIST_SELECTION));
		btnCustomer = new Button(compSearch, SWT.NONE);
		btnNextVocabulary
				.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
					public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
						newData();
					}
				});
		btnCustomer.setText("ܾ߰(&a)");
		btnCustomer.setForeground(Display.getCurrent().getSystemColor(SWT.COLOR_LIST_SELECTION));
		btnCustomer.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				newControl();
			}
		});
	}

	/**
	 * This method initializes compGroup	
	 *
	 */
	private void createCompGroup() {
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 1;
		gridLayout.marginHeight = 0;
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		gridData.verticalAlignment = GridData.FILL;
		compGroup = new Composite(top, SWT.NONE);
		createSashForm();
		compGroup.setLayout(gridLayout);
		compGroup.setLayoutData(gridData);
	}

	/**
	 * This method initializes sashForm	
	 *
	 */
	private void createSashForm() {
		GridData gridData3 = new GridData();
		gridData3.horizontalAlignment = GridData.FILL;
		gridData3.grabExcessHorizontalSpace = true;
		gridData3.grabExcessVerticalSpace = true;
		gridData3.verticalAlignment = GridData.FILL;
		sashForm = new SashForm(compGroup, SWT.BORDER);
		sashForm.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_TITLE_BACKGROUND_GRADIENT));
		
		createGroupBrowser();
		sashForm.setLayoutData(gridData3);
		createGroupQuestion();
		createGroupControl();
	}

	/**
	 * This method initializes groupBrowser	
	 *
	 */
	private void createGroupBrowser() {
		GridLayout gridLayout2 = new GridLayout();
		gridLayout2.marginHeight = 0;
		gridLayout2.marginWidth = 0;
		gridLayout2.horizontalSpacing = 0;
		gridLayout2.verticalSpacing = 0;
		groupBrowser = new Group(sashForm, SWT.NONE);
		groupBrowser.setFont(new Font(Display.getDefault(), "Segoe UI", 9, SWT.BOLD));
		createBrowser();
		groupBrowser.setLayout(gridLayout2);
		groupBrowser.setText("Dictionary");
	}

	/**
	 * This method initializes groupQuestion	
	 *
	 */
	private void createGroupQuestion() {
		GridData gridData10 = new GridData();
		gridData10.horizontalAlignment = GridData.FILL;
		gridData10.grabExcessHorizontalSpace = true;
		gridData10.verticalAlignment = GridData.CENTER;
		GridData gridData9 = new GridData();
		gridData9.horizontalAlignment = GridData.FILL;
		gridData9.grabExcessHorizontalSpace = true;
		gridData9.verticalAlignment = GridData.CENTER;
		GridData gridData8 = new GridData();
		gridData8.horizontalAlignment = GridData.FILL;
		gridData8.grabExcessHorizontalSpace = true;
		gridData8.verticalAlignment = GridData.CENTER;
		GridData gridData7 = new GridData();
		gridData7.grabExcessHorizontalSpace = true;
		gridData7.verticalAlignment = GridData.CENTER;
		gridData7.horizontalAlignment = GridData.FILL;
		GridData gridData6 = new GridData();
		gridData6.grabExcessHorizontalSpace = true;
		gridData6.verticalAlignment = GridData.CENTER;
		gridData6.horizontalAlignment = GridData.FILL;
		GridData gridData4 = new GridData();
		gridData4.horizontalAlignment = GridData.FILL;
		gridData4.grabExcessHorizontalSpace = true;
		gridData4.grabExcessVerticalSpace = true;
		gridData4.verticalAlignment = GridData.FILL;
		groupQuestion = new Group(sashForm, SWT.NONE);
		groupQuestion.setLayout(new GridLayout());
		groupQuestion.setText("    ");
		groupQuestion.setFont(new Font(Display.getDefault(), "Segoe UI", 9, SWT.BOLD));
		groupQuestion.setLayoutData(gridData4);
		radioButton = new Button(groupQuestion, SWT.RADIO);
		radioButton.setLayoutData(gridData6);
		radioButton.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				checkCorrect(radioButton);
			}
		});
		radioButton1 = new Button(groupQuestion, SWT.RADIO);
		radioButton1.setLayoutData(gridData10);
		radioButton1.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				checkCorrect(radioButton1);
			}
		});
		radioButton2 = new Button(groupQuestion, SWT.RADIO);
		radioButton2.setLayoutData(gridData9);
		radioButton2.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				checkCorrect(radioButton2);
			}
		});
		radioButton3 = new Button(groupQuestion, SWT.RADIO);
		radioButton3.setLayoutData(gridData8);
		radioButton3.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				checkCorrect(radioButton3);
			}
		});
		radioButton4 = new Button(groupQuestion, SWT.RADIO);
		radioButton4.setLayoutData(gridData7);
		createBrowserHidden();
		radioButton4.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
			public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
				checkCorrect(radioButton4);
			}
		});
	}

	/**
	 * This method initializes groupControl	
	 *
	 */
	private void createGroupControl() {
		GridData gridData16 = new GridData();
		gridData16.horizontalAlignment = GridData.FILL;
		gridData16.grabExcessHorizontalSpace = true;
		gridData16.grabExcessVerticalSpace = true;
		gridData16.verticalAlignment = GridData.FILL;
		GridLayout gridLayout3 = new GridLayout();
		gridLayout3.marginHeight = 0;
		GridData gridData2 = new GridData();
		gridData2.horizontalAlignment = GridData.END;
		gridData2.verticalAlignment = GridData.CENTER;
		GridData gridData11 = new GridData();
		gridData11.grabExcessHorizontalSpace = true;
		gridData11.horizontalAlignment = GridData.FILL;
		gridData11.verticalAlignment = GridData.FILL;
		gridData11.grabExcessVerticalSpace = true;
		GridData gridData5 = new GridData();
		gridData5.horizontalAlignment = GridData.FILL;
		gridData5.grabExcessHorizontalSpace = true;
		gridData5.grabExcessVerticalSpace = true;
		gridData5.verticalAlignment = GridData.FILL;
		groupControl = new Group(sashForm, SWT.NONE);
		groupControl.setText("ܾ");
		groupControl.setFont(new Font(Display.getDefault(), "Segoe UI", 9, SWT.BOLD));
		groupControl.setLayout(gridLayout3);
		groupControl.setLayoutData(gridData5);
		listCtl = new List(groupControl, SWT.V_SCROLL);
		listCtl.setLayoutData(gridData16);
		listCtl.setLayoutData(gridData11);
		btnControlDel = new Button(groupControl, SWT.NONE);
		btnControlDel.setText("ϱ(&d)");
		btnControlDel.setLayoutData(gridData2);
		btnControlDel
				.addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
					public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
						if(listCtl.getSelectionIndex() == -1) {
							MessageDialog.openError(null, "Ȯ", "ϱϽ ׸ ϼ.");
						} else {
							dfh.removeUnKnow(listCtl.getItem(listCtl.getSelectionIndex()));
							
							listCtl.remove(listCtl.getSelectionIndex());
							listCtl.redraw();
						}
					}
				});
	}

	/**
	 * This method initializes browser	
	 *
	 */
	private void createBrowser() {
		GridData gridData13 = new GridData();
		gridData13.horizontalAlignment = GridData.FILL;
		gridData13.grabExcessVerticalSpace = true;
		gridData13.grabExcessHorizontalSpace = true;
		gridData13.verticalAlignment = GridData.FILL;
		browser = new Browser(groupBrowser, SWT.NONE);
		browser.setLayoutData(gridData13);
	}
	
	public void initData() {
		dfh = new DataFileHandler();
		
		newData();
		
		initControl();
	}
	
	private void initControl() {
		HashMap<String, String[]> unKnowMap = dfh.getMapUnKnow();
		
		Iterator ite = unKnowMap.keySet().iterator();
		while(ite.hasNext()) {
			String[] unKnow = unKnowMap.get(ite.next().toString());
			
			listCtl.add(unKnow[0] + " - " + unKnow[1]);
		}
		
		listCtl.redraw();
	}
	
	/**
	 * 
	 * @param btn
	 */
	private void checkCorrect(Button btn) {
//		System.out.println(btn.getText() + ":" + question[1]);
		
		if(btn.getText().equals(question[1])) {
			dfh.setKnowData();
			newData();
			
			lblComment.setForeground(Display.getCurrent().getSystemColor(SWT.COLOR_BLUE));
			lblComment.setText(" ߾...  ض ...");
		} else {
			lblComment.setForeground(Display.getCurrent().getSystemColor(SWT.COLOR_RED));
			lblComment.setText("ƴѵ,  ܿ..  Next,  ư  ܿ...");
		}
	}
	
	private void newData() {
		question = dfh.getQuestion();
		String[] questionList = dfh.getQuestionList();
		
		//  ġϰ  κ random ϰ ش.
		textWord.setText(question[0]);
		setQustList(question[1], questionList);
		
		String firstCharUpper = question[0].substring(0, 1).toUpperCase();

		sbStrHtml = new StringBuffer();
		sbStrHtml.append("<OBJECT ID='KrDic_Pron_Player' Name='KrDic_Pron_Player' width='0' height='0' ")
	      .append(" CLASSID='CLSID:22D6F312-B0F6-11D0-94AB-0080C74C7E95'> ")
	      .append(" <PARAM NAME='FileName' VALUE='http://msrv.yahoo.co.kr/SOUND/")
	      
	      .append(firstCharUpper)
	      .append("/")
	      .append(question[0])
	      .append(".mp3'> ")
	      .append(" <PARAM NAME='autoStart' VALUE='1'> ")
	      .append(" <EMBED type='application/x-mplayer2' pluginspage='http://www.microsoft.com/Windows/Downloads/Contents/Products/MediaPlayer/' ")
	      .append(" id='KrDic_Pron_Player' name='KrDic_Pron_Player' ")
	      .append(" autostart='1' controller='1' ")
	      .append(" src='http://msrv.yahoo.co.kr/SOUND/")
	      
	      .append(firstCharUpper)
	      .append("/")
	      .append(question[0])
	      
	      .append(".mp3' width='0' height='0'> ")
	      .append(" </EMBED> ")
	      .append(" </OBJECT>");
		
//		listenVocabulary();

		radioButton.setSelection(false);
		radioButton1.setSelection(false);
		radioButton2.setSelection(false);
		radioButton3.setSelection(false);
		radioButton4.setSelection(false);
	}
	
	public void newControl() {
		dfh.setUnKnow();
		
		// 
		listCtl.add(question[0] + " - " + question[1]);
		listCtl.redraw();
		
		newData();
	}

	/**
	 *  
	 * 
	 * @param answQust
	 * @param worng
	 */
	public void setQustList(String answQust, String[] worng) {
		int postion = RandomUtil.getInt(4);
		
		int index = 0;
		if(postion == 1) radioButton.setText(answQust);
		else radioButton.setText(worng[index++]);
		
		if(postion == 2) radioButton1.setText(answQust);
		else radioButton1.setText(worng[index++]);
		
		if(postion == 3) radioButton2.setText(answQust);
		else radioButton2.setText(worng[index++]);
		
		if(postion == 4) radioButton3.setText(answQust);
		else radioButton3.setText(worng[index++]);
		
		if(postion == 5) radioButton4.setText(answQust);
		else radioButton4.setText(worng[index++]);
	}

	/**
	 * This method initializes browserHidden	
	 *
	 */
	private void createBrowserHidden() {
		browserHidden = new Browser(groupQuestion, SWT.NONE);
		browserHidden.setVisible(false);
	}
	
	/**
	 * listen
	 *
	 */
	private void listenVocabulary() {
		browserHidden.getDisplay().syncExec(new Runnable() {
			public void run() { 
				browserHidden.setText(sbStrHtml.toString());
			}
		});
	}
	
	private void viewBrowser() {
		try {
			URLConnection urlConnection = new URL(browserUrl + textWord.getText().trim() + browserUrl2).openConnection();
			urlConnection.connect();
			InputStream is = urlConnection.getInputStream();
			
			byte [] byteData = new byte[1024];
			int len = 0;
			StringBuffer sbHtml = new StringBuffer(30000);
			while( (len = is.read(byteData, 0, byteData.length)) != -1) {
				sbHtml.append(new String(byteData, 0, len));
			}
			String modifyHtml = StringUtils.replace(sbHtml.toString(), "<thead>", "<thead style='display:none;'>");
			browser.setText(modifyHtml);
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * unit test  
	 * @return
	 */
	public VocabularyView getVocabularyView() {
		return this;
	}

}  //  @jve:decl-index=0:visual-constraint="10,10,632,316"
