// GraphWnd.cpp : implementation file
//

#include "stdafx.h"
#include "wgnuplot.h"
#include "GraphWnd.h"

#include "src/bitmap.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

static BOOL brushes_initialized = FALSE;
/////////////////////////////////////////////////////////////////////////////
// CGraphWnd

CGraphWnd::CGraphWnd()
{
}

CGraphWnd::~CGraphWnd()
{
}


BEGIN_MESSAGE_MAP(CGraphWnd, CWnd)
	//{{AFX_MSG_MAP(CGraphWnd)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CGraphWnd message handlers

int CGraphWnd::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	HDC hdc = ::GetDC( m_hWnd );
	MakePens(hdc);

	LoadCursors();

	RECT rect;
	GetClientRect( &rect );
	MakeFonts((LPRECT)&rect, hdc);
	::ReleaseDC(m_hWnd, hdc);

#if WINVER >= 0x030a
	{
		WORD version = LOWORD(GetVersion());
		
		if ((LOBYTE(version)*100 + HIBYTE(version)) >= 310)
			if ( lptw && (lptw->DragPre!=(LPSTR)NULL) && (lptw->DragPost!=(LPSTR)NULL) )
				DragAcceptFiles(TRUE);
	}
#endif
	
	return 0;
}

/* Prepare pens and brushes (--> colors) for use by the driver. Pens are (now) created
 * on-the-fly (--> DeleteObject(SelectObject(...)) idiom), but the brushes are still
 * all created statically, and kept until the window is closed */
void CGraphWnd::MakePens(HDC hdc)
{
	/*
	int i;
	
	if ((GetDeviceCaps(hdc,NUMCOLORS) == 2) || !color) 
	{
		hapen = CreatePenIndirect((LOGPEN FAR *)&monopen[1]); 	/// axis
		hbrush = CreateSolidBrush(RGB(255,255,255));
		for (i=0; i<WGNUMPENS+2; i++)
			colorbrush[i] = CreateSolidBrush(RGB(0,0,0));
	} else {
		hapen = CreatePenIndirect((LOGPEN FAR *)&colorpen[1]); 	/// axis
		hbrush = CreateSolidBrush(background);
		for (i=0; i<WGNUMPENS+2; i++)
			colorbrush[i] = CreateSolidBrush(colorpen[i].lopnColor);
	}
	
	/// build pattern brushes for filled boxes (ULIG)
	if( ! brushes_initialized ) 
	{
		int i;
		
		for(i=0; i < halftone_num; i++) 
		{
			halftone_bitdata[i].bmType       = 0;
			halftone_bitdata[i].bmWidth      = 16;
			halftone_bitdata[i].bmHeight     = 8;
			halftone_bitdata[i].bmWidthBytes = 2;
			halftone_bitdata[i].bmPlanes     = 1;
			halftone_bitdata[i].bmBitsPixel  = 1;
			halftone_bitdata[i].bmBits       = halftone_bitmaps[i];
			halftone_bitmap[i] = CreateBitmapIndirect(&halftone_bitdata[i]);
			halftone_brush[i] = CreatePatternBrush(halftone_bitmap[i]);
		}
		
		for(i=0; i < pattern_num; i++) 
		{
			pattern_bitdata[i].bmType       = 0;
			pattern_bitdata[i].bmWidth      = 16;
			pattern_bitdata[i].bmHeight     = 8;
			pattern_bitdata[i].bmWidthBytes = 2;
			pattern_bitdata[i].bmPlanes     = 1;
			pattern_bitdata[i].bmBitsPixel  = 1;
			pattern_bitdata[i].bmBits       = pattern_bitmaps[i];
			pattern_bitmap[i] = CreateBitmapIndirect(&pattern_bitdata[i]);
			pattern_brush[i] = CreatePatternBrush(pattern_bitmap[i]);
		}
		
		brushes_initialized = TRUE;
	}
	*/
}

void CGraphWnd::LoadCursors()
{
	/*
	///3 of them are standard cursor shapes:
	hptrDefault = LoadCursor(NULL, IDC_ARROW);
	hptrZooming = LoadCursor(NULL, IDC_SIZEALL);
	hptrCrossHair = LoadCursor( NULL, IDC_CROSS);
	///the other 2 are kept in the resource file:
	hptrScaling = LoadCursor( hInstance, MAKEINTRESOURCE(IDC_SCALING));
	hptrRotating = LoadCursor( hInstance, MAKEINTRESOURCE(IDC_ROTATING));
	
	hptrCurrent = hptrCrossHair;
	*/
}

void CGraphWnd::MakeFonts(LPRECT lprect, HDC hdc)
{
	/*
	HFONT hfontold;
	TEXTMETRIC tm;
	int result;
	char FAR *p;
	int cx, cy;
	
	rotate = FALSE;
	memset(&(lf), 0, sizeof(LOGFONT));
	strncpy(lf.lfFaceName,fontname,LF_FACESIZE);
	lf.lfHeight = -MulDiv(fontsize, GetDeviceCaps(hdc, LOGPIXELSY), 72);
	lf.lfCharSet = DEFAULT_CHARSET;
	if ( (p = strstr(fontname," Italic")) != (LPSTR)NULL ) {
		lf.lfFaceName[ (unsigned int)(p-fontname) ] = '\0';
		lf.lfItalic = TRUE;
	}
	if ( (p = strstr(fontname," Bold")) != (LPSTR)NULL ) {
		lf.lfFaceName[ (unsigned int)(p-fontname) ] = '\0';
		lf.lfWeight = FW_BOLD;
	}
	
	if (hfonth == 0) {
		hfonth = CreateFontIndirect((LOGFONT FAR *)&(lf));
	}
	
	/// we do need a 90 degree font
	if (hfontv) 
		DeleteObject(hfontv);
	lf.lfEscapement = 900;
	lf.lfOrientation = 900;
	hfontv = CreateFontIndirect((LOGFONT FAR *)&(lf));
	
	/// save text size
	hfontold = (HFONT)SelectObject(hdc, hfonth);
	Wnd_GetTextSize(hdc, "0123456789", 10, &cx, &cy);
	vchar = MulDiv(cy,ymax,lprect->bottom - lprect->top);
	hchar = MulDiv(cx/10,xmax,lprect->right - lprect->left);
	
	/// CMW: Base tick size on character size
	htic = hchar / 2;
	cy = MulDiv(cx/20, GetDeviceCaps(hdc, LOGPIXELSY), GetDeviceCaps(hdc, LOGPIXELSX));
	vtic = MulDiv(cy,ymax,lprect->bottom - lprect->top);
	/// find out if we can rotate text 90deg
	SelectObject(hdc, hfontv);
	result = GetDeviceCaps(hdc, TEXTCAPS);
	if ((result & TC_CR_90) || (result & TC_CR_ANY))
		rotate = TRUE;
	GetTextMetrics(hdc,(TEXTMETRIC FAR *)&tm);
	if (tm.tmPitchAndFamily & TMPF_VECTOR)
		rotate = TRUE;	/// vector fonts can all be rotated
#if WINVER >=0x030a
	if (tm.tmPitchAndFamily & TMPF_TRUETYPE)
		rotate = TRUE;	/// truetype fonts can all be rotated
#endif
	SelectObject(hdc, hfontold);
	return;
	*/
}
