<?php // $Id: main.php,v 20.13 2004/01/08 22:43:48 EllselAn Exp $
/************************************************************************/
/* KalenderMx v1.3                                                      */
/* ===================                                                  */
/*  Calendar Module for vkpMx 2.x & phpNuke 5.5-7.0                     */
/*  Copyright (c) 2004 by A.Ellsel (kalender@pragmamx.org)              */
/*  http://www.pragmamx.org & http://ww.shiba-design.de                 */
/* -------------------------------------------------------------------- */
/* KalenderMx is based on EventCalendar 2.0                             */
/*  Copyright (c) 2001 Originally by Rob Sutton                         */
/*  http://smart.xnettech.net (Nuke Site)                               */
/*  Development continued by Aleks A.-Lessmann                          */
/* Included some ideas and changes by:                                  */
/*  flobee, bulli-frank, kicks, kochloeffel, FrankySz, Jubilee          */
/* -------------------------------------------------------------------- */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 or a newer version.   */
/************************************************************************/
if (!defined("CAL_MODULE_NAME")) die (" Ϸ    ϴ."); // aus case datei

if (!isset($calconf)) include(CAL_MODULE_PATH."config/config.php");
include_once(CAL_MODULE_PATH."includes/functions.php");
get_lang(CAL_MODULE_NAME);
if ((!calIsAdmin()) || (!eregi("admin.php", $_SERVER["PHP_SELF"]))) {
	$op = "errNoAuthorized";
	}

#########################################################################################
function CalendarPreviewEvent($event) { # post
	$event = calStripSlashes($event);
	$GLOBALS["pagetitle"]=_CALSUBMISSIONSADMIN;
	include("header.php");
	calAdminMenu(_CALSUBMISSIONSADMIN);
  calEventView($event);
	calSubmitForm($event);
	include("footer.php");
	}

#########################################################################################
function CalendarPostEvent($event){ # post
	global $dbi, $calconf;
	
	$event["activ"] = (empty($event["activ"])) ? 1 : $event["activ"];
	$event = calPrepareEventForSql($event);
	if (empty($event["eid"])) {
		$qry = calGetSqlQuery($event, "insert");
		}
	else {
		$qry="SELECT * FROM ".CAL_TABLE_EVENTS." where eid=".$event["eid"]."";
		$result=sql_query($qry, $dbi);
		if (!is_resource($result)) {
			calErrAdminMsg(_CALERRSQLERROR);#.mysql_errno(). ": ".mysql_error();
			}
		$testevent = sql_fetch_array($result, $dbi);
		if (!is_array($testevent)) {
			calErrAdminMsg(_CALERREVENTNOTEXIST);
			}
		$result = sql_query("select aid from ".CAL_TABLE_MX_AUTHORS." where aid='".$event["aid"]."'", $dbi);
		list($xaid) = sql_fetch_row($result, $dbi);
		if (!$xaid || !$event["aid"]){
			$event["aid"]=calIsAdmin();
			}
		$qry = calGetSqlQuery($event, "update");
		}
	#print $qry; exit;
	$result = sql_query($qry, $dbi);
	if (!($result)) {
		calErrAdminMsg(_CALERRSQLERROR);#.mysql_errno(). ": ".mysql_error();
		}
	if ($event["addasarticle"]){
		calAddArticle($event);
		}
	#Header("Location: ".CAL_MODULE_LINK."&y=".$event["startYear"]."&m=".$event["startMonth"]."&d=".$event["startDay"]."&view=".$calconf['defaultview']."");
	Header("Location: admin.php?op=CalendarAdmin");
	}

#########################################################################################
function CalendarEditEvent($eid) { # DB
	global $dbi, $op;
	$eid = (int)$eid;
	if (calIsAuthorsOwnEvent($eid)){
		$qry="SELECT * FROM ".CAL_TABLE_EVENTS." where eid=$eid";
		$result=sql_query($qry, $dbi);
		if (!is_resource($result)) {
			calErrAdminMsg(_CALERRSQLERROR);#.mysql_errno(). ": ".mysql_error();
			}
		$event = sql_fetch_array($result, $dbi);
		if (!is_array($event)) {
			calErrAdminMsg(_CALERREVENTNOTEXIST);
			}
		$event["op"] = $op;
		$GLOBALS["pagetitle"]=_CALSUBMISSIONSADMIN;
		if (empty($GLOBALS['header'])) include("header.php");
		calAdminMenu(_CALSUBMISSIONSADMIN);
	  calEventView($event);
		calSubmitForm($event);
		include("footer.php");
		}
	else {
		$msg = "<b>"._CALNOTAUTHORIZED1."</b><br><br>"._CALNOTAUTHORIZED2."<br><br>";
		calErrAdminMsg($msg, _CALSUBMISSIONSADMIN);
		}
	}

#########################################################################################
function CalendarDeleteEvent($eid, $ok=0) {
	global $dbi;
	$eid = (int)$eid;
	if (!calIsAuthorsOwnEvent($eid)) {
		$msg = "<b>"._CALNOTAUTHORIZED1."</b><br><br>"._CALNOTAUTHORIZED2."<br><br>";
		calErrAdminMsg($msg, _CALSUBMISSIONSADMIN);
		}
	$qry="SELECT * FROM ".CAL_TABLE_EVENTS." where eid=$eid";
	$result=sql_query($qry, $dbi);
	if (!is_resource($result)) {
		calErrAdminMsg(_CALERRSQLERROR);#.mysql_errno(). ": ".mysql_error();
		}
	$event = sql_fetch_array($result, $dbi);
	if (!is_array($event)) {
		calErrAdminMsg(_CALERREVENTNOTEXIST);
		}
	if ($ok) {
		$result = sql_query("delete from ".CAL_TABLE_EVENTS." where eid=$eid", $dbi);
		if (!$result) {
			calErrAdminMsg(_CALERRSQLERROR);
			}
		Header("Location: admin.php?op=CalendarAdmin");
		}
	else {
		$GLOBALS["pagetitle"]=_CALSUBMISSIONSADMIN;
		include("header.php");
		calAdminMenu(_CALSUBMISSIONSADMIN);
		OpenTable();
		echo "<center>"._CALREMOVETEST."<br><br><b>".$event["title"]."</b><br>";
		echo "<br>[ <a href=\"admin.php?op=CalendarAdmin\">"._CALNO."</a> | <a href=\"admin.php?op=CalendarDeactivateEvent&eid=".$event["eid"]."\">"._CALONLYDEACTIVATE."</a> | <a href=\"admin.php?op=CalendarDeleteEvent&eid=".$event["eid"]."&ok=1\">"._CALYES."</a> ]</center>";
		CloseTable();
		echo "<br>";
  	calEventView($event);
		include("footer.php");
		}
	}

#########################################################################################
function CalendarDeactivateEvent($eid){
	global $dbi;
	$eid = (int)$eid;
	if (!calIsAuthorsOwnEvent($eid)) {
		$msg = "<b>"._CALNOTAUTHORIZED1."</b><br><br>"._CALNOTAUTHORIZED2."<br><br>";
		calErrAdminMsg($msg, _CALSUBMISSIONSADMIN);
		}
	$qry="update ".CAL_TABLE_EVENTS." set 
		activ = 2 
		where eid = $eid";
	$result = sql_query($qry, $dbi);
	if (!($result)) {
		calErrAdminMsg(_CALERRSQLERROR);#.mysql_errno(). ": ".mysql_error();
		}
	Header("Location: admin.php?op=CalendarAdmin");
	}

#########################################################################################
function CalendarSubmissions() {
	global $bgcolor1, $bgcolor2, $bgcolor3, $dbi;
	$newevents = (empty($newevents)) ? "" : $newevents;
	$deacevents = (empty($deacevents)) ? "" : $deacevents;

	$GLOBALS["pagetitle"]=_CALSUBMISSIONSADMIN;
	include ("header.php"); // hier bereits einbinden wegen $bgcolors

	$qry = "SELECT * FROM ".CAL_TABLE_EVENTS." 
	WHERE activ <> 1 
	ORDER BY activ, posteddate";
	$result1 = sql_query($qry, $dbi);
	if (!is_resource($result1)) {
		calErrAdminMsg(_CALERRSQLERROR);#.mysql_errno(). ": ".mysql_error();
		}

	calAdminMenu(_CALSUBMISSIONSADMIN);
	
	$tblheader = "<center><table border=\"0\" width=\"80%\" bgcolor=\"$bgcolor3\" cellpadding=\"3\" cellspacing=\"1\">\n<tr bgcolor=\"$bgcolor2\">";
	$tblheader1 = $tblheader
		."<th colspan=2 width=\"10%\">"._CAL1EVENT."</th>"
		."<th nowrap>"._CALSUBTITLE."</th>"
		."<th nowrap>"._CALARTICLETEXT."</th>"
		."<th nowrap>"._CALNAMEFIELD."</th>"
		."<th nowrap>"._CALPOSTEDON."</th>"
		."<th width=\"5%\">&nbsp;</th>"
		."</tr>\n";
	$tblheader2 = $tblheader
		."<th colspan=2 width=\"10%\">"._CAL1EVENT."</th>"
		."<th nowrap>"._CALSUBTITLE."</th>"
		."<th nowrap>"._CALARTICLETEXT."</th>"
		."<th width=\"5%\">&nbsp;</th>"
		."</tr>\n";
	
	$tblfooter = "</table>\n</center>\n";
	
	$i1 = 0; $i2 = 0;
	while ($xevent = sql_fetch_array($result1, $dbi)) {
		if ($xevent["activ"]==0) {
			$i1++;
			$newevents[] = calFormatListRow($xevent, 1, $i1);
			}
		else if ($xevent["activ"]==2) {
			$i2++;
			$deacevents[] = calFormatListRow($xevent, 2, $i2);
			}
		}

	if (count($newevents) && !empty($newevents)) {
		OpenTable();
		echo "<center><font class=\"option\">".count($newevents)."&nbsp;"._CALNEWSUBMISSIONS."</font></center><br>";
		echo $tblheader1;
		echo implode("\n",$newevents);
		echo $tblfooter;
		CloseTable();
		echo "<br>";
		}
	else {
		title(_CALNOSUBMISSIONS);
		}
	
	if (count($deacevents) && !empty($deacevents)) {
		OpenTable();
		echo "<center><font class=\"option\">".count($deacevents)."&nbsp;"._CALDEACTIVATED."</font></center><br>";
		echo $tblheader2;
		echo implode("\n",$deacevents);
		echo $tblfooter;
		CloseTable();
		}
	else {
		title(_CALNODEACTIVATED);
		}
	include ("footer.php");
	}


#########################################################################################
function calFormatListRow($event, $mode, $i) {
	global $bgcolor1, $bgcolor2, $bgcolor3;
	$bgcolor = ($i % 2) ? $bgcolor1 : $bgcolor2;
	
	$eventsdates = calGetEventDates($event);
	$event = array_merge($event,$eventsdates);

	$event["title"]    = htmlspecialchars(strip_tags($event["title"]), ENT_QUOTES);
	$event["title"]    = (empty($event["title"])) ? _CALNOSUBJECT : $event["title"];
	$event["hometext"] = substr(htmlspecialchars(strip_tags($event["hometext"]), ENT_QUOTES),0,100)."...";
	
	$event["informant"] = (empty($event["informant"]) || $event["informant"] == $GLOBALS["anonymous"]) ? "" : "<a href=\"".CAL_MOD_USERINFO.$event["informant"]."\" target=\"_blank\">".$event["informant"]."</a>";
	
	$out = "<tr bgcolor=\"$bgcolor\">";
	$out .= "<td align=\"right\"><b>".$i."</b></td>\n";
	$out .= "<td>".$event["startDateShort"]."</td>";
	$out .= "<td nowrap>&nbsp;<a href=\"admin.php?op=CalendarEditEvent&eid=".$event["eid"]."\">".$event["title"]."</a>&nbsp;</td>\n";
	$out .= "<td>".$event["hometext"]."</td>";
	if ($mode==1) $out .= "<td>".$event["informant"]."</td>";
	if ($mode==1) $out .= "<td nowrap>".$event["postDateShort"]."</td>";
	$out .= "<td align=\"center\"><a href=\"admin.php?op=CalendarEditEvent&eid=".$event["eid"]."\"><img src=\"".CAL_IMAGE_PATH."edit.gif\" alt=\""._CALPOSTSTORY."\" width=\"19\" height=\"17\" border=\"0\"></a>&nbsp;<a href=\"admin.php?op=CalendarDeleteEvent&eid=".$event["eid"]."\"><img src=\"".CAL_IMAGE_PATH."delete.gif\" alt=\""._CALDELETESTORY."\" width=\"20\" height=\"16\" border=\"0\"></a></td>\n";
	$out .= "</tr>\n";
	return $out;
	}

#########################################################################################
function calIsAuthorsOwnEvent($eid){
	global $dbi, $calconf;
	$eid = (int)$eid;
	$calIsAdmin = calIsAdmin();
	if (!$calIsAdmin) {return 0; exit;}
	if (!$calconf['AdminEditAll']){
		$qry="select ".$calconf['AdminType'].", radminsuper from ".CAL_TABLE_MX_AUTHORS." where aid='$calIsAdmin'";
		$result = sql_query($qry, $dbi);
		list($CalendarAdmin, $radminsuper) = sql_fetch_row($result, $dbi);
		}
	else {
		$radminsuper=0;
		}
	$qry="select aid from ".CAL_TABLE_EVENTS." where eid='$eid'";
	$result = sql_query($qry, $dbi);
	list($aaid) = sql_fetch_row($result, $dbi);
	if (empty($aaid)) {
		return $calIsAdmin;
		}
	else if (($radminsuper == 1) || ($calIsAdmin == $aaid) || ($calIsAdmin && $calconf['AdminEditAll'])){
	#else if (($calIsAdmin == $aaid) || ($calIsAdmin && $calconf['AdminEditAll'])){
		return $aaid;
		}
	else {
		return 0;
		}
	}

#########################################################################################
function CalendarConfig($ok = 0) {
	global $admin, $dbi;
	$conffile = CAL_MODULE_PATH."config/config.php";
	include($conffile);

	if ($ok == 1) {
		$statmsg = _CALCONF1;
		}
	else if ($ok > 1) {
		$statmsg = _CALCONF2;
		}
	@chmod($conffile, 0666);
	if (!is_writable(CAL_MODULE_PATH."config/config.php")) {
		$statmsg = _CALCONF3." '".CAL_MODULE_PATH."config/config.php' "._CALCONF4;
		}
	@chmod($conffile, 0444);

	$GLOBALS["pagetitle"]=_CALCALENDARCONFIG;
	include ("header.php");
	calAdminMenu(_CALCALENDARCONFIG);
	if (isset($statmsg)) {
		OpenTable2();
		echo "<blockquote><font class=\"title\"><b>$statmsg</b></font></blockquote>";
		CloseTable2();
		echo "<br>";
		}

	OpenTable();
	echo "<center>"
	."<form action=\"admin.php\" method=\"post\">"
	."<input type=\"hidden\" name=\"op\" value=\"CalendarConfigSave\">"
	."<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\">";
	
	$sel1 = (!empty($calconf['AdminMenu'])) ? "checked" : "";
	$sel2 = (empty($calconf['AdminMenu'])) ? "checked" : "";
	echo "<tr valign=\"top\"><td>"._CALADMINMENUSHOW."</td><td>"
	."<input type=\"radio\" name=\"xcalAdminMenu\" value=\"1\" $sel1>"._CALYES." &nbsp;"
	."<input type=\"radio\" name=\"xcalAdminMenu\" value=\"0\" $sel2>"._CALNO
	."</td></tr>\n";
	
	if (defined('MX_VERSION')) {
		echo "<input type='hidden' name='xcalAdminType' value='radmincalendar'>";
		}
	else {
		$qry="select * from ".CAL_TABLE_MX_AUTHORS." LIMIT 0,1";
		$result = sql_query($qry, $dbi);
		$radmins = sql_fetch_array($result, $dbi);
		$sel1  = ($calconf['AdminType']=="radminarticle")    ? "selected" : "";
		$sel2  = ($calconf['AdminType']=="radmintopic")      ? "selected" : "";
		$sel3  = ($calconf['AdminType']=="radminuser")       ? "selected" : "";
		$sel4  = ($calconf['AdminType']=="radminsurvey")     ? "selected" : "";
		$sel5  = ($calconf['AdminType']=="radminsection")    ? "selected" : "";
		$sel6  = ($calconf['AdminType']=="radminlink")       ? "selected" : "";
		$sel7  = ($calconf['AdminType']=="radminephem")      ? "selected" : "";
		$sel8  = ($calconf['AdminType']=="radminfaq")        ? "selected" : "";
		$sel9  = ($calconf['AdminType']=="radmindownload")   ? "selected" : "";
		$sel10 = ($calconf['AdminType']=="radminreviews")    ? "selected" : "";
		$sel11 = ($calconf['AdminType']=="radminnewsletter") ? "selected" : "";
		$sel12 = ($calconf['AdminType']=="radminforum")      ? "selected" : "";
		$sel13 = ($calconf['AdminType']=="radmincontent")    ? "selected" : "";
		$sel14 = ($calconf['AdminType']=="radminency")       ? "selected" : "";
		$sel15 = ($calconf['AdminType']=="radminsuper")      ? "selected" : "";
		#if (isset($radmins["radmincalendar"])) $sel17 = ($calconf['AdminType']=="radmincalendar") ? "selected" : "";
		echo "<tr valign=\"top\"><td>"._CALADMINTYPE."</td><td>";
		echo "<select name=\"xcalAdminType\">";
		#if (isset($radmins["radmincalendar"])) echo "<option value=\"radmincalendar\" $sel17>"._CALNAME."</option>\n";
		echo "<option value=\"radminarticle\" $sel1>"._ARTICLES."</option>\n";
		echo "<option value=\"radmintopic\" $sel2>"._TOPICS."</option>\n";
		echo "<option value=\"radminuser\" $sel3>"._USERS."</option>\n";
		echo "<option value=\"radminsurvey\" $sel4>"._SURVEYS."</option>\n";
		echo "<option value=\"radminsection\" $sel5>"._SECTIONS."</option>\n";
		echo "<option value=\"radminlink\" $sel6>"._WEBLINKS."</option>\n";
		echo "<option value=\"radminephem\" $sel7>"._EPHEMERIDS."</option>\n";
		echo "<option value=\"radminfaq\" $sel8>"._FAQ."</option>\n";
		echo "<option value=\"radmindownload\" $sel9>"._DOWNLOAD."</option>\n";
		echo "<option value=\"radminreviews\" $sel10>"._REVIEWS."</option>\n";
		echo "<option value=\"radminnewsletter\" $sel11>"._NEWSLETTER."</option>\n";
		echo "<option value=\"radminforum\" $sel12>"._BBFORUM."</option>\n";
		echo "<option value=\"radmincontent\" $sel13>"._CONTENT."</option>\n";
		echo "<option value=\"radminency\" $sel14>"._ENCYCLOPEDIA."</option>\n";
		echo "<option value=\"radminsuper\" $sel15>"._SUPERUSER."</option>\n";
		echo "</select>";
		echo "</td></tr>\n";
		}
	$sel1 = (!empty($calconf['AdminEditAll'])) ? "checked" : "";
	$sel2 = (empty($calconf['AdminEditAll'])) ? "checked" : "";
	echo "<tr valign=\"top\"><td>"._CALADMINEDITALL."</td><td>"
	."<input type=\"radio\" name=\"xcalAdminEditAll\" value=\"1\" $sel1>"._CALYES." &nbsp;"
	."<input type=\"radio\" name=\"xcalAdminEditAll\" value=\"0\" $sel2>"._CALNO
	."</td></tr>\n";
	
	$sel1 = (!empty($calconf['allowuserpost'])) ? "checked" : "";
	$sel2 = (empty($calconf['allowuserpost']))  ? "checked" : "";
	echo "<tr valign=\"top\"><td>"._CALPOSTUSERS."</td><td>"
	."<input type=\"radio\" name=\"xallowuserpost\" value=\"1\" $sel1>"._CALYES." &nbsp;"
	."<input type=\"radio\" name=\"xallowuserpost\" value=\"0\" $sel2>"._CALNO
	."</td></tr>\n";
	
	$sel1 = (!empty($calconf['userautoactive'])) ? "checked" : "";
	$sel2 = (empty($calconf['userautoactive']))  ? "checked" : "";
	echo "<tr valign=\"top\"><td>"._CALUSERSAUTOPOST."</td><td>"
	."<input type=\"radio\" name=\"xuserautoactive\" value=\"1\" $sel1>"._CALYES." &nbsp;"
	."<input type=\"radio\" name=\"xuserautoactive\" value=\"0\" $sel2>"._CALNO
	."</td></tr>\n";
	
	$sel1 = (!empty($calconf['allowanonpost'])) ? "checked" : "";
	$sel2 = (empty($calconf['allowanonpost']))  ? "checked" : "";
	echo "<tr valign=\"top\"><td>"._CALPOSTANONYMOUS."</td><td>"
	."<input type=\"radio\" name=\"xallowanonpost\" value=\"1\" $sel1>"._CALYES." &nbsp;"
	."<input type=\"radio\" name=\"xallowanonpost\" value=\"0\" $sel2>"._CALNO
	."</td></tr>\n";
	
	$sel1 = (!empty($calconf['anonautoactive'])) ? "checked" : "";
	$sel2 = (empty($calconf['anonautoactive']))  ? "checked" : "";
	echo "<tr valign=\"top\"><td>"._CALANONYAUTOPOST."</td><td>"
	."<input type=\"radio\" name=\"xanonautoactive\" value=\"1\" $sel1>"._CALYES." &nbsp;"
	."<input type=\"radio\" name=\"xanonautoactive\" value=\"0\" $sel2>"._CALNO
	."</td></tr>\n";
	
	$sel1 = (!empty($calconf['allowaddarticle'])) ? "checked" : "";
	$sel2 = (empty($calconf['allowaddarticle'])) ? "checked" : "";
	echo "<tr valign=\"top\"><td>"._CALADDARTICLEBOX."</td><td>"
	."<input type=\"radio\" name=\"xcalallowaddarticle\" value=\"1\" $sel1>"._CALYES." &nbsp;"
	."<input type=\"radio\" name=\"xcalallowaddarticle\" value=\"0\" $sel2>"._CALNO
	."</td></tr>\n";
	
	$sel0 = (empty($calconf['usetopics'])) ? "selected" : "";
	$sel1 = ($calconf['usetopics']==1)     ? "selected" : "";
	$sel2 = ($calconf['usetopics']==2)     ? "selected" : "";
	echo "<tr valign=\"top\"><td>"._CALUSETOPICS."</td><td>"
	."<select name=\"xcalusetopics\">"
	."<option value=\"0\" $sel0>"._CALNO."</option>\n"
	."<option value=\"1\" $sel1>"._CALUSETOPICS1."</option>\n"
	."<option value=\"2\" $sel2>"._CALUSETOPICS2."</option>\n"
	."</select>"
	."</td></tr>\n";
	
	echo "<tr valign=\"top\"><td>"._CALMINUTERANGE.":</td><td><input type=\"text\" name=\"xcalminuterange\" value=\"".$calconf['minuterange']."\" size=\"4\"></td></tr>\n";
	
	$sel1 = (!empty($index)) ? "checked" : "";
	$sel2 = (empty($index)) ? "checked" : "";
	echo "<tr valign=\"top\"><td>"._CALINDEX."?</td><td>"
	."<input type=\"radio\" name=\"xindex\" value=\"1\" $sel1>"._CALYES." &nbsp;"
	."<input type=\"radio\" name=\"xindex\" value=\"0\" $sel2>"._CALNO
	."</td></tr>\n";
	
	$sel1 = ($calconf['defaultview']=="list")  ? "selected" : "";
	$sel2 = ($calconf['defaultview']=="month") ? "selected" : "";
	$sel3 = ($calconf['defaultview']=="day")  ? "selected" : "";
	$sel4 = ($calconf['defaultview']=="year") ? "selected" : "";
	echo "<tr valign=\"top\"><td>"._CALDEFAULTVIEW."</td><td>"
	."<select name=\"xcaldefaultview\">"
	."<option value=\"list\" $sel1>"._CALLISTLINK."</option>\n"
	."<option value=\"month\" $sel2>"._CALMONTHLINK."</option>\n"
	."<option value=\"day\" $sel3>"._CALDAYLINK."</option>\n"
	."<option value=\"year\" $sel4>"._CALYEARLINK."</option>\n"
	."</select>"
	."</td></tr>\n";
	
	$sel1 = (!empty($calconf['TextEvents'])) ? "checked" : "";
	$sel2 = (empty($calconf['TextEvents'])) ? "checked" : "";
	echo "<tr valign=\"top\"><td>"._CALTEXTEVENTS."</td><td>"
	."<input type=\"radio\" name=\"xcalTextEvents\" value=\"0\" $sel2>"._CALYES
	."<input type=\"radio\" name=\"xcalTextEvents\" value=\"1\" $sel1>"._CALNO." &nbsp;" // ACHTUNG, umgekehrt !!
	."</td></tr>\n";
	
	$sel1 = (!empty($calconf['ShowPopup'])) ? "checked" : "";
	$sel2 = (empty($calconf['ShowPopup'])) ? "checked" : "";
	echo "<tr valign=\"top\"><td>"._CALSHOWPOPS."</td><td>"
	."<input type=\"radio\" name=\"xShowPopup\" value=\"1\" $sel1>"._CALYES
	."<input type=\"radio\" name=\"xShowPopup\" value=\"0\" $sel2>"._CALNO." &nbsp;"
	."</td></tr>\n";
	
	$calconf['catListCols'] = (empty($calconf['catListCols'])) ? 6 : (int)$calconf['catListCols'];
	echo "<tr valign=\"top\"><td>"._CALMENUROWS.":</td><td><input type=\"text\" name=\"xcatListCols\" value=\"".$calconf['catListCols']."\" size=\"4\"><font class=\"tiny\"> "._CALMENUROWS2."</font></td></tr>\n";

	/**** Specific List-View config variables */
	$calconf['listcount'] = (empty($calconf['listcount'])) ? 20 : (int)$calconf['listcount'];
	echo "<tr valign=\"top\"><td>"._CALLISTCOUNT.":</td><td><input type=\"text\" name=\"xcallistcount\" value=\"".$calconf['listcount']."\" size=\"4\"></td></tr>\n";
	
	$sel1 = (!empty($calconf['listStarttime'])) ? "checked" : "";
	$sel2 = (empty($calconf['listStarttime'])) ? "checked" : "";
	echo "<tr valign=\"top\"><td>"._CALLISTSHOWSTART."</td><td>"
	."<input type=\"radio\" name=\"xcallistStarttime\" value=\"1\" $sel1>"._CALYES." &nbsp;"
	."<input type=\"radio\" name=\"xcallistStarttime\" value=\"0\" $sel2>"._CALNO
	."</td></tr>\n";
	
	$sel1 = (!empty($calconf['listEnddate'])) ? "checked" : "";
	$sel2 = (empty($calconf['listEnddate'])) ? "checked" : "";
	echo "<tr valign=\"top\"><td>"._CALLISTENDDATE."</td><td>"
	."<input type=\"radio\" name=\"xcallistEnddate\" value=\"1\" $sel1>"._CALYES." &nbsp;"
	."<input type=\"radio\" name=\"xcallistEnddate\" value=\"0\" $sel2>"._CALNO
	."</td></tr>\n";
	
	$sel1 = (!empty($calconf['listEndtime'])) ? "checked" : "";
	$sel2 = (empty($calconf['listEndtime'])) ? "checked" : "";
	echo "<tr valign=\"top\"><td>"._CALLISTENDTIME."</td><td>"
	."<input type=\"radio\" name=\"xcallistEndtime\" value=\"1\" $sel1>"._CALYES." &nbsp;"
	."<input type=\"radio\" name=\"xcallistEndtime\" value=\"0\" $sel2>"._CALNO
	."&nbsp; "._CALONLYWEN."</td></tr>\n";
	
	$sel1 = (!empty($calconf['listEnddate2'])) ? "checked" : "";
	$sel2 = (empty($calconf['listEnddate2'])) ? "checked" : "";
	echo "<tr valign=\"top\"><td>"._CALLISTENDDATE2."</td><td>"
	."<input type=\"radio\" name=\"xcallistEnddate2\" value=\"1\" $sel1>"._CALYES." &nbsp;"
	."<input type=\"radio\" name=\"xcallistEnddate2\" value=\"0\" $sel2>"._CALNO
	."&nbsp; "._CALONLYWEN."</td></tr>\n";
	
	$sel1 = (!empty($calconf['listBrTime'])) ? "checked" : "";
	$sel2 = (empty($calconf['listBrTime'])) ? "checked" : "";
	echo "<tr valign=\"top\"><td>"._CALLISTBR."</td><td>"
	."<input type=\"radio\" name=\"xcallistBrTime\" value=\"1\" $sel1>"._CALYES." &nbsp;"
	."<input type=\"radio\" name=\"xcallistBrTime\" value=\"0\" $sel2>"._CALNO
	."</td></tr>\n";
	
	$sel1 = (!empty($calconf['showlinks'])) ? "checked" : "";
	$sel2 = (empty($calconf['showlinks'])) ? "checked" : "";
	echo "<tr valign=\"top\"><td>"._CALSHOWLINKS."</td><td>"
	."<input type=\"radio\" name=\"xshowlinks\" value=\"1\" $sel1>"._CALYES." &nbsp;"
	."<input type=\"radio\" name=\"xshowlinks\" value=\"0\" $sel2>"._CALNO
	."</td></tr>\n";
	
	$xcalTimeArray = implode(", ",$calconf['TimeArray']);
	echo "<tr valign=\"top\"><td>"._CALDAYTIMEARRAY."</td><td>"
	."<textarea cols=\"40\" rows=\"5\" name=\"xcalTimeArray\">$xcalTimeArray</textarea>"
	."</td></tr>\n";
	
	$xcalAllowableHTML = implode(", ",$calconf['AllowableHTML']);
	echo "<tr valign=\"top\"><td>"._CALALLOWABLEHTML."</td><td>"
	."<textarea cols=\"40\" rows=\"5\" name=\"xcalAllowableHTML\">$xcalAllowableHTML</textarea>"
	."</td></tr>\n";
	
	
	echo "</table>";
	echo "<blockquote><input type=\"submit\" value=\""._SAVECHANGES."\"></blockquote>";
	echo "</form>";
	echo "</center>";
	CloseTable();
	include ("footer.php");
	}

#################################################################################################
function CalendarConfigSave($pvs) {
	extract($pvs);
	$conffile = CAL_MODULE_PATH."config/config.php";
	include($conffile);
	$xindex              = (empty($xindex))              ? 0 : 1;
	$xcalTextEvents      = (empty($xcalTextEvents))      ? 0 : 1;
	$xShowPopup          = (empty($xShowPopup))          ? 0 : 1;
	$xcaldefaultview     = (empty($xcaldefaultview))     ? "list" : $xcaldefaultview ;
	$xcalminuterange     = (empty($xcalminuterange))     ? 5 : $xcalminuterange;
	$xcalusetopics       = (empty($xcalusetopics))       ? 0 : $xcalusetopics;
	$xcalallowaddarticle = (empty($xcalallowaddarticle)) ? 0 : 1;
	$xallowuserpost      = (empty($xallowuserpost))      ? 0 : 1;
	$xallowanonpost      = (empty($xallowanonpost))      ? 0 : 1;
	$xanonautoactive     = (empty($xanonautoactive))     ? 0 : 1;
	$xuserautoactive     = (empty($xuserautoactive))     ? 0 : 1;
	$xcalAdminEditAll    = (empty($xcalAdminEditAll))    ? 0 : 1;
	$xcalAdminMenu       = (empty($xcalAdminMenu))       ? 0 : 1;
	$xcallistcount       = (empty($xcallistcount))       ? 20 : $xcallistcount;
	$xcallistStarttime   = (empty($xcallistStarttime))   ? 0 : 1;
	$xcallistEnddate     = (empty($xcallistEnddate))     ? 0 : 1;
	$xcallistEndtime     = (empty($xcallistEndtime))     ? 0 : 1;
	$xcallistEnddate2    = (empty($xcallistEnddate2))    ? 0 : 1;
	$xcallistBrTime      = (empty($xcallistBrTime))      ? 0 : 1;
	$xcalshowlinks       = (empty($xcalshowlinks))       ? 0 : 1;
	$xcalTimeArray       = (empty($xcalTimeArray))       ? "" : $xcalTimeArray;
	$xcalAllowableHTML   = (empty($xcalAllowableHTML))   ? "" : $xcalAllowableHTML;
	$xcatListCols        = (empty($xcatListCols))        ? 6  : $xcatListCols;
	if (defined('MX_VERSION')) {
		$xcalAdminType       = (empty($xcalAdminType))     ? "radmincalendar" : $xcalAdminType;
		}
	else {
		$xcalAdminType       = (empty($xcalAdminType))     ? "radminarticle" : $xcalAdminType;
		}

	$ycalTimeArray = explode(",", $xcalTimeArray); 
	foreach ($ycalTimeArray as $word) {
		$xx = trim($word);
		if (!empty($xx)) {
			$words1[] = "\"".trim($word)."\"";
			}
		}
	$xcalTimeArray = "array(".implode(",",$words1).")";

	$ycalAllowableHTML = explode(",", $xcalAllowableHTML); 
	foreach ($ycalAllowableHTML as $word) {
		$xx = trim($word);
		if (!empty($xx)) {
			$words2[] = "\"".trim($word)."\"";
			}
		}
	$xcalAllowableHTML = "array(".implode(",",$words2).");";
	$content = "<?php // write with: \$Id: main.php,v 20.13 2004/01/08 22:43:48 EllselAn Exp $\n\n";
	$content .= "/************************************************************************/\n";
	$content .= "/* XCalender".CAL_VERSION."                                                      */\n";
	$content .= "/* ===================                                                  */\n";
	$content .= "/*  Calendar Module for vkpMx 2.x & phpNuke 5.5-7.0                     */\n";
	$content .= "/*  Copyright (c) 2004 by A.Ellsel (kalender@pragmamx.org)              */\n";
	$content .= "/*  Ported for Korean by Inhyun Choi (Inhyun.Choi@xybersystem.net)      */\n";
	$content .= "/*  http://www.pragmamx.org & http://ww.shiba-design.de                 */\n";
	$content .= "/*  http://www.xybersystem.net                                          */\n";
	$content .= "/************************************************************************/\n\n";
	$content .= "\$index = $xindex;\n";
	$content .= "\$calconf['defaultview'] = \"$xcaldefaultview\";\n";
	$content .= "\$calconf['minuterange'] = $xcalminuterange;\n";
	$content .= "\$calconf['usetopics'] = $xcalusetopics;\n";
	$content .= "\$calconf['allowaddarticle'] = $xcalallowaddarticle;\n";
	$content .= "\$calconf['allowuserpost'] = $xallowuserpost;\n";
	$content .= "\$calconf['userautoactive'] = $xuserautoactive;\n";
	$content .= "\$calconf['allowanonpost'] = $xallowanonpost;\n";
	$content .= "\$calconf['anonautoactive'] = $xanonautoactive;\n";
	$content .= "\$calconf['AdminEditAll'] = $xcalAdminEditAll;\n";
	$content .= "\$calconf['AdminMenu'] = $xcalAdminMenu;\n";
	$content .= "\$calconf['AdminType'] = \"$xcalAdminType\";\n";
	$content .= "/**** Allowable HTML tags in events description */\n";
	$content .= "\$calconf['AllowableHTML'] = $xcalAllowableHTML\n";
	$content .= "/**** Specific List-View config variables */\n";
	$content .= "\$calconf['listcount'] = $xcallistcount;\n";
	$content .= "\$calconf['listStarttime'] = $xcallistStarttime;\n";
	$content .= "\$calconf['listEnddate'] = $xcallistEnddate;\n";
	$content .= "\$calconf['listEndtime'] = $xcallistEndtime;\n";
	$content .= "\$calconf['listEnddate2'] = $xcallistEnddate2;\n";
	$content .= "\$calconf['listBrTime'] = $xcallistBrTime;\n";
	$content .= "\$calconf['catListCols'] = $xcatListCols;\n";
	$content .= "/**** Specific Month-View config variables */\n";
	$content .= "\$calconf['TextEvents'] = $xcalTextEvents;\n";
	$content .= "\$calconf['ShowPopup'] = $xShowPopup;\n";
	$content .= "/**** Specific Day-View config variables */\n";
	$content .= "\$calconf['TimeArray'] = $xcalTimeArray;\n";
	$content .= "\$calconf['showlinks'] = $xcalshowlinks;\n";
	$content .= "\n/************************************************************************/\n";
	$content .= "// DONT CHANGE ANYTHING BEHIND THIS LINE!!!!!\n";
	$content .= "if (!defined('CAL_MODULE_NAME')) die (\"     ϴ\");\n";
	$content .= "?>";
	#mxDebugFuncVars($content);
	#exit;
	@chmod($conffile, 0666);
	$file = fopen($conffile, "w");
	$ok = fwrite($file, $content);
	fclose($file);
	@chmod($conffile, 0444);
	$ok = (int)$ok + 1;
	#print $ok; exit;
	Header("Location: admin.php?op=CalendarConfig&ok=$ok");
	}

/********************************************************/
if (empty($addasarticle)) $addasarticle=0;
if (empty($op)) $op="CalendarAdmin";
switch($op) {
case "errFalsePath":
	die ("<h2>Error!</h2><h5>You must change the constant '\"CAL_MODULE_NAME\"' in file: </h5><p>".__file__."</p>");
	break;
case "errNoAuthorized":
	calErrAdminMsg("<b>"._CALNOTAUTHORIZED3."</b><br><br>"._GOBACK."<br>");
	break;
case "CalendarPreviewEvent":
	CalendarPreviewEvent($_POST);
	break;
case "CalendarPostEvent":
	CalendarPostEvent($_POST);
	break;
case "CalendarEditEvent":
	CalendarEditEvent($eid);
	break;
case "CalendarDeleteEvent":
	if (empty($ok)) $ok=0;
	CalendarDeleteEvent($eid, $ok);
	break;
case "CalendarDeactivateEvent":
	CalendarDeactivateEvent($eid);
	break;
case "CalendarConfig":
	if (empty($ok)) $ok = 0;
	CalendarConfig($ok);
	break;
case "CalendarConfigSave":
	CalendarConfigSave($_POST);
	break;
case "CalendarAdmin":
	CalendarSubmissions();
	break;
}

/* CVS-Log:
$Log: main.php,v $
Revision 20.13  2004/01/08 22:43:48  EllselAn
popups zum abschalten

Revision 20.12  2004/01/07 22:10:22  EllselAn
weitere Pfadanpassungen und Konstanten umgelagert

Revision 20.11  2004/01/06 23:14:58  EllselAn
Pfade angepasst

Revision 20.10  2004/01/06 21:29:51  EllselAn
falsche revisionsnummer

Revision 1.1  2004/01/06 21:27:45  EllselAn
verschoben admin.inc.php

Revision 20.10  2004/01/05 22:32:39  EllselAn
kleinere Anpassungen

Revision 20.9  2004/01/05 14:16:12  EllselAn
kompatibil. mit original-Nuke verbessert

Revision 20.8  2004/01/04 00:37:30  EllselAn
zustzliche Optionen

Revision 20.7  2004/01/03 22:58:29  EllselAn
calendar.php umbenannt und verschoben

Revision 20.6  2003/11/16 19:37:49  EllselAn
Versionsnummer...

Revision 20.5  2003/11/16 19:34:33  EllselAn
Versionsnummer...

Revision 20.4  2003/11/16 19:31:38  EllselAn
Versionsnummer...

Revision 20.3  2003/11/16 19:19:35  EllselAn
Kalender etwas berarbeitet,
neuer Header, da neuer Name
kleine Fehler gefixt

Revision 20.2  2003/09/01 14:49:24  EllselAn
function join() / implode() falsch verwendet


 */

?>