<?php // $Id: functions.php,v 20.17 2004/01/11 15:12:26 EllselAn Exp $
/************************************************************************/
/* KalenderMx v1.3                                                      */
/* ===================                                                  */
/*  Calendar Module for vkpMx 2.x & phpNuke 5.5-7.0                     */
/*  Copyright (c) 2004 by A.Ellsel (kalender@pragmamx.org)              */
/*  http://www.pragmamx.org & http://ww.shiba-design.de                 */
/* -------------------------------------------------------------------- */
/* KalenderMx is based on EventCalendar 2.0                             */
/*  Copyright (c) 2001 Originally by Rob Sutton                         */
/*  http://smart.xnettech.net (Nuke Site)                               */
/*  Development continued by Aleks A.-Lessmann                          */
/* Included some ideas and changes by:                                  */
/*  flobee, bulli-frank, kicks, kochloeffel, FrankySz, Jubilee          */
/* -------------------------------------------------------------------- */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 or a newer version.   */
/************************************************************************/
if (!defined("CAL_MODULE_NAME")) die ("     ϴ.");

#if (@file_exists(CAL_MODULE_PATH."includes/temp.php")) include_once(CAL_MODULE_PATH."includes/temp.php");

#########################################################################################
// Tabellendefinitionen zum Aendern bei Mehrfachgebrauch des Modules
if (!defined("CAL_TABLE_EVENTS"))     define("CAL_TABLE_EVENTS",     $GLOBALS["prefix"]."_events");
if (!defined("CAL_TABLE_MX_TOPICS"))  define("CAL_TABLE_MX_TOPICS",  $GLOBALS["prefix"]."_topics");
if (!defined("CAL_TABLE_MX_QUEUE"))   define("CAL_TABLE_MX_QUEUE",   $GLOBALS["prefix"]."_queue");
if (!defined("CAL_TABLE_MX_AUTHORS")) define("CAL_TABLE_MX_AUTHORS", $GLOBALS["prefix"]."_authors");
if (!defined("CAL_TABLE_MX_USERS"))   define("CAL_TABLE_MX_USERS",   $GLOBALS["user_prefix"]."_users");

#########################################################################################
function calDetectVersion() {
	static $version;
	if (isset($version)) return $version;
	if (defined('MX_VERSION')) {
		$version = "mx";
		}
	else {
		global $dbi;
		$result = sql_query("SHOW COLUMNS FROM `".CAL_TABLE_MX_USERS."`", $dbi);
		while (list($fieldname)=sql_fetch_row($result, $dbi)){
			$fields[$fieldname] = 1;
			}
		if (isset($fields['uid']) && isset($fields['uname']) && isset($fields['email'])) {
			$version = "55";
			}
		else {
			$version = "65";
			}
		}
	return $version;
	}

#########################################################################################
// weitere Moduldefinitionen
if (!defined("CAL_VERSION"))          define("CAL_VERSION","1.3");
if (!defined("CAL_MODULE_LINK"))      define("CAL_MODULE_LINK","modules.php?name=".CAL_MODULE_NAME);
if (!defined("CAL_IMAGE_PATH"))       define("CAL_IMAGE_PATH",CAL_MODULE_PATH."images/");
if (!defined("CAL_CMS_VERSION"))      define("CAL_CMS_VERSION",calDetectVersion());

switch(CAL_CMS_VERSION) {
	case "mx";
		define("CAL_MOD_USERINFO","modules.php?name=Userinfo&uname=");
		define("CAL_MOD_TOPICSEARCH","modules.php?name=News&new_topic=");
		break;
	case "55";
		define("CAL_MOD_USERINFO","modules.php?name=Your_Account&op=userinfo&uname=");
		define("CAL_MOD_TOPICSEARCH","modules.php?name=Search&topic=");
		break;
	case "65";
		define("CAL_MOD_USERINFO","modules.php?name=Your_Account&op=userinfo&username=");
		define("CAL_MOD_TOPICSEARCH","modules.php?name=Search&topic=");
		break;
	}
define("CAL_MOD_USERLOGIN","modules.php?name=Your_Account");

#########################################################################################
function calGetEventDates($event){
	setlocale (LC_TIME, _CALLOCALE);
	
	if (empty($event["startTime"])) {
		$event["startAmPm"] = "AM";
		}
	else {
		$startTime      = calGetTime($event["startTime"]); 	# "$hour:$min $ampm" oder "$hour:$min:00"
		$arrtmp         = explode(" ",$startTime);
		$event["startAmPm"] = (isset($arrtmp[1])) ? $arrtmp[1] : "";
		}
	
	if (isset($event["startHour"]) && isset($event["startMin"])) {
		$event["startTime"] = sprintf ("%02d:%02d:00", $event["startHour"], $event["startMin"]);
		}
	else {
		$arrstartTime   = explode(":",$event["startTime"]);
		$event["startHour"] = (empty($arrstartTime[0])) ? "00" : $arrstartTime[0];
		$event["startMin"]  = (empty($arrstartTime[1])) ? "00" : $arrstartTime[1];
		}
	
	if (isset($event["startYear"]) && isset($event["startMonth"]) && isset($event["startDay"])) {
		$event["startDate"] = sprintf ("%04d-%02d-%02d", $event["startYear"], $event["startMonth"], $event["startDay"]);
		}
	else {
		$arrdateStart    = explode("-",$event["startDate"]);
		$event["startYear"]  = $arrdateStart[0];
		$event["startMonth"] = $arrdateStart[1];
		$event["startDay"]   = $arrdateStart[2];
		}

	$event["startTimestamp"]    = mktime($event["startHour"], $event["startMin"], 0, $event["startMonth"], $event["startDay"], $event["startYear"]);
	$event["startDateShort"]     = strftime(_CALSHORTDATEFORMAT, $event["startTimestamp"]);
	$event["startDateLong"]     = strftime(_CALLONGDATEFORMAT, $event["startTimestamp"]);
	$event["startTimeFormat"]   = strftime(_CALTIMEFORMAT, $event["startTimestamp"]);
	$event["startDateListLink"] = "m=".$event["startMonth"]."&d=".$event["startDay"]."&y=".$event["startYear"]."";

	if (empty($event["endTime"])) {
		$event["endAmPm"] = "AM";
		}
	else {
		$endTime      = calGetTime($event["endTime"]); 			# "$hour:$min $ampm" oder "$hour:$min:00"
		$arrtmp       = explode(" ",$endTime);
		$event["endAmPm"] = (isset($arrtmp[1])) ? $arrtmp[1] : "";
		}

	if (isset($event["endHour"]) && isset($event["endMin"])) {
		$event["endTime"] = sprintf ("%02d:%02d:00", $event["endHour"], $event["endMin"]);
		}
	else {
		$arrendTime   = explode(":",$event["endTime"]);
		$event["endHour"] = (empty($arrendTime[0])) ? "00" : $arrendTime[0];
		$event["endMin"]  = (empty($arrendTime[1])) ? "00" : $arrendTime[1];
		}

	if (isset($event["endYear"]) && isset($event["endMonth"]) && isset($event["endDay"])) {
		$event["endDate"] = sprintf ("%04d-%02d-%02d", $event["endYear"], $event["endMonth"], $event["endDay"]);
		}
	else {
		$arrdateend    = explode("-",$event["endDate"]);
		$event["endYear"]  = $arrdateend[0];
		$event["endMonth"] = $arrdateend[1];
		$event["endDay"]   = $arrdateend[2];
		}

	$event["endTimestamp"]    = mktime($event["endHour"], $event["endMin"], 0, $event["endMonth"], $event["endDay"], $event["endYear"]);
	$event["endDateShort"]    = strftime(_CALSHORTDATEFORMAT, $event["endTimestamp"]);
	$event["endDateLong"]     = strftime(_CALLONGDATEFORMAT, $event["endTimestamp"]);
	$event["endTimeFormat"]   = strftime(_CALTIMEFORMAT, $event["endTimestamp"]);
	$event["endDateListLink"] = "m=".$event["endMonth"]."&d=".$event["endDay"]."&y=".$event["endYear"]."";
	
	if (empty($event["posteddate"])){
		$event["posteddate"] = sprintf ("%04d-%02d-%02d %02d:%02d:00", Date("Y"), Date("m"), Date("d"), Date("H"), Date("i"));
		$event["postDateShort"] = strftime(_CALSHORTDATEFORMAT, time());
		}
	else {
		$xpdate = explode(" ", $event["posteddate"]); 			# Zeit u. Datum trennen
		$pdate = explode("-",$xpdate[0]);
		$event["postDateShort"] = strftime(_CALSHORTDATEFORMAT, mktime(0, 0, 0, $pdate[1], $pdate[2], $pdate[0]));
		}

	setlocale (LC_TIME, $GLOBALS["locale"]);
	return $event;
	}

#########################################################################################
function calEventView($event){
	global $calconf, $dbi;
	global $bgcolor1,$bgcolor2,$bgcolor3,$textcolor1,$textcolor2;
	$eventsdates = calGetEventDates($event);
	$event = array_merge($event,$eventsdates);

	if (!empty($calconf['showlinks'])){
    $event["startDateLong"]="<a href=\"".CAL_MODULE_LINK."&op=day&".$event["startDateListLink"]."\">".$event["startDateLong"]."</a>";
		$event["endDateLong"]="<a href=\"".CAL_MODULE_LINK."&op=day&".$event["endDateListLink"]."\">".$event["endDateLong"]."</a>";
		}

	$event["informant"]   = (empty($event["informant"])) ? $GLOBALS["anonymous"] : $event["informant"];
	$event["alldayevent"] = (empty($event["alldayevent"])) ? 0 : 1;
	$event["categorie"] = calGetCurrentEventPoint($event["categorie"]);
	$categoriealt = calGetBarColorAlt($event["categorie"]);
	$event["title"] = strip_tags($event["title"]);
  if (empty($event["title"])) {$event["title"] = "<img src=\"".CAL_IMAGE_PATH."caution.gif\" alt=\"\" width=\"10\" height=\"21\" border=\"0\" align=\"absmiddle\" vspace=\"5\"> "._CALNOSUBJECT."";}
	$event["hometext"] = nl2br(strip_tags($event["hometext"],calGetAllowedtags()));
  $event["hometext"] = (empty($event["hometext"])) ? $event["title"] : $event["hometext"];
	if ($calconf['usetopics']>0){
		if (empty($event["topic"])) {
			if (calIsAdmin()){
				if ($event["eid"]){
					$topicimage="<a href=\"admin.php?op=CalendarEditEvent&eid=".$event["eid"]."\"><img src=\"".$GLOBALS["tipath"]."AllTopics.gif\" border=\"0\"><br><font class='tiny'><img src=\"".CAL_IMAGE_PATH."caution.gif\" alt=\"\" width=\"10\" height=\"21\" border=\"0\" align=\"absmiddle\" vspace=\"5\">"._CALSELECTTOPIC."!</font></a>";
					}
				else {
					$topicimage="<img src=\"".$GLOBALS["tipath"]."AllTopics.gif\" border=\"0\"><br><font class='tiny'><img src=\"".CAL_IMAGE_PATH."caution.gif\" alt=\"\" width=\"10\" height=\"21\" border=\"0\" align=\"absmiddle\" vspace=\"5\">"._CALSELECTTOPIC."</font>";
					}
				}
			else {
				$topicimage="<img src=\"".CAL_IMAGE_PATH."calendar.gif\" width=\"32\" height=\"32\" border=\"0\">";
				}
			}
		else {
		  $result = sql_query("select topicimage, topictext from ".CAL_TABLE_MX_TOPICS." where topicid=".$event["topic"]."", $dbi);
		  list($topicimage, $topictext) = sql_fetch_row($result, $dbi);
					$topicimage ="<a href=\"".CAL_MOD_TOPICSEARCH.$event["topic"]."\"><img src=\"".$GLOBALS["tipath"]."$topicimage\" border=\"0\" alt=\"$topictext\"></a>";
			}
		}
	else {
		$topicimage ="<img src=\"".CAL_IMAGE_PATH."calendar.gif\" width=\"32\" height=\"32\" border=\"0\">";
		}
	$colspan = ($event["alldayevent"]) ? "colspan=\"3\"" : "";
	$rowspan = ($event["startTimestamp"] == $event["endTimestamp"]) ? "rowspan=\"2\"" : "";
	
	OpenTable();
  echo "<center>";
	#echo "<table cellspacing=\"1\" cellpadding=\"3\" border=\"1\" width=\"90%\" bgcolor=\"$bgcolor3\">";
	echo "<table width=\"90%\" border=\"0\" cellspacing=\"1\" cellpadding=\"4\" bgcolor=\"$bgcolor1\">\n";
	echo "<tr valign=\"top\"><td align=\"center\" colspan=\"5\" bgcolor=\"$bgcolor2\"><br><font class=\"title\">".$event["title"]."</font><br><br></td></tr>";
	#echo "<tr bgcolor=\"$bgcolor2\"><td></td><td></td><td></td><td></td><td></td></tr>";
	echo "<tr valign=\"top\">";
	echo "<td nowrap bgcolor=\"$bgcolor2\" $rowspan><font class=\"content\"><b>"._CALEVENTDATETEXT."</b>:</font></td>";
	echo "<td nowrap bgcolor=\"$bgcolor3\" $colspan $rowspan><font class=\"content\">".$event["startDateLong"]."</font></td>";
	if (!$event["alldayevent"]) {
		echo "<td nowrap bgcolor=\"$bgcolor2\"><font class=\"content\"><b>"._CALSTARTTIME."</b>:</font></td>";
		echo "<td bgcolor=\"$bgcolor3\"><font class=\"content\">".$event["startTimeFormat"]."</font></td>";
		}
	echo "<td rowspan=\"4\" valign=\"top\" align=\"center\" bgcolor=\"$bgcolor2\">$topicimage</td></tr>";
	echo "<tr valign=\"top\">";
	if ($event["startTimestamp"] != $event["endTimestamp"]) {
		echo "<td bgcolor=\"$bgcolor2\"><font class=\"content\"><b>"._CALENDDATEPREVIEW."</b>:</font></td>";
		echo "<td nowrap bgcolor=\"$bgcolor3\" $colspan><font class=\"content\">".$event["endDateLong"]."</font></td>";
		}
	if (!$event["alldayevent"]) {
		echo "<td nowrap bgcolor=\"$bgcolor2\"><font class=\"content\"><b>"._CALENDTIME."</b>:</font></td>";
		echo "<td bgcolor=\"$bgcolor3\"><font class=\"content\">".$event["endTimeFormat"]."</font></td>";
		}
	echo "</tr>";
	echo "<tr valign=\"top\"><td bgcolor=\"$bgcolor2\"><font class=\"content\"><b>"._CALBARCOLORTEXT."</b>:</font></td><td colspan=\"3\" bgcolor=\"$bgcolor3\"><font class=\"content\"><img src=\"".calGetBarImage("ball", $event["categorie"])."\" align=\"absmiddle\" alt=\"$categoriealt\" title=\"$categoriealt\">&nbsp;&nbsp;&nbsp;<a href=\"".CAL_MODULE_LINK."&op=list&".$event["startDateListLink"]."&col=".$event["categorie"]."\">$categoriealt</a></font></td></tr>";
	echo "<tr valign=\"top\"><td bgcolor=\"$bgcolor2\"><font class=\"content\"><b>"._CALARTICLETEXT."</b>:</font></td><td colspan=\"3\" bgcolor=\"$bgcolor3\"><font class=\"content\">".$event["hometext"]."</font></td></tr>";
	
	echo "<tr valign=\"top\"><td nowrap colspan=\"5\" align=\"center\" bgcolor=\"$bgcolor2\"><font class=\"tiny\">";
	if (!empty($calconf['showlinks']) && $event["informant"]!=$GLOBALS["anonymous"]){
		echo ""._CALPOSTEDBY." <a href=\"".CAL_MOD_USERINFO.$event["informant"]."\"><font class=\"tiny\">".$event["informant"]."</font></a> "._CALPOSTEDON." ".$event["postDateShort"]." ";
		}
	else{
		echo ""._CALPOSTEDBY." ".$event["informant"]." "._CALPOSTEDON." ".$event["postDateShort"]." ";
		}
	if ($event["aid"] != $event["informant"] && $event["aid"]){
		echo ""._CALACCEPTEDBY." ".$event["aid"]."";
		}
	echo "</font>";
	echo "</td></tr>";
	echo "</table></center>";
	CloseTable();
	echo "<br>";
}

#########################################################################################
function calCheckEventData($event){
	global $calconf;
	$arrDateStart=explode("-",$event["startDate"]);
	$arrTimeStart=explode(":",$event["startTime"]);
	$event["startTime"]=calGetTimeFormat($arrTimeStart[0],$arrTimeStart[1],$event["startAmPm"]); # umrechnen von am/pm in 24 stunden
	$arrTimeStart=explode(":",$event["startTime"]);
	$arrDateEnd=explode("-",$event["endDate"]);
	$arrTimeEnd=explode(":",$event["endTime"]);
	$event["endTime"]=calGetTimeFormat($arrTimeEnd[0],$arrTimeEnd[1],$event["endAmPm"]); # umrechnen von am/pm in 24 stunden
	$arrTimeEnd=explode(":",$event["endTime"]);
	$msg="";
	if (!$event["title"]) {
	  $msg.=_CALVALIDSUBJECT; # Das Feld 'Betreff' ist zwingend notwendig.
		}
	if (!checkdate ($arrDateStart[1], $arrDateStart[2], $arrDateStart[0])) {
	  if ($msg) $msg.="<br>";
		$msg.= _CALVALIDEVENTDATE; #Das 'Enddatum' hat einen ungltigen Eintrag.
		}
	if (!checkdate ($arrDateEnd[1], $arrDateEnd[2], $arrDateEnd[0])) {
	  if ($msg) $msg.="<br>";
	  $msg.= _CALVALIDENDDATE; # Das 'Enddatum' hat einen ungltigen Eintrag.
		}
	if ((mktime($arrTimeStart[0], $arrTimeStart[1], 00, $arrDateStart[1], $arrDateStart[2], $arrDateStart[0]) > mktime($arrTimeEnd[0], $arrTimeEnd[1], 00, $arrDateEnd[1], $arrDateEnd[2], $arrDateEnd[0]) && (!$event["alldayevent"]))) {
	  if ($msg) $msg.="<br>";
	  $msg.= _CALVALIDDATES; # Das 'Enddatum' muss nach oder gleich dem 'Termindatum' liegen.
		}
	if ((mktime(00, 00, 00, $arrDateEnd[1], $arrDateEnd[2], $arrDateEnd[0]) < mktime(00, 00, 00, $arrDateStart[1], $arrDateStart[2], $arrDateStart[0])) && $event["alldayevent"]) {
	  if ($msg) $msg.="<br>";
	  $msg.= _CALVALIDDATES; # Das 'Enddatum' muss nach oder gleich dem 'Termindatum' liegen.
		}
	if ($calconf['usetopics']>1 && !$event["topic"]){
	  if ($msg) $msg.="<br>";
	  $msg.=_CALVALIDTOPIC; # BITTE EIN THEMA AUSWHLEN!
		}
	return $msg;
	}

#########################################################################################
function calGetAllowedtags($entities=0){
	global $calconf;
	$allowedtags="";
	foreach($calconf['AllowableHTML'] as $varname => $val) {
		$allowedtags .= ($entities) ? "&nbsp;&lt;$val&gt;" : "<$val>";
		}
	return $allowedtags;
	}

#########################################################################################
function calBuildModusselectors($op, $tag, $monat, $jahr){
	global $index, $calconf, $col;
	if (calIsPrintView()) return;
	$printerlink = (isset($_ENV["REQUEST_URI"])) ? $_ENV["REQUEST_URI"]."&amp;cprint=1" : "";
	$reqfile = (isset($_REQUEST['file'])) ? $_REQUEST['file'] : "";
	$op = (empty($op)) ? $calconf['defaultview'] : $op;
	OpenTable();
	echo "<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"3\">
	<tr><td colspan=2><a name=\"caltop\">&nbsp;</a><b>"._CALJUMPTOTEXT."</b>:</td>";
	if (!$index){
		echo "<td width=\"10%\" rowspan=\"2\"><a href=\"".CAL_MODULE_LINK."&op=".$calconf['defaultview']."\"><img  src=\"".CAL_IMAGE_PATH."calendar.gif\" width=\"32\" height=\"32\" border=\"0\" alt=\""._CALLISTLINK."\" title=\""._CALLISTLINK."\"></a></td>\n";
		}
	echo "</tr><tr>
	<td width=\"30%\" nowrap>
	<form action=\"modules.php\" method=\"GET\" name=\"jump\">";
	if (_CALINTERNATIONALDATES) {
		echo calBuiltDaySelect("d",$tag); 
		echo calBuiltMonthSelect("m",$monat); 
		echo calBuiltYearSelect("y",$jahr);
		}
	else {
		echo calBuiltMonthSelect("m",$monat); 
		echo calBuiltDaySelect("d",$tag); 
		echo calBuiltYearSelect("y",$jahr);
		}
	echo "&nbsp;<select name=\"op\" onChange=\"location.href='".CAL_MODULE_LINK."&op=' + document.jump.op.options[document.jump.op.options.selectedIndex].value + '&m=' + document.jump.m.options[document.jump.m.options.selectedIndex].value + '&d=' + document.jump.d.options[document.jump.d.options.selectedIndex].value + '&y=' + document.jump.y.options[document.jump.y.options.selectedIndex].value;\">\n<!-- KalenderMx v".CAL_VERSION."  by shiba-design.de -->\n
	<option "; if ($op == "list"){ echo "SELECTED ";} echo "value=\"list\">"._CALLISTLINK."</option>\n
	<option "; if ($op == "day"){ echo "SELECTED ";} echo "value=\"day\">"._CALDAYLINK."</option>\n
	<option "; if ($op == "month"){ echo "SELECTED ";} echo "value=\"month\">"._CALMONTHLINK."</option>\n
	<option "; if ($op == "year"){ echo "SELECTED ";} echo "value=\"year\">"._CALYEARLINK."</option>\n
	</select>\n
	&nbsp;<input type=\"submit\" value=\""._CALJUMPBUTTON."\">
	<input type=\"hidden\" name=\"name\" value=\"".CAL_MODULE_NAME."\">
	<input type=\"hidden\" name=\"col\" value=\"$col\">
	</form></td>";
	if ($op == "view") {$op="day";}
	echo "<td width=\"60%\">
	<form action=\"modules.php\" method=\"GET\" name=\"jumptoday\">
	<input type=\"submit\" value=\""._CALTODAY."\">
	<input type=\"hidden\" name=\"name\" value=\"".CAL_MODULE_NAME."\">
	<input type=\"hidden\" name=\"d\" value=\"".Date("d")."\">
	<input type=\"hidden\" name=\"m\" value=\"".Date("m")."\">
	<input type=\"hidden\" name=\"y\" value=\"".Date("Y")."\">
	<input type=\"hidden\" name=\"op\" value=\"$op\">
	<input type=\"hidden\" name=\"col\" value=\"$col\">
	</form></td>\n</tr>\n";
	echo "<tr><td class='content'>";
	if (calIsPostAllowed()) echo "<a href=\"".CAL_MODULE_LINK."&file=submit&sd=$jahr-$monat-$tag\"><img src=\"".CAL_IMAGE_PATH."sign.gif\" alt=\""._CALSUBMITEVENT."\" width=\"16\" height=\"16\" border=\"0\" align=\"absmiddle\" hspace=\"5\">"._CALSUBMITEVENT."</a>";
	if (calIsAdmin()) echo "&nbsp;&nbsp;<a href=\"admin.php?op=CalendarAdmin\" title=\""._CALNEWSUBMISSIONS."\"><img src=\"".CAL_IMAGE_PATH."waiting.gif\" alt=\""._CALNEWSUBMISSIONS."\" width=\"16\" height=\"16\" border=\"0\" align=\"absmiddle\" hspace=\"5\">"._CALSUBMISSIONSADMIN."</a>";
	echo "&nbsp;</td><td colspan='2' align='right' class='content'>";
	if ($printerlink && $reqfile != 'submit') {
		echo "<a href='".$printerlink."' target='calprintwin' onClick=\"window.open('".$printerlink."','calprintwin','left=10, top=10, width=640,height=480,toolbar=1,location=0,directories=0,status=1,menubar=1,scrollbars=1,resizable=1,copyhistory=0'); return false;\">";
		echo "<img src='".CAL_IMAGE_PATH."print.gif' alt='"._CALPRINTER1."' width='17' height='16' hspace='5' border='0' align='absmiddle' title='"._CALPRINTER2."'>"._CALPRINTER1."";
		echo "</a>";
		}
	echo "</td>";
	echo "</tr></table>";
	CloseTable();
	}

#########################################################################################
function calGetTimeFormat($hour,$min,$ampm) {
	if (!_CALTIME24HOUR) {
	  if (($ampm == "AM") & ($hour == "12")) {
	    $hour = "00";
	  	}
		elseif (($ampm == "PM") & ($hour != "12")) {
	    $hour = 12 + $hour;
	  	}
		}
  $time = "$hour:$min:00";
  return $time;
}

#########################################################################################
function calGetTime($time) {
	#print "<b>time: $time</b>";
	if (_CALTIME24HOUR) {
	  $time_Array = explode(":",$time);
	  if (isset($time_Array[0]) && isset($time_Array[1])){
			$time = $time_Array[0].":".$time_Array[1];
			}
		}
	else {
	  $time_Array = explode(":",$time);
	  $min = $time_Array[1];
	  if ($time_Array[0] == "00" || $time_Array[0] == "0") {
	    $hour = "12";
	    $ampm = "AM";
		  }
		elseif ($time_Array[0] == "12") {
	    $hour = "12";
	    $ampm = "PM";
		  }
		elseif ($time_Array[0] > 12) {
	    $hour = $time_Array[0] - 12;
	    $ampm = "PM";
		  }
		else {
	    if ($time_Array[0] < 10)
	      $hour = substr($time_Array[0],1,1);
	    else
	      $hour = $time_Array[0];
		    $ampm = "AM";
			  }
		  $time = "$hour:$min $ampm";
			}
	  return $time;
	}

#########################################################################################
function calIsAdmin() {
	global $dbi, $calconf;
	static $admintest;
	if (!isset($admintest)) {
		if (!isset($calconf)) {
			include(CAL_MODULE_PATH."config/config.php");
			}
		if (function_exists('mxGetAdminData')) {
			$adata = mxGetAdminData();
			$admintest = (empty($adata[$calconf['AdminType']]) && empty($adata['radminsuper'])) ? 0 : $adata['aid'];
			}
		else if (isset($_COOKIE['admin'])) {
			if ($calconf['AdminType'] == 'radmincalendar') { // falls Grundeinstellung von vkpMx
				$calconf['AdminType'] = 'radminsuper';
				}
			$xadmin = base64_decode($_COOKIE['admin']);
			$yadmin = explode(":", $xadmin);
			$xaid = (empty($yadmin[0])) ? "" : $yadmin[0];
			$xpwd = (empty($yadmin[1])) ? "" : $yadmin[1];
			if ($xaid && $xpwd) {
				$result = sql_query("select aid, pwd, ".$calconf['AdminType'].", radminsuper from ".CAL_TABLE_MX_AUTHORS." where aid='$xaid'", $dbi);
				list($aid, $pwd, $CalendarAdmin, $radminsuper) = sql_fetch_row($result, $dbi);
				$admintest = (($pwd == $xpwd && $pwd != "") && (($CalendarAdmin==1) || ($radminsuper==1))) ? $aid : 0;
				}
			else {
				$admintest = 0;
				}
			}
		else {
			$admintest = 0;
			}
		}
	return $admintest;
	}

#########################################################################################
function calGetBarColorAlt ($categorie) {
	static $lastcat, $caption;
	if ($categorie==$lastcat && isset($caption)) {
		return $caption;
		}
	$points = calGetEventpoints();
	$categorie = calGetCurrentEventPoint($categorie);
	$caption = $points[$categorie];
	return $caption;
	}

#########################################################################################
function calGetBarImage($picname, $categorie) {
	static $lastcat, $lastpic, $pic;
	if ($categorie==$lastcat && $picname==$lastpic && isset($pic)) {
		return $pic;
		}
	if (!is_numeric($categorie)) $categorie = calGetOldColors($categorie);
	$categorie = (int)$categorie;
	$xcategorie = ($categorie<10) ? "0$categorie" : "$categorie";
	$pic = "".CAL_IMAGE_PATH."colors/${picname}_${xcategorie}.gif";
	return $pic;
	}

#########################################################################################
// zur Abwaertskompatibilitaet, 
// ermittelt die neuen Zahlenwerte der alten Farbbuchstaben
function calGetOldColors($categorie='b'){
	if      ($categorie == "b") return 1;
	else if ($categorie == "c") return 2;
	else if ($categorie == "g") return 3;
	else if ($categorie == "o") return 4;
	else if ($categorie == "r") return 5;
	else if ($categorie == "u") return 6;
	else if ($categorie == "w") return 7;
	else if ($categorie == "y") return 8;
	else                        return 1;
	}

#########################################################################################
// zur Abwaertskompatibilitaet, 
// ermittelt die alten Farbbuchstaben der neuen Zahlenwerte
function calSetOldColors($categorie=0){
	if      ($categorie == 1) return "b";
	else if ($categorie == 2) return "c";
	else if ($categorie == 3) return "g";
	else if ($categorie == 4) return "o";
	else if ($categorie == 5) return "r";
	else if ($categorie == 6) return "u";
	else if ($categorie == 7) return "w";
	else if ($categorie == 8) return "y";
	else                      return "b";
	}

#########################################################################################
// gibt das Array zurueck welches in den Sprachfiles definiert ist
// nur die Schluessel mit Werten werden beruecksichtigt, der Index bleibt erhalten
function calGetEventpoints(){
	static $points;
	if (empty($points)) {
		global $caldotcolor;
		if (!isset($caldotcolor)) {
			$caldotcolor = calGetDotColors();
			}
		$points = array();
		foreach($caldotcolor as $index => $caption) {
			$caption=trim($caption);
			if (!empty($caption)) {
				$points[$index] = $caption;
				#print "\$points[$index] = $caption;<br>";
				}
			}
		asort($points);
		}
	return $points;
	}

#########################################################################################
function calGetSqlEventpoints($categorie=0){
	if ($categorie) {
		$categorie = (int)$categorie;
		$points[$categorie] = calGetCurrentEventPoint($categorie);
		}
	else {
		$points = calGetEventpoints();
		}
	foreach($points as $index => $caption) {
		$vari[] = $index;
		if ($index < 10) $vari[] = "0$index";
		if ($index<=8) {
			$vari[] = calSetOldColors($index);
			}
		}
	$xvari = "'".implode("','",$vari)."'";
	#$xvari = "'$xvari'";
	#print $xvari;
	return $xvari;
	}

#########################################################################################
// ermittelt den Index der ersten definierte Kategorie aus dem Sprachfile
function calGetFirstEventPoint(){
	static $firstpoint;
	if (empty($firstpoint)) {
		$points = calGetEventpoints();
		reset($points);
		$firstpoint = key($points);
		}
	return $firstpoint;
	}

#########################################################################################
// ermittelt den gueltigen Index des uebergebenen Farbwertes
function calGetCurrentEventPoint($categorie){
	static $lastcategorie;
	$categorie = (is_numeric($categorie)) ? $categorie : calGetOldColors($categorie);
	$categorie = (int)$categorie;
	if (empty($lastcategorie) || empty($categorie) || ($categorie != $lastcategorie)) {
		$points = calGetEventpoints();
		$points = array_flip($points);
		if (empty($categorie) || (!in_array ($categorie, $points))) {
			$categorie = calGetFirstEventPoint();
			}
		$lastcategorie = $categorie;
		}
	return $categorie;
	}

#########################################################################################
function calBuildColorLegend($modus,$showalldot=0,$showNewlink=0,$categorie="",$linkdate=""){ 
	global $calconf;
	#$showNewlink=1;
	$maxcols = (empty($calconf['catListCols'])) ? 6 : $calconf['catListCols'];
	$maxcols = ($modus=="form") ? $maxcols-1 : $maxcols;
	
	$eventpoints = calGetEventpoints();
	#print_r($eventpoints);
	$catcountall = count($eventpoints);
	if ($showalldot) $catcountall++;
	if ($showNewlink) $catcountall++;
	$catcount=0;
	$rowcount=1;
	$link = CAL_MODULE_LINK."&op=list$linkdate";
	$legend="\n<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n<tr valign=\"top\">";

	if ($showalldot && !calIsPrintView()){
		if ($catcount==$maxcols){
			$legend.="</tr>\n<tr valign=\"top\">";
			$catcount=0;
			}
		$catcount++;
		$imgprops= "align=\"absmiddle\" hspace=\"1\" width=\"16\" height=\"14\" border=\"0\" vspace=\"0\" alt=\""._CALDOTCOLORALL."\"";
		$legend.="<td nowrap><font class=\"tiny\">";
		if (empty($categorie)) {
			$legend.="<b><img src=\"".CAL_IMAGE_PATH."star.gif\" $imgprops>"._CALDOTCOLORALL."</b>";
			}
		else {
			$legend.="<a href=\"$link\"><img src=\"".CAL_IMAGE_PATH."star.gif\" $imgprops>"._CALDOTCOLORALL."</a>";
			}
		$legend.="</font></td>\n";
		}

	$imgprops= "hspace=\"4\" vspace=\"4\" width=\"9\" height=\"9\" border=\"0\" alt=\"\" align=\"absmiddle\"";
	foreach($eventpoints as $index => $caption) {
		$catcount++;
		$image = calGetBarImage("ball", $index);
		$legend.="<td nowrap><font class=\"tiny\">";
		
		if ($modus=="centerblock") {
			$legend.="<a href=\"$link&col=$index\"><img src=\"$image\" $imgprops>$caption</a>";
			}
		else if ($modus=="form") {
			$sel = ((int)$categorie==(int)$index) ? "CHECKED" : "";
			$legend.="<input type=\"radio\" $sel name=\"categorie\" value=\"$index\" style=\"background-color: transparent;\">&nbsp;<img src=\"$image\" $imgprops>$caption";
			}
		else {
			if ($index == $categorie) {
				$legend.="<img src=\"$image\" $imgprops><b>$caption</b>";
				}
			else {
				$legend.="<a href=\"$link&col=$index\"><img src=\"$image\" $imgprops>$caption</a>";
				} 
			}
		
		$legend.="</font></td>";
		if ($catcount==$maxcols){
			$legend.="</tr>\n<tr valign=\"top\">";
			$catcount=0;
			}
		}
	if ($showNewlink && calIsPostAllowed() && !calIsPrintView()) {
		if ($catcount==$maxcols){
			$legend.="</tr>\n<tr valign=\"top\">";
			$catcount=0;
			}
		$catcount++;
		$imgprops= "width=\"16\" height=\"16\" border=\"0\" align=\"absmiddle\" hspace=\"3\" vspace=\"0\" alt=\""._CALSUBMITEVENT."\"";
		$legend.="<td nowrap><font class=\"tiny\"><a href=\"".CAL_MODULE_LINK."&file=submit\"><img src=\"".CAL_IMAGE_PATH."sign.gif\" $imgprops>"._CALSUBMITEVENT."</a></font></td>\n";
		}
	$colspan = $maxcols - $catcount;
	if ($colspan && $colspan < $maxcols) {
		$legend.="<td colspan=\"$colspan\">&nbsp;</td>\n";
		}
	$legend.="</tr>\n</table>\n";
	return $legend;
	}

#########################################################################################
function calBuildColorLegendSideBlocks(){ 
	$link = CAL_MODULE_LINK."&op=list";
	$eventpoints = calGetEventpoints();
	$imgprops= "hspace=\"2\" width=\"9\" height=\"9\" border=\"0\" alt=\"\"";
	$legend="<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">";
	foreach($eventpoints as $index => $caption) {
		$image = calGetBarImage("ball", $index);
		$legend.="<tr><td><img src=\"$image\" $imgprops></td><td valign=\"top\"><font class=\"tiny\">";
		$legend.="<a href=\"$link&col=$index\">$caption</a>\n";
		$legend.="</font></td></tr>";
		}
	$legend.="</table>";
	return $legend;
	}

#########################################################################################
function calBuildTopicsSelect($topic) {
	global $dbi;
	$toplist = sql_query("select topicid, topictext from ".CAL_TABLE_MX_TOPICS." where topictext<>'' order by topictext", $dbi);
	$out = "\n<select name=\"topic\">\n<option value=\"\">"._CALSELECTTOPIC."</option>\n";
	while(list($topicid, $topics) = sql_fetch_row($toplist, $dbi)) {
    $sel = ($topicid==$topic) ? "SELECTED" : "";
		$out .= "<option value=\"$topicid\" $sel>".calPrepareDisplay($topics)."</option>\n";
		}
	$out .= "</select>\n";
	return $out;
	}

#########################################################################################
function calBuiltMonthSelect($name, $month) {
  $out = "<select name=\"$name\" id=\"$name\">\n";
  for ($i = 1; $i <= 12; $i++) {
    $sel = ($i == $month) ? "SELECTED" : "";
		$mname = calGetMonthName($i);
    $out .= "<option value=\"$i\" $sel>$mname</option>\n";
	  }
	$out .= "</select>&nbsp;\n";
	return $out;
	}

#########################################################################################
function calBuiltDaySelect($name, $day) {
  $out = "<select name=\"$name\" id=\"$name\">\n";
	for ($i = 1; $i <= 31; $i++) {
    $y = ($i<10) ? '0'.$i : $i;
		$sel = ($i == $day) ? "SELECTED " : "";
    $out .= "<option value=\"$i\" $sel>$y</option>\n";
	  }
	$out .= "</select>&nbsp;\n";
	return $out;
	}

#########################################################################################
function calBuiltYearSelect($name, $year) {
  $out = "<select name=\"$name\" id=\"$name\">\n";
  $yrange = (int)Date("Y");
	for ($i = $yrange-10; $i <= $yrange+30; $i++) {
    $sel = ($i == $year) ? "SELECTED " : "";
    $out .= "<option value=\"$i\" $sel>$i\n</option>\n";
	  }
	$out .= "</select>&nbsp;\n";
	return $out;
	}

#########################################################################################
function calBuildHourSelect($name, $hour) {
  $out = "<select name=\"$name\" id=\"$name\">\n";
	$range = (_CALTIME24HOUR) ? 23 : 12;
	for ($i = 0; $i <= $range; $i++) {
		$sel = ($i == $hour) ? "SELECTED " : "";
		$out .= "<option value=\"$i\" $sel>";
		if ($i<10) $out .= "0";
		$out .= "$i</option>\n";
		}
	$out .= "</select>&nbsp;\n";
	return $out;
	}

#########################################################################################
function calBuildMinuteSelect($name, $min) {
	global $calconf;
  $out = "<select name=\"$name\" id=\"$name\">\n";
  for ($i = 0; $i <= (60-$calconf['minuterange']);) {
    $sel = (($i == $min) | (($i == 0) & ($min == "00"))) ? "SELECTED " : "";
		if ($i == 0) {
			$out .= "<option value=\"00\" $sel>:00</option>\n";
			}
    else {
			$xi = ($i<10) ? "0" : "";
			$out .= "<option value=\"${xi}${i}\" $sel>:${xi}${i}</option>\n";
			}
    $i = $i + $calconf['minuterange'];
  	}
	$out .= "</select>&nbsp;\n";
	return $out;
	}

#########################################################################################
function calBuildAmPmSelect($name, $ampm="") {
  if (_CALTIME24HOUR) {
		$out = "<input type=\"hidden\" name=\"$name\" value=\"$ampm\">\n";
		}
	else {
	  $sel1 = ($ampm == "AM") ? "SELECTED" : "";
	  $sel2 = ($ampm != "AM") ? "SELECTED" : "";
		$out = "<select name=\"$name\" id=\"$name\">";
	  $out .= "<option value=\"AM\" $sel1>AM</option>\n";
	  $out .= "<option value=\"PM\" $sel2>PM</option>\n";
		$out .= "</select>&nbsp;\n";
		}
	return $out;
	}

#########################################################################################
function calGetMonthName($month) {
	$month = (int)$month;
	if     ($month == 1)  {	$monthname = _CALJAN;	}
	elseif ($month == 2)  {	$monthname = _CALFEB;	}
	elseif ($month == 3)  {	$monthname = _CALMAR;	}
	elseif ($month == 4)  {	$monthname = _CALAPR;	}
	elseif ($month == 5)  {	$monthname = _CALMAY;	}
	elseif ($month == 6)  {	$monthname = _CALJUN;	}
	elseif ($month == 7)  {	$monthname = _CALJUL;	}
	elseif ($month == 8)  {	$monthname = _CALAUG;	}
	elseif ($month == 9)  {	$monthname = _CALSEP;	}
	elseif ($month == 10) {	$monthname = _CALOCT;	}
	elseif ($month == 11) {	$monthname = _CALNOV;	}
	elseif ($month == 12) {	$monthname = _CALDEC;	}
	else                  {	$monthname = "";	}
	return $monthname;
	}

#########################################################################################
function calGetLongDayName($Date) {
	$day = (int)Date("w",$Date)-_CALWEEKBEGINN;
	if ($day<0) $day=6;
	if     ($day == 0) {$dayname = _CALLONGFIRSTDAY;}
	elseif ($day == 1) {$dayname = _CALLONGSECONDDAY;}
	elseif ($day == 2) {$dayname = _CALLONGTHIRDDAY;}
	elseif ($day == 3) {$dayname = _CALLONGFOURTHDAY;}
	elseif ($day == 4) {$dayname = _CALLONGFIFTHDAY;}
	elseif ($day == 5) {$dayname = _CALLONGSIXTHDAY;}
	elseif ($day == 6) {$dayname = _CALLONGSEVENTHDAY;}
	else               {$dayname = "";}
	return $dayname;
	}

#########################################################################################
function calIsPostAllowed(){
	global $calconf;
	static $oki;
	if (isset($oki)) return $oki;
	if (calIsAdmin()) {
		$oki = 1;
		return $oki;
		}
	$user = (isset($_COOKIE['user'])) ? $_COOKIE['user'] : "";
	if (is_user($user)) {
		$oki = ($calconf['allowuserpost']) ? 1 : 0;
		}
	else {
		$oki = ($calconf['allowanonpost']) ? 1 : 0;
		}
	return $oki;
	}

######################################################################################
function calGetDotColors($language="") {
	static $caldotcolor, $lastlang;
	#if (empty($caldotcolor) && ($language != $lastlang)) {
	if (empty($caldotcolor)) {
		$lastlang = $language;
		$caldotcolor = array();
		$language = (empty($language)) ? $GLOBALS['currentlang'] : $language;
		if (@file_exists(CAL_MODULE_PATH."categories/$language.php")) {	
			include(CAL_MODULE_PATH."categories/$language.php");
			}
		else {
			include(CAL_MODULE_PATH."categories/german.php");
			}
		}
	return $caldotcolor;
	}

#########################################################################################
function calGetUserData($uname){
	static $username, $userdat;
	if (empty($username) || $uname != $username) {
		global $dbi;
		$username = $uname; // statik!
		if (CAL_CMS_VERSION == '65') {
			$qry = "select user_id, user_email, username from ".CAL_TABLE_MX_USERS." where username='".$uname."'";
			}
		else {
			$qry = "select uid, email, uname from ".CAL_TABLE_MX_USERS." where uname='".$uname."'";
			}
		$result = sql_query($qry, $dbi);
		list($userdat["uid"], $userdat["email"], $userdat["uname"]) = sql_fetch_row($result, $dbi);
		}
	return $userdat;
	}

#########################################################################################
function calAddArticle($event){
	global $calconf, $dbi;
	$categoriealt = calGetBarColorAlt($event["categorie"]);
# die folgenden Zeilen formatieren den Artikeltext
	$story="<img src=\"".calGetBarImage("ball", $event["categorie"])."\" align=\"absmiddle\" alt=\"$categoriealt\" title=\"$categoriealt\">&nbsp;&nbsp;<a href=\"".CAL_MODULE_LINK."&".$event["startDateListLink"]."&col=".$event["categorie"]."\">$categoriealt</a>";
	$story.="\n"._CALEVENTDATETEXT.": <a href=\"".CAL_MODULE_LINK."&op=day&".$event["startDateListLink"]."\">".$event["startDateLong"]."</a>";
	if (!$event["alldayevent"]) {
		$story.="&nbsp;&nbsp;"._CALSTARTTIME.": ".$event["startTimeFormat"]."";
		}
	if ($event["startTimestamp"] != $event["endTimestamp"]) {
		$story.="\n"._CALENDDATEPREVIEW.": <a href=\"".CAL_MODULE_LINK."&op=day&".$event["endDateListLink"]."\">".$event["endDateLong"]."</a>";
		}
	if (!$event["alldayevent"]) {
		$story.="&nbsp;&nbsp;"._CALENDTIME.": ".$event["endTimeFormat"]."";
		}
  $story = calAddSlashes($story."\n").$event["hometext"];
# Ende der Formatierung
	$qry="INSERT INTO ".CAL_TABLE_MX_QUEUE." SET 
	uid       = ".$event["uid"].",
	uname     = '".$event["informant"]."',
	subject   = '".$event["title"]."',
	story     = '".$story."',
	timestamp = '".$event["posteddate"]."',
	topic     = ".$event["topic"]."
	;";
	$result = sql_query($qry, $dbi);
	}

#########################################################################################
function calErrmsg($text) {
	OpenTable();
	echo "<center><font class=\"content\"><img src=\"".CAL_IMAGE_PATH."caution.gif\" alt=\"\" width=\"10\" height=\"21\" border=\"0\" align=\"absmiddle\" vspace=\"5\">"._CALVALIDERRORMSG."<img src=\"".CAL_IMAGE_PATH."caution.gif\" alt=\"\" width=\"10\" height=\"21\" border=\"0\" align=\"absmiddle\" vspace=\"5\"><br>";
	echo "<b>$text</b><br>";
	echo "<br>"._CALVALIDFIXMSG."</font></center>";
	CloseTable();
	echo "<br>";
	}

#################################################################################################
function calErrAdminMsg($msg, $title="") {
	$title = (empty($title)) ? _CALSUBMISSIONSADMIN : $title;
	$GLOBALS["pagetitle"]= $title;
	if (empty($GLOBALS['header'])) include_once("header.php");
	if (calIsAdmin()) {
		calAdminMenu($title);
		}
	OpenTable();
	echo "<center>".$msg."<br><br>"._GOBACK."</center>";
	CloseTable();
	include ("footer.php");
	die();
	}

#########################################################################################
function calAdminMenu($thetitle){
	global $calconf;
	if ($calconf['AdminMenu'] && function_exists('GraphicAdmin')) {
		GraphicAdmin();
		}
	else {
		$part1[] = "<a href=\"admin.php\">"._CALADMINMENU."</a>";
		}
	$part1[] = "<a href=\"".CAL_MODULE_LINK."\">"._CALNAME."</a>";
	$part1[] = "<a href=\"".CAL_MODULE_LINK."&file=submit\">"._CALOK."</a>";
	$part2[] = "<a href=\"admin.php?op=CalendarAdmin\">"._CALSUBMISSIONSADMIN."</a>";
	$part2[] = "<a href=\"admin.php?op=CalendarConfig\">"._CALCALENDARCONFIG."</a>";
	$part2[] = "<a href=\"admin.php?op=CalSetcols\">"._CALCATEGORIESADMIN."</a>";
	OpenTable();
	echo "<center>\n<font class=\"title\">".$thetitle."</font><br><br>\n";
	echo "<table><tr><td align='center'>";
	echo implode(" | ",$part1);
	echo "</td></tr>\n<tr><td align='center'>";
	echo implode(" | ",$part2);
	echo "</td></tr></table>";
	echo "</center>";
	CloseTable();
	echo "<br>";
	}

#################################################################################################
function calDetectGoodBrowser () {
	static $good;
	if (isset($good)) return $good;
	$agent = strtolower(getenv("HTTP_USER_AGENT"));
	$good = 0;
	if (strpos($agent, "gecko")) 
		$good = 1;
	else if (strpos($agent, "msie") || strpos($agent, "explorer")) 
		$good = 1;
	else if (strpos($agent, "konqueror")) 
		$good = 1;
	/* 
	else if ((strpos($agent, "nav")) || (strpos($agent, "gold")) || (strpos($agent, "x11")) || (strpos($agent, "mozilla")) || (strpos($agent, "netscape")) AND (!strpos($agent, "msie") AND (!strpos($agent, "konqueror")))) 
		$good = 0;
	else if (strpos($agent, "lynx")) 
		$good = 0;
	else if (strpos($agent, "opera")) 
		$good = 0;
	else if (strpos($agent, "webtv")) 
		$good = 0;
	else if (strpos($agent, "konqueror")) 
		$good = 0;
	else if ((strpos($agent, "bot")) || (strpos($agent, "google")) || (strpos($agent, "slurp")) || (strpos($agent, "scooter")) || (strpos($agent, "spider")) || (strpos($agent, "infoseek"))) 
		$good = 0;
	 */
	return $good;
	}

#########################################################################################
function calValueToText($tmp) {
  $tmp = ereg_replace(10,"",$tmp);
  $tmp = ereg_replace(9,"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;",$tmp);
  $tmp = ereg_replace("<","&lt;",$tmp);
  $tmp = ereg_replace(">","&gt;",$tmp);
  $tmp = ereg_replace("\"","&quot;",$tmp);
  //$tmp = str_replace("\\","\\\\",$tmp);
  $tmp = ereg_replace("'","`",$tmp);
  #$tmp = ereg_replace(13,"<br>",$tmp);
  $tmp = ereg_replace(13," ",$tmp);
	$tmp=nl2br($tmp);
  return $tmp;
	}

#########################################################################################
function calGetSqlQuery($event, $mode) {
	$fields[] = "aid = '".$event["aid"]."'";
	$fields[] = "title = '".$event["title"]."'";
	$fields[] = "hometext = '".$event["hometext"]."'";
	$fields[] = "topic = ".$event["topic"]."";
	$fields[] = "informant = '".$event["informant"]."'";
	$fields[] = "startDate = '".$event["startDate"]."'";
	$fields[] = "endDate = '".$event["endDate"]."'";
	$fields[] = "startTime = '".$event["startTime"]."'";
	$fields[] = "endTime = '".$event["endTime"]."'";
	$fields[] = "alldayevent = ".$event["alldayevent"]."";
	$fields[] = "categorie = '".$event["categorie"]."'";
	$fields[] = "activ = ".$event["activ"]."";

	/// periodic
	#$fields[] = "rec_period = '".$event["rec_period"]."'";
	#$fields[] = "rec_type = '".$event["rec_type"]."'";
	/// periodic

	if ($mode == "insert") {
		$fields[] = "posteddate = '".$event["posteddate"]."'";
		$qry="INSERT INTO ".CAL_TABLE_EVENTS." SET ".implode(', ',$fields)."";
		}
	else {
		$qry="UPDATE ".CAL_TABLE_EVENTS." SET ".implode(', ',$fields)." WHERE eid = ".$event["eid"]."";
		}
	return $qry;
	}

#########################################################################################
function calPrepareEventForSql($event){
	global $dbi, $calconf;
	$event["categorie"] = calGetCurrentEventPoint($event["categorie"]);
	if (!empty($event["informant"])){
		$userdata = calGetUserData($event["informant"]);
		$event["informant"] = ($event["informant"] != $userdata["uname"]) ? "" : $userdata["uname"];
		$event["uid"]       = ($event["informant"] != $userdata["uname"]) ? 0  : $userdata["uid"];
		}
	$event["uid"]          = (empty($event["uid"]))          ? 0 : (int)$event["uid"];
	$event["aid"]          = (empty($event["aid"]))          ? calIsAdmin() : $event["aid"];
	$event["eid"]          = (empty($event["eid"]))          ? 0 : (int)$event["eid"];
	$event["addasarticle"] = (empty($event["addasarticle"])) ? 0 : (int)$event["addasarticle"];
	$event["topic"]        = (empty($event["topic"]))        ? 0 : (int)$event["topic"];
	$event["alldayevent"]  = (empty($event["alldayevent"]))  ? 0 : 1;
	$event["activ"]        = (empty($event["activ"]))        ? 0 : $event["activ"];
	/// periodic
	#$event["rec_period"] = (empty($event["rec_period"])) ? 0 : $event["rec_period"];
	#$event["rec_type"]   = (empty($event["rec_type"]) || empty($event["rec_period"])) ? "" : $event["rec_type"];
	/// periodic

	$eventsdates = calGetEventDates($event);
	$event = array_merge($event,$eventsdates);
	$errormsg = calCheckEventData($event);# Daten checken
	if ($errormsg) {
		$event = calStripSlashes($event);
		$GLOBALS["pagetitle"]=_CALSUBMITNAME;
		if (empty($GLOBALS['header'])) include_once("header.php");
		title(_CALSUBMITNAME);
		calErrmsg($errormsg);
		calSubmitForm($event);
		include("footer.php");
		die();
		}
	$event["title"]    = strip_tags($event["title"]);
	$event["hometext"] = strip_tags($event["hometext"],calGetAllowedtags());

	foreach($event as $varname => $value) {
		$event[$varname] = trim(calAddSlashes($value));
		}

	return $event;
	}

#########################################################################################
function calSubmitForm($event){
	global $user, $cookie, $dbi, $calconf;
	global $bgcolor1,$bgcolor2,$bgcolor3,$textcolor1,$textcolor2;

	$eventsdates = calGetEventDates($event);
	$event = array_merge($event,$eventsdates);

	$event["title"]     = strip_tags($event["title"]);
  $event["hometext"]  = strip_tags($event["hometext"], calGetAllowedtags());
	$event["categorie"] = calGetCurrentEventPoint($event["categorie"]);
	$event["eid"]       = (empty($event["eid"])) ? 0 : $event["eid"];
	$event["aid"]       = (empty($event["aid"])) ? calIsAdmin() : $event["aid"];
	#$event["informant"] = (empty($event["informant"])) ? $GLOBALS["anonymous"] : $event["informant"];
	$event["informant"] = (empty($event["informant"]) || $event["informant"]==$GLOBALS["anonymous"]) ? "" : $event["informant"]; // sicherstellen, dass informant nicht $GLOBALS["anonymous"]
	$event["posteddate"]= (empty($event["posteddate"])) ? 0 : $event["posteddate"];
	$checkalldayevent   = (empty($event["alldayevent"])) ? "" : "CHECKED";
	$checkaddarticle    = (empty($event["addasarticle"])) ? "" : "CHECKED";
	$namecaption        = (empty($event["eid"])) ? _CALYOURNAME : _CALNAMEFIELD;

	# build Start and End Event Select
	if (_CALINTERNATIONALDATES) {
		$eventstart  = calBuiltDaySelect("startDay",$event["startDay"]);
		$eventstart .= calBuiltMonthSelect("startMonth",$event["startMonth"]);
		$eventend    = calBuiltDaySelect("endDay",$event["endDay"]);
		$eventend   .= calBuiltMonthSelect("endMonth",$event["endMonth"]);
		}
	else {
		$eventstart  = calBuiltMonthSelect("startMonth",$event["startMonth"]);
		$eventstart .= calBuiltDaySelect("startDay",$event["startDay"]);
		$eventend    = calBuiltMonthSelect("endMonth",$event["endMonth"]);
		$eventend   .= calBuiltDaySelect("endDay",$event["endDay"]);
		}
	$eventstart .= calBuiltYearSelect("startYear",$event["startYear"]);
	$eventstart .= calBuildHourSelect("startHour",$event["startHour"]);
	$eventstart .= calBuildMinuteSelect("startMin",$event["startMin"]);
	$eventstart .= calBuildAmPmSelect("startAmPm",$event["startAmPm"]);
	$eventend   .= calBuiltYearSelect("endYear",$event["endYear"]);
	$eventend   .= calBuildHourSelect("endHour",$event["endHour"]);
	$eventend   .= calBuildMinuteSelect("endMin",$event["endMin"]);
	$eventend   .= calBuildAmPmSelect("endAmPm",$event["endAmPm"]);

	/// periodic
	#$event["rec_period"] = (empty($event["rec_period"])) ? 0 : $event["rec_period"];
	#$event["rec_type"]   = (empty($event["rec_type"]))   ? CAL_PERIOD_DEFAULT : $event["rec_type"];
	#$eventperiod = calBuiltRecTypeSelect($event['rec_period'], $event["rec_type"]);
	/// periodic

	$user = (isset($_COOKIE['user'])) ? $_COOKIE['user'] : "";
	if (is_user($user)) {
		$namefield = "<a href=\"".CAL_MOD_USERLOGIN."\"><b>".$event["informant"]."</b></a>";
		$autoactive = (empty($calconf['userautoactive'])) ? 0 : 1;
	  }
	else {
		$namefield = "".$GLOBALS["anonymous"]." [ <a href=\"".CAL_MOD_USERLOGIN."\">"._CALLOGIN."</a> ]";
		$autoactive = (empty($calconf['anonautoactive'])) ? 0 : 1;
		}

	if ($event["op"]=="CalendarPreviewEvent" || $event["op"]=="CalendarEditEvent" || $event["op"] == "CalendarNewEvent" || $event["op"]=="CalendarPostEvent"){
		$actionfile = "admin.php";
		$hiddenfields  = "<input type=\"hidden\" name=\"name\" value=\"".CAL_MODULE_NAME."\">\n";
		$hiddenfields .= "<input type=\"hidden\" name=\"file\" value=\"submit\">\n";
		$hiddenfields .= "<input type=\"hidden\" value=\"".$event["posteddate"]."\" name=\"posteddate\">";
		$submitoptions  = "<option value=\"CalendarPreviewEvent\">"._CALPREVIEWSTORY."</option>\n";
		$submitoptions .= "<option value=\"CalendarPostEvent\" selected>"._CALPOSTSTORY."</option>\n";
		if (!empty($event["eid"])) $submitoptions .= "<option value=\"CalendarDeleteEvent\">"._CALDELETESTORY."</option>\n";
		$xactiv = (empty($event["activ"])) ? "<b> (neuer Termin)</b>" : "";
		$event["activ"]  = (empty($event["activ"])) ? 1 : $event["activ"];
		$selactiv1 = ($event["activ"] == 1) ? "checked" : "";
		$selactiv2 = ($event["activ"] != 1) ? "checked" : "";
		#$namefield = "<input type=\"text\" NAME=\"informant\" size=\"25\" value=\"".calPrepareDisplay($event["informant"])."\">";
		if ($event["informant"] && $event["op"] != "CalendarNewEvent") {
			$userdata = calGetUserData($event["informant"]);
			$event["informant"] = $userdata["uname"]; // falls Username nicht mehr existiert, wird "" gesetzt
			if ($event["informant"]){
				$namefield .= "&nbsp; <font class=\"tiny\">[ <a href=\"".CAL_MOD_USERINFO.$event["informant"]."\" target=\"_blank\">Userinfo</a> | <a href=\"mailto:".$userdata["email"]."\">Email User</a>";
				$namefield .= " ]</font>";
				}
			}
		}
	else {
		$actionfile = "modules.php";
		$hiddenfields  = "<input type=\"hidden\" name=\"name\" value=\"".CAL_MODULE_NAME."\">\n";
		$hiddenfields .= "<input type=\"hidden\" name=\"file\" value=\"submit\">\n";
		$hiddenfields .= "<input type=\"hidden\" value=\"".$event["posteddate"]."\" name=\"posteddate\">";
		$hiddenfields .= "<input type=\"hidden\" name=\"activ\" value=\"".$autoactive."\">\n";
		$submitoptions  = "<option value=\"calNewEventPreview\" selected>"._CALPREVIEW."</option>\n";
		$submitoptions .= "<option value=\"calNewEventSubmit\">"._CALOK."</option>\n";
		$event["activ"]  = 0;
		}
	if (empty($calconf['allowaddarticle'])){
		$hiddenfields  .= "<input type=\"hidden\" name=\"addasarticle\" value=\"0\">\n";
		}
	$usermsg1 = (empty($event["activ"])) ? "<br>"._CALSUBMITADVICE2 : "";
############## Beginn Formview #####################
	OpenTable();
	echo "<center>";
	echo "<form action=\"".$actionfile."\" method=\"post\">\n";
	echo "<table width=\"90%\" border=\"0\" cellspacing=\"1\" cellpadding=\"3\" bgcolor=\"$bgcolor1\">\n";
	echo "<tr valign=\"top\"><td colspan=\"2\" bgcolor=\"$bgcolor2\"><font class=\"content\">";
	echo " <img src=\"".CAL_IMAGE_PATH."sign.gif\" alt=\""._CALSUBMITEVENT."\" width=\"16\" height=\"16\" border=\"0\" align=\"absmiddle\" hspace=\"5\" vspace=\"3\"><b>"._CALSUBMITADVICE1."</b>".$usermsg1."</td>\n</tr>\n";
	echo "<tr valign=\"top\"><td bgcolor=\"$bgcolor2\"><font class=\"content\"><b>".$namecaption."</b>:</font></td>\n";
	echo " <td bgcolor=\"$bgcolor3\"><font class=\"content\">".$namefield."</font></td>\n</tr>\n";
	echo "<tr valign=\"top\"><td bgcolor=\"$bgcolor2\"><font class=\"content\"><b>"._CALSUBTITLE."</b>:</font></td>\n";
	echo " <td bgcolor=\"$bgcolor3\"><font class=\"tiny\"><input type=\"text\" name=\"title\" size=\"50\" maxlength=\"80\" value=\"".calPrepareDisplay($event["title"])."\">\n<br>"._CALBEDESCRIPTIVE."</font></td>\n</tr>\n";
	echo "<tr valign=\"top\"><td bgcolor=\"$bgcolor2\"><font class=\"content\"><b>"._CALEVENTDATETEXT."</b>:</font></td>\n";# _CALSTARTTIME
	echo " <td bgcolor=\"$bgcolor3\"><font class=\"tiny\">".$eventstart."</font></td>\n</tr>\n";
	echo "<tr valign=\"top\"><td bgcolor=\"$bgcolor2\"><font class=\"content\"><b>"._CALENDDATETEXT."</b>:</font></td>\n"; # _CALENDTIME
	echo " <td bgcolor=\"$bgcolor3\"><font class=\"tiny\">".$eventend."</font></td>\n</tr>\n";
 	echo "<tr valign=\"top\"><td bgcolor=\"$bgcolor2\"><font class=\"content\"><b>"._CALALLDAYEVENT."</b>:</font></td>\n";
	echo " <td bgcolor=\"$bgcolor3\"><font class=\"tiny\"><input name=\"alldayevent\" $checkalldayevent type=\"checkbox\" value=\"1\" style=\"background-color: transparent;\">&nbsp;&nbsp;"._CALTIMEIGNORED."</font></td>\n</tr>\n";
	
	/// periodic
	#echo "<tr valign=\"top\"><td bgcolor=\"$bgcolor2\"><font class=\"content\"><b>"._CALEVENTPERIODTEXT."</b>:</font></td>\n"; # _CALENDTIME
	#echo " <td bgcolor=\"$bgcolor3\"><font class=\"tiny\">".$eventperiod."</font></td>\n</tr>\n";
	/// periodic
	
	echo "<tr valign=\"top\"><td bgcolor=\"$bgcolor2\"><font class=\"content\"><b>"._CALARTICLETEXT."</b>:</font></td>\n";
	echo " <td bgcolor=\"$bgcolor3\"><font class=\"tiny\"><textarea cols=\"70\" rows=\"7\" name=\"hometext\">".calPrepareDisplay($event["hometext"])."</textarea><br>"._CALHTMLISFINE."<br>"._CALALLOWEDHTML.": ".calGetAllowedtags(1)."</font></td>\n</tr>\n";
	echo "<tr valign=\"top\"><td bgcolor=\"$bgcolor2\"><font class=\"content\"><b>"._CALBARCOLORTEXT."</b>:</font></td>\n";
	echo " <td bgcolor=\"$bgcolor3\">".calBuildColorLegend("form","","",$event["categorie"])."</td>\n</tr>\n";
	if ($calconf['usetopics'] > 0){
		echo "<tr valign=\"top\"><td bgcolor=\"$bgcolor2\"><font class=\"content\"><b>"._CALTOPIC."</b>:</font></td>\n";
		echo " <td bgcolor=\"$bgcolor3\"><font class=\"tiny\">".calBuildTopicsSelect($event["topic"])."</font></td>\n</tr>\n";
		}
	if ($calconf['allowaddarticle']){
		echo "<tr valign=\"top\"><td bgcolor=\"$bgcolor2\"><font class=\"content\"><b>"._CALADDASARTICLE."</b>:</font></td>\n";
		echo " <td bgcolor=\"$bgcolor3\"><font class=\"tiny\"><input type=\"checkbox\" name=\"addasarticle\" value=\"1\" style=\"background-color: transparent;\" ".$checkaddarticle.">&nbsp;&nbsp;"._CALADDASARTICLE2."</font></td>\n</tr>\n";
		}
	if ($event["activ"]){
		echo "<tr valign=\"top\"><td bgcolor=\"$bgcolor2\"><font class=\"content\"><b>"._CALACTIV."</b>:</font></td>\n";
		echo " <td bgcolor=\"$bgcolor3\"><input type=\"radio\" name=\"activ\" value=\"1\" $selactiv1>"._CALYES." &nbsp;<input type=\"radio\" name=\"activ\" value=\"2\" $selactiv2>"._CALNO." &nbsp; $xactiv</font></td>\n</tr>\n";
		}
	echo "<tr valign=\"top\"><td bgcolor=\"$bgcolor2\" colspan=\"2\"><select name=\"op\">".$submitoptions."</select>&nbsp;&nbsp;<input type=\"submit\" value=\""._CALSEND."\">";
	echo " <br><font class=\"tiny\">"._CALCHECKSTORY."</font></td>\n</tr>\n";
	# align=\"center\"
	echo "</table>";
	echo "".$hiddenfields."<input type=\"hidden\" name=\"informant\" value=\"".$event["informant"]."\">\n";
	echo "<input type=\"hidden\" value=\"".$event["aid"]."\" name=\"aid\">\n";
	echo "<input type=\"hidden\" value=\"".$event["eid"]."\" name=\"eid\">\n";
	echo "</form>";
	echo "</center>";
	CloseTable();
	echo "<br>";
	}

#########################################################################################
function calStripSlashes(&$what) {
	// wenn $what leer ist, Leerstring zurueckgeben
	if (empty($what)) return "";
	// eindeutige Kennung erstellen
	static $entity;
	if (empty($entity)) {
		mt_srand((double)microtime()*1000000);
		$entity = md5(mt_rand());
		}
	if(is_array($what)) {
		array_walk($what,'calStripSlashes');
		}
	else {
		// erwuenschte Backslashes in eindeutigen String umwandeln
		$what = str_replace("\\\\", $entity, $what);
		// alle anderen Backslashes entfernen
		$what = stripslashes($what);
		// erwuenschte Backslashes wieder zurueckwandeln
		$what = str_replace($entity, "\\", $what);
		}
	return $what;
	}

#########################################################################################
function calAddSlashes($what){
	// wenn $what numerisch oder leer ist, unveraendert zurueckgeben
	if (is_numeric($what) || empty($what)) return $what;
	static $entity;
	if (empty($entity)) {
		// eindeutige Kennung erstellen
		mt_srand((double)microtime()*1000000);
		$entity = md5(mt_rand());
		}
	// wenn $what ein Array, das Array durchlaufen 
	// und die Funktion rekursiv aufrufen
	if (is_array($what)) {
		foreach ($what as $key => $value) {
			$what[$key] = calAddSlashes($value);
			}
		}
	// wenn String
	else {
		// erwuenschte Backslashes in eindeutigen String umwandeln
		$what = str_replace("\\\\", $entity, $what);
		// alle anderen Backslashes entfernen
		$what = stripslashes($what);
		// erwuenschte Backslashes wieder zurueckwandeln
		$what = str_replace($entity, "\\", $what);
		// sicherstellen, dass die richtige Anzahl von Backslashes wieder eingefuegt werden
		$what = addslashes($what);
		}
	return $what;
	}

#########################################################################################
function calPrepareDisplay(){
	// This search and replace finds the text 'x@y' and replaces
	// it with HTML entities, this provides protection against
	// email harvesters
	static $search = array('/(.)@(.)/se');
	static $replace = array('"&#" .sprintf("%03d", ord("\\1")) .";&#064;&#" .sprintf("%03d", ord("\\2")) . ";";');
	$resarray = array();
	foreach (func_get_args() as $var) {
		$var = htmlspecialchars($var, ENT_QUOTES);// Prepare var
		$var = preg_replace($search, $replace, $var);
		$var = preg_replace('/&amp;#/', '&#', $var);
		$var = str_replace("&amp;nbsp;","&nbsp;",$var);
		$var = str_replace("&amp;amp;","&amp;",$var);
		$resarray[] = $var;// Add to array
		}
	if (func_num_args() == 1) {// Return vars
		return $resarray[0];
		}
	else {
		return $resarray;
		}
	}

#########################################################################################
function calIsPrintView(){
	return defined("CAL_PRINTERPAGE");
	}

?>