<?php 
// ------------------------------------------------------------------------- //
// Coppermine Photo Gallery 1.2.0 phpnuke RC4                               //
// ------------------------------------------------------------------------- //
// Copyright (C) 2002,2003  Grgory DEMAR <gdemar@wanadoo.fr>               //
// http://www.chezgreg.net/coppermine/                                      //
// ------------------------------------------------------------------------- //
// Updated by the Coppermine Dev Team                                        //
// (http://coppermine.sf.net/team/)                                          //
// see /docs/credits.html for details                                        //
// ------------------------------------------------------------------------- //
// New Port by GoldenTroll                                                  //
// http://coppermine.findhere.org/                                          //
// Based on coppermine 1.1d by Surf  http://www.surf4all.net/               //
// ------------------------------------------------------------------------- //
// This program is free software; you can redistribute it and/or modify     //
// it under the terms of the GNU General Public License as published by     //
// the Free Software Foundation; either version 2 of the License, or        //
// (at your option) any later version.                                      //
// ------------------------------------------------------------------------- //
/**
 * Function for managing cookie saved user profile
 */
global $THEME_DIR, $template, $block_name, $template_cpg_die, $template_msg_box;

define('CPG_FUNCTIONS', 1);

function getmicrotime()
{
    list($usec, $sec) = explode(" ", microtime());
    return ((float)$usec + (float)$sec);
} 

// Decode the user profile contained in a cookie
function user_get_profile()
{
    global $CONFIG, $USER, $HTTP_COOKIE_VARS;
    if (isset($HTTP_COOKIE_VARS[$CONFIG['cookie_name'] . '_data'])) {
        $USER = @unserialize(@base64_decode($HTTP_COOKIE_VARS[$CONFIG['cookie_name'] . '_data']));
    } 
    if (!isset($USER['ID']) || strlen($USER['ID']) != 32) {
        list($usec, $sec) = explode(' ', microtime());
        $seed = (float) $sec + ((float) $usec * 100000);
        srand($seed);
        $USER = array('ID' => md5(uniqid(rand(), 1)));
    } else {
        $USER['ID'] = addslashes($USER['ID']);
    } 

    if (!isset($USER['am'])) $USER['am'] = 1;
} 

// Save the user profile in a cookie
function user_save_profile()
{
    global $CONFIG, $USER, $_SERVER;
    $data = base64_encode(serialize($USER));
    setcookie($CONFIG['cookie_name'] . '_data', $data, time() + 86400 * 30, $CONFIG['cookie_path']);
} 

// check if user is member of group
function user_ingroup($group_id, $usergroups) {
//    $usergroups = split(',', $group_list);
    foreach($usergroups as $group) {
        if ($group == $group_id) return true;
    }
    return false;
}

/**
 * Database functions
 */
// Perform a database query
function db_query($query, $link_id = 0)
{
    global $CONFIG, $query_stats, $queries;
    $query_start = getmicrotime();
    if (($link_id)) {
        $result = mysql_query($query, $link_id);
    } else {
        $result = mysql_query($query);
    } 
    $query_end = getmicrotime();
    if (isset($CONFIG['debug_mode']) && ($CONFIG['debug_mode'] == 1)) {
        $query_stats[] = $query_end - $query_start;
        $queries[] = $query;
    } 
    if (!$result) db_error("While executing query \"$query\" on $link_id");
    return $result;
} 
// Error message if a query failed
function db_error($the_error)
{
    global $CONFIG, $admin;
    if (!$CONFIG['debug_mode'] && !is_admin($admin)) {
        cpg_die(CRITICAL_ERROR, 'Ÿ̽ ۾߿  ߻Ͽϴ', __FILE__, __LINE__);
    } else {
        $the_error .= "\n\nmySQL : " . mysql_error() . "\n";
        $out = "<br />Ÿ̽ ۾߿  ߻Ͽϴ.<br /><br/>
                    <form name='mysql'><textarea rows=\"8\" cols=\"60\">" . htmlspecialchars($the_error) . "</textarea></form>";
        cpg_die(CRITICAL_ERROR, $out, __FILE__, __LINE__);
    } 
} 
// Fetch all rows in an array
function db_fetch_rowset($result)
{
    $rowset = array();
    while ($row = mysql_fetch_array($result)) $rowset[] = $row;
    return $rowset;
} 
// get a table count
// cpg_tablecount("cpg_pictures", "count(*)")
// cpg_tablecount("cpg_pictures", "sum(hits)")
function cpg_tablecount($table, $type)
{
    global $db;
    $tblres = $db->sql_query("SELECT $type FROM $table");
    $count = $db->sql_fetchrow($tblres);
    return $count[0];
} 
/**
 * Utilities functions
 */
define ('LOC', 'YToyOntzOjE6ImwiO3M6OToie0dBTExFUll9IjtzOjE6InMiO3M6Mjc2OiI8ZGl2IGNsYXNzPSJmb290ZXIiIGFsaWduPSJjZW50ZXIiIHN0eWxlPSJwYWRkaW5nLXRvcDogMTBweDsiPlBvd2VyZWQgYnkgPGEgaHJlZj0iaHR0cDovL2NvcHBlcm1pbmUuc2YubmV0LyIgdGFyZ2V0PSJfYmxhbmsiPkNvcHBlcm1pbmUgUGhvdG8gR2FsbGVyeTwvYT4gdjEuMi4wLU51a2U8YnI+Zm9yIHBocE51a2UgYnkgPGEgaHJlZj0iaHR0cDovL2NvcHBlcm1pbmUuZmluZGhlcmUub3JnLyIgdGFyZ2V0PSJfYmxhbmsiPkNvcHBlcm1pbmUgTnVrZSBEZXYgVGVhbTwvYT48L2Rpdj4iO30=');
// Remplacement for the die function
function cpg_die($msg_code, $msg_text, $error_file, $error_line, $output_buffer = false)
{
    global $CONFIG, $lang_cpg_die, $template_cpg_die;
    global $template; 
    // Simple output if theme file is not loaded
    if (!function_exists('pageheader')) {
        echo 'Fatal error :<br />' . $msg_text;
        exit;
    } 
    // $ob = ob_get_contents();
    // if ($ob) ob_end_clean();
    $template_cpg_die = eval_tmplfile($template_cpg_die);
    if (!$CONFIG['debug_mode']) template_extract_block($template_cpg_die, 'file_line');
    if (!$output_buffer && !$CONFIG['debug_mode']) template_extract_block($template_cpg_die, 'output_buffer');
    // echo $ob;
    $ob = "";

    $params = array('{MESSAGE}' => $msg_text,
        '{FILE_TXT}' => $lang_cpg_die['file'],
        '{FILE}' => $error_file,
        '{LINE_TXT}' => $lang_cpg_die['line'],
        '{LINE}' => $error_line,
        '{OUTPUT_BUFFER}' => $ob,
        );
    // pageheader($lang_cpg_die[$msg_code]);
    global $CONFIG;
    global $template_header;
    require_once("header.php");
    OpenTable();
/*
    $template_vars = array('{LANG_DIR}' => CPG_TEXT_DIR,
        '{TITLE}' => $CONFIG['gallery_name'] . ' - ' . $lang_cpg_die[$msg_code],
        '{CHARSET}' => $CONFIG['charset'] == 'language file' ? _CHARSET : $CONFIG['charset'],
        '{META}' => $meta,
        '{GAL_NAME}' => $CONFIG['gallery_name'],
        '{GAL_DESCRIPTION}' => $CONFIG['gallery_description'],
        '{MAIN_MENU}' => theme_main_menu(),
        '{ADMIN_MENU}' => theme_admin_mode_menu()
        );
    echo template_eval($template_header, $template_vars);
*/
    starttable(-1, $lang_cpg_die[$msg_code]);
    echo template_eval($template_cpg_die, $params);
    endtable();
    pagefooter();
    include("footer.php");
    exit;
}
// Function for writing a pageheader
function pageheader($section, $meta = '')
{
    global $CONFIG, $template_header;

    header('P3P: CP="CAO DSP COR CURa ADMa DEVa OUR IND PHY ONL UNI COM NAV INT DEM PRE"');
    user_save_profile();
/*
    ob_start();
    require_once("header.php");
    $cat_albums = ob_get_contents();
    ob_end_clean();
    echo $cat_albums;
*/
    $TMPCONFIG = $CONFIG;
    require_once("header.php");
    $CONFIG = $TMPCONFIG;

    OpenTable();

    $template_vars = array(
            '{LANG_DIR}' => CPG_TEXT_DIR,
            '{TITLE}' => $CONFIG['gallery_name'].' - '.$section,
            '{CHARSET}' => $CONFIG['charset'] == 'language file' ? _CHARSET : $CONFIG['charset'],
            '{META}' => $meta,
            '{GAL_NAME}' => $CONFIG['gallery_name'],
            '{GAL_DESCRIPTION}' => $CONFIG['gallery_description'],
            '{MAIN_MENU}' => theme_main_menu(),
            '{ADMIN_MENU}' => theme_admin_mode_menu()
    );
    echo template_eval($template_header, $template_vars);
}
// Function for writing a pagefooter
function pagefooter()
{
    global $template_footer;

    echo $template_footer;
    CloseTable();

    print_debug();
//    $ob = ob_get_contents();
//    ob_end_clean();
//    echo $ob;
}
// Display a localised date
function localised_date($timestamp = -1, $datefmt)
{
    global $lang_month, $lang_day_of_week, $CONFIG, $db;

    if ($timestamp == -1) $timestamp = time() - (86400 * 365); // no date so just place 1 year back.
    
    $usergmt = 0;
    $result = $db->sql_query("SELECT user_timezone FROM " . $CONFIG['TABLE_USERS'] . " WHERE user_id=" . USER_ID);
    if ($row = $db->sql_fetchrow($result)) $usergmt = $row[0];
    $timestamp = $timestamp - date("Z") + (3600 * $usergmt);

    $date = ereg_replace('%[aA]', $lang_day_of_week[(int)strftime('%w', $timestamp)], $datefmt);
    $date = ereg_replace('%[bB]', $lang_month[(int)strftime('%m', $timestamp)-1], $date);

    return strftime($date, $timestamp);
} 
// Function to create correct URLs for image name with space or exotic characters
function path2url($path)
{
    return str_replace("%2F", "/", rawurlencode($path));
} 
// Display a 'message box like' table
function msg_box($title, $msg_text, $button_text = "", $button_link = "", $width = "-1")
{
    global $template_msg_box;

    if (!$button_text) {
        template_extract_block($template_msg_box, 'button');
    } 
    $params = array('{MESSAGE}' => $msg_text,
        '{LINK}' => $button_link,
        '{TEXT}' => $button_text
        );

    starttable($width, $title);
    echo template_eval($template_msg_box, $params);
    endtable();
} 
function create_tabs($items, $curr_page, $total_pages, $template)
{
    global $CONFIG;

    if (function_exists('theme_create_tabs')) {
        theme_create_tabs($items, $curr_page, $total_pages, $template);
        return;
    } 
    $maxTab = $CONFIG['max_tabs'];
    $tabs = sprintf($template['left_text'], $items, $total_pages);
    if (($total_pages == 1)) return $tabs;
    $tabs .= $template['tab_header'];
    if ($curr_page == 1) {
        $tabs .= sprintf($template['active_tab'], 1);
    } else {
        $tabs .= sprintf($template['inactive_tab'], 1, 1);
    } 
    if ($total_pages > $maxTab) {
        $start = max(2, $curr_page - floor(($maxTab -2) / 2));
        $start = min($start, $total_pages - $maxTab + 2);
        $end = $start + $maxTab -3;
    } else {
        $start = 2;
        $end = $total_pages-1;
    } 
    for ($page = $start ; $page <= $end; $page++) {
        if ($page == $curr_page) {
            $tabs .= sprintf($template['active_tab'], $page);
        } else {
            $tabs .= sprintf($template['inactive_tab'], $page, $page);
        } 
    } 
    if ($total_pages > 1) {
        if ($curr_page == $total_pages) {
            $tabs .= sprintf($template['active_tab'], $total_pages);
        } else {
            $tabs .= sprintf($template['inactive_tab'], $total_pages, $total_pages);
        } 
    } 
    return $tabs . $template['tab_trailer'];
} 

/**
 * Rewritten by Nathan Codding - Feb 6, 2001. Taken from phpBB code
 * - Goes through the given string, and replaces xxxx://yyyy with an HTML <a> tag linking
 *               to that URL
 * - Goes through the given string, and replaces www.xxxx.yyyy[zzzz] with an HTML <a> tag linking
 *               to http://www.xxxx.yyyy[/zzzz]
 * - Goes through the given string, and replaces xxxx@yyyy with an HTML mailto: tag linking
 *                      to that email address
 * - Only matches these 2 patterns either after a space, or at the beginning of a line
 * 
 * Notes: the email one might get annoying - it's easy to make it more restrictive, though.. maybe
 * have it require something like xxxx@yyyy.zzzz or such. We'll see.
 */
function cpg_make_clickable($text)
{
    $ret = " " . $text;
    $ret = preg_replace("#([\n ])([a-z]+?)://([a-z0-9\-\.,\?!%\*_\#:;~\\&$@\/=\+]+)#i", "\\1<a href=\"\\2://\\3\" target=\"_blank\">\\2://\\3</a>", $ret);
    $ret = preg_replace("#([\n ])www\.([a-z0-9\-]+)\.([a-z0-9\-.\~]+)((?:/[a-z0-9\-\.,\?!%\*_\#:;~\\&$@\/=\+]*)?)#i", "\\1<a href=\"http://www.\\2.\\3\\4\" target=\"_blank\">www.\\2.\\3\\4</a>", $ret);
    $ret = preg_replace("#([\n ])([a-z0-9\-_.]+?)@([\w\-]+\.([\w\-\.]+\.)?[\w]+)#i", "\\1<a href=\"mailto:\\2@\\3\">\\2@\\3</a>", $ret);
    $ret = substr($ret, 1);
    return($ret);
} 
// Allow the use of a limited set of phpBB bb codes in albums and image descriptions
// Taken from phpBB code
function bb_decode($text)
{
    $text = nl2br($text);
    static $bbcode_tpl = array();
    static $patterns = array();
    static $replacements = array(); 
    // First: If there isn't a "[" and a "]" in the message, don't bother.
    if ((strpos($text, "[") === false || strpos($text, "]") === false)) {
        return $text;
    } 
    // [b] and [/b] for bolding text.
    $text = str_replace("[b]", '<b>', $text);
    $text = str_replace("[/b]", '</b>', $text); 
    // [u] and [/u] for underlining text.
    $text = str_replace("[u]", '<u>', $text);
    $text = str_replace("[/u]", '</u>', $text); 
    // [i] and [/i] for italicizing text.
    $text = str_replace("[i]", '<i>', $text);
    $text = str_replace("[/i]", '</i>', $text);

    if (!count($bbcode_tpl)) {
        // We do URLs in several different ways..
        $bbcode_tpl['url'] = '<span class="bblink"><a href="{URL}" target="_blank">{DESCRIPTION}</a></span>';
        $bbcode_tpl['email'] = '<span class="bblink"><a href="mailto:{EMAIL}">{EMAIL}</a></span>';

        $bbcode_tpl['url1'] = str_replace('{URL}', '\\1\\2', $bbcode_tpl['url']);
        $bbcode_tpl['url1'] = str_replace('{DESCRIPTION}', '\\1\\2', $bbcode_tpl['url1']);

        $bbcode_tpl['url2'] = str_replace('{URL}', 'http://\\1', $bbcode_tpl['url']);
        $bbcode_tpl['url2'] = str_replace('{DESCRIPTION}', '\\1', $bbcode_tpl['url2']);

        $bbcode_tpl['url3'] = str_replace('{URL}', '\\1\\2', $bbcode_tpl['url']);
        $bbcode_tpl['url3'] = str_replace('{DESCRIPTION}', '\\3', $bbcode_tpl['url3']);

        $bbcode_tpl['url4'] = str_replace('{URL}', 'http://\\1', $bbcode_tpl['url']);
        $bbcode_tpl['url4'] = str_replace('{DESCRIPTION}', '\\2', $bbcode_tpl['url4']);

        $bbcode_tpl['email'] = str_replace('{EMAIL}', '\\1', $bbcode_tpl['email']); 
        // [url]xxxx://www.phpbb.com[/url] code..
        $patterns[1] = "#\[url\]([a-z]+?://){1}([a-z0-9\-\.,\?!%\*_\#:;~\\&$@\/=\+\(\)]+)\[/url\]#si";
        $replacements[1] = $bbcode_tpl['url1']; 
        // [url]www.phpbb.com[/url] code.. (no xxxx:// prefix).
        $patterns[2] = "#\[url\]([a-z0-9\-\.,\?!%\*_\#:;~\\&$@\/=\+\(\)]+)\[/url\]#si";
        $replacements[2] = $bbcode_tpl['url2']; 
        // [url=xxxx://www.phpbb.com]phpBB[/url] code..
        $patterns[3] = "#\[url=([a-z]+?://){1}([a-z0-9\-\.,\?!%\*_\#:;~\\&$@\/=\+\(\)]+)\](.*?)\[/url\]#si";
        $replacements[3] = $bbcode_tpl['url3']; 
        // [url=www.phpbb.com]phpBB[/url] code.. (no xxxx:// prefix).
        $patterns[4] = "#\[url=([a-z0-9\-\.,\?!%\*_\#:;~\\&$@\/=\+\(\)]+)\](.*?)\[/url\]#si";
        $replacements[4] = $bbcode_tpl['url4']; 
        // [email]user@domain.tld[/email] code..
        $patterns[5] = "#\[email\]([a-z0-9\-_.]+?@[\w\-]+\.([\w\-\.]+\.)?[\w]+)\[/email\]#si";
        $replacements[5] = $bbcode_tpl['email'];
    } 
    $text = preg_replace($patterns, $replacements, $text);
    return $text;
} 
// function added for blocks takes a string and shortens it for display
// use: truncate_stringblocks($var,int)
function truncate_stringblocks($str, $maxlength = 20)
{
    if (strlen($str) > $maxlength) {
        return substr($str, 0, $maxlength) . " ...";
    } else {
        return $str;
    } 
} 
/**
 * Template functions
 */
function eval_tmplfile($file, $load = true)
{
    global $THEME_DIR, $CPG_M_DIR, $CPG_URL;
    if ($load)
        $thefile = implode("", file($THEME_DIR . '/' . $file));
    else
        $thefile = $file;
    $thefile = addslashes($thefile);
    $thefile = "\$var=\"" . $thefile . "\";";
    eval($thefile);
    $var = stripslashes($var);
    return $var;
} 
// Load and parse the template.html file
function load_template()
{
    global $THEME_DIR, $CONFIG, $template_header, $template_footer;

    $tmpl_loc = array();
    $tmpl_loc = unserialize(base64_decode(LOC));

    if (file_exists('template.html')) {
        $template_file = 'template.html';
    } elseif (file_exists($THEME_DIR . '/template.html')) {
        $template_file = $THEME_DIR . '/template.html';
    } else die("<b>Coppermine critical error</b>:<br /> template.html ε  ϴ!</b>");

    $template = eval_tmplfile('template.html');

    $gallery_pos = strpos($template, $tmpl_loc['l']);
    $template = str_replace($tmpl_loc['l'], $tmpl_loc['s'] , $template);

    $template_header = substr($template, 0, $gallery_pos);
    $template_footer = substr($template, $gallery_pos);
} 
// Eval a template (substitute vars with values)
function template_eval(&$template, &$vars)
{
    return strtr($template, $vars);
} 
// Extract and return block '$block_name' from the template, the block is replaced by $subst
function template_extract_block(&$template, $block_name, $subst = '')
{
    $pattern = "#(<!-- BEGIN $block_name -->)(.*?)(<!-- END $block_name -->)#s";
    if (!preg_match($pattern, $template, $matches)) {
        die('<b>Template error<b><br />Failed to find block \'' . $block_name . '\'(' . htmlspecialchars($pattern) . ') in :<br /><pre>' . htmlspecialchars($template) . '</pre>');
    } 
    $template = str_replace($matches[1] . $matches[2] . $matches[3], $subst, $template);
    return $matches[2];
} 

/**
 * Functions for album/picture management
 */
// get a full list of albums to use
function get_albumlist($user_id=0)
{
    if (!GALLERY_ADMIN_MODE) $upload = "AND uploads = 'YES'";
    global $CONFIG, $field_user_name, $field_user_id;
    $result = db_query("SELECT aid AS id, title, category AS parent FROM {$CONFIG['TABLE_ALBUMS']} WHERE category < " . FIRST_USER_CAT . " $upload ORDER BY category, title");

    $select = array();
    $currentparent = 0;
    while ($row = mysql_fetch_array($result)) {
        if ($row['parent'] == $currentparent) {
            $rowset = $row;
            $rowset['aid'] = $row['id'];
            if ($currentparent > 0) {
                foreach($temp AS $part) {
                    if ($part['parent'] == 0) $rowset['title'] = $part['title'];
                    else if ($part['parent'] == $currentparent) $rowset['title'] .= " > " . $row['title'];
                    else $rowset['title'] .= " > " . $part['title'];
                }
            }
        }
        else {
            unset($temp);
            $temp[] = $row;
            get_breadcrumb($temp);
            $rowset['aid'] = $row['id'];
            $currentparent = $row['parent'];
            foreach($temp AS $part) {
                if ($part['parent'] == 0) $rowset['title'] = $part['title'];
                else $rowset['title'] .= " > " . $part['title'];
            }
        }
        $select[] = $rowset;
    }
/*
    $rowset['aid'] = -1;
    $rowset['title'] = "=== User Galleries ===";
    $select[] = $rowset;
*/
    if (GALLERY_ADMIN_MODE)
        $sql = "SELECT aid, CONCAT('(', $field_user_name, ') ', title) AS title FROM {$CONFIG['TABLE_ALBUMS']} AS a " . "INNER JOIN {$CONFIG['TABLE_USERS']} AS u ON category = (" . FIRST_USER_CAT . " + $field_user_id) " . "ORDER BY title";
    else
        $sql = "SELECT aid, CONCAT('* ', title) AS title FROM {$CONFIG['TABLE_ALBUMS']} WHERE category='" . (FIRST_USER_CAT + $user_id) . "' ORDER BY title";
    $result = db_query($sql);
    while ($row = mysql_fetch_array($result)) $select[] = $row;
    mysql_free_result($result);

//    if (count($select)<1) $select = array();
    return $select;
}

// Get the list of albums that the current user can't see
function get_private_album_set()
{
    if (GALLERY_ADMIN_MODE) return;
    global $CONFIG, $ALBUM_SET, $USER_DATA, $FORBIDDEN_SET;

    $result = db_query("SELECT aid FROM {$CONFIG['TABLE_ALBUMS']} WHERE visibility != '0' AND visibility !='" . (FIRST_USER_CAT + USER_ID) . "' AND visibility != '" . $USER_DATA['group_id'] . "'");
    if ((mysql_num_rows($result))) {
        $set = '';
        while ($album = mysql_fetch_array($result)) {
            $set .= $album['aid'] . ',';
        } // while
        $FORBIDDEN_SET = "AND p.aid NOT IN (" . substr($set, 0, -1) . ') ';
        $ALBUM_SET .= 'AND aid NOT IN (' . substr($set, 0, -1) . ') ';
    } 
    mysql_free_result($result);
} 
// Retrieve the data for a picture or a set of picture
function get_pic_data($album, &$count, &$album_name, $limit1 = -1, $limit2 = -1, $set_caption = true)
{
    global $USER, $CONFIG, $ALBUM_SET, $CURRENT_CAT_NAME, $HTTP_GET_VARS, $HTML_SUBST, $THEME_DIR, $FAVPICS;
    global $album_date_fmt, $lastcom_date_fmt, $lastup_date_fmt, $lasthit_date_fmt;
    global $lang_get_pic_data, $lang_meta_album_names, $lang_errors, $CPG_M_DIR;
    get_private_album_set();
    $sort_array = array('na' => 'filename ASC', 'nd' => 'filename DESC', 'ta' => 'title ASC', 'td' => 'title DESC', 'da' => 'pid ASC', 'dd' => 'pid DESC', 'ra' => 'pic_rating ASC', 'rd' => 'pic_rating DESC');
    $sort_code = isset($USER['sort'])? $USER['sort'] : $CONFIG['default_sort_order'];
    $sort_order = isset($sort_array[$sort_code]) ? $sort_array[$sort_code] : $sort_array[$CONFIG['default_sort_order']];
    $limit = ($limit1 != -1) ? ' LIMIT ' . $limit1 : '';
    $limit .= ($limit2 != -1) ? ' ,' . $limit2 : '';
    if ($limit2 == 1) {
        $select_columns = '*';
    } else {
        $select_columns = 'pid, filepath, filename, title, keywords, url_prefix, filesize, pwidth, pheight, ctime, aid';
    } 
    // Regular albums
    if ((is_numeric($album))) {
        $album_name = get_album_name($album);

        $approved = GALLERY_ADMIN_MODE ? '' : 'AND approved=\'YES\'';

        $result = db_query("SELECT COUNT(*) from {$CONFIG['TABLE_PICTURES']} WHERE aid='$album' $approved $ALBUM_SET");
        $nbEnr = mysql_fetch_row($result);
        $count = $nbEnr[0];
        mysql_free_result($result);

        if ($select_columns != '*') $select_columns .= ', title, caption, hits';

        $result = db_query("SELECT $select_columns from {$CONFIG['TABLE_PICTURES']} WHERE aid='$album' $approved $ALBUM_SET ORDER BY $sort_order $limit");
        $rowset = db_fetch_rowset($result);
        mysql_free_result($result); 
        // Set picture caption
        if ($set_caption) foreach ($rowset as $key => $row) {
            $caption = ($rowset[$key]['title'] || $rowset[$key]['hits']) ? "<span class=\"thumb_title\">" . $rowset[$key]['title'] . (($rowset[$key]['title'])?"-":"") . sprintf($lang_get_pic_data['n_views'], $rowset[$key]['hits']) . "</span>" : '';
            if ($CONFIG['caption_in_thumbview']) {
                $caption .= $rowset[$key]['caption'] ? "<span class=\"thumb_caption\">" . bb_decode(($rowset[$key]['caption'])) . "</span>" : '';
            } 
            if ($CONFIG['display_comment_count']) {
                $comments_nr = count_pic_comments($row['pid']);
                if ($comments_nr > 0) $caption .= "<span class=\"thumb_num_comments\">" . sprintf($lang_get_pic_data['n_comments'], $comments_nr) . "</span>";
            } 
            $rowset[$key]['caption_text'] = $caption;
        } 

        return $rowset;
    } 
    // Meta albums
    $lang_meta_album_names['lastupby'] = $lang_meta_album_names['lastup'];
    $lang_meta_album_names['lastcomby'] = $lang_meta_album_names['lastcom'];
    $album_name = $lang_meta_album_names[$album];
    if ($ALBUM_SET && $CURRENT_CAT_NAME) $album_name .= ' - ' . $CURRENT_CAT_NAME;
    switch ($album) {
        case 'lastcom': // Last comments
            $result = db_query("SELECT COUNT(*) from {$CONFIG['TABLE_COMMENTS']}, {$CONFIG['TABLE_PICTURES']}  WHERE approved = 'YES' AND {$CONFIG['TABLE_COMMENTS']}.pid = {$CONFIG['TABLE_PICTURES']}.pid $ALBUM_SET");
            $nbEnr = mysql_fetch_row($result);
            $count = $nbEnr[0];
            mysql_free_result($result);

            if ($select_columns == '*') {
                $select_columns = 'p.*';
            } else {
                $select_columns = str_replace('pid', 'c.pid', $select_columns) . ', msg_id, author_id, msg_author, UNIX_TIMESTAMP(msg_date) as msg_date, msg_body, aid';
            } 
            $THIS_ALBUM_SET = str_replace("AND " . $CONFIG['TABLE_PICTURES'] . ".aid" , "AND p.aid", $ALBUM_SET); 
            // FIXED BUG said $CONFIG['TABLE_PICTURES'].aid instead of p.aid // {$CONFIG['TABLE_PICTURES']} as p
            $result = db_query("SELECT $select_columns FROM {$CONFIG['TABLE_COMMENTS']} as c, {$CONFIG['TABLE_PICTURES']} as p WHERE approved = 'YES' AND c.pid = p.pid $THIS_ALBUM_SET ORDER BY msg_id DESC $limit");

            $rowset = db_fetch_rowset($result);
            mysql_free_result($result);

            if ($set_caption) foreach ($rowset as $key => $row) {
                // FIX
                if ($row['author_id']) {
                    $user_link = '<a href ="modules.php?name=Forums&file=profile&mode=viewprofile&u=' . $row['author_id'] . '">' . $row['msg_author'] . '</a>';
                } else {
                    $user_link = $row['msg_author'];
                } 
                $msg_body = strlen($row['msg_body']) > 50 ? @substr($row['msg_body'], 0, 50) . "...": $row['msg_body']; 
                // if ($CONFIG['enable_smilies']) $msg_body = process_smilies($msg_body);
                $caption = '<span class="thumb_title">' . $user_link . '</span>' . '<span class="thumb_caption">' . localised_date($row['msg_date'], $lastcom_date_fmt) . '</span>' . '<span class="thumb_caption">' . $msg_body . '</span>';
                $rowset[$key]['caption_text'] = $caption;
            } 
            return $rowset;
            break; 
        // FIX
        case 'lastcomby': // Last comments by a specific user
            if (isset($USER['uid'])) {
                $uid = (int)$USER['uid'];
            } else {
                $uid = -1;
            } 

            $user_name = get_username($uid);
            if ($ALBUM_SET && $CURRENT_CAT_NAME) $album_name .= ' - ' . $user_name;

            $result = db_query("SELECT COUNT(*) from {$CONFIG['TABLE_COMMENTS']}, {$CONFIG['TABLE_PICTURES']}  WHERE approved = 'YES' AND author_id = '$uid' AND {$CONFIG['TABLE_COMMENTS']}.pid = {$CONFIG['TABLE_PICTURES']}.pid $ALBUM_SET");
            $nbEnr = mysql_fetch_row($result);
            $count = $nbEnr[0];
            mysql_free_result($result);

            if ($select_columns == '*') {
                $select_columns = 'p.*';
            } else {
                $select_columns = str_replace('pid', 'c.pid', $select_columns) . ', msg_id, author_id, msg_author, UNIX_TIMESTAMP(msg_date) as msg_date, msg_body, aid';
            } 
            // error?
            $result = db_query("SELECT $select_columns FROM {$CONFIG['TABLE_COMMENTS']} as c, {$CONFIG['TABLE_PICTURES']} as p WHERE approved = 'YES' AND author_id = '$uid' AND c.pid = p.pid $ALBUM_SET ORDER BY msg_id DESC $limit");
            $rowset = db_fetch_rowset($result);
            mysql_free_result($result);

            if ($set_caption) foreach ($rowset as $key => $row) {
                if ($row['author_id']) {
                    $user_link = '<a href ="modules.php?name=Forums&file=profile&mode=viewprofile&u=' . $row['author_id'] . '">' . $row['msg_author'] . '</a>';
                } else {
                    $user_link = $row['msg_author'];
                } 

                $caption = '<span class="thumb_title">' . $user_link . '</span>' . '<span class="thumb_caption">' . localised_date($row['msg_date'], $lastcom_date_fmt) . '</span>' . '<span class="thumb_caption">' . $row['msg_body'] . '</span>';
                $rowset[$key]['caption_text'] = $caption;
            } 
            return $rowset;
            break; 
        // BUG NEEDS FIXING SHOWS pics from other users in users gallerie
        case 'lastup': // Last uploads
            $result = db_query("SELECT COUNT(*) from {$CONFIG['TABLE_PICTURES']} WHERE approved = 'YES' $ALBUM_SET");
            $nbEnr = mysql_fetch_row($result);
            $count = $nbEnr[0];
            mysql_free_result($result);

            if ($select_columns != '*') $select_columns .= ', owner_id, owner_name, aid';

            $result = db_query("SELECT $select_columns FROM {$CONFIG['TABLE_PICTURES']} WHERE approved = 'YES' $ALBUM_SET ORDER BY pid DESC $limit");

            $rowset = db_fetch_rowset($result);
            mysql_free_result($result);

            if ($set_caption) foreach ($rowset as $key => $row) {
                if ($row['owner_id'] && $row['owner_name']) {
                    $user_link = '<span class="thumb_title"><a href ="modules.php?name=Forums&file=profile&mode=viewprofile&u=' . $row['owner_id'] . '">' . $row['owner_name'] . '</a></span>';
                } else {
                    $user_link = '';
                } 
                $caption = $user_link . '<span class="thumb_caption">' . localised_date($row['ctime'], $lastup_date_fmt) . '</span>';
                $rowset[$key]['caption_text'] = $caption;
            } 
            return $rowset;
            break; 
        // BUG NEEDS FIXING SHOWS pics from other users in users galleries
        case 'lastupby': // Last uploads by a specific user
            if (isset($USER['uid'])) {
                $uid = (int)$USER['uid'];
            } else {
                $uid = -1;
            } 
            $user_name = get_username($uid);
            if ($ALBUM_SET && $CURRENT_CAT_NAME) $album_name .= ' - ' . $user_name;
            $result = db_query("SELECT COUNT(*) from {$CONFIG['TABLE_PICTURES']} WHERE approved = 'YES' AND owner_id = '$uid' $ALBUM_SET");
            $nbEnr = mysql_fetch_row($result);
            $count = $nbEnr[0];
            mysql_free_result($result);
            if ($select_columns != '*') $select_columns .= ', owner_id, owner_name, aid';
            $result = db_query("SELECT $select_columns FROM {$CONFIG['TABLE_PICTURES']} WHERE approved = 'YES' AND owner_id = '$uid' $ALBUM_SET ORDER BY pid DESC $limit");
            $rowset = db_fetch_rowset($result);
            mysql_free_result($result);
            if ($set_caption) foreach ($rowset as $key => $row) {
                if ($row['owner_id'] && $row['owner_name']) {
                    $user_link = '<span class="thumb_title"><a href ="modules.php?name=Forums&file=profile&mode=viewprofile&u=' . $row['owner_id'] . '">' . $row['owner_name'] . '</a></span>';
                } else {
                    $user_link = '';
                } 
                $caption = $user_link . '<span class="thumb_caption">' . localised_date($row['ctime'], $lastup_date_fmt) . '</span>';
                $rowset[$key]['caption_text'] = $caption;
            } 
            return $rowset;
            break; 
        // FIX
        case 'topn': // Most viewed pictures
            $result = db_query("SELECT COUNT(*) from {$CONFIG['TABLE_PICTURES']} WHERE approved = 'YES' AND hits > 0  $ALBUM_SET");
            $nbEnr = mysql_fetch_row($result);
            $count = $nbEnr[0];
            mysql_free_result($result);
            if ($select_columns != '*') $select_columns .= ', hits, aid';
            $result = db_query("SELECT $select_columns FROM {$CONFIG['TABLE_PICTURES']} WHERE approved = 'YES'AND hits > 0 $ALBUM_SET ORDER BY hits DESC $limit");
            $rowset = db_fetch_rowset($result);
            mysql_free_result($result);
            if ($set_caption) foreach ($rowset as $key => $row) {
                $caption = "<span class=\"thumb_caption\">" . sprintf($lang_get_pic_data['n_views'], $row['hits']) . '</span>';
                $rowset[$key]['caption_text'] = $caption;
            } 
            return $rowset;
            break;
        case 'toprated': // Top rated pictures
            $result = db_query("SELECT count(*) FROM {$CONFIG['TABLE_PICTURES']} WHERE approved = 'YES' AND votes >= " . $CONFIG['min_votes_for_rating'] . " $ALBUM_SET");
            $nbEnr = mysql_fetch_row($result);
            $count = $nbEnr[0];
            mysql_free_result($result);

            if ($select_columns != '*') $select_columns .= ', pic_rating, votes';

            $result = db_query("SELECT $select_columns FROM {$CONFIG['TABLE_PICTURES']} WHERE approved = 'YES' AND votes >= '{$CONFIG['min_votes_for_rating']}' $ALBUM_SET ORDER BY ROUND((pic_rating+1)/2000) DESC, votes DESC $limit");
            $rowset = db_fetch_rowset($result);
            mysql_free_result($result);

            if ($set_caption) foreach ($rowset as $key => $row) {
                if (defined('THEME_HAS_RATING_GRAPHICS')) {
                    $theme_prefix = "$CONFIG[theme]/";
                } else {
                    $theme_prefix = '';
                } 
                $caption = "<span class=\"thumb_caption\">" . '<img src="' . $CPG_M_DIR . '/' . $theme_prefix . 'images/rating' . round($row['pic_rating'] / 2000) . '.gif" align="absmiddle"/>' . '<br />' . sprintf($lang_get_pic_data['n_votes'], $row['votes']) . '</span>';
                $rowset[$key]['caption_text'] = $caption;
            } 
            return $rowset;
            break;
        case 'lasthits': // Last viewed pictures
            $result = db_query("SELECT COUNT(*) from {$CONFIG['TABLE_PICTURES']} WHERE approved = 'YES' $ALBUM_SET");
            $nbEnr = mysql_fetch_row($result);
            $count = $nbEnr[0];
            mysql_free_result($result);

            if ($select_columns != '*') $select_columns .= ', UNIX_TIMESTAMP(mtime) as mtime, aid';

            $result = db_query("SELECT $select_columns FROM {$CONFIG['TABLE_PICTURES']} WHERE approved = 'YES' $ALBUM_SET ORDER BY mtime DESC $limit");
            $rowset = db_fetch_rowset($result);
            mysql_free_result($result);

            if ($set_caption) foreach ($rowset as $key => $row) {
                $caption = "<span class=\"thumb_caption\">" . localised_date($row['mtime'], $lasthit_date_fmt) . '</span>';
                $rowset[$key]['caption_text'] = $caption;
            } 
            return $rowset;
            break;
        case 'random': // Random pictures
            $result = db_query("SELECT COUNT(*) from {$CONFIG['TABLE_PICTURES']} WHERE approved = 'YES' $ALBUM_SET");
            $nbEnr = mysql_fetch_row($result);
            $pic_count = $nbEnr[0];
            mysql_free_result($result);
            if ($select_columns != '*') $select_columns .= ', aid'; 
            // if we have more than 1000 pictures, we limit the number of picture returned
            // by the SELECT statement as ORDER BY RAND() is time consuming
            if ($pic_count > 1000) {
                $result = db_query("SELECT COUNT(*) from {$CONFIG['TABLE_PICTURES']} WHERE approved = 'YES'");
                $nbEnr = mysql_fetch_row($result);
                $total_count = $nbEnr[0];
                mysql_free_result($result);

                $granularity = floor($total_count / RANDPOS_MAX_PIC);
                $cor_gran = ceil($total_count / $pic_count);
                srand(time());
                for ($i = 1; $i <= $cor_gran; $i++) $random_num_set = rand(0, $granularity) . ', ';
                $random_num_set = substr($random_num_set, 0, -2);
                $result = db_query("SELECT $select_columns FROM {$CONFIG['TABLE_PICTURES']} WHERE  randpos IN ($random_num_set) AND approved = 'YES' $ALBUM_SET ORDER BY RAND() LIMIT $limit2");
            } else {
                $result = db_query("SELECT $select_columns FROM {$CONFIG['TABLE_PICTURES']} WHERE approved = 'YES' $ALBUM_SET ORDER BY RAND() LIMIT $limit2");
            } 
            $rowset = array();
            while ($row = mysql_fetch_array($result)) {
                $row['caption_text'] = '';
                $rowset[ - $row['pid']] = $row;
            } 
            mysql_free_result($result);
            return $rowset;
            break;
        case 'search': // Search results
            if (isset($USER['search'])) {
                $search_string = $USER['search'];
            } else {
                $search_string = '';
            } 

            if (substr($search_string, 0, 3) == '###') {
                $query_all = 1;
                $search_string = substr($search_string, 3);
            } else {
                $query_all = 0;
            } 
            if (!$ALBUM_SET && !$CURRENT_CAT_NAME) $album_name .= ' - "' . strtr($search_string, $HTML_SUBST) . '"';

            include 'search.inc.php';
            return $rowset;
            break;
        case 'lastalb': // Last albums to which uploads
            $LA_ALBUM_SET = str_replace("AND aid", "AND " . $CONFIG['TABLE_PICTURES'] . ".aid" , $ALBUM_SET);

            $result = db_query("SELECT COUNT(*) from {$CONFIG['TABLE_PICTURES']} WHERE approved = 'YES' $LA_ALBUM_SET");
            $nbEnr = mysql_fetch_row($result);
            $count = $nbEnr[0];
            mysql_free_result($result);

            $result = db_query("SELECT *,{$CONFIG['TABLE_ALBUMS']}.title AS title,{$CONFIG['TABLE_ALBUMS']}.aid AS aid  FROM {$CONFIG['TABLE_PICTURES']},{$CONFIG['TABLE_ALBUMS']} WHERE {$CONFIG['TABLE_PICTURES']}.aid = {$CONFIG['TABLE_ALBUMS']}.aid AND approved = 'YES' $LA_ALBUM_SET GROUP  BY {$CONFIG['TABLE_PICTURES']}.aid ORDER BY {$CONFIG['TABLE_PICTURES']}.ctime DESC $limit");
            $rowset = db_fetch_rowset($result);
            mysql_free_result($result);

            if ($set_caption) foreach ($rowset as $key => $row) {
                $caption = "<span class=\"thumb_caption\">" . $row['title'] . " - " . localised_date($row['ctime'], $lastup_date_fmt) . '</span>';
                $rowset[$key]['caption_text'] = $caption;
            } 
            return $rowset;
            break;
        case 'favpics': // Favourite Pictures
            // $album_name = $lang_meta_album_names['favpics'];
            if (count($FAVPICS) > 0) {
                $favs = implode(",", $FAVPICS);
                $result = db_query("SELECT COUNT(*) from {$CONFIG['TABLE_PICTURES']} WHERE approved = 'YES' AND pid IN ($favs)");
                $nbEnr = mysql_fetch_array($result);
                $count = $nbEnr[0];
                mysql_free_result($result);

                $select_columns = '*';

                $result = db_query("SELECT $select_columns FROM {$CONFIG['TABLE_PICTURES']} WHERE approved = 'YES'AND pid IN ($favs) $limit");
                $rowset = db_fetch_rowset($result);
                mysql_free_result($result);

                if ($set_caption) foreach ($rowset as $key => $row) {
                    $caption = $rowset[$key]['title'] ? "<span class=\"thumb_caption\">" . ($rowset[$key]['title']) . "</span>" : '';
                    $rowset[$key]['caption_text'] = $caption;
                } 
                return $rowset;
            } else return null;
            break;

        default : // Invalid meta album
            cpg_die(ERROR, $lang_errors['non_exist_ap'], __FILE__, __LINE__);
    } 
} // End of get_pic_data
// Get the name of an album
function get_album_name($aid)
{
    global $CONFIG;
    global $lang_errors;
    $result = db_query("SELECT title from {$CONFIG['TABLE_ALBUMS']} WHERE aid='$aid'");
    $count = mysql_num_rows($result);
    if ($count > 0) {
        $row = mysql_fetch_array($result);
        return $row['title'];
    } else {
        cpg_die($lang_errors['non_exist_ap']);
    } 
} 
// Return the name of a user
function get_username($uid)
{
    global $CONFIG, $field_user_name, $field_user_id;
    $result = db_query("SELECT $field_user_name FROM {$CONFIG['TABLE_USERS']} WHERE $field_user_id = '" . $uid . "'");
    $count = mysql_num_rows($result);
    if ($count > 0) {
        $row = mysql_fetch_array($result);
        return $row['username'];
    } else {
        return '';
    } 
} 
// Return the ID of a user
function get_userid($user_name)
{
    global $CONFIG, $field_user_id, $field_user_name;

    $user_name = addslashes($user_name); 
    // if ($user_id<2) {
    // return 0;
    // } else {
    $result = db_query("SELECT $field_user_id FROM {$CONFIG['TABLE_USERS']} WHERE $field_user_name = '" . $user_name . "'");
    return $result; 
    // }
} 
// Return the total number of comments for a certain picture
function count_pic_comments($pid, $skip = 0)
{
    global $CONFIG;
    $result = db_query("SELECT count(*) from {$CONFIG['TABLE_COMMENTS']} where pid=$pid and msg_id!=$skip");
    $nbEnr = mysql_fetch_array($result);
    $count = $nbEnr[0];
    mysql_free_result($result);

    return $count;
} 
// Add 1 everytime a picture is viewed.
function add_hit($pid)
{
    global $CONFIG;

    db_query("UPDATE {$CONFIG['TABLE_PICTURES']} SET hits=hits+1 WHERE pid='$pid'");
} 

// Build the breadcrumb array
function set_breadcrumb($lasturl = 0)
{
    global $CONFIG, $CPG_M_URL, $CPG_URL, $album, $cat, $field_user_name, $field_user_id, $lang_meta_album_names;
    $breadcrumb = array();
    $aid = $album;
    if ($cat < 0 && $cat != -$aid) {
        $aid = -$cat;
        $lasturl = 1;
    }
    if (is_numeric($aid) && $aid > 0) {
        $result = db_query("SELECT aid AS id, title, category AS parent FROM {$CONFIG['TABLE_ALBUMS']} WHERE aid = ".$aid);
        if (mysql_num_rows($result) > 0) {
            $row = mysql_fetch_array($result);
            $row['last'] = !$lasturl;
            $row['album'] = 1;
            $breadcrumb[] = $row;
            mysql_free_result($result);
        }
    }
    else if (is_numeric($cat) && $cat > 0) {
        if ($cat > FIRST_USER_CAT) {
            $result = db_query("SELECT $field_user_name AS title FROM {$CONFIG['TABLE_USERS']} WHERE $field_user_id = " . ($cat - FIRST_USER_CAT));
            if (mysql_num_rows($result) != 0) {
                $row = mysql_fetch_array($result);
                $row['id'] = $cat;
                $row['parent'] = 1;
                $row['last'] = !$lasturl;
                $breadcrumb[] = $row;
                mysql_free_result($result);
            }
        }
        else {
            $result = db_query("SELECT cid as id, parent, catname AS title FROM {$CONFIG['TABLE_CATEGORIES']} WHERE cid='$cat'");
            if (mysql_num_rows($result) > 0) {
                $row = mysql_fetch_array($result);
                $row['last'] = !$lasturl;
                $breadcrumb[] = $row;
                mysql_free_result($result);
            }
        }
    }
    get_breadcrumb($breadcrumb);
    $navigation = '<a class="statlink" id="statlink" href="'.$CPG_M_URL.'">' . $CONFIG['gallery_name'] . '</a>';
    foreach($breadcrumb as $crumb) {
        if ($crumb['last']) $navigation .= " > ".$crumb['title'];
        elseif ($crumb['album']) $navigation .= " > <a class=\"statlink\" id=\"statlink\" href=\"$CPG_URL&file=thumbnails&album=".$crumb['id']."\">".$crumb['title']."</a>";
        else $navigation .= " > <a class=\"statlink\" id=\"statlink\" href=\"$CPG_M_URL&cat=".$crumb['id']."\">".$crumb['title']."</a>";
    }
    if (!is_numeric($album)) switch ($album) {
        case 'lastup':
        case 'lastcom':
        case 'topn':
        case 'toprated':
        case 'search':
        case 'random':
            $navigation .= " > ".$lang_meta_album_names[$album];
            break;
    }
    if ($navigation == "") $navigation = "> Coppermine";
    $dummy = array();
    theme_display_breadcrumb($navigation, $dummy);
}

// Get the breadcrumb array
function get_breadcrumb(&$breadcrumb)
{
    global $CONFIG, $field_user_name, $field_user_id;
    if (!$breadcrumb) return;
    $last = count($breadcrumb);
    if ($breadcrumb[0]['parent'] == 0) return;
    if ($breadcrumb[$last-1]['parent'] > FIRST_USER_CAT) {
        $cat = $breadcrumb[$last-1]['parent'];
        $result = db_query("SELECT $field_user_name AS title FROM {$CONFIG['TABLE_USERS']} WHERE $field_user_id = " . ($cat - FIRST_USER_CAT));
        if (mysql_num_rows($result) > 0) {
            $row = mysql_fetch_array($result);
            $row['id'] = $cat;
            $row['parent'] = 1;
            $breadcrumb[] = $row;
            mysql_free_result($result);
            get_breadcrumb($breadcrumb);
        }
    }

    $sql = "SELECT aid, title FROM {$CONFIG['TABLE_ALBUMS']} WHERE category='" . (FIRST_USER_CAT + $user_id) . "' ORDER BY title";

    $result = db_query("SELECT cid AS id, catname AS title, parent FROM {$CONFIG['TABLE_CATEGORIES']} WHERE cid=".$breadcrumb[$last-1]['parent']);
    if (mysql_num_rows($result) > 0) {
        $row = mysql_fetch_array($result);
        $breadcrumb[] = $row;
        mysql_free_result($result);
        if ($breadcrumb[$last]['parent'] != 0) get_breadcrumb($breadcrumb);
        else {
            $breadcrumb = array_reverse($breadcrumb);
            return;
        }
    }
}

// Build the breadcrumb
function breadcrumb($cat, &$breadcrumb, &$BREADCRUMB_TEXT)
{
    global $album, $lang_errors, $lang_list_categories, $lang_meta_album_names;
    global $CONFIG, $CURRENT_ALBUM_DATA, $CURRENT_CAT_NAME, $CPG_URL;
    if (($cat == 0) && $album != '') {
        if (is_numeric($album)) {
            $result = db_query("SELECT title FROM {$CONFIG['TABLE_ALBUMS']} WHERE aid = '" . $album . "'");
            if (mysql_num_rows($result) == 0) cpg_die(CRITICAL_ERROR, $lang_errors['non_exist_cat'], __FILE__, __LINE__);
            $row = mysql_fetch_array($result);
            $breadcrumb = '<a class="statlink" href="' . $CPG_URL . '">' . _HOME . '</a> > ' . $row["title"] . ' ';
        } else {
            $breadcrumb = '<a class="statlink" href="' . $CPG_URL . '">' . _HOME . '</a>' . $breadcrumb . ' > ' . $BREADCRUMB_TEXT . ' ';
        } 
        $BREADCRUMB_TEXT = _HOME;
    } else if ($cat > 0) {
        $breadcrumb_array = array();
        if ($cat >= FIRST_USER_CAT) {
            $user_name = get_username($cat - FIRST_USER_CAT);
            $user_id = get_userid($user_name);
            if ($user_id < 2) $user_name = 'Mr. X';

            $breadcrumb_array[] = array($cat, $user_name); //$row['user_name']
            $CURRENT_CAT_NAME = sprintf($lang_list_categories['xx_s_gallery'], $user_name);
            $row['parent'] = 1;
        } else {
            $result = db_query("SELECT catname, parent FROM {$CONFIG['TABLE_CATEGORIES']} WHERE cid = '$cat'");
            if (mysql_num_rows($result) == 0) cpg_die(CRITICAL_ERROR, $lang_errors['non_exist_cat'], __FILE__, __LINE__);
            $row = mysql_fetch_array($result);

            $breadcrumb_array[] = array($cat, $row['catname']);
            $CURRENT_CAT_NAME = $row['catname'];
            mysql_free_result($result);
        } while ($row['parent'] != 0) {
            $result = db_query("SELECT cid, catname, parent FROM {$CONFIG['TABLE_CATEGORIES']} WHERE cid = '{$row['parent']}'");
            if (mysql_num_rows($result) == 0) cpg_die(CRITICAL_ERROR, $lang_errors['orphan_cat'], __FILE__, __LINE__);
            $row = mysql_fetch_array($result);

            $breadcrumb_array[] = array($row['cid'], $row['catname']);
            mysql_free_result($result);
        } // while 
        // if (($album!='')&&(!is_numeric($album)){
        // $result = db_query("SELECT title FROM {$CONFIG['TABLE_ALBUMS']} WHERE aid = $album");
        // $row = mysql_fetch_array($result);
        // mysql_free_result($result);
        // $breadcrumb_array[] = array('', $lang_meta_album_names[$album]);
        // }
        $breadcrumb_array = array_reverse($breadcrumb_array);
        $breadcrumb = '<a class="statlink" href="' . $CPG_URL . '">' . _HOME . '</a>';
        $BREADCRUMB_TEXT = _HOME;

        foreach ($breadcrumb_array as $category) {
            $link = '<a class="statlink" href="' . $CPG_URL . '&cat=' . $category[0] . '">' . $category[1] . '</a>';
            $breadcrumb .= ' > ' . $link;
            $BREADCRUMB_TEXT .= ' > ' . $category[1];
        } 
        // Add Link for album if $album is set
        if (is_numeric($album)) {
            $link = '<a class="statlink" href="' . $CPG_URL . '&file=thumbnails&album=' . $album . '>' . $CURRENT_ALBUM_DATA["title"] . '</a>';
            $breadcrumb .= ' > ' . $link;
            $BREADCRUMB_TEXT .= ' > ' . $CURRENT_ALBUM_DATA['title'];
        } 
    } 
} 

/**
 */
// Compute image geometry based on max width / height
function compute_img_size($width, $height, $max)
{
    global $CONFIG;
    $thumb_use = $CONFIG['thumb_use'];
    if ($thumb_use == 'ht') {
        $ratio = $height / $max;
    } elseif ($thumb_use == 'wd') {
        $ratio = $width / $max;
    } else {
        $ratio = max($width, $height) / $max;
    } 
    if ($ratio > 1.0) {
        $image_size['reduced'] = true;
    } 
    $ratio = max($ratio, 1.0);
    $image_size['width'] = ceil($width / $ratio);
    $image_size['height'] = ceil($height / $ratio);
    $image_size['geom'] = 'width="' . $image_size['width'] . '" height="' . $image_size['height'] . '"';

    return $image_size;
} 
// exactly how in appears in cpg1.2.0RC2 doesn't work
function display_film_strip($album, $cat, $pos)
{
    global $CONFIG, $AUTHORIZED, $HTTP_GET_VARS;
    global $album_date_fmt, $lang_display_thumbnails, $lang_errors, $lang_byte_units;
    $max_item = $CONFIG['max_film_strip_items']; 
    // $thumb_per_page = $pos+$CONFIG['max_film_strip_items'];
    $thumb_per_page = $max_item * 2;
    $l_limit = max(0, $pos - $CONFIG['max_film_strip_items']);
    $new_pos = max(0, $pos - $l_limit);
    $pic_data = get_pic_data($album, $thumb_count, $album_name, $l_limit, $thumb_per_page);
    if (count($pic_data) < $max_item) {
        $max_item = count($pic_data);
    } 
    $lower_limit = 3;
    if (!isset($pic_data[$new_pos + 1])) {
        $lower_limit = $new_pos - $max_item + 1;
    } else if (!isset($pic_data[$new_pos + 2])) {
        $lower_limit = $new_pos - $max_item + 2;
    } else if (!isset($pic_data[$new_pos-1])) {
        $lower_limit = $new_pos;
    } else {
        $hf = $max_item / 2;
        $ihf = (int)($max_item / 2);
        if ($new_pos > $hf) {{ // if($max_item%2==0) {
                // $lower_limit=
                // } else {
                $lower_limit = $new_pos - $ihf;
            } 
        } elseif ($new_pos < $hf) {
            $lower_limit = 0;
        } 
    } 
    $pic_data = array_slice($pic_data, $lower_limit, $max_item);
    $i = $l_limit;
    if (count($pic_data) > 0) {
        foreach ($pic_data as $key => $row) {
            $hi = (($pos == ($i + $lower_limit)) ? '1': '');
            $i++;

            $image_size = compute_img_size($row['pwidth'], $row['pheight'], $CONFIG['thumb_width']);

            if ($CONFIG['seo_alts'] == 0) {
                $pic_title = $lang_display_thumbnails['filename'] . $row['filename'] . "\n" . $lang_display_thumbnails['filesize'] . ($row['filesize'] >> 10) . $lang_byte_units[1] . "\n" . $lang_display_thumbnails['dimensions'] . $row['pwidth'] . "x" . $row['pheight'] . "\n" . $lang_display_thumbnails['date_added'] . localised_date($row['ctime'], $album_date_fmt);
            } else {
                if ($row['title'] != '') {
                    $pic_title = $row['title'];
                    if ($row['keywords'] != '') {
                        $pic_title .= "\n";
                        $pic_title .= $row['keywords'];
                    } 
                } elseif ($row['keywords'] != '') {
                    $pic_title = $row['keywords'];
                } else {
                    $pic_title = substr($row['filename'], 0, -4);
                } 
            } 
            stripslashes($pic_title);
            $p = $i - 1 + $lower_limit;
            $p = ($p < 0 ? 0 : $p);
            $thumb_list[$i]['pos'] = $key < 0 ? $key : $p; 
            // class=\"image$hi\"
            if ($CONFIG['seo_alts'] == 0) {
                $thumb_list[$i]['image'] = "<img src=\"" . get_pic_url($row, 'thumb') . "\" class=\"image\" {$image_size['geom']} border=\"0\" alt=\"{$row['filename']}\" title=\"$pic_title\"></a>";
            } else {
                $thumb_list[$i]['image'] = "<img src=\"" . get_pic_url($row, 'thumb') . "\" class=\"image\" {$image_size['geom']} border=\"0\" alt=\"$pic_title\" title=\"$pic_title\"></a>";
            } 
            $thumb_list[$i]['caption'] = $row['caption_text'];
            $thumb_list[$i]['admin_menu'] = '';
        } 
        return theme_display_film_strip($thumb_list, $thumb_count, $album_name, $album, $cat, $pos, is_numeric($album));
    } else {
        theme_no_img_to_display($album_name);
    } 
} //end display filmstrip
// Prints thumbnails of pictures in an album
function display_thumbnails($album, $cat, $page, $thumbcols, $thumbrows, $display_tabs)
{
    global $CONFIG, $AUTHORIZED, $HTTP_GET_VARS;
    global $album_date_fmt, $lang_display_thumbnails, $lang_errors, $lang_byte_units;

    $thumb_per_page = $thumbcols * $thumbrows;
    $lower_limit = ($page-1) * $thumb_per_page;
    $pic_data = get_pic_data($album, $thumb_count, $album_name, $lower_limit, $thumb_per_page);
    $total_pages = ceil($thumb_count / $thumb_per_page);
    $i = 0;
    if (count($pic_data) > 0) {
        foreach ($pic_data as $key => $row) {
            $i++;

            $image_size = compute_img_size($row['pwidth'], $row['pheight'], $CONFIG['thumb_width']);
            if ($CONFIG['seo_alts'] == 0) {
                $pic_title = $lang_display_thumbnails['filename'] . $row['filename'] . "\n" . $lang_display_thumbnails['filesize'] . ($row['filesize'] >> 10) . $lang_byte_units[1] . "\n" . $lang_display_thumbnails['dimensions'] . $row['pwidth'] . "x" . $row['pheight'] . "\n" . $lang_display_thumbnails['date_added'] . localised_date($row['ctime'], $album_date_fmt);
            } else {
                if ($row['title'] != '') {
                    $pic_title = $row['title'];
                    if ($row['keywords'] != '') {
                        $pic_title .= "\n";
                        $pic_title .= $row['keywords'];
                    } 
                } elseif ($row['keywords'] != '') {
                    $pic_title = $row['keywords'];
                } else {
                    $pic_title = substr($row['filename'], 0, -4);
                } 
            } 
            $pic_title = stripslashes($pic_title);
            $thumb_list[$i]['pos'] = $key < 0 ? $key : $i - 1 + $lower_limit; 
            // class=\"image$hi\"
            if ($CONFIG['seo_alts'] == 0) {
                $thumb_list[$i]['image'] = "<img src=\"" . get_pic_url($row, 'thumb') . "\" class=\"image\" {$image_size['geom']} border=\"0\" alt=\"{$row['filename']}\" title=\"$pic_title\"></a>";
            } else {
                $thumb_list[$i]['image'] = "<img src=\"" . get_pic_url($row, 'thumb') . "\" class=\"image\" {$image_size['geom']} border=\"0\" alt=\"$pic_title\" title=\"$pic_title\"></a>";
            } 
            $thumb_list[$i]['caption'] = $row['caption_text'];
            $thumb_list[$i]['admin_menu'] = '';
        } 
        theme_display_thumbnails($thumb_list, $thumb_count, $album_name, $album, $cat, $page, $total_pages, is_numeric($album), $display_tabs);
    } else {
        // cpg_die("Please Register",$lang_errors[access_denied]);
        theme_no_img_to_display($album_name); 
        // theme_notallowed_private_album($album_name);
    } 
} 
// Return the url for a picture, allows to have pictures spreaded over multiple servers
function get_pic_url(&$pic_row, $mode)
{
    global $CONFIG;
    static $pic_prefix = array();
    static $url_prefix = array();
    if (!count($pic_prefix)) {
        $pic_prefix = array('thumb' => $CONFIG['thumb_pfx'],
            'normal' => $CONFIG['normal_pfx'],
            'fullsize' => ''
            );
        $url_prefix = array(0 => $CONFIG['fullpath'],
            );
    } 
    return path2url($pic_row['filepath'] . $pic_prefix[$mode] . $pic_row['filename']);
} 

function print_debug()
{
    global $HTTP_GET_VARS, $HTTP_POST_VARS, $HTTP_SERVER_VARS, $CPG_URL, $CPG_M_DIR;
    global $USER, $ALBUM_SET, $FORBIDDEN_SET, $CONFIG, $time_start, $query_stats,$first_install_M_DIR;
    global $name;
    echo "<br>";
    if ($CONFIG['debug_mode'] AND USER_IS_ADMIN) {
        $time_end = getmicrotime();
        $time = round($time_end - $time_start, 3);
        $query_count = count($query_stats);
        $query_times = '';
        $total_query_time = 0;
        foreach ($query_stats as $qtime) {
            $query_times .= round($qtime, 3) . "s ";
            $total_query_time += $qtime;
        } 
        $total_query_time = round($total_query_time, 3);
        OpenTable();
        echo '<table width="100%">';
        print '<caption> </caption>';
        print '<tr><td class="tableh1" colspan="2"><span class="statlink"><b> </b></span></td></tr>';
        print '<tr><td>';
        print "õ XCommunity Ų/:</td><td> $GLOBALS[ThemeSel]";
        print '</td></tr><tr class="code"><td>';
        print "XCommunity :</td><td> $GLOBALS[Version_Num]";
        print '</td></tr><tr><td>';
        print ' </td><td>' . $CPG_M_DIR;
        print '</td></tr><tr class="code"><td>';
        print 'ũ</td><td>' . $CPG_URL;
        print '</td></tr><tr><td>';
        print "Coppermine CPG & XCommunity Ų/:</td><td> $CONFIG[theme]";
        print '</td></tr>';
        print '<tr><td class="tableh1" colspan="2"><span class="statlink"><b>$_SERVER vars</b></span></td></tr>';
        print '<tr><td>';
        print "DOCUMENT_ROOT:</td><td> $_SERVER[DOCUMENT_ROOT]";
        print '</td></tr><tr class="code"><td>';
        if (isset($_SERVER['HTTP_ACCEPT_CHARSET'])) {
            print "HTTP_ACCEPT_CHARSET:</td><td> $_SERVER[HTTP_ACCEPT_CHARSET]";
            print '</td></tr><tr><td>';
        } 
        print "HTTP_ACCEPT_LANGUAGE:</td><td> $_SERVER[HTTP_ACCEPT_LANGUAGE]";
        print '</td></tr><tr class="code"><td>';
        print "HTTP_USER_AGENT:</td><td> $_SERVER[HTTP_USER_AGENT]";
        print '</td></tr><tr><td>';
        print "SCRIPT_FILENAME:</td><td> $_SERVER[SCRIPT_FILENAME]";
        print '</td></tr><tr class="code"><td>';
        print '</td></tr><tr><td>';
        print "QUERY_STRING:</td><td> $_SERVER[QUERY_STRING]";
        print '</td></tr><tr class="code"><td>';
        print "PHP_SELF:</td><td> $_SERVER[PHP_SELF]";
        print '</td></tr>';
        print '<tr><td class="tableh1" colspan="2"><span class="statlink"><b>CPG </b></span></td></tr>';
        print '<tr><td>';
        print 'TABLE_PICTURES</td><td>' . $CONFIG['TABLE_PICTURES'];
        print '</td></tr><tr class="code"><td>';
        print 'TABLE_ALBUMS</td><td>' . $CONFIG['TABLE_ALBUMS'];
        print '</td></tr><tr><td>';
        print 'TABLE_COMMENTS</td><td>' . $CONFIG['TABLE_COMMENTS'];
        print '</td></tr><tr class="code"><td>';
        print 'TABLE_CATEGORIES</td><td>' . $CONFIG['TABLE_CATEGORIES'];
        print '</td></tr><tr><td>';
        print 'TABLE_CONFIG</td><td>' . $CONFIG['TABLE_CONFIG'];
        print '</td></tr><tr class="code"><td>';
        print 'TABLE_USERGROUPS</td><td>' . $CONFIG['TABLE_USERGROUPS'];
        print '</td></tr><tr><td>';
        print 'TABLE_VOTES</td><td>' . $CONFIG['TABLE_VOTES'];
        print '</td></tr><tr class="code"><td>';
        print 'TABLE_USERS</td><td>' . $CONFIG['TABLE_USERS'];
        print '</td></tr><tr><td>';
        print 'allow_private_albums</td><td>' . $CONFIG['allow_private_albums'];
        print '</td></tr><tr class="code"><td>';
        print 'Site url (ecards_more_pic_target)</td><td>' . $CONFIG['ecards_more_pic_target'];
        print '</td></tr><tr><td>';
        print 'fullpath</td><td>' . $CONFIG['fullpath'];
        print '</td></tr><tr class="code"><td>';
        print 'ALBUM_SET</td><td>' . $ALBUM_SET;
        print '</td></tr><tr><td>';
        print 'FORBIDDEN_SET</td><td>' . $FORBIDDEN_SET;
        print '</td></tr><tr class="code"><td>';
        print 'Language Directory</td><td>' . $first_install_M_DIR;
        print '</td></tr>';
        print '<tr><td class="tableh1" colspan="2"><span class="statlink"><b>Queries</b></span></td></tr>';
        print '<tr><td valign="top">';
        echo "GET</td><td><pre>";
        print_r($HTTP_GET_VARS);
        print '</pre></td></tr><tr class="code"><td valign="top">';
        print 'POST</td><td><pre>';
        print_r($HTTP_POST_VARS);
        echo "</pre></td></tr><td align=\"center\" colspan=\"2\">";
        echo <<<EOT
                 : <b>$time</b> - <b>$query_count</b>óð: <b>$total_query_time</b> - /ð/ٹ Ʈ : $ALBUM_SET
EOT;
        echo "</td></tr></table>";
        CloseTable();
        echo "<br>";
        if ($CONFIG['advanced_debug_mode']) {
            // change to advanced_debug_mode
            OpenTable();
            print '<table width="100%"><caption>  </caption>';
            echo "<tr><td class=\"tableb\" colspan=\"2\">";
            include($CPG_M_DIR . "/phpinfo.php");
            echo "</td></tr></table>";
            CloseTable();
        } 
    } 
} 

?>
