<?php
/***************************************************************************
 *                         album_update_v1_to_v2.php
 *                            -------------------
 *   begin                : Sunday, February 02, 2003
 *   copyright            : (C) 2003 Smartor
 *   email                : smartor_xp@hotmail.com
 *
 *   $Id: album_update_v1_to_v2.php,v 1.0.2 2003/03/29 10:41:22 ngoctu Exp $
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

@set_time_limit(3600); // <grin>

define('IN_PHPBB', true);

$phpbb_root_path = './';
include($phpbb_root_path.'extension.inc');
include($phpbb_root_path.'common.'.$phpEx);	
	
$userdata = session_pagestart($user_ip, PAGE_INDEX);
init_userprefs($userdata);

include($phpbb_root_path.'includes/db.'.$phpEx);

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html;">
<meta http-equiv="Content-Style-Type" content="text/css">
<style type="text/css">
<!--

font,th,td,p,body { font-family: "Courier New", courier; font-size: 11pt }

a:link,a:active,a:visited { color : #006699; }
a:hover		{ text-decoration: underline; color : #DD6900;}

hr	{ height: 0px; border: solid #D1D7DC 0px; border-top-width: 1px;}

.maintitle,h1,h2	{font-weight: bold; font-size: 22px; font-family: "Trebuchet MS",Verdana, Arial, Helvetica, sans-serif; text-decoration: none; line-height : 120%; color : #000000;}

.ok {color:green}

-->
</style>
</head>
<body bgcolor="#FFFFFF" text="#000000" link="#006699" vlink="#5584AA">

<table width="100%" border="0" cellspacing="0" cellpadding="10" align="center"> 
	<tr>
		<td><table width="100%" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td align="center" width="100%" valign="middle"><span class="maintitle">Updating Photo Album Addon for phpBB2 from v1 to v2</span></td>
			</tr>
		</table></td>
	</tr>
</table>

<br clear="all" />

<?php

//
// First we will store the old database into the memory (ignore configuration data)
//
echo '<br /><b>Step 1: Backing up your old data... </b>';

$sql = "SELECT * FROM " . $table_prefix . "album";
if(!$result = $db->sql_query($sql))
{
	message_die(GENERAL_ERROR, "Could not query Album information", "", __LINE__, __FILE__, $sql);
}
while( $row = $db->sql_fetchrow($result) )
{
	$album_row[] = $row;
}

$sql = "SELECT * FROM " . $table_prefix . "album_cat";
if(!$result = $db->sql_query($sql))
{
	message_die(GENERAL_ERROR, "Could not query Album Categories information", "", __LINE__, __FILE__, $sql);
}
while( $row = $db->sql_fetchrow($result) )
{
	$album_cat_row[] = $row;
}

$sql = "DROP TABLE " . $table_prefix . "album";
if(!$result = $db->sql_query($sql))
{
	message_die(GENERAL_ERROR, "Could not drop Album table", "", __LINE__, __FILE__, $sql);
}

$sql = "DROP TABLE " . $table_prefix . "album_cat";
if(!$result = $db->sql_query($sql))
{
	message_die(GENERAL_ERROR, "Could not drop Album Categories table", "", __LINE__, __FILE__, $sql);
}

$sql = "DROP TABLE " . $table_prefix . "album_config";
if(!$result = $db->sql_query($sql))
{
	message_die(GENERAL_ERROR, "Could not drop Album Configuration table", "", __LINE__, __FILE__, $sql);
}

echo '<span class="ok"><b>DONE!</b></span><br /><br />';

//
// Here we dump in the schema of v2
//
echo '<br /><b>Step 2: Creating new tables... </b><br />';

include($phpbb_root_path.'includes/sql_parse.'.$phpEx);

$available_dbms = array(
	"mysql" => array(
		"SCHEMA" => "album_mysql", 
		"DELIM" => ";",
		"DELIM_BASIC" => ";",
		"COMMENTS" => "remove_remarks"
	), 
	"mysql4" => array(
		"SCHEMA" => "album_mysql", 
		"DELIM" => ";", 
		"DELIM_BASIC" => ";",
		"COMMENTS" => "remove_remarks"
	),
	"mssql" => array(
		"SCHEMA" => "album_mssql", 
		"DELIM" => "GO", 
		"DELIM_BASIC" => ";",
		"COMMENTS" => "remove_comments"
	),
	"mssql-odbc" =>	array(
		"SCHEMA" => "album_mssql", 
		"DELIM" => "GO",
		"DELIM_BASIC" => ";",
		"COMMENTS" => "remove_comments"
	),
	"postgres" => array(
		"LABEL" => "PostgreSQL 7.x",
		"SCHEMA" => "album_postgres", 
		"DELIM" => ";", 
		"DELIM_BASIC" => ";",
		"COMMENTS" => "remove_comments"
	)
);

$dbms_file = $available_dbms[$dbms]['SCHEMA'] . '.sql';

$remove_remarks = $available_dbms[$dbms]['COMMENTS'];;
$delimiter = $available_dbms[$dbms]['DELIM']; 
$delimiter_basic = $available_dbms[$dbms]['DELIM_BASIC']; 

if ( !($fp = @fopen($dbms_file, 'r')) )
{
	message_die(GENERAL_MESSAGE, "Can't open " . $dbms_file);
}

fclose($fp);

//
// process db schema & basic
//
$sql_query = @fread(@fopen($dbms_file, 'r'), @filesize($dbms_file));
$sql_query = preg_replace('/phpbb_/', $table_prefix, $sql_query);

$sql_query = $remove_remarks($sql_query);
$sql_query = split_sql_file($sql_query, $delimiter);

$sql_count = count($sql_query);

$errored = FALSE;

for($i = 0; $i < $sql_count; $i++)
{
	echo "Running :: " . $sql_query[$i];
	flush();

	if ( !($result = $db->sql_query($sql_query[$i])) )
	{
		$errored = true;
		$error = $db->sql_error();
		echo " -> <b>FAILED</b> ---> <u>" . $error['message'] . "</u><br /><br />\n\n";
	}
	else
	{
		echo " -> <b><span class=\"ok\">COMPLETED</span></b><br /><br />\n\n";
	}
}

echo '<span class="ok"><b>DONE!</b></span><br />';

//
// Insert old data
//
echo '<br /><b>Step 3: Inserting old data... </b><br />';

for( $i = 0; $i < count($album_row); $i++ )
{
	$sql = "INSERT INTO " . $table_prefix . "album (pic_id, pic_filename, pic_title, pic_user_id, pic_time, pic_cat_id)
			VALUES ('". $album_row[$i]['id'] ."', '". $album_row[$i]['filename'] ."', '". str_replace("'", "''", $album_row[$i]['title']) ."', '". $album_row[$i]['user_id'] ."', '". $album_row[$i]['timestamp'] ."', '". $album_row[$i]['cat_id'] ."')";
	if(!$result = $db->sql_query($sql))
	{
		$errored = TRUE;
		$error = $db->sql_error();
		echo $sql . " -> <b>FAILED</b> ---> <u>" . $error['message'] . "</u><br /><br />\n\n";
	}
}

for( $i = 0; $i < count($album_cat_row); $i++ )
{
	$sql = "INSERT INTO " . $table_prefix . "album_cat (cat_id, cat_title, cat_order)
			VALUES ('". $album_cat_row[$i]['cat_id'] ."', '". str_replace("'", "''", $album_cat_row[$i]['cat_title']) ."', '". (($i+1)*10) ."')";
	if(!$result = $db->sql_query($sql))
	{
		$errored = TRUE;
		$error = $db->sql_error();
		echo $sql . " -> <b>FAILED</b> ---> <u>" . $error['message'] . "</u><br /><br />\n\n";
	}
}

echo '<span class="ok"><b>DONE!</b></span><br />';

$message = '';

if ($errored)
{
	$message .= '<br />Some queries failed. Please contact me at <a href="http://smartor.is-root.com">http://smartor.is-root.com</a> we may solve your problems...<br />';
}
else
{
	$message .= '<br />Photo Album Tables updated successfully.<br />';
}

echo "\n<br />\n<b>UPGRADE COMPLETED!</b><br />\n";
echo $message . "<br />";
echo "<br /><b>NOW DELETE THIS FILE</b><br />\n";
echo "</body>";
echo "</html>";

?>