<?php
/***************************************************************************
 *                            weblog_db_update.php
 *                            --------------------
 *  This file makes changes to your databaseby running the SQL commands. Run
 *  this file if you are not comfortable with running the SQL commands 
 *  yourself. In order for this to work, it must be run in the root directory
 *  of phpBB2. After you've run this file, make sure you delete it.
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);

$sql = array(
"CREATE TABLE " . $table_prefix . "weblog_groups (group_id SMALLINT (5) UNSIGNED DEFAULT '0' NOT NULL, PRIMARY KEY(group_id))",
"CREATE TABLE " . $table_prefix . "weblog_config (config_name VARCHAR (255) NOT NULL, config_value VARCHAR (255) NOT NULL, PRIMARY KEY(config_name))",
"INSERT INTO " . $table_prefix . "weblog_config (config_name, config_value) VALUES ('config_id', '1')",
"INSERT INTO " . $table_prefix . "weblog_config (config_name, config_value) VALUES ('display_stats', '1')",
"INSERT INTO " . $table_prefix . "weblog_config (config_name, config_value) VALUES ('default_access', '0')",
"INSERT INTO " . $table_prefix . "weblog_config (config_name, config_value) VALUES ('default_entries', '5')",
"INSERT INTO " . $table_prefix . "weblog_config (config_name, config_value) VALUES ('default_name', '%s\'s Blog')",
"INSERT INTO " . $table_prefix . "weblog_config (config_name, config_value) VALUES ('default_desc', 'Welcome to my new blog!')",
"INSERT INTO " . $table_prefix . "weblog_config (config_name, config_value) VALUES ('default_comment', 'Comments: %s')",
"INSERT INTO " . $table_prefix . "weblog_config (config_name, config_value) VALUES ('default_post_comment', '(Post a comment)')",
"INSERT INTO " . $table_prefix . "weblog_config (config_name, config_value) VALUES ('weblogs_per_page', '10')",
"INSERT INTO " . $table_prefix . "weblog_config (config_name, config_value) VALUES ('weblog_sort', '1')",
"INSERT INTO " . $table_prefix . "weblog_config (config_name, config_value) VALUES ('weblog_order', 'desc')",
"INSERT INTO " . $table_prefix . "weblog_config (config_name, config_value) VALUES ('allow_advanced', '0')",
"INSERT INTO " . $table_prefix . "weblog_config (config_name, config_value) VALUES ('attachment_mod', '0')",
"INSERT INTO " . $table_prefix . "weblog_config (config_name, config_value) VALUES ('birthday_mod', '0')",
"INSERT INTO " . $table_prefix . "weblog_config (config_name, config_value) VALUES ('birthday_zodiac_mod', '0')",
"INSERT INTO " . $table_prefix . "weblog_config (config_name, config_value) VALUES ('gender_mod', '0')",
"INSERT INTO " . $table_prefix . "weblog_config (config_name, config_value) VALUES ('last_visit_mod', '0')",

"CREATE TABLE " . $table_prefix . "weblog_mood (mood_id SMALLINT (5) UNSIGNED NOT NULL AUTO_INCREMENT, image_url VARCHAR (100), mood VARCHAR (75), PRIMARY KEY(mood_id))",
"INSERT INTO " . $table_prefix . "weblog_mood (image_url, mood) VALUES ('mood_none.gif', '(none)')",
"INSERT INTO " . $table_prefix . "weblog_mood (image_url, mood) VALUES ('mood_angelic.gif', 'Angelic')",
"INSERT INTO " . $table_prefix . "weblog_mood (image_url, mood) VALUES ('mood_confused.gif', 'Confused')",
"INSERT INTO " . $table_prefix . "weblog_mood (image_url, mood) VALUES ('mood_cool.gif', 'Cool')",
"INSERT INTO " . $table_prefix . "weblog_mood (image_url, mood) VALUES ('mood_silly.gif', 'Silly')",
"INSERT INTO " . $table_prefix . "weblog_mood (image_url, mood) VALUES ('mood_verysad.gif', 'Very Sad')",
"INSERT INTO " . $table_prefix . "weblog_mood (image_url, mood) VALUES ('mood_shocked.gif', 'Shocked')",
"INSERT INTO " . $table_prefix . "weblog_mood (image_url, mood) VALUES ('mood_evil.gif', 'Evil')",
"INSERT INTO " . $table_prefix . "weblog_mood (image_url, mood) VALUES ('mood_love.gif', 'In Love')",
"INSERT INTO " . $table_prefix . "weblog_mood (image_url, mood) VALUES ('mood_amused.gif', 'Amused')",
"INSERT INTO " . $table_prefix . "weblog_mood (image_url, mood) VALUES ('mood_angry.gif', 'Angry')",
"INSERT INTO " . $table_prefix . "weblog_mood (image_url, mood) VALUES ('mood_neutral.gif', 'Neutral')",
"INSERT INTO " . $table_prefix . "weblog_mood (image_url, mood) VALUES ('mood_sick.gif', 'Sick')",
"INSERT INTO " . $table_prefix . "weblog_mood (image_url, mood) VALUES ('mood_scared.gif', 'Scared')",
"INSERT INTO " . $table_prefix . "weblog_mood (image_url, mood) VALUES ('mood_happy.gif', 'Happy')",
"INSERT INTO " . $table_prefix . "weblog_mood (image_url, mood) VALUES ('mood_fedup.gif', 'Fed Up With Life')",
"INSERT INTO " . $table_prefix . "weblog_mood (image_url, mood) VALUES ('mood_distorted.gif', 'Distorted')",
"INSERT INTO " . $table_prefix . "weblog_mood (image_url, mood) VALUES ('mood_hypnotized.gif', 'Hypnotized')",
"INSERT INTO " . $table_prefix . "weblog_mood (image_url, mood) VALUES ('mood_embarrased.gif', 'Embarrased')",
"INSERT INTO " . $table_prefix . "weblog_mood (image_url, mood) VALUES ('mood_sleepy.gif', 'Sleepy')",

"CREATE TABLE " . $table_prefix . "weblog_currently (currently_id SMALLINT (5) UNSIGNED NOT NULL AUTO_INCREMENT, image_url VARCHAR (100), currently VARCHAR (75), PRIMARY KEY(currently_id))",
"INSERT INTO " . $table_prefix . "weblog_currently (image_url, currently) VALUES ('currently_none.gif', '(none)')",
"INSERT INTO " . $table_prefix . "weblog_currently (image_url, currently) VALUES ('currently_eat.gif', 'Eating')",
"INSERT INTO " . $table_prefix . "weblog_currently (image_url, currently) VALUES ('currently_listen.gif', 'Listening to')",
"INSERT INTO " . $table_prefix . "weblog_currently (image_url, currently) VALUES ('currently_play.gif', 'Playing')",
"INSERT INTO " . $table_prefix . "weblog_currently (image_url, currently) VALUES ('currently_read.gif', 'Reading')",
"INSERT INTO " . $table_prefix . "weblog_currently (image_url, currently) VALUES ('currently_watch.gif', 'Watching')",
"INSERT INTO " . $table_prefix . "weblog_currently (image_url, currently) VALUES ('currently_work.gif', 'Working')",
"INSERT INTO " . $table_prefix . "weblog_currently (image_url, currently) VALUES ('currently_custom.gif', '(custom)')",

"CREATE TABLE " . $table_prefix . "weblog_styles(style_id SMALLINT(5) UNSIGNED NOT NULL AUTO_INCREMENT, style_name VARCHAR(100), style_dir VARCHAR(100), PRIMARY KEY(style_id))",

"ALTER TABLE " . $table_prefix . "users ADD user_weblog SMALLINT(5)",
"ALTER TABLE " . $table_prefix . "users ADD weblog_start_date INT(11) UNSIGNED",
"ALTER TABLE " . $table_prefix . "users ADD weblog_show_entries SMALLINT(5) UNSIGNED DEFAULT '5'",
"ALTER TABLE " . $table_prefix . "users ADD weblog_access SMALLINT(5) UNSIGNED DEFAULT '0'",
"ALTER TABLE " . $table_prefix . "users ADD weblog_access2 SMALLINT(5) UNSIGNED DEFAULT '0'",
"ALTER TABLE " . $table_prefix . "users ADD weblog_visible TINYINT(5) DEFAULT '1'",
"ALTER TABLE " . $table_prefix . "users ADD weblog_group SMALLINT(5) UNSIGNED DEFAULT '0'",
"ALTER TABLE " . $table_prefix . "users ADD weblog_show_profile TINYINT(4) NOT NULL DEFAULT '1'",
"ALTER TABLE " . $table_prefix . "users ADD weblog_show_desc TINYINT(4) NOT NULL DEFAULT '1'",
"ALTER TABLE " . $table_prefix . "users ADD weblog_contact_info TINYINT(4) NOT NULL DEFAULT '1'",
"ALTER TABLE " . $table_prefix . "users ADD weblog_show_info TINYINT(4) NOT NULL DEFAULT '1'",
"ALTER TABLE " . $table_prefix . "users ADD weblog_advanced TINYINT(1) NOT NULL DEFAULT '0'",
"ALTER TABLE " . $table_prefix . "users ADD weblog_style VARCHAR(30) DEFAULT ''",
"ALTER TABLE " . $table_prefix . "users ADD INDEX(user_weblog)",
"ALTER TABLE " . $table_prefix . "categories ADD cat_allow_weblogs TINYINT(1) UNSIGNED DEFAULT '0'",
"ALTER TABLE " . $table_prefix . "users ADD weblog_post_comment_name VARCHAR(255) DEFAULT '(Post a comment)'",
"ALTER TABLE " . $table_prefix . "users ADD weblog_comment_name VARCHAR(255) DEFAULT 'Comments: %s'",
"ALTER TABLE " . $table_prefix . "topics ADD topic_mood TINYINT(2) UNSIGNED NOT NULL DEFAULT '0'",
"ALTER TABLE " . $table_prefix . "topics ADD topic_auth TINYINT(4) UNSIGNED NOT NULL DEFAULT '0'",
"ALTER TABLE " . $table_prefix . "topics ADD topic_currently1 TINYINT(2) UNSIGNED NOT NULL DEFAULT '0'",
"ALTER TABLE " . $table_prefix . "topics ADD topic_currently2 VARCHAR(100) NOT NULL DEFAULT ''",
"ALTER TABLE " . $table_prefix . "posts ADD post_mood TINYINT(2) UNSIGNED NOT NULL DEFAULT '0'",
"ALTER TABLE " . $table_prefix . "posts ADD post_currently1 TINYINT(2) UNSIGNED NOT NULL DEFAULT '0'",
"ALTER TABLE " . $table_prefix . "posts ADD post_currently2 VARCHAR(100) NOT NULL DEFAULT ''",
"ALTER TABLE " . $table_prefix . "forums ADD forum_views INT(11) UNSIGNED DEFAULT '0'"
);

//
// Start session management
//
$userdata = session_pagestart($user_ip, PAGE_INDEX);
init_userprefs($userdata);
//
// End session management
//

if ( $userdata['user_level']!= ADMIN )
{
      message_die(GENERAL_ERROR, $lang['Not_Authorised']); 
}

$message = "<b>Running SQL queries...</b><br /><br />";

for ($i = 0; $i < count($sql); $i++)
{
	if( !($result = $db->sql_query($sql[$i])) )
	{
			$error = $db->sql_error();
			$message .= '<b><font color=#FF0000>[Error/Already Added]</font></b><b> line: '.($i+1).'</b>, '.$sql[$i].'<font color=#FF0000>' . $error['message'] . '</font><br />';
	}
	else
	{
		if ( $db->sql_affectedrows() )
		{
			$message .='<b><font color=#0000FF>[Added/Updated]</font></b><b> line: '.($i+1).'</b>, '.$sql[$i].'<br />';
		}
	}

}

message_die(GENERAL_MESSAGE, $message); 
?>