/*
 * Decompiled with CFR 0.152.
 */
package cookxml.common;

import cookxml.common.adder.CompoundAdder;
import cookxml.core.DecodeEngine;
import cookxml.core.TagLibrary;
import cookxml.core.adder.Adder;
import cookxml.core.exception.AdderException;
import cookxml.core.setter.Setter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class InheritableTagLibrary
extends TagLibrary {
    private final Map m_inheritMap;
    private final Adder m_parentAdder = new Adder(){

        public boolean add(String parentTag, Object parent, Object child, DecodeEngine decodeEngine) throws AdderException {
            LinkedList parentList = InheritableTagLibrary.this.getParentTags(parentTag);
            if (parentList == null) {
                return false;
            }
            Iterator iter = parentList.iterator();
            while (iter.hasNext()) {
                String tag = (String)iter.next();
                Adder adder = InheritableTagLibrary.this.getAdder(tag);
                if (adder == null || !adder.add(tag, parent, child, decodeEngine)) continue;
                return true;
            }
            return false;
        }
    };

    public InheritableTagLibrary() {
        this(null);
    }

    public InheritableTagLibrary(TagLibrary parentTagLibrary) {
        super(parentTagLibrary);
        this.m_inheritMap = new HashMap();
    }

    public void inheritTag(String parentTag, String thisTag) {
        LinkedList<String> list = (LinkedList<String>)this.m_inheritMap.get(thisTag);
        if (list == null) {
            list = new LinkedList<String>();
            this.m_inheritMap.put(thisTag, list);
            list.add(parentTag);
            return;
        }
        if (!list.contains(parentTag)) {
            list.add(parentTag);
        }
    }

    public Setter getSetter(String tag, String attr) {
        LinkedList parentList;
        Setter setter = super.getSetter(tag, attr);
        if (setter != null) {
            return setter;
        }
        if (tag == null) {
            tag = "";
        }
        if (attr == null) {
            attr = "";
        }
        if ((parentList = this.getParentTags(tag)) == null) {
            return null;
        }
        Iterator iter = parentList.iterator();
        while (iter.hasNext()) {
            String parentTag = (String)iter.next();
            setter = this.getSetter(parentTag, attr);
            if (setter == null) continue;
            return setter;
        }
        return null;
    }

    public Adder getAdder(String tag) {
        LinkedList parentList;
        Adder adder = super.getAdder(tag);
        if (adder != null) {
            return adder;
        }
        if (tag == null) {
            tag = "";
        }
        if ((parentList = this.getParentTags(tag)) == null || parentList.size() == 0) {
            return null;
        }
        Iterator iter = parentList.iterator();
        while (iter.hasNext()) {
            String parentTag = (String)iter.next();
            Adder newAdder = this.getAdder(parentTag);
            if (newAdder == null) continue;
            if (adder == null) {
                adder = newAdder;
                continue;
            }
            CompoundAdder tmpAdder = new CompoundAdder();
            tmpAdder.add(adder);
            tmpAdder.add(newAdder);
            adder = tmpAdder;
        }
        return adder;
    }

    public void addAdder(String tag, Adder adder) {
        Adder oldAdder;
        if (tag == null) {
            tag = "";
        }
        if ((oldAdder = super.getAdder(tag)) == null) {
            oldAdder = this.m_parentAdder;
        }
        if (oldAdder instanceof CompoundAdder) {
            ((CompoundAdder)oldAdder).add(adder);
        } else {
            super.setAdder(tag, CompoundAdder.getAdder(oldAdder, adder));
        }
    }

    public LinkedList getParentTags(String tag) {
        return (LinkedList)this.m_inheritMap.get(tag);
    }
}

