/*
 * Decompiled with CFR 0.152.
 */
package cookxml.common.converter;

import cookxml.core.DecodeEngine;
import cookxml.core.converter.Converter;
import cookxml.core.exception.ConverterException;
import java.text.DateFormat;
import java.util.Date;

public class DateConverter
implements Converter {
    private static final Converter s_instance = new DateConverter();

    public static Converter getInstance() {
        return s_instance;
    }

    private DateConverter() {
    }

    public Object convert(String value, DecodeEngine decodeEngine) throws ConverterException {
        try {
            if ("current".equals(value)) {
                return new Date(System.currentTimeMillis());
            }
            DateFormat df = DateFormat.getDateInstance();
            df.setLenient(true);
            return df.parse(value);
        }
        catch (Exception ex) {
            throw new ConverterException(decodeEngine, (Throwable)ex, this, value);
        }
    }
}

