/*
 * Decompiled with CFR 0.152.
 */
package cookxml.core;

import cookxml.core.DecodeEngine;
import cookxml.core.DefaultVarLookup;
import cookxml.core.IdReference;
import cookxml.core.TagLibrary;
import cookxml.core.VarLookup;
import cookxml.core.exception.CookXmlException;
import cookxml.core.exception.InvalidInputException;
import cookxml.core.exceptionhandler.DebugExceptionHandler;
import cookxml.core.exceptionhandler.ExceptionHandler;
import cookxml.core.stringhook.ResourceBundleStringHook;
import cookxml.core.util.DocumentElement;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class CookXml {
    private static ExceptionHandler s_defaultExceptionHandler = DebugExceptionHandler.getInstance();
    private static boolean s_defaultAccessible = false;
    private static ClassLoader s_defaultClassLoader = CookXml.class.getClassLoader();
    private final TagLibrary m_tagLibrary;
    private Object m_rootObj;
    private DocumentBuilder m_docBuilder;
    private VarLookup m_varLookup;
    private ResourceBundle m_bundle;
    private ExceptionHandler m_exceptionHandler;
    private boolean m_accessible = s_defaultAccessible;
    private final Map m_idMap = new HashMap();
    private ClassLoader m_classLoader = s_defaultClassLoader;

    public static ExceptionHandler getDefaultExceptionHandler() {
        return s_defaultExceptionHandler;
    }

    public static void setDefaultExceptionHandler(ExceptionHandler defaultExceptionHandler) {
        s_defaultExceptionHandler = defaultExceptionHandler;
    }

    public static void setDefaultAccessible(boolean accessible) {
        s_defaultAccessible = accessible;
    }

    public static boolean isDefaultAccessible() {
        return s_defaultAccessible;
    }

    public static ClassLoader getDefaultClassLoader() {
        return s_defaultClassLoader;
    }

    public static void setDefaultClassLoader(ClassLoader defaultClassLoader) {
        s_defaultClassLoader = defaultClassLoader;
    }

    public static boolean debug(String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        return true;
    }

    public static boolean debug(String msg, Exception ex) {
        if (msg != null) {
            System.out.println(msg);
        }
        if (ex != null) {
            ex.printStackTrace(System.out);
        }
        return true;
    }

    public static boolean debug(Exception ex) {
        if (ex != null) {
            ex.printStackTrace(System.out);
        }
        return true;
    }

    public CookXml(DocumentBuilder builder, TagLibrary tagLibrary, Object varObj) {
        this.m_docBuilder = builder;
        this.m_tagLibrary = tagLibrary;
        if (varObj != null) {
            this.m_varLookup = new DefaultVarLookup(varObj);
        }
    }

    public CookXml(DocumentBuilder builder, TagLibrary tagLibrary, VarLookup varLookup) {
        this.m_docBuilder = builder;
        this.m_tagLibrary = tagLibrary;
        this.m_varLookup = varLookup;
    }

    public TagLibrary getTagLibrary() {
        return this.m_tagLibrary;
    }

    public IdReference getId(String id) {
        return (IdReference)this.m_idMap.get(id);
    }

    public void setId(String id, String tag, Object obj) {
        this.m_idMap.put(id, new IdReference(id, tag, obj));
    }

    public Object xmlDecode(Object input) throws CookXmlException {
        return this.xmlDecode(input, null, null);
    }

    public Object xmlDecode(Object input, String parentTag, Object parentObj) throws CookXmlException {
        try {
            DocumentBuilder builder = this.m_docBuilder;
            Document doc = null;
            Element elm = null;
            if (input instanceof String) {
                InputStream inputStream = this.m_classLoader.getResourceAsStream((String)input);
                doc = inputStream == null ? builder.parse((String)input) : builder.parse(inputStream);
            } else if (input instanceof InputStream) {
                doc = builder.parse((InputStream)input);
            } else if (input instanceof File) {
                doc = builder.parse((File)input);
            } else if (input instanceof InputSource) {
                doc = builder.parse((InputSource)input);
            } else if (input instanceof Document) {
                doc = (Document)input;
            } else if (input instanceof DocumentElement) {
                doc = ((DocumentElement)input).doc;
                elm = ((DocumentElement)input).element;
            }
            if (doc == null) {
                this.getExceptionHandler().handleException(null, new InvalidInputException(input));
                return null;
            }
            ResourceBundleStringHook stringHook = null;
            if (this.m_bundle != null) {
                stringHook = new ResourceBundleStringHook(this.m_bundle);
            }
            DecodeEngine decodeEngine = DecodeEngine.createDecodeEngine(this, this.m_varLookup, stringHook);
            decodeEngine.setDocument(doc);
            if (elm == null) {
                elm = doc.getDocumentElement();
            }
            Object obj = decodeEngine.decodeElement(parentTag, elm, parentObj);
            decodeEngine.cleanup();
            return obj;
        }
        catch (CookXmlException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.getExceptionHandler().handleException(null, ex);
            return null;
        }
    }

    public Object getRootObject() {
        return this.m_rootObj;
    }

    public void setRootObject(Object rootObj) {
        this.m_rootObj = rootObj;
    }

    public DocumentBuilder getDocumentBuilder() {
        return this.m_docBuilder;
    }

    public void setDocumentBuilder(DocumentBuilder docBuilder) {
        this.m_docBuilder = docBuilder;
    }

    public ResourceBundle getResourceBundle() {
        return this.m_bundle;
    }

    public void setResourceBundle(ResourceBundle bundle) {
        this.m_bundle = bundle;
    }

    public VarLookup getVarLookup() {
        return this.m_varLookup;
    }

    public void setVarLookup(VarLookup varLookup) {
        this.m_varLookup = varLookup;
    }

    public ExceptionHandler getExceptionHandler() {
        ExceptionHandler handler = this.m_exceptionHandler;
        if (handler == null) {
            return CookXml.getDefaultExceptionHandler();
        }
        return handler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.m_exceptionHandler = exceptionHandler;
    }

    public boolean isAccessible() {
        return this.m_accessible;
    }

    public void setAccessible(boolean accessible) {
        this.m_accessible = accessible;
    }

    public ClassLoader getClassLoader() {
        return this.m_classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.m_classLoader = classLoader;
    }
}

