/*
 * Decompiled with CFR 0.152.
 */
package cookxml.core.creator;

import cookxml.core.CookXml;
import cookxml.core.DecodeEngine;
import cookxml.core.creator.Creator;
import cookxml.core.exception.CookXmlException;
import cookxml.core.exception.CreatorException;
import cookxml.core.exception.NoDefaultConstructorException;
import java.lang.reflect.Constructor;
import org.w3c.dom.Element;

public class DefaultCreator
implements Creator {
    public static final Class[] EMPTY_CLASS_PARAM = new Class[0];
    public static final Object[] EMPTY_OBJECT_PARAM = new Object[0];
    private final Constructor m_ctor;
    private final boolean m_addAfterFinish;

    public static Creator getCreator(Class targetClass) throws CookXmlException {
        return DefaultCreator.getCreator(targetClass, false);
    }

    public static Creator getCreator(Class targetClass, boolean addAfterFinish) throws CookXmlException {
        try {
            Constructor ctor = targetClass.getConstructor(EMPTY_CLASS_PARAM);
            return new DefaultCreator(ctor, addAfterFinish);
        }
        catch (Exception ex) {
            CookXml.getDefaultExceptionHandler().handleException(null, new NoDefaultConstructorException(targetClass));
            return null;
        }
    }

    private DefaultCreator(Constructor ctor, boolean addAfterFinish) {
        this.m_ctor = ctor;
        this.m_addAfterFinish = addAfterFinish;
    }

    public Object create(String parentTag, Element elm, Object parentObj, String value, DecodeEngine decodeEngine) throws CreatorException {
        try {
            if (this.m_addAfterFinish) {
                decodeEngine.setDoAdd(false);
            }
            return this.m_ctor.newInstance(EMPTY_OBJECT_PARAM);
        }
        catch (Exception ex) {
            throw new CreatorException(decodeEngine, ex, this, parentTag, elm, parentObj, value);
        }
    }

    public Object editFinished(String parentTag, Element elm, Object parentObj, Object obj, DecodeEngine decodeEngine) throws CookXmlException {
        if (this.m_addAfterFinish) {
            decodeEngine.addChild(parentTag, elm, parentObj, obj);
        }
        return obj;
    }
}

