/*
 * Decompiled with CFR 0.152.
 */
package cookxml.cookswt.converter;

import cookxml.core.DecodeEngine;
import cookxml.core.converter.Converter;
import cookxml.core.exception.ConverterException;
import java.lang.reflect.Field;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageConverter
implements Converter {
    private static final Converter s_instance = new ImageConverter();

    public static Converter getInstance() {
        return s_instance;
    }

    private ImageConverter() {
    }

    public Object convert(String value, DecodeEngine decodeEngine) throws ConverterException {
        try {
            Field imageField;
            String imageName = value.toUpperCase().trim();
            if (!imageName.startsWith("ICON_")) {
                imageName = "ICON_" + value;
            }
            if ((imageField = SWT.class.getField(imageName)) != null) {
                int id = imageField.getInt(null);
                return Display.getCurrent().getSystemImage(id);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            return new Image((Device)Display.getCurrent(), decodeEngine.getCookXml().getClassLoader().getResourceAsStream(value));
        }
        catch (Exception ex) {
            throw new ConverterException(decodeEngine, (Throwable)ex, (Converter)this, value);
        }
    }
}

