/*
 * Decompiled with CFR 0.152.
 */
package cookxml.common.helper;

import cookxml.common.exception.InvalidClassTypeException;
import cookxml.core.NoAdd;
import cookxml.core.exception.CookXmlException;
import cookxml.core.util.ClassUtils;
import java.util.LinkedList;

public class ArrayHelper
implements NoAdd {
    private boolean m_sameTypes = true;
    private LinkedList m_list = new LinkedList();
    private Class m_classType;
    private String m_primitiveType;
    private boolean m_primitive = false;
    private int m_size = -1;
    private final ClassLoader m_classLoader;

    public ArrayHelper(ClassLoader classLoader) {
        this.m_classLoader = classLoader;
    }

    public void setSize(int size) {
        this.m_size = size;
    }

    public void setType(String type) throws CookXmlException {
        try {
            Class<?> cl = ClassUtils.getEquivalentClass(type);
            if (cl == null) {
                cl = this.m_classLoader.loadClass(type);
            } else {
                this.m_primitiveType = type;
                this.m_primitive = true;
            }
            this.m_classType = cl;
        }
        catch (Exception ex) {
            throw new InvalidClassTypeException(type);
        }
    }

    public void add(Object obj) {
        this.m_list.add(obj);
        if (obj == null) {
            return;
        }
        if (!this.m_sameTypes) {
            return;
        }
        if (this.m_classType == null) {
            this.m_classType = obj.getClass();
        } else if (!this.m_classType.isInstance(obj)) {
            this.m_classType = Object.class;
            this.m_sameTypes = false;
        }
    }

    public Object getFinalObject() throws Exception {
        Object array;
        LinkedList list = this.m_list;
        int size = this.m_size;
        if (size < 0) {
            size = list.size();
        }
        if ((array = this.m_primitive ? ClassUtils.getArray(this.m_primitiveType, size) : ClassUtils.getArray(this.m_classType, size)) == null) {
            return null;
        }
        ClassUtils.setArray(array, size, list);
        return array;
    }
}

