/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.codecs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Vector;
import net.sourceforge.jiu.codecs.CodecMode;
import net.sourceforge.jiu.codecs.UnsupportedCodecModeException;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.Operation;
import net.sourceforge.jiu.ops.WrongParameterException;

public abstract class ImageCodec
extends Operation {
    private int boundsX1;
    private int boundsY1;
    private int boundsX2;
    private int boundsY2;
    private boolean boundsAvail;
    private int boundsWidth;
    private int boundsHeight;
    private Vector comments = new Vector();
    private int dpiX;
    private int dpiY;
    private DataInput din;
    private DataOutput dout;
    private PixelImage image;
    private int imageIndex;
    private InputStream in;
    private CodecMode mode;
    private OutputStream out;
    private RandomAccessFile raf;

    public ImageCodec() {
        this.removeBounds();
    }

    public void appendComment(String comment) {
        if (comment != null) {
            this.comments.addElement(comment);
        }
    }

    public void checkBounds(int width, int height) throws WrongParameterException {
        if (!this.hasBounds()) {
            return;
        }
        int x1 = this.getBoundsX1();
        if (x1 >= width) {
            throw new WrongParameterException("Codec bounds x1 (" + x1 + ") must be smaller than image width (" + width + ").");
        }
        int x2 = this.getBoundsX2();
        if (x2 >= width) {
            throw new WrongParameterException("Codec bounds x2 (" + x2 + ") must be smaller than image width (" + width + ").");
        }
        int y1 = this.getBoundsY1();
        if (y1 >= height) {
            throw new WrongParameterException("Codec bounds y1 (" + y1 + ") must be smaller than image height (" + height + ").");
        }
        int y2 = this.getBoundsY2();
        if (y2 >= height) {
            throw new WrongParameterException("Codec bounds y2 (" + y2 + ") must be smaller than image height (" + height + ").");
        }
    }

    public void checkImageResolution() throws WrongParameterException {
        PixelImage image = this.getImage();
        if (image != null) {
            if (image.getWidth() != this.getBoundsWidth()) {
                throw new WrongParameterException("Specified input image must have width equal to getBoundsWidth().");
            }
            if (image.getHeight() != this.getBoundsHeight()) {
                throw new WrongParameterException("Specified input image must have height equal to getBoundsHeight().");
            }
        }
    }

    public void close() {
        try {
            if (this.in != null) {
                this.in.close();
            }
            if (this.out != null) {
                this.out.close();
            }
            if (this.raf != null) {
                this.raf.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getBoundsX1() {
        return this.boundsX1;
    }

    public int getBoundsX2() {
        return this.boundsX2;
    }

    public int getBoundsY1() {
        return this.boundsY1;
    }

    public int getBoundsY2() {
        return this.boundsY2;
    }

    public int getBoundsHeight() {
        return this.boundsHeight;
    }

    public int getBoundsWidth() {
        return this.boundsWidth;
    }

    public String getComment(int index) {
        if (index >= 0 && index < this.comments.size()) {
            return (String)this.comments.elementAt(index);
        }
        return null;
    }

    public DataInput getDataInput() {
        return this.din;
    }

    public DataOutput getDataOutput() {
        return this.dout;
    }

    public int getDpiX() {
        return this.dpiX;
    }

    public int getDpiY() {
        return this.dpiY;
    }

    public String[] getFileExtensions() {
        return null;
    }

    public abstract String getFormatName();

    public PixelImage getImage() {
        return this.image;
    }

    public int getImageIndex() {
        return this.imageIndex;
    }

    public DataInput getInputAsDataInput() {
        DataInput din = this.getDataInput();
        if (din != null) {
            return din;
        }
        RandomAccessFile raf = this.getRandomAccessFile();
        if (this.getMode() == CodecMode.LOAD && raf != null) {
            return raf;
        }
        InputStream in = this.getInputStream();
        if (in != null) {
            if (in instanceof DataInput) {
                return (DataInput)((Object)in);
            }
            return new DataInputStream(in);
        }
        return null;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public abstract String[] getMimeTypes();

    public CodecMode getMode() {
        return this.mode;
    }

    public int getNumComments() {
        return this.comments.size();
    }

    public DataOutput getOutputAsDataOutput() {
        DataOutput dout = this.getDataOutput();
        if (dout != null) {
            return dout;
        }
        OutputStream out = this.getOutputStream();
        if (out != null) {
            if (out instanceof DataOutput) {
                return (DataOutput)((Object)out);
            }
            return new DataOutputStream(out);
        }
        RandomAccessFile raf = this.getRandomAccessFile();
        if (raf != null && this.getMode() == CodecMode.SAVE) {
            return raf;
        }
        return null;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.raf;
    }

    public boolean hasBounds() {
        return this.boundsAvail;
    }

    protected void initModeFromIOObjects() throws MissingParameterException {
        if (this.getMode() != null) {
            return;
        }
        if (this.getInputStream() != null || this.getDataInput() != null) {
            this.mode = CodecMode.LOAD;
        } else if (this.getOutputStream() != null || this.getDataOutput() != null) {
            this.mode = CodecMode.SAVE;
        } else {
            throw new MissingParameterException("No streams or files available.");
        }
    }

    public abstract boolean isLoadingSupported();

    public abstract boolean isSavingSupported();

    public boolean isRowRequired(int row) {
        if (this.hasBounds()) {
            return row >= this.boundsY1 && row <= this.boundsY2;
        }
        return row >= 0 && row < this.getImage().getHeight();
    }

    public boolean isTileRequired(int x1, int y1, int x2, int y2) {
        if (this.hasBounds()) {
            return this.getBoundsY2() >= y1 && this.getBoundsY1() <= y2 && this.getBoundsX2() >= x1 && this.getBoundsX1() <= x2;
        }
        return true;
    }

    public void removeAllComments() {
        this.comments.removeAllElements();
    }

    public void removeBounds() {
        this.boundsAvail = false;
    }

    public void setBounds(int x1, int y1, int x2, int y2) {
        if (x1 < 0 || y1 < 0 || x2 < x1 || y2 < y1) {
            throw new IllegalArgumentException("Not a valid bounds rectangle: x1=" + x1 + ", y1=" + y1 + ", x2=" + x2 + ", y2=" + y2);
        }
        this.boundsX1 = x1;
        this.boundsY1 = y1;
        this.boundsX2 = x2;
        this.boundsY2 = y2;
        this.boundsAvail = true;
        this.boundsWidth = x2 - x1 + 1;
        this.boundsHeight = y2 - y1 + 1;
    }

    public void setBoundsIfNecessary(int width, int height) {
        if (!this.hasBounds()) {
            this.setBounds(0, 0, width - 1, height - 1);
        }
    }

    public void setDataInput(DataInput dataInput) {
        this.din = dataInput;
    }

    public void setDataOutput(DataOutput dataOutput) {
        this.dout = dataOutput;
    }

    public void setDpi(int horizontalDpi, int verticalDpi) {
        this.dpiX = horizontalDpi;
        this.dpiY = verticalDpi;
    }

    public void setFile(File file, CodecMode codecMode) throws IOException, UnsupportedCodecModeException {
        this.setFile(file.getAbsolutePath(), codecMode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFile(String fileName, CodecMode codecMode) throws IOException, UnsupportedCodecModeException {
        if (codecMode == CodecMode.LOAD) {
            if (!this.isLoadingSupported()) throw new UnsupportedCodecModeException("Loading is not supported for this codec (" + this.getFormatName() + ").");
            this.setInputStream(new BufferedInputStream(new FileInputStream(fileName)));
            return;
        } else {
            if (!this.isSavingSupported()) throw new UnsupportedCodecModeException("Saving is not supported for this codec (" + this.getFormatName() + ").");
            this.setOutputStream(new BufferedOutputStream(new FileOutputStream(fileName)));
        }
    }

    public void setImage(PixelImage img) {
        this.image = img;
    }

    public void setImageIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("The index must be 0 or larger.");
        }
        this.imageIndex = index;
    }

    public void setInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void setRandomAccessFile(RandomAccessFile randomAccessFile, CodecMode codecMode) {
        if (randomAccessFile == null) {
            throw new IllegalArgumentException("Argument RandomAccessFile must be non-null.");
        }
        if (codecMode == null) {
            throw new IllegalArgumentException("Argument codec mode must be non-null.");
        }
        this.raf = randomAccessFile;
        this.mode = codecMode;
    }

    public String suggestFileExtension(PixelImage image) {
        return null;
    }
}

