/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.codecs.jpeg;

import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import net.sourceforge.jiu.codecs.CodecMode;
import net.sourceforge.jiu.codecs.ImageCodec;
import net.sourceforge.jiu.codecs.InvalidFileStructureException;
import net.sourceforge.jiu.codecs.UnsupportedTypeException;
import net.sourceforge.jiu.codecs.WrongFileFormatException;
import net.sourceforge.jiu.codecs.jpeg.JPEGData;
import net.sourceforge.jiu.codecs.jpeg.JPEGFrame;
import net.sourceforge.jiu.codecs.jpeg.JPEGMarkerReader;
import net.sourceforge.jiu.data.MemoryGray8Image;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.OperationFailedException;
import net.sourceforge.jiu.util.ArrayConverter;

public class JPEGCodec
extends ImageCodec {
    private DataInput in;

    private void decodeScan(JPEGData jpegData) {
        JPEGFrame frame = jpegData.getFrame();
        int width = frame.getWidth();
        int height = frame.getHeight();
        MemoryGray8Image image = new MemoryGray8Image(width, height);
        boolean x = false;
        boolean y = false;
        int numMCUs = (width + 7) / 8 * ((height + 7) / 8);
        while (numMCUs > 0) {
            --numMCUs;
        }
    }

    public String[] getFileExtensions() {
        return new String[]{".jpg", ".jpeg"};
    }

    public String getFormatName() {
        return "JPEG File Interchange Format";
    }

    public String[] getMimeTypes() {
        return new String[]{"image/jpeg"};
    }

    public boolean isLoadingSupported() {
        return true;
    }

    public boolean isSavingSupported() {
        return false;
    }

    private void load() throws OperationFailedException, WrongFileFormatException {
        this.in = this.getInputAsDataInput();
        if (this.in == null) {
            throw new MissingParameterException("Input object missing (could not retrieve via getAsDataInput).");
        }
        try {
            try {
                byte[] data = new byte[4];
                this.in.readFully(data, 0, 2);
                int signature = ArrayConverter.getShortBEAsInt(data, 0);
                if (signature != 65496) {
                    throw new WrongFileFormatException("Not a JFIF file (first two bytes are not 0xff 0xd8).");
                }
                JPEGData jpegData = new JPEGData();
                while (true) {
                    this.in.readFully(data);
                    int marker = ArrayConverter.getShortBEAsInt(data, 0);
                    int length = ArrayConverter.getShortBEAsInt(data, 2);
                    this.readMarker(jpegData, marker, length);
                }
            }
            catch (IOException ioe) {
                throw new OperationFailedException("Error reading from input.");
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.close();
            throw throwable;
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Need JPEG file names as arguments.");
            System.exit(1);
        }
        int i = 0;
        while (i < args.length) {
            String fileName = args[i];
            JPEGCodec codec = new JPEGCodec();
            codec.setFile(new File(fileName), CodecMode.LOAD);
            codec.process();
            ++i;
        }
    }

    public void process() throws MissingParameterException, OperationFailedException, WrongFileFormatException {
        this.initModeFromIOObjects();
        if (this.getMode() != CodecMode.LOAD) {
            if (this.getMode() == CodecMode.SAVE) {
                throw new OperationFailedException("Saving is not supported.");
            }
            throw new OperationFailedException("Unsupported codec mode.");
        }
        this.load();
    }

    private void readMarker(JPEGData jpegData, int marker, int length) throws InvalidFileStructureException, IOException, UnsupportedTypeException {
        if (marker >> 8 != 255) {
            throw new InvalidFileStructureException("Marker " + marker + " does not have 0xff in its top eight bits.");
        }
        length -= 2;
        switch (marker &= 0xFF) {
            case 196: {
                JPEGMarkerReader.readHuffmanTables(this.in, jpegData, length);
                break;
            }
            case 219: {
                JPEGMarkerReader.readQuantizationTables(this.in, jpegData, length);
                break;
            }
            case 192: {
                JPEGMarkerReader.readStartOfFrame(this.in, jpegData, marker, length);
                break;
            }
            case 193: 
            case 194: 
            case 195: 
            case 197: 
            case 198: 
            case 199: 
            case 201: 
            case 202: 
            case 203: 
            case 205: 
            case 206: 
            case 207: {
                throw new UnsupportedTypeException("Unsupported JPEG SOF type: " + Integer.toHexString(marker));
            }
            case 218: {
                JPEGMarkerReader.readStartOfScan(this.in, jpegData, length);
                this.decodeScan(jpegData);
                break;
            }
            default: {
                System.out.println("Unknown marker: " + Integer.toHexString(marker));
                while (length > 0) {
                    int skipped = this.in.skipBytes(length);
                    if (skipped <= 0) continue;
                    length -= skipped;
                }
                break block0;
            }
        }
    }

    public String suggestFileExtension(PixelImage image) {
        return ".jpg";
    }
}

