/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.codecs.tiff;

import java.io.DataInput;
import java.io.IOException;
import net.sourceforge.jiu.codecs.InvalidFileStructureException;
import net.sourceforge.jiu.codecs.tiff.TIFFDecoder;
import net.sourceforge.jiu.codecs.tiff.TIFFFaxCodes;
import net.sourceforge.jiu.ops.MissingParameterException;

public class TIFFDecoderModifiedHuffman
extends TIFFDecoder {
    private DataInput in;
    private int bitBuffer;
    private int numBufferedBits;

    public void decode() throws InvalidFileStructureException, IOException {
        byte[] row = new byte[this.getBytesPerRow()];
        int y = this.getY1();
        while (y <= this.getY2()) {
            this.decodeRow(row);
            this.putBytes(row, 0, row.length);
            ++y;
        }
    }

    private int decodeBlackRun() throws InvalidFileStructureException, IOException {
        return this.decodeRun(TIFFFaxCodes.BLACK_CODES, 2);
    }

    private void decodeRow(byte[] row) throws InvalidFileStructureException, IOException {
        this.reset();
        boolean black = false;
        int index = 0;
        do {
            int runLength;
            int completeRunLength = 0;
            do {
                runLength = black ? this.decodeBlackRun() : this.decodeWhiteRun();
                completeRunLength += runLength;
            } while (runLength >= 64);
            byte value = black ? (byte)0 : 1;
            while (completeRunLength-- > 0) {
                row[index++] = value;
            }
            boolean bl = black = !black;
        } while (index < row.length);
    }

    private int decodeRun(int[][][] codes, int minCodeSize) throws InvalidFileStructureException, IOException {
        int code = this.readBits(minCodeSize);
        int i = 0;
        while (i < codes.length) {
            int[][] data = codes[i];
            int j = 0;
            int LENGTH = data.length;
            while (j < LENGTH) {
                int[] pair;
                if ((pair = data[j++])[0] != code) continue;
                return pair[1];
            }
            code = code << 1 | this.readBit();
            ++i;
        }
        throw new InvalidFileStructureException("Could not identify Huffman code in TIFF file.");
    }

    private int decodeWhiteRun() throws InvalidFileStructureException, IOException {
        return this.decodeRun(TIFFFaxCodes.WHITE_CODES, 4);
    }

    public Integer[] getCompressionTypes() {
        return new Integer[]{new Integer(2)};
    }

    public void initialize() throws IOException, MissingParameterException {
        super.initialize();
        this.in = this.getInput();
    }

    private int readBit() throws IOException {
        int result;
        if (this.numBufferedBits == 0) {
            this.bitBuffer = this.in.readUnsignedByte();
            result = (this.bitBuffer & 0x80) == 0 ? 0 : 1;
            this.bitBuffer &= 0x7F;
            this.numBufferedBits = 7;
        } else {
            --this.numBufferedBits;
            result = this.bitBuffer >> this.numBufferedBits;
            this.bitBuffer &= (1 << this.numBufferedBits) - 1;
        }
        return result;
    }

    private int readBits(int number) throws IOException {
        while (this.numBufferedBits < number) {
            int b = this.in.readUnsignedByte();
            this.bitBuffer = this.bitBuffer << 8 | b;
            this.numBufferedBits += 8;
        }
        this.numBufferedBits -= number;
        int result = this.bitBuffer >> this.numBufferedBits;
        this.bitBuffer &= (1 << this.numBufferedBits) - 1;
        return result;
    }

    private void reset() {
        this.bitBuffer = 0;
        this.numBufferedBits = 0;
    }
}

