/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.adjustment;

import net.sourceforge.jiu.data.GrayIntegerImage;
import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.Palette;
import net.sourceforge.jiu.data.Paletted8Image;
import net.sourceforge.jiu.data.RGBIntegerImage;
import net.sourceforge.jiu.ops.LookupTableOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class Contrast
extends LookupTableOperation {
    private int contrast;

    private int[] createLookupTable(int numSamples, int contrast) {
        int[] result = new int[numSamples];
        int MAX = numSamples - 1;
        float MID = (float)MAX / 2.0f;
        int i = 0;
        while (i < numSamples) {
            result[i] = contrast < 0 ? ((float)i < MID ? (int)((float)i + (MID - (float)i) * (float)(-contrast) / 100.0f) : (int)(MID + ((float)i - MID) * (100.0f + (float)contrast) / 100.0f)) : ((float)i < MID ? (int)((float)i * (100.0f - (float)contrast) / 100.0f) : (int)((float)i + (float)((MAX - i) * contrast) / 100.0f));
            ++i;
        }
        return result;
    }

    public int getContrast() {
        return this.contrast;
    }

    private void process(Paletted8Image in, Paletted8Image out) {
        if (out == null) {
            out = (Paletted8Image)in.createCompatibleImage(in.getWidth(), in.getHeight());
        }
        Palette palette = out.getPalette();
        int numSamples = palette.getMaxValue() + 1;
        int[] LUT = this.createLookupTable(numSamples, this.contrast);
        int c = 0;
        while (c < 3) {
            int i = 0;
            while (i < palette.getNumEntries()) {
                palette.putSample(c, i, LUT[palette.getSample(c, i)]);
                ++i;
            }
            ++c;
        }
        int y = 0;
        while (y < in.getHeight()) {
            int x = 0;
            while (x < in.getWidth()) {
                out.putSample(0, x, y, in.getSample(0, x, y));
                ++x;
            }
            this.setProgress(y, in.getHeight());
            ++y;
        }
        this.setOutputImage(out);
    }

    public void process() throws MissingParameterException, WrongParameterException {
        this.prepareImages();
        IntegerImage in = (IntegerImage)this.getInputImage();
        if (in instanceof GrayIntegerImage || in instanceof RGBIntegerImage) {
            this.setNumTables(in.getNumChannels());
            int channelIndex = 0;
            while (channelIndex < in.getNumChannels()) {
                this.setTable(channelIndex, this.createLookupTable(in.getMaxSample(channelIndex) + 1, this.getContrast()));
                ++channelIndex;
            }
            super.process();
        } else if (in instanceof Paletted8Image) {
            this.process((Paletted8Image)in, (Paletted8Image)this.getOutputImage());
        } else {
            throw new WrongParameterException("Contrast operation cannot operate on input image type: " + in.getClass());
        }
    }

    public void setContrast(int newContrast) {
        if (newContrast < -100) {
            throw new IllegalArgumentException("Contrast must be at least -100: " + newContrast);
        }
        if (newContrast > 100) {
            throw new IllegalArgumentException("Contrast must be at most 100: " + newContrast);
        }
        this.contrast = newContrast;
    }
}

