/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.conversion;

public class LogLuvConversion {
    private static final double M_LN2 = 0.6931471805599453;
    private static final double UVSCALE = 410.0;
    private static final float UV_SQSIZ = 0.0035f;
    private static final int UV_NDIVS = 16289;
    private static final float UV_VSTART = 0.01694f;
    private static final int UV_NVS = 163;
    private static final double U_NEU = 0.210526316;
    private static final double V_NEU = 0.473684211;
    private static final double[] USTART = new double[]{0.247663, 0.243779, 0.241684, 0.237874, 0.235906, 0.232153, 0.228352, 0.226259, 0.222371, 0.22041, 0.21471, 0.212714, 0.210721, 0.204976, 0.202986, 0.199245, 0.195525, 0.19356, 0.189878, 0.186216, 0.186216, 0.182592, 0.179003, 0.175466, 0.172001, 0.172001, 0.168612, 0.168612, 0.163575, 0.158642, 0.158642, 0.158642, 0.153815, 0.153815, 0.149097, 0.149097, 0.142746, 0.142746, 0.142746, 0.13827, 0.13827, 0.13827, 0.132166, 0.132166, 0.126204, 0.126204, 0.126204, 0.120381, 0.120381, 0.120381, 0.120381, 0.112962, 0.112962, 0.112962, 0.10745, 0.10745, 0.10745, 0.10745, 0.100343, 0.100343, 0.100343, 0.095126, 0.095126, 0.095126, 0.095126, 0.088276, 0.088276, 0.088276, 0.088276, 0.081523, 0.081523, 0.081523, 0.081523, 0.074861, 0.074861, 0.074861, 0.074861, 0.06829, 0.06829, 0.06829, 0.06829, 0.063573, 0.063573, 0.063573, 0.063573, 0.057219, 0.057219, 0.057219, 0.057219, 0.050985, 0.050985, 0.050985, 0.050985, 0.050985, 0.044859, 0.044859, 0.044859, 0.044859, 0.040571, 0.040571, 0.040571, 0.040571, 0.036339, 0.036339, 0.036339, 0.036339, 0.032139, 0.032139, 0.032139, 0.032139, 0.027947, 0.027947, 0.027947, 0.023739, 0.023739, 0.023739, 0.023739, 0.019504, 0.019504, 0.019504, 0.016976, 0.016976, 0.016976, 0.016976, 0.012639, 0.012639, 0.012639, 0.009991, 0.009991, 0.009991, 0.009016, 0.009016, 0.009016, 0.006217, 0.006217, 0.005097, 0.005097, 0.005097, 0.003909, 0.003909, 0.00234, 0.002389, 0.001068, 0.001653, 7.17E-4, 0.001614, 2.7E-4, 4.84E-4, 0.001103, 0.001242, 0.001188, 0.001011, 7.09E-4, 3.01E-4, 0.002416, 0.003251, 0.003246, 0.004141, 0.005963, 0.008839, 0.01049, 0.016994, 0.023659};
    private static final short[] NCUM;

    static {
        short[] sArray = new short[163];
        sArray[1] = 4;
        sArray[2] = 10;
        sArray[3] = 17;
        sArray[4] = 26;
        sArray[5] = 36;
        sArray[6] = 48;
        sArray[7] = 62;
        sArray[8] = 77;
        sArray[9] = 94;
        sArray[10] = 112;
        sArray[11] = 133;
        sArray[12] = 155;
        sArray[13] = 178;
        sArray[14] = 204;
        sArray[15] = 231;
        sArray[16] = 260;
        sArray[17] = 291;
        sArray[18] = 323;
        sArray[19] = 357;
        sArray[20] = 393;
        sArray[21] = 429;
        sArray[22] = 467;
        sArray[23] = 507;
        sArray[24] = 549;
        sArray[25] = 593;
        sArray[26] = 637;
        sArray[27] = 683;
        sArray[28] = 729;
        sArray[29] = 778;
        sArray[30] = 830;
        sArray[31] = 882;
        sArray[32] = 934;
        sArray[33] = 989;
        sArray[34] = 1044;
        sArray[35] = 1102;
        sArray[36] = 1160;
        sArray[37] = 1222;
        sArray[38] = 1284;
        sArray[39] = 1346;
        sArray[40] = 1411;
        sArray[41] = 1476;
        sArray[42] = 1541;
        sArray[43] = 1610;
        sArray[44] = 1679;
        sArray[45] = 1752;
        sArray[46] = 1825;
        sArray[47] = 1898;
        sArray[48] = 1975;
        sArray[49] = 2052;
        sArray[50] = 2129;
        sArray[51] = 2206;
        sArray[52] = 2288;
        sArray[53] = 2370;
        sArray[54] = 2452;
        sArray[55] = 2538;
        sArray[56] = 2624;
        sArray[57] = 2710;
        sArray[58] = 2796;
        sArray[59] = 2887;
        sArray[60] = 2978;
        sArray[61] = 3069;
        sArray[62] = 3164;
        sArray[63] = 3259;
        sArray[64] = 3354;
        sArray[65] = 3449;
        sArray[66] = 3549;
        sArray[67] = 3649;
        sArray[68] = 3749;
        sArray[69] = 3849;
        sArray[70] = 3954;
        sArray[71] = 4059;
        sArray[72] = 4164;
        sArray[73] = 4269;
        sArray[74] = 4379;
        sArray[75] = 4489;
        sArray[76] = 4599;
        sArray[77] = 4709;
        sArray[78] = 4824;
        sArray[79] = 4939;
        sArray[80] = 5054;
        sArray[81] = 5169;
        sArray[82] = 5288;
        sArray[83] = 5407;
        sArray[84] = 5526;
        sArray[85] = 5645;
        sArray[86] = 5769;
        sArray[87] = 5893;
        sArray[88] = 6017;
        sArray[89] = 6141;
        sArray[90] = 6270;
        sArray[91] = 6399;
        sArray[92] = 6528;
        sArray[93] = 6657;
        sArray[94] = 6786;
        sArray[95] = 6920;
        sArray[96] = 7054;
        sArray[97] = 7188;
        sArray[98] = 7322;
        sArray[99] = 7460;
        sArray[100] = 7598;
        sArray[101] = 7736;
        sArray[102] = 7874;
        sArray[103] = 8016;
        sArray[104] = 8158;
        sArray[105] = 8300;
        sArray[106] = 8442;
        sArray[107] = 8588;
        sArray[108] = 8734;
        sArray[109] = 8880;
        sArray[110] = 9026;
        sArray[111] = 9176;
        sArray[112] = 9326;
        sArray[113] = 9476;
        sArray[114] = 9630;
        sArray[115] = 9784;
        sArray[116] = 9938;
        sArray[117] = 10092;
        sArray[118] = 10250;
        sArray[119] = 10408;
        sArray[120] = 10566;
        sArray[121] = 10727;
        sArray[122] = 10888;
        sArray[123] = 11049;
        sArray[124] = 11210;
        sArray[125] = 11375;
        sArray[126] = 11540;
        sArray[127] = 11705;
        sArray[128] = 11873;
        sArray[129] = 12041;
        sArray[130] = 12209;
        sArray[131] = 12379;
        sArray[132] = 12549;
        sArray[133] = 12719;
        sArray[134] = 12892;
        sArray[135] = 13065;
        sArray[136] = 13240;
        sArray[137] = 13415;
        sArray[138] = 13590;
        sArray[139] = 13767;
        sArray[140] = 13944;
        sArray[141] = 14121;
        sArray[142] = 14291;
        sArray[143] = 14455;
        sArray[144] = 14612;
        sArray[145] = 14762;
        sArray[146] = 14905;
        sArray[147] = 15041;
        sArray[148] = 15170;
        sArray[149] = 15293;
        sArray[150] = 15408;
        sArray[151] = 15517;
        sArray[152] = 15620;
        sArray[153] = 15717;
        sArray[154] = 15806;
        sArray[155] = 15888;
        sArray[156] = 15964;
        sArray[157] = 16033;
        sArray[158] = 16095;
        sArray[159] = 16150;
        sArray[160] = 16197;
        sArray[161] = 16237;
        sArray[162] = 16268;
        NCUM = sArray;
    }

    private LogLuvConversion() {
    }

    public static double convertLogL10toY(int p10) {
        if (p10 == 0) {
            return 0.0;
        }
        return Math.exp(0.010830424696249145 * ((double)p10 + 0.5) - 8.317766166719343);
    }

    public static double convertLogL16toY(int p16) {
        int Le = p16 & Short.MAX_VALUE;
        if (Le == 0) {
            return 0.0;
        }
        double Y = Math.exp(0.0027076061740622863 * ((double)Le + 0.5) - 44.3614195558365);
        if ((p16 & 0x8000) == 0) {
            return Y;
        }
        return -Y;
    }

    private static byte convertDoubleToByte(double d) {
        if (d <= 0.0) {
            return 0;
        }
        if (d >= 1.0) {
            return -1;
        }
        double result = 255.0 * Math.sqrt(d);
        return (byte)result;
    }

    public static void convertLogLuv24InterleavedtoRGB24Planar(byte[] logluv, byte[] red, byte[] green, byte[] blue, int num) {
        int srcOffs = 0;
        int destOffs = 0;
        while (num-- != 0) {
            float X = 0.0f;
            float Y = 0.0f;
            float Z = 0.0f;
            int v1 = logluv[srcOffs++] & 0xFF;
            int v2 = logluv[srcOffs++] & 0xFF;
            int v3 = logluv[srcOffs++] & 0xFF;
            double L = LogLuvConversion.convertLogL10toY(v1 << 2 | v2 >> 6 & 3);
            if (L > 0.0) {
                int c = (v2 & 0x3F) << 8 | v3;
                double u = 0.210526316;
                double v = 0.473684211;
                int upper = 163;
                int lower = 0;
                if (c >= 0 && c < 16289) {
                    lower = 0;
                    upper = 163;
                    int ui = 0;
                    int vi = 0;
                    while (upper - lower > 1) {
                        vi = lower + upper >> 1;
                        ui = c - NCUM[vi];
                        if (ui > 0) {
                            lower = vi;
                            continue;
                        }
                        if (ui < 0) {
                            upper = vi;
                            continue;
                        }
                        lower = vi;
                        break;
                    }
                    vi = lower;
                    ui = c - NCUM[vi];
                    u = USTART[vi] + ((double)ui + 0.5) * (double)0.0035f;
                    v = (double)0.01694f + ((double)vi + 0.5) * (double)0.0035f;
                }
                double s = 1.0 / (6.0 * u - 16.0 * v + 12.0);
                double x = 9.0 * u * s;
                double y = 4.0 * v * s;
                X = (float)(x / y * L);
                Y = (float)L;
                Z = (float)((1.0 - x - y) / y * L);
            }
            double r = 2.69 * (double)X + -1.276 * (double)Y + -0.414 * (double)Z;
            double g = -1.022 * (double)X + 1.978 * (double)Y + 0.044 * (double)Z;
            double b = 0.061 * (double)X + -0.224 * (double)Y + 1.163 * (double)Z;
            red[destOffs] = LogLuvConversion.convertDoubleToByte(r);
            green[destOffs] = LogLuvConversion.convertDoubleToByte(g);
            blue[destOffs] = LogLuvConversion.convertDoubleToByte(b);
            ++destOffs;
        }
    }

    public static void convertLogLuv32InterleavedtoRGB24Planar(byte[] logluv, byte[] red, byte[] green, byte[] blue, int num) {
        int srcOffs = 0;
        int destOffs = 0;
        while (num-- != 0) {
            float X = 0.0f;
            float Y = 0.0f;
            float Z = 0.0f;
            int v1 = logluv[srcOffs++] & 0xFF;
            int n = srcOffs++;
            int v2 = logluv[n] & 0xFF;
            double L = LogLuvConversion.convertLogL16toY((short)(v1 << 8 | v2));
            if (L > 0.0) {
                double u = 0.0024390243902439024 * ((double)(logluv[srcOffs++] & 0xFF) + 0.5);
                double v = 0.0024390243902439024 * ((double)(logluv[srcOffs++] & 0xFF) + 0.5);
                double s = 1.0 / (6.0 * u - 16.0 * v + 12.0);
                double x = 9.0 * u * s;
                double y = 4.0 * v * s;
                X = (float)(x / y * L);
                Y = (float)L;
                Z = (float)((1.0 - x - y) / y * L);
            }
            double r = 2.69 * (double)X + -1.276 * (double)Y + -0.414 * (double)Z;
            double g = -1.022 * (double)X + 1.978 * (double)Y + 0.044 * (double)Z;
            double b = 0.061 * (double)X + -0.224 * (double)Y + 1.163 * (double)Z;
            red[destOffs] = LogLuvConversion.convertDoubleToByte(r);
            green[destOffs] = LogLuvConversion.convertDoubleToByte(g);
            blue[destOffs] = LogLuvConversion.convertDoubleToByte(b);
            ++destOffs;
        }
    }

    public static void convertLogL16toGray8(byte[] logl, byte[] gray, int num) {
        int srcOffs = 0;
        int destOffs = 0;
        while (num-- != 0) {
            int v1 = logl[srcOffs++] & 0xFF;
            int v2 = logl[srcOffs++] & 0xFF;
            double L = LogLuvConversion.convertLogL16toY((short)(v1 << 8 | v2));
            gray[destOffs++] = LogLuvConversion.convertDoubleToByte(L);
        }
    }
}

