/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.color.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import net.sourceforge.jiu.codecs.ImageLoader;
import net.sourceforge.jiu.codecs.PNMCodec;
import net.sourceforge.jiu.data.MemoryRGB24Image;
import net.sourceforge.jiu.data.Palette;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGB24Image;
import net.sourceforge.jiu.data.RGBIndex;
import net.sourceforge.jiu.ops.OperationFailedException;

public class PaletteSerialization
implements RGBIndex {
    private PaletteSerialization() {
    }

    public static Palette convertImageToPalette(RGB24Image image) {
        if (image == null) {
            return null;
        }
        int numPixels = image.getWidth() * image.getHeight();
        if (numPixels > 256) {
            return null;
        }
        Palette result = new Palette(numPixels, 255);
        int index = 0;
        int y = 0;
        while (y < image.getHeight()) {
            int x = 0;
            while (x < image.getWidth()) {
                result.put(index++, image.getSample(0, x, y), image.getSample(1, x, y), image.getSample(2, x, y));
                ++x;
            }
            ++y;
        }
        return result;
    }

    public static RGB24Image convertPaletteToImage(Palette palette) {
        MemoryRGB24Image result = new MemoryRGB24Image(1, palette.getNumEntries());
        int index = 0;
        while (index < palette.getNumEntries()) {
            result.putSample(0, 0, index, palette.getSample(0, index));
            result.putSample(1, 0, index, palette.getSample(1, index));
            result.putSample(2, 0, index, palette.getSample(2, index));
            ++index;
        }
        return result;
    }

    public static Palette load(File paletteFile) {
        PixelImage image;
        try {
            image = ImageLoader.load(paletteFile, null);
        }
        catch (Exception e) {
            return null;
        }
        if (!(image instanceof RGB24Image)) {
            return null;
        }
        return PaletteSerialization.convertImageToPalette((RGB24Image)image);
    }

    public static void save(Palette palette, File paletteFile) throws IOException {
        RGB24Image image = PaletteSerialization.convertPaletteToImage(palette);
        PNMCodec codec = new PNMCodec();
        codec.setOutputStream(new FileOutputStream(paletteFile));
        codec.setAscii(true);
        codec.setImage(image);
        try {
            codec.process();
        }
        catch (OperationFailedException ofe) {
            throw new IOException("I/O error: " + ofe.toString());
        }
    }
}

