/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.filters;

import net.sourceforge.jiu.data.GrayIntegerImage;
import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.PixelImage;
import net.sourceforge.jiu.data.RGBIntegerImage;
import net.sourceforge.jiu.filters.ConvolutionKernelData;
import net.sourceforge.jiu.ops.ImageToImageOperation;
import net.sourceforge.jiu.ops.MissingParameterException;
import net.sourceforge.jiu.ops.OperationFailedException;
import net.sourceforge.jiu.ops.WrongParameterException;

public class ConvolutionKernelFilter
extends ImageToImageOperation {
    public static final int TYPE_BLUR = 0;
    public static final int TYPE_SHARPEN = 1;
    public static final int TYPE_EDGE_DETECTION = 2;
    public static final int TYPE_EMBOSS = 3;
    public static final int TYPE_PSYCHEDELIC_DISTILLATION = 4;
    public static final int TYPE_LITHOGRAPH = 5;
    public static final int TYPE_HORIZONTAL_SOBEL = 6;
    public static final int TYPE_VERTICAL_SOBEL = 7;
    public static final int TYPE_HORIZONTAL_PREWITT = 8;
    public static final int TYPE_VERTICAL_PREWITT = 9;
    private static final int[] BLUR_DATA = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1};
    private static final int[] SHARPEN_DATA;
    private static final int[] EDGE_DETECTION_DATA;
    private static final int[] EMBOSS_DATA;
    private static final int[] PSYCHEDELIC_DISTILLATION_DATA;
    private static final int[] LITHOGRAPH_DATA;
    private static final int[] HORIZONTAL_SOBEL_DATA;
    private static final int[] VERTICAL_SOBEL_DATA;
    private static final int[] HORIZONTAL_PREWITT_DATA;
    private static final int[] VERTICAL_PREWITT_DATA;
    private static ConvolutionKernelData[] PREDEFINED_KERNELS;
    private int kernelBias;
    private int[] kernelData;
    private int kernelDiv;
    private int kernelHeight;
    private int kernelWidth;

    static {
        int[] nArray = new int[9];
        nArray[1] = -1;
        nArray[3] = -1;
        nArray[4] = 5;
        nArray[5] = -1;
        nArray[7] = -1;
        SHARPEN_DATA = nArray;
        EDGE_DETECTION_DATA = new int[]{-1, -1, -1, -1, 8, -1, -1, -1, -1};
        int[] nArray2 = new int[9];
        nArray2[0] = 1;
        nArray2[1] = 1;
        nArray2[3] = 1;
        nArray2[5] = -1;
        nArray2[7] = -1;
        nArray2[8] = -1;
        EMBOSS_DATA = nArray2;
        int[] nArray3 = new int[25];
        nArray3[1] = -1;
        nArray3[2] = -2;
        nArray3[3] = -3;
        nArray3[4] = -4;
        nArray3[6] = -1;
        nArray3[7] = 3;
        nArray3[8] = 2;
        nArray3[9] = 1;
        nArray3[11] = -1;
        nArray3[12] = 10;
        nArray3[13] = 2;
        nArray3[14] = 1;
        nArray3[16] = -1;
        nArray3[17] = 3;
        nArray3[18] = 2;
        nArray3[19] = 1;
        nArray3[21] = -1;
        nArray3[22] = -2;
        nArray3[23] = -3;
        nArray3[24] = -4;
        PSYCHEDELIC_DISTILLATION_DATA = nArray3;
        LITHOGRAPH_DATA = new int[]{-1, -1, -1, -1, -1, -1, -10, -10, -10, -1, -1, -10, 98, -10, -1, -1, -10, -10, -10, -1, -1, -1, -1, -1, -1};
        int[] nArray4 = new int[9];
        nArray4[0] = -1;
        nArray4[2] = 1;
        nArray4[3] = -2;
        nArray4[5] = 2;
        nArray4[6] = -1;
        nArray4[8] = 1;
        HORIZONTAL_SOBEL_DATA = nArray4;
        int[] nArray5 = new int[9];
        nArray5[0] = -1;
        nArray5[1] = -2;
        nArray5[2] = -1;
        nArray5[6] = 1;
        nArray5[7] = 2;
        nArray5[8] = 1;
        VERTICAL_SOBEL_DATA = nArray5;
        int[] nArray6 = new int[9];
        nArray6[0] = -1;
        nArray6[2] = 1;
        nArray6[3] = -1;
        nArray6[5] = 1;
        nArray6[6] = -1;
        nArray6[8] = 1;
        HORIZONTAL_PREWITT_DATA = nArray6;
        int[] nArray7 = new int[9];
        nArray7[0] = -1;
        nArray7[1] = -1;
        nArray7[2] = -1;
        nArray7[6] = 1;
        nArray7[7] = 1;
        nArray7[8] = 1;
        VERTICAL_PREWITT_DATA = nArray7;
        PREDEFINED_KERNELS = new ConvolutionKernelData[]{new ConvolutionKernelData("Blur", BLUR_DATA, 3, 3, 9, 0), new ConvolutionKernelData("Sharpen", SHARPEN_DATA, 3, 3, 1, 0), new ConvolutionKernelData("Edge detection", EDGE_DETECTION_DATA, 3, 3, 1, 0), new ConvolutionKernelData("Emboss", EMBOSS_DATA, 3, 3, 1, 128), new ConvolutionKernelData("Psychedelic Distillation", PSYCHEDELIC_DISTILLATION_DATA, 5, 5, 1, 0), new ConvolutionKernelData("Lithograph", LITHOGRAPH_DATA, 5, 5, 1, 0), new ConvolutionKernelData("Horizontal Sobel", HORIZONTAL_SOBEL_DATA, 3, 3, 1, 0), new ConvolutionKernelData("Vertical Sobel", VERTICAL_SOBEL_DATA, 3, 3, 1, 0), new ConvolutionKernelData("Horizontal Prewitt", HORIZONTAL_PREWITT_DATA, 3, 3, 1, 0), new ConvolutionKernelData("Vertical Prewitt", VERTICAL_PREWITT_DATA, 3, 3, 1, 0)};
    }

    private void copyRow(IntegerImage srcImage, int srcChannelIndex, int rowIndex, int[] dest, int destOffset, int numBorderColumns) {
        int WIDTH = srcImage.getWidth();
        srcImage.getSamples(srcChannelIndex, 0, rowIndex, WIDTH, 1, dest, destOffset + numBorderColumns);
        int srcOffset = destOffset + numBorderColumns;
        int offset = numBorderColumns - 1;
        while (offset >= 0) {
            dest[offset--] = dest[srcOffset];
        }
        srcOffset = destOffset + numBorderColumns + WIDTH - 1;
        offset = srcOffset + 1;
        int n = numBorderColumns;
        while (n-- > 0) {
            dest[offset++] = dest[srcOffset];
        }
    }

    public static PixelImage filter(PixelImage input, int kernelType) {
        return ConvolutionKernelFilter.filter(input, PREDEFINED_KERNELS[kernelType]);
    }

    public static PixelImage filter(PixelImage input, ConvolutionKernelData data) {
        ConvolutionKernelFilter op = new ConvolutionKernelFilter();
        op.setKernel(data);
        op.setInputImage(input);
        try {
            op.process();
            return op.getOutputImage();
        }
        catch (OperationFailedException ofe) {
            return null;
        }
    }

    private void process(int channelIndex, IntegerImage in, IntegerImage out) {
        int y;
        int H_DIM = this.kernelWidth;
        int H_DIM_2 = H_DIM / 2;
        int V_DIM = this.kernelHeight;
        int V_DIM_2 = V_DIM / 2;
        int HEIGHT = in.getHeight();
        int WIDTH = in.getWidth();
        int NEW_WIDTH = WIDTH + 2 * H_DIM_2;
        int NEW_HEIGHT = HEIGHT + 2 * V_DIM_2;
        int MAX = in.getMaxSample(channelIndex);
        int processedItems = channelIndex * HEIGHT;
        int TOTAL_ITEMS = in.getNumChannels() * HEIGHT;
        int[] src = new int[NEW_WIDTH * NEW_HEIGHT];
        int y2 = 0;
        int offs = V_DIM_2 * NEW_WIDTH;
        while (y2 < HEIGHT) {
            this.copyRow(in, channelIndex, y2, src, offs, H_DIM_2);
            ++y2;
            offs += NEW_WIDTH;
        }
        int srcOffset = V_DIM_2 * NEW_WIDTH;
        int y3 = 0;
        while (y3 < V_DIM_2) {
            System.arraycopy(src, srcOffset, src, y3 * NEW_WIDTH, NEW_WIDTH);
            ++y3;
        }
        srcOffset = (HEIGHT + V_DIM_2 - 1) * NEW_WIDTH;
        y3 = V_DIM_2 + HEIGHT;
        while (y3 < NEW_HEIGHT) {
            System.arraycopy(src, srcOffset, src, y3 * NEW_WIDTH, NEW_WIDTH);
            ++y3;
        }
        int count = H_DIM * V_DIM;
        int[] kernelLine = new int[count];
        int[] kernelD = new int[count];
        count = 0;
        int j = H_DIM - 1;
        int x = H_DIM;
        while (x-- > 0) {
            y = V_DIM;
            while (y-- > 0) {
                int index = y * H_DIM + x;
                if (this.kernelData[index] == 0) continue;
                kernelLine[count] = this.kernelData[index];
                kernelD[count] = y * NEW_WIDTH + x;
                ++count;
            }
        }
        if (count == 0) {
            this.setProgress(channelIndex, in.getNumChannels());
            return;
        }
        int p = (HEIGHT - 1) * NEW_WIDTH + (WIDTH - 1);
        int[] dest = new int[WIDTH];
        y = HEIGHT;
        while (y-- > 0) {
            int x2 = WIDTH;
            while (x2-- > 0) {
                int sum = 0;
                int i = count;
                while (i-- > 0) {
                    sum += (src[p + kernelD[i]] & MAX) * kernelLine[i];
                }
                dest[x2] = (sum = sum / this.kernelDiv + this.kernelBias) <= 0 ? 0 : (sum >= MAX ? MAX : sum);
                --p;
            }
            out.putSamples(channelIndex, 0, y, WIDTH, 1, dest, 0);
            p -= j;
            this.setProgress(processedItems++, TOTAL_ITEMS);
        }
    }

    private void process(IntegerImage in, IntegerImage out) {
        int channelIndex = 0;
        while (channelIndex < in.getNumChannels()) {
            this.process(channelIndex, in, out);
            ++channelIndex;
        }
    }

    public void process() throws MissingParameterException, WrongParameterException {
        PixelImage out;
        this.ensureInputImageIsAvailable();
        this.ensureImagesHaveSameResolution();
        PixelImage in = this.getInputImage();
        if (in instanceof GrayIntegerImage || in instanceof RGBIntegerImage) {
            out = this.getOutputImage();
            if (out == null) {
                out = (IntegerImage)in.createCompatibleImage(in.getWidth(), in.getHeight());
                this.setOutputImage(out);
            }
        } else {
            throw new WrongParameterException("Input image must implement GrayIntegerImage or RGBIntegerImage.");
        }
        this.process((IntegerImage)in, (IntegerImage)out);
    }

    public void setKernel(int[] data, int width, int height, int div, int bias) {
        if (data == null) {
            throw new IllegalArgumentException("Kernel data must be non-null.");
        }
        if (width < 1) {
            throw new IllegalArgumentException("Kernel width must be at least 1.");
        }
        if (width % 2 != 1) {
            throw new IllegalArgumentException("Kernel width must not be even.");
        }
        if (height < 1) {
            throw new IllegalArgumentException("Kernel height must be at least 1.");
        }
        if (height % 2 != 1) {
            throw new IllegalArgumentException("Kernel width must not be even.");
        }
        if (data.length < width * height) {
            throw new IllegalArgumentException("Kernel data must have a length >= " + width * height + " to hold " + width + " times " + height + " elements.");
        }
        if (div == 0) {
            throw new IllegalArgumentException("The div parameter must not be zero.");
        }
        this.kernelData = data;
        this.kernelWidth = width;
        this.kernelHeight = height;
        this.kernelDiv = div;
        this.kernelBias = bias;
    }

    public void setKernel(ConvolutionKernelData ckd) {
        this.setKernel(ckd.getData(), ckd.getWidth(), ckd.getHeight(), ckd.getDiv(), ckd.getBias());
    }

    public void setKernel(int type) {
        if (type < 0 || type >= PREDEFINED_KERNELS.length) {
            throw new IllegalArgumentException("Not a valid type index for predefined kernels: " + type);
        }
        this.setKernel(PREDEFINED_KERNELS[type]);
    }
}

