/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.gui.awt.dialogs;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import net.sourceforge.jiu.apps.Strings;
import net.sourceforge.jiu.gui.awt.dialogs.Dialogs;

public class CropDialog
extends Dialog
implements ActionListener,
KeyListener {
    private Button ok;
    private Button cancel;
    private TextField x1;
    private TextField y1;
    private TextField x2;
    private TextField y2;
    private int width;
    private int height;
    private Label newWidth;
    private Label newHeight;
    private boolean pressedOk = false;

    public CropDialog(Frame owner, Strings strings, int width, int height) {
        super(owner, String.valueOf(strings.get(114)) + " (" + width + " x " + height + ")", true);
        this.width = width;
        this.height = height;
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(0, 6));
        panel.add(new Label(strings.get(115)));
        this.x1 = new TextField("0");
        this.x1.addKeyListener(this);
        panel.add(this.x1);
        panel.add(new Label(strings.get(117)));
        this.x2 = new TextField(Integer.toString(width - 1));
        this.x2.addKeyListener(this);
        panel.add(this.x2);
        panel.add(new Label(strings.get(61)));
        this.newWidth = new Label();
        panel.add(this.newWidth);
        panel.add(new Label(strings.get(116)));
        this.y1 = new TextField("0");
        this.y1.addKeyListener(this);
        panel.add(this.y1);
        panel.add(new Label(strings.get(118)));
        this.y2 = new TextField(Integer.toString(height - 1));
        this.y2.addKeyListener(this);
        panel.add(this.y2);
        panel.add(new Label(strings.get(62)));
        this.newHeight = new Label();
        panel.add(this.newHeight);
        this.add((Component)panel, "Center");
        this.ok = new Button(strings.get(64));
        this.ok.addActionListener(this);
        this.cancel = new Button(strings.get(65));
        this.cancel.addActionListener(this);
        panel = new Panel();
        panel.add(this.ok);
        panel.add(this.cancel);
        this.add((Component)panel, "South");
        this.updateLabels();
        this.pack();
        Dialogs.center(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok) {
            this.pressedOk = true;
            this.setVisible(false);
        } else if (e.getSource() == this.cancel) {
            this.setVisible(false);
        }
    }

    public int getHeight() {
        int y1 = this.getY1();
        int y2 = this.getY2();
        if (y1 != -1 && y2 != -1 && y1 >= 0 && y2 >= y1 && y2 < this.height && y1 <= y2) {
            return y2 - y1 + 1;
        }
        return -1;
    }

    private int getValue(TextComponent textField) {
        try {
            return Integer.parseInt(textField.getText());
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public int getWidth() {
        int x1 = this.getX1();
        int x2 = this.getX2();
        if (x1 != -1 && x2 != -1 && x1 >= 0 && x2 >= x1 && x2 < this.width && x1 <= x2) {
            return x2 - x1 + 1;
        }
        return -1;
    }

    public int getX1() {
        return this.getValue(this.x1);
    }

    public int getX2() {
        return this.getValue(this.x2);
    }

    public int getY1() {
        return this.getValue(this.y1);
    }

    public int getY2() {
        return this.getValue(this.y2);
    }

    public boolean hasPressedOk() {
        return this.pressedOk;
    }

    private void updateLabels() {
        String text;
        boolean enabled = true;
        int valueWidth = this.getWidth();
        if (valueWidth == -1) {
            text = "-";
            enabled = false;
        } else {
            text = Integer.toString(valueWidth);
        }
        this.newWidth.setText(text);
        int valueHeight = this.getHeight();
        if (valueHeight == -1) {
            text = "-";
            enabled = false;
        } else {
            text = Integer.toString(valueHeight);
        }
        this.newHeight.setText(text);
        this.ok.setEnabled(enabled);
    }

    public void keyPressed(KeyEvent e) {
        this.updateLabels();
    }

    public void keyReleased(KeyEvent e) {
        this.updateLabels();
    }

    public void keyTyped(KeyEvent e) {
        this.updateLabels();
    }
}

