/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.gui.awt.dialogs;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import net.sourceforge.jiu.apps.Strings;

public class OctreeDialog
extends Dialog
implements ActionListener,
KeyListener {
    public final int[] DITHERING_STRINGS = new int[]{92, 124, 125, 126, 127, 128, 129};
    public final int[] DITHERING_TYPES;
    private Button ok;
    private Button cancel;
    private TextField numColorsField;
    private Choice outputColorType;
    private Choice dithering;
    private boolean pressedOk;

    public OctreeDialog(Frame owner, Strings strings, int numColors, boolean paletted) {
        super(owner, strings.get(171), true);
        int[] nArray = new int[7];
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 3;
        nArray[5] = 4;
        nArray[6] = 5;
        this.DITHERING_TYPES = nArray;
        this.pressedOk = false;
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(0, 2));
        panel.add(new Label(strings.get(66)));
        this.numColorsField = new TextField(Integer.toString(numColors), 6);
        this.numColorsField.addKeyListener(this);
        panel.add(this.numColorsField);
        panel.add(new Label(strings.get(93)));
        this.dithering = new Choice();
        int i = 0;
        while (i < this.DITHERING_STRINGS.length) {
            this.dithering.add(strings.get(this.DITHERING_STRINGS[i]));
            ++i;
        }
        this.dithering.select(1);
        panel.add(this.dithering);
        this.add((Component)panel, "Center");
        this.ok = new Button(strings.get(64));
        this.ok.addActionListener(this);
        this.cancel = new Button(strings.get(65));
        this.cancel.addActionListener(this);
        panel = new Panel();
        panel.add(this.ok);
        panel.add(this.cancel);
        this.add((Component)panel, "South");
        this.pack();
        this.center();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok) {
            this.pressedOk = true;
            this.setVisible(false);
        } else if (e.getSource() == this.cancel) {
            this.setVisible(false);
        }
    }

    public void center() {
        Rectangle rect = this.getBounds();
        int width = rect.width;
        int height = rect.height;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 2 - width / 2, screenSize.height / 2 - height / 2);
    }

    public int getErrorDiffusion() {
        int sel = this.dithering.getSelectedIndex();
        if (sel > 0) {
            return this.DITHERING_TYPES[sel];
        }
        return -1;
    }

    private int getIntValue(TextField textField) {
        try {
            return Integer.parseInt(textField.getText());
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public int getNumColors() {
        return this.getIntValue(this.numColorsField);
    }

    public boolean hasPressedOk() {
        return this.pressedOk;
    }

    public boolean isOutputTypePaletted() {
        return this.outputColorType.getSelectedIndex() == 0;
    }

    public void keyPressed(KeyEvent e) {
        this.updateOkButton();
    }

    public void keyReleased(KeyEvent e) {
        this.updateOkButton();
    }

    public void keyTyped(KeyEvent e) {
        this.updateOkButton();
    }

    private void updateOkButton() {
        int nc = this.getNumColors();
        boolean enabled = nc >= 1 && nc <= 256;
        this.ok.setEnabled(enabled);
    }

    public boolean useErrorDiffusion() {
        return this.dithering.getSelectedIndex() > 0;
    }

    public boolean useNoDithering() {
        return this.dithering.getSelectedIndex() == 0;
    }
}

