/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jiu.gui.awt.dialogs;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import net.sourceforge.jiu.apps.Strings;
import net.sourceforge.jiu.geometry.Shear;
import net.sourceforge.jiu.gui.awt.dialogs.Dialogs;

public class ShearDialog
extends Dialog
implements ActionListener,
KeyListener {
    private Button ok;
    private Button cancel;
    private TextField angleTextField;
    private boolean pressedOk;
    private Double result;
    private Label newWidthLabel;
    private int imageWidth;
    private int imageHeight;

    public ShearDialog(Frame owner, Strings strings, double initialValue, int imageWidth, int imageHeight) {
        super(owner, String.valueOf(strings.get(139)) + " (" + imageWidth + " x " + imageHeight + ")", true);
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        Panel panel = new Panel(new GridLayout(0, 2));
        panel.add(new Label(strings.get(140)));
        this.angleTextField = new TextField(Double.toString(initialValue));
        this.angleTextField.addKeyListener(this);
        panel.add(this.angleTextField);
        panel.add(new Label(strings.get(61)));
        this.newWidthLabel = new Label("");
        panel.add(this.newWidthLabel);
        this.add((Component)panel, "Center");
        panel = new Panel();
        this.ok = new Button(strings.get(64));
        this.ok.addActionListener(this);
        this.cancel = new Button(strings.get(65));
        this.cancel.addActionListener(this);
        panel.add(this.ok);
        panel.add(this.cancel);
        this.add((Component)panel, "South");
        this.handleKeys(null);
        this.pack();
        Dialogs.center(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok) {
            this.pressedOk = true;
            this.result = this.getValue(this.angleTextField);
            this.setVisible(false);
        } else if (e.getSource() == this.cancel) {
            this.setVisible(false);
        }
    }

    private Double getValue(TextField tf) {
        double d;
        if (tf == null) {
            return null;
        }
        try {
            d = Double.valueOf(tf.getText());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        if (d <= -90.0 || d >= 90.0) {
            return null;
        }
        return new Double(d);
    }

    public Double getValue() {
        return this.result;
    }

    public boolean hasPressedOk() {
        return this.pressedOk;
    }

    public void handleKeys(KeyEvent e) {
        String labelText;
        Double d = this.getValue(this.angleTextField);
        double angle = -90.0;
        if (d != null) {
            angle = d;
        }
        if (angle > -90.0 && angle < 90.0) {
            this.ok.setEnabled(true);
            int newWidth = Shear.computeNewImageWidth(this.imageWidth, this.imageHeight, angle);
            labelText = Integer.toString(newWidth);
        } else {
            this.ok.setEnabled(false);
            labelText = "-";
        }
        this.newWidthLabel.setText(labelText);
    }

    public void keyPressed(KeyEvent e) {
        this.handleKeys(e);
    }

    public void keyReleased(KeyEvent e) {
        this.handleKeys(e);
    }

    public void keyTyped(KeyEvent e) {
        this.handleKeys(e);
    }
}

