/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleFactory;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleObject;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;

public class Accessible {
    Vector accessibleListeners = new Vector();
    Vector controlListeners = new Vector();
    Vector textListeners = new Vector();
    AccessibleObject accessibleObject;
    Control control;

    Accessible(Control control) {
        this.control = control;
        AccessibleFactory.registerAccessible(this);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Accessible.this.release();
            }
        });
    }

    public void addAccessibleListener(AccessibleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.accessibleListeners.addElement(listener);
    }

    public void addAccessibleControlListener(AccessibleControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.controlListeners.addElement(listener);
    }

    public void addAccessibleTextListener(AccessibleTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.textListeners.addElement(listener);
    }

    public Control getControl() {
        return this.control;
    }

    void checkWidget() {
        if (!this.isValidThread()) {
            SWT.error(22);
        }
        if (this.control.isDisposed()) {
            SWT.error(24);
        }
    }

    AccessibleListener[] getAccessibleListeners() {
        if (this.accessibleListeners == null) {
            return null;
        }
        Object[] result = new AccessibleListener[this.accessibleListeners.size()];
        this.accessibleListeners.copyInto(result);
        return result;
    }

    int getControlHandle() {
        return this.control.handle;
    }

    AccessibleControlListener[] getControlListeners() {
        if (this.controlListeners == null) {
            return null;
        }
        Object[] result = new AccessibleControlListener[this.controlListeners.size()];
        this.controlListeners.copyInto(result);
        return result;
    }

    AccessibleTextListener[] getTextListeners() {
        if (this.textListeners == null) {
            return null;
        }
        Object[] result = new AccessibleTextListener[this.textListeners.size()];
        this.textListeners.copyInto(result);
        return result;
    }

    public static Accessible internal_new_Accessible(Control control) {
        return new Accessible(control);
    }

    boolean isValidThread() {
        return this.control.getDisplay().getThread() == Thread.currentThread();
    }

    void release() {
        AccessibleFactory.unregisterAccessible(this);
        if (this.accessibleObject != null) {
            this.accessibleObject.release();
            this.accessibleObject = null;
        }
        this.accessibleListeners = null;
        this.controlListeners = null;
        this.textListeners = null;
    }

    public void removeAccessibleControlListener(AccessibleControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.controlListeners.removeElement(listener);
    }

    public void removeAccessibleListener(AccessibleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.accessibleListeners.removeElement(listener);
    }

    public void removeAccessibleTextListener(AccessibleTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.textListeners.removeElement(listener);
    }

    public void selectionChanged() {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.selectionChanged();
        }
    }

    public void setFocus(int childID) {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.setFocus(childID);
        }
    }

    public void textCaretMoved(int index) {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.textCaretMoved(index);
        }
    }

    public void textChanged(int type, int startIndex, int length) {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.textChanged(type, startIndex, length);
        }
    }

    public void textSelectionChanged() {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.textSelectionChanged();
        }
    }
}

